/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.compatibility;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rest.client.exception.UnprocessableSchemaException;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RuleContext;
import io.apicurio.registry.rules.RuleViolation;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.rules.compatibility.CompatibilityRuleExecutor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class CompatibilityRuleApplicationTest
extends AbstractResourceTestBase {
    private static final String SCHEMA_SIMPLE = "{\"type\": \"string\"}";
    private static final String SCHEMA_WITH_MAP = "{\r\n    \"type\": \"record\",\r\n    \"name\": \"userInfo\",\r\n    \"namespace\": \"my.example\",\r\n    \"fields\": [\r\n        {\r\n            \"name\": \"name\",\r\n            \"type\": \"string\",\r\n            \"default\": \"NONE\"\r\n        },\r\n        {\r\n            \"name\": \"props\",\r\n            \"type\": {\r\n                \"type\": \"map\",\r\n                \"values\": \"string\"\r\n            }\r\n        }\r\n    ]\r\n}";
    private static final String INVALID_SCHEMA_WITH_MAP = "{\r\n    \"type\": \"record\",\r\n    \"name\": \"userInfo\",\r\n    \"namespace\": \"my.example\",\r\n    \"fields\": [\r\n        {\r\n            \"name\": \"name\",\r\n            \"type\": \"string\",\r\n            \"default\": \"NONE\"\r\n        },\r\n        {\r\n            \"name\": \"props\",\r\n            \"type\": {\r\n                \"type\": \"map\",\r\n                \"values\": \"string\"\r\n            },\r\n            \"default\": \"{}\"\r\n        }\r\n    ]\r\n}";
    private static final String citizenSchema = "{\n  \"$id\": \"https://example.com/citizen.schema.json\",\n  \"$schema\": \"http://json-schema.org/draft-07/schema#\",\n  \"title\": \"Citizen\",\n  \"type\": \"object\",\n  \"properties\": {\n    \"firstName\": {\n      \"type\": \"string\",\n      \"description\": \"The citizen's first name.\"\n    },\n    \"lastName\": {\n      \"type\": \"string\",\n      \"description\": \"The citizen's last name.\"\n    },\n    \"age\": {\n      \"description\": \"Age in years which must be equal to or greater than zero.\",\n      \"type\": \"integer\",\n      \"minimum\": 0\n    },\n    \"city\": {\n      \"$ref\": \"city.json\"\n    }\n  },\n  \"required\": [\n    \"city\"\n  ]\n}";
    private static final String citySchema = "{\n  \"$id\": \"https://example.com/city.schema.json\",\n  \"$schema\": \"http://json-schema.org/draft-07/schema#\",\n  \"title\": \"City\",\n  \"type\": \"object\",\n  \"properties\": {\n    \"name\": {\n      \"type\": \"string\",\n      \"description\": \"The city's name.\"\n    },\n    \"zipCode\": {\n      \"type\": \"integer\",\n      \"description\": \"The zip code.\",\n      \"minimum\": 0\n    }\n  }\n}";
    @Inject
    RulesService rules;
    @Inject
    CompatibilityRuleExecutor compatibility;

    @Test
    public void testGlobalCompatibilityRuleNoArtifact() throws Exception {
        Rule rule = new Rule();
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/registry/v1/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v1/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        this.rules.applyRules("no-group", "not-existent", "AVRO", ContentHandle.create((String)SCHEMA_SIMPLE), RuleApplicationType.CREATE, Collections.emptyList(), Collections.emptyMap());
    }

    @Test
    public void testAvroCompatibility() {
        String v1Schema = "{\"type\":\"record\",\"namespace\":\"com.example\",\"name\":\"FullName\",\"fields\":[{\"name\":\"first\",\"type\":\"string\"},{\"name\":\"last\",\"type\":\"string\"}]}";
        String v2Schema = SCHEMA_SIMPLE;
        Assertions.assertThrows(RuleViolationException.class, () -> {
            RuleContext context = new RuleContext("TestGroup", "Test", "AVRO", "BACKWARD", Collections.singletonList(ContentHandle.create((String)v1Schema)), ContentHandle.create((String)v2Schema), Collections.emptyList(), Collections.emptyMap());
            this.compatibility.execute(context);
        });
    }

    @Test
    public void testJsonSchemaCompatibility() {
        String v1Schema = "{\n  \"type\": \"object\",\n  \"properties\": {\n    \"age\": {\n      \"description\": \"Age in years which must be equal to or greater than zero.\",\n      \"type\": \"integer\",\n      \"minimum\": 0\n    },\n    \"zipcode\": {\n      \"description\": \"ZipCode\",\n      \"type\": \"integer\"\n    }\n  }\n}";
        String v2Schema = "{\n  \"type\": \"object\",\n  \"properties\": {\n    \"age\": {\n      \"description\": \"Age in years which must be equal to or greater than zero.\",\n      \"type\": \"string\",\n      \"minimum\": 0\n    },\n    \"zipcode\": {\n      \"description\": \"ZipCode\",\n      \"type\": \"string\"\n    }\n  }\n}";
        RuleViolationException ruleViolationException = (RuleViolationException)Assertions.assertThrows(RuleViolationException.class, () -> {
            RuleContext context = new RuleContext("TestGroup", "TestJson", "JSON", "FORWARD_TRANSITIVE", Collections.singletonList(ContentHandle.create((String)v1Schema)), ContentHandle.create((String)v2Schema), Collections.emptyList(), Collections.emptyMap());
            this.compatibility.execute(context);
        });
        Set ruleViolationCauses = ruleViolationException.getCauses();
        RuleViolation ageViolationCause = this.findCauseByContext(ruleViolationCauses, "/properties/age/type");
        RuleViolation zipCodeViolationCause = this.findCauseByContext(ruleViolationCauses, "/properties/zipcode");
        Assertions.assertEquals((Object)"/properties/age/type", (Object)ageViolationCause.getContext());
        Assertions.assertEquals((Object)DiffType.NUMBER_TYPE_INTEGER_REQUIRED_FALSE_TO_TRUE.getDescription(), (Object)ageViolationCause.getDescription());
        Assertions.assertEquals((Object)"/properties/zipcode", (Object)zipCodeViolationCause.getContext());
        Assertions.assertEquals((Object)DiffType.SUBSCHEMA_TYPE_CHANGED.getDescription(), (Object)zipCodeViolationCause.getDescription());
    }

    @Test
    public void validateJsonSchemaEvolutionWithReferences() throws Exception {
        String groupId = TestUtils.generateGroupId();
        String cityArtifactId = this.generateArtifactId();
        Integer cityDependencyGlobalId = this.createArtifact(groupId, cityArtifactId, "JSON", citySchema);
        this.waitForGlobalId(cityDependencyGlobalId.intValue());
        ArtifactReference cityReference = new ArtifactReference();
        cityReference.setVersion("1");
        cityReference.setGroupId(groupId);
        cityReference.setArtifactId(cityArtifactId);
        cityReference.setName("city.json");
        String artifactId = this.generateArtifactId();
        Integer globalId = this.createArtifactWithReferences(groupId, artifactId, "JSON", citizenSchema, List.of(cityReference));
        this.waitForGlobalId(globalId.intValue());
        this.createArtifactRule(groupId, artifactId, RuleType.COMPATIBILITY, "BACKWARD");
        this.updateArtifactWithReferences(groupId, artifactId, "JSON", citizenSchema, List.of(cityReference));
        this.waitForGlobalId(globalId.intValue());
    }

    private RuleViolation findCauseByContext(Set<RuleViolation> ruleViolations, String context) {
        for (RuleViolation violation : ruleViolations) {
            if (!violation.getContext().equals(context)) continue;
            return violation;
        }
        return null;
    }

    @Test
    public void testCompatibilityRuleApplication_Map() throws Exception {
        String artifactId = "testCompatibilityRuleApplication_Map";
        this.createArtifact(artifactId, "AVRO", SCHEMA_WITH_MAP);
        Rule rule = new Rule();
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig(CompatibilityLevel.FULL.name());
        this.clientV2.createArtifactRule("default", artifactId, rule);
        Assertions.assertThrows(UnprocessableSchemaException.class, () -> this.clientV2.updateArtifact("default", artifactId, IoUtil.toStream((String)INVALID_SCHEMA_WITH_MAP)));
    }

    @Test
    public void testCompatibilityInvalidExitingContentRuleApplication_Map() throws Exception {
        String artifactId = "testCompatibilityInvalidExitingContentRuleApplication_Map";
        this.createArtifact(artifactId, "AVRO", INVALID_SCHEMA_WITH_MAP);
        Rule rule = new Rule();
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig(CompatibilityLevel.FULL.name());
        this.clientV2.createArtifactRule("default", artifactId, rule);
        Assertions.assertThrows(UnprocessableSchemaException.class, () -> this.clientV2.updateArtifact("default", artifactId, IoUtil.toStream((String)INVALID_SCHEMA_WITH_MAP)));
    }

    @Test
    public void testCompatibilityRuleApplication_FullTransitive() throws Exception {
        String artifactId = "testCompatibilityRuleApplication_FullTransitive";
        this.createArtifact(artifactId, "AVRO", SCHEMA_SIMPLE);
        this.createArtifactVersion(artifactId, "AVRO", SCHEMA_WITH_MAP);
        this.createArtifactVersion(artifactId, "AVRO", SCHEMA_WITH_MAP);
        this.createArtifactVersion(artifactId, "AVRO", SCHEMA_WITH_MAP);
        this.createArtifactVersion(artifactId, "AVRO", SCHEMA_WITH_MAP);
        Rule rule = new Rule();
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig(CompatibilityLevel.BACKWARD_TRANSITIVE.name());
        this.clientV2.createArtifactRule("default", artifactId, rule);
        Assertions.assertThrows(io.apicurio.registry.rest.client.exception.RuleViolationException.class, () -> this.clientV2.updateArtifact("default", artifactId, IoUtil.toStream((String)SCHEMA_WITH_MAP)));
        rule = new Rule();
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig(CompatibilityLevel.BACKWARD.name());
        this.clientV2.updateArtifactRuleConfig("default", artifactId, RuleType.COMPATIBILITY, rule);
        this.clientV2.updateArtifact("default", artifactId, IoUtil.toStream((String)SCHEMA_WITH_MAP));
    }
}

