/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.content;

import io.apicurio.registry.AbstractRegistryTestBase;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.quarkus.test.junit.QuarkusTest;
import jakarta.inject.Inject;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class ContentCanonicalizerTest
extends AbstractRegistryTestBase {
    @Inject
    ArtifactTypeUtilProviderFactory factory;

    private ContentCanonicalizer getContentCanonicalizer(String type) {
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(type);
        return provider.getContentCanonicalizer();
    }

    @Test
    void testOpenAPI() {
        ContentCanonicalizer canonicalizer = this.getContentCanonicalizer("OPENAPI");
        String before = "{\r\n    \"openapi\": \"3.0.2\",\r\n    \"info\": {\r\n        \"title\": \"Empty 3.0 API\",\r\n        \"version\": \"1.0.0\"\r\n    },\r\n    \"paths\": {\r\n        \"/\": {}\r\n    },\r\n    \"components\": {}\r\n}";
        String expected = "{\"components\":{},\"info\":{\"title\":\"Empty 3.0 API\",\"version\":\"1.0.0\"},\"openapi\":\"3.0.2\",\"paths\":{\"/\":{}}}";
        ContentHandle content = ContentHandle.create((String)before);
        String actual = canonicalizer.canonicalize(content, Collections.emptyMap()).content();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testAvro() {
        ContentCanonicalizer canonicalizer = this.getContentCanonicalizer("AVRO");
        String before = "{\r\n     \"type\": \"record\",\r\n     \"namespace\": \"com.example\",\r\n     \"name\": \"FullName\",\r\n     \"fields\": [\r\n       { \"name\": \"first\", \"type\": \"string\" },\r\n       { \"name\": \"middle\", \"type\": \"string\" },\r\n       { \"name\": \"last\", \"type\": \"string\" }\r\n     ]\r\n} ";
        String expected = "{\"fields\":[{\"name\":\"first\",\"type\":\"string\"},{\"name\":\"last\",\"type\":\"string\"},{\"name\":\"middle\",\"type\":\"string\"}],\"name\":\"FullName\",\"namespace\":\"com.example\",\"type\":\"record\"}";
        ContentHandle content = ContentHandle.create((String)before);
        String actual = canonicalizer.canonicalize(content, Collections.emptyMap()).content();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testProtobuf() {
        ContentCanonicalizer canonicalizer = this.getContentCanonicalizer("PROTOBUF");
        String before = "message SearchRequest {\r\n  required string query = 1;\r\n  optional int32 page_number = 2;\r\n  optional int32 result_per_page = 3;\r\n}";
        String expected = "// Proto schema formatted by Wire, do not edit.\n// Source: \n\nmessage SearchRequest {\n  required string query = 1;\n\n  optional int32 page_number = 2;\n\n  optional int32 result_per_page = 3;\n}\n";
        ContentHandle content = ContentHandle.create((String)before);
        String actual = canonicalizer.canonicalize(content, Collections.emptyMap()).content();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testGraphQL() {
        ContentCanonicalizer canonicalizer = this.getContentCanonicalizer("GRAPHQL");
        String before = "type Query {\r\n  bookById(id: ID): Book \r\n}\r\n\r\ntype Book {\r\n    id: ID\r\n  name: String\r\n   pageCount: Int\r\n  author: Author\r\n}\r\n\r\ntype Author {\r\n  id: ID\r\n\r\n    firstName: String\r\n  lastName: String\r\n}\r\n\r\n";
        String expected = "type Author {\n  firstName: String\n  id: ID\n  lastName: String\n}\n\ntype Book {\n  author: Author\n  id: ID\n  name: String\n  pageCount: Int\n}\n\ntype Query {\n  bookById(id: ID): Book\n}\n";
        ContentHandle content = ContentHandle.create((String)before);
        String actual = canonicalizer.canonicalize(content, Collections.emptyMap()).content();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testKafkaConnect() {
        ContentCanonicalizer canonicalizer = this.getContentCanonicalizer("KCONNECT");
        String before = "{\r\n    \"type\": \"struct\",\r\n    \"fields\": [\r\n        {\r\n            \"type\": \"string\",\r\n            \"optional\": false,\r\n            \"field\": \"bar\"\r\n        }\r\n    ],\r\n    \"optional\": false\r\n}";
        String expected = "{\"fields\":[{\"field\":\"bar\",\"optional\":false,\"type\":\"string\"}],\"optional\":false,\"type\":\"struct\"}";
        ContentHandle content = ContentHandle.create((String)before);
        String actual = canonicalizer.canonicalize(content, Collections.emptyMap()).content();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testXsd() {
        ContentCanonicalizer canonicalizer = this.getContentCanonicalizer("XSD");
        ContentHandle content = this.resourceToContentHandle("xml-schema-before.xsd");
        String expected = this.resourceToString("xml-schema-expected.xsd");
        String actual = canonicalizer.canonicalize(content, Collections.emptyMap()).content();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testWsdl() {
        ContentCanonicalizer canonicalizer = this.getContentCanonicalizer("WSDL");
        ContentHandle content = this.resourceToContentHandle("wsdl-before.wsdl");
        String expected = this.resourceToString("wsdl-expected.wsdl");
        String actual = canonicalizer.canonicalize(content, Collections.emptyMap()).content();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testXml() {
        ContentCanonicalizer canonicalizer = this.getContentCanonicalizer("XML");
        ContentHandle content = this.resourceToContentHandle("xml-before.xml");
        String expected = this.resourceToString("xml-expected.xml");
        String actual = canonicalizer.canonicalize(content, Collections.emptyMap()).content();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

