/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.maven;

import io.apicurio.registry.maven.DownloadArtifact;
import io.apicurio.registry.maven.DownloadRegistryMojo;
import io.apicurio.registry.noprofile.maven.RegistryMojoTestBase;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class DownloadRegistryMojoTest
extends RegistryMojoTestBase {
    DownloadRegistryMojo mojo;

    @BeforeEach
    public void createMojo() {
        this.mojo = new DownloadRegistryMojo();
        this.mojo.setRegistryUrl(TestUtils.getRegistryV2ApiUrl((int)this.testPort));
    }

    @Test
    public void testDownloadIds() throws Exception {
        String groupId = DownloadRegistryMojoTest.class.getName();
        String artifactId = this.generateArtifactId();
        Schema schema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
        this.clientV2.createArtifact(groupId, artifactId, "AVRO", (InputStream)new ByteArrayInputStream(schema.toString().getBytes(StandardCharsets.UTF_8)));
        this.waitForArtifact(groupId, artifactId);
        ArrayList<DownloadArtifact> artifacts = new ArrayList<DownloadArtifact>();
        DownloadArtifact artifact = new DownloadArtifact();
        artifact.setGroupId(groupId);
        artifact.setArtifactId(artifactId);
        artifact.setOverwrite(Boolean.valueOf(true));
        artifact.setFile(new File(this.tempDirectory, "avro-schema.avsc"));
        artifacts.add(artifact);
        Assertions.assertFalse((boolean)artifact.getFile().isFile());
        this.mojo.setArtifacts(artifacts);
        this.mojo.execute();
        Assertions.assertTrue((boolean)artifact.getFile().isFile());
    }
}

