/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.maven;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.maven.RegisterArtifact;
import io.apicurio.registry.maven.RegisterRegistryMojo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public class RegistryMojoTestBase
extends AbstractResourceTestBase {
    protected File tempDirectory;

    @BeforeEach
    public void createTempDirectory() throws IOException {
        this.tempDirectory = File.createTempFile(this.getClass().getSimpleName(), ".tmp");
        this.tempDirectory.delete();
        this.tempDirectory.mkdirs();
    }

    @AfterEach
    public void cleanupTempDirectory() {
        for (File tempFile : this.tempDirectory.listFiles()) {
            tempFile.delete();
        }
        this.tempDirectory.delete();
    }

    protected void writeContent(File outputPath, byte[] content) throws IOException {
        try (FileOutputStream writer = new FileOutputStream(outputPath);){
            ((OutputStream)writer).write(content);
            writer.flush();
        }
    }

    protected void testRegister(RegisterRegistryMojo mojo, String groupId) throws IOException, MojoFailureException, MojoExecutionException {
        String keySubject = "TestSubject-key";
        String valueSubject = "TestSubject-value";
        Schema keySchema = Schema.create((Schema.Type)Schema.Type.STRING);
        Schema valueSchema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
        File keySchemaFile = new File(this.tempDirectory, keySubject + ".avsc");
        File valueSchemaFile = new File(this.tempDirectory, valueSubject + ".avsc");
        this.writeContent(keySchemaFile, keySchema.toString(true).getBytes(StandardCharsets.UTF_8));
        this.writeContent(valueSchemaFile, valueSchema.toString(true).getBytes(StandardCharsets.UTF_8));
        Assertions.assertTrue((boolean)keySchemaFile.isFile());
        Assertions.assertTrue((boolean)valueSchemaFile.isFile());
        ArrayList<RegisterArtifact> artifacts = new ArrayList<RegisterArtifact>();
        RegisterArtifact keySchemaArtifact = new RegisterArtifact();
        keySchemaArtifact.setGroupId(groupId);
        keySchemaArtifact.setArtifactId(keySubject);
        keySchemaArtifact.setType("AVRO");
        keySchemaArtifact.setFile(keySchemaFile);
        artifacts.add(keySchemaArtifact);
        RegisterArtifact valueSchemaArtifact = new RegisterArtifact();
        valueSchemaArtifact.setGroupId(groupId);
        valueSchemaArtifact.setArtifactId(valueSubject);
        valueSchemaArtifact.setType("AVRO");
        valueSchemaArtifact.setFile(valueSchemaFile);
        artifacts.add(valueSchemaArtifact);
        mojo.setArtifacts(artifacts);
        mojo.execute();
    }
}

