/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.maven;

import io.apicurio.registry.maven.DownloadRegistryMojo;
import io.apicurio.registry.maven.RegisterArtifact;
import io.apicurio.registry.maven.RegisterRegistryMojo;
import io.apicurio.registry.noprofile.maven.RegistryMojoTestBase;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rest.v2.beans.IfExists;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class RegistryMojoWithAutoReferencesTest
extends RegistryMojoTestBase {
    private static final String PROTO_SCHEMA_EXTENSION = ".proto";
    private static final String AVSC_SCHEMA_EXTENSION = ".avsc";
    private static final String JSON_SCHEMA_EXTENSION = ".json";
    RegisterRegistryMojo registerMojo;
    DownloadRegistryMojo downloadMojo;

    @BeforeEach
    public void createMojos() {
        this.registerMojo = new RegisterRegistryMojo();
        this.registerMojo.setRegistryUrl(TestUtils.getRegistryV2ApiUrl((int)this.testPort));
        this.downloadMojo = new DownloadRegistryMojo();
        this.downloadMojo.setRegistryUrl(TestUtils.getRegistryV2ApiUrl((int)this.testPort));
    }

    @Test
    public void autoRegisterAvroWithReferences() throws MojoExecutionException, MojoFailureException {
        String groupId = "autoRegisterAvroWithReferences";
        String artifactId = "tradeRaw";
        File tradeRawFile = new File(this.getClass().getResource("TradeRawArray.avsc").getFile());
        Set<String> avroFiles = Arrays.stream(Objects.requireNonNull(tradeRawFile.getParentFile().listFiles((dir, name) -> name.endsWith(AVSC_SCHEMA_EXTENSION)))).map(file -> {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream((File)file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return IoUtil.toString(fis);
        }).collect(Collectors.toSet());
        RegisterArtifact tradeRawArtifact = new RegisterArtifact();
        tradeRawArtifact.setGroupId(groupId);
        tradeRawArtifact.setArtifactId(artifactId);
        tradeRawArtifact.setType("AVRO");
        tradeRawArtifact.setFile(tradeRawFile);
        tradeRawArtifact.setAnalyzeDirectory(Boolean.valueOf(true));
        tradeRawArtifact.setIfExists(IfExists.FAIL);
        this.registerMojo.setArtifacts(Collections.singletonList(tradeRawArtifact));
        this.registerMojo.execute();
        this.validateStructure(groupId, artifactId, 1, 3, avroFiles);
    }

    @Test
    public void autoRegisterProtoWithReferences() throws MojoExecutionException, MojoFailureException {
        String groupId = "autoRegisterProtoWithReferences";
        String artifactId = "tableNotification";
        File tableNotificationFile = new File(this.getClass().getResource("table_notification.proto").getFile());
        Set<String> protoFiles = Arrays.stream(Objects.requireNonNull(tableNotificationFile.getParentFile().listFiles((dir, name) -> name.endsWith(PROTO_SCHEMA_EXTENSION)))).map(file -> {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream((File)file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return IoUtil.toString(fis).trim();
        }).collect(Collectors.toSet());
        RegisterArtifact tableNotification = new RegisterArtifact();
        tableNotification.setGroupId(groupId);
        tableNotification.setArtifactId(artifactId);
        tableNotification.setType("PROTOBUF");
        tableNotification.setFile(tableNotificationFile);
        tableNotification.setAnalyzeDirectory(Boolean.valueOf(true));
        tableNotification.setIfExists(IfExists.FAIL);
        this.registerMojo.setArtifacts(Collections.singletonList(tableNotification));
        this.registerMojo.execute();
        this.validateStructure(groupId, artifactId, 2, 4, protoFiles);
    }

    @Test
    public void autoRegisterJsonSchemaWithReferences() throws MojoExecutionException, MojoFailureException {
        String groupId = "autoRegisterJsonSchemaWithReferences";
        String artifactId = "citizen";
        File citizenFile = new File(this.getClass().getResource("citizen.json").getFile());
        Set<String> protoFiles = Arrays.stream(Objects.requireNonNull(citizenFile.getParentFile().listFiles((dir, name) -> name.endsWith(JSON_SCHEMA_EXTENSION)))).map(file -> {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream((File)file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return IoUtil.toString(fis).trim();
        }).collect(Collectors.toSet());
        RegisterArtifact citizen = new RegisterArtifact();
        citizen.setGroupId(groupId);
        citizen.setArtifactId(artifactId);
        citizen.setType("JSON");
        citizen.setFile(citizenFile);
        citizen.setAnalyzeDirectory(Boolean.valueOf(true));
        citizen.setIfExists(IfExists.FAIL);
        this.registerMojo.setArtifacts(Collections.singletonList(citizen));
        this.registerMojo.execute();
        this.validateStructure(groupId, artifactId, 3, 4, protoFiles);
    }

    private void validateStructure(String groupId, String artifactId, int expectedMainReferences, int expectedTotalArtifacts, Set<String> originalContents) {
        ArtifactMetaData artifactWithReferences = this.clientV2.getArtifactMetaData(groupId, artifactId);
        String mainContent = IoUtil.toString((InputStream)this.clientV2.getArtifactVersion(groupId, artifactId, artifactWithReferences.getVersion()));
        Assertions.assertTrue((boolean)originalContents.contains(mainContent));
        List mainArtifactReferences = this.clientV2.getArtifactReferencesByGlobalId(artifactWithReferences.getGlobalId().longValue());
        Assertions.assertEquals((int)expectedMainReferences, (int)this.clientV2.getArtifactReferencesByGlobalId(artifactWithReferences.getGlobalId().longValue()).size());
        this.validateReferences(mainArtifactReferences, originalContents);
        Assertions.assertEquals((int)expectedTotalArtifacts, (Integer)this.clientV2.listArtifactsInGroup(groupId).getCount());
    }

    private void validateReferences(List<ArtifactReference> artifactReferences, Set<String> loadedContents) {
        for (ArtifactReference artifactReference : artifactReferences) {
            String referenceContent = IoUtil.toString((InputStream)this.clientV2.getArtifactVersion(artifactReference.getGroupId(), artifactReference.getArtifactId(), artifactReference.getVersion()));
            ArtifactMetaData referenceMetadata = this.clientV2.getArtifactMetaData(artifactReference.getGroupId(), artifactReference.getArtifactId());
            Assertions.assertTrue((boolean)loadedContents.contains(referenceContent.trim()));
            List nestedReferences = this.clientV2.getArtifactReferencesByGlobalId(referenceMetadata.getGlobalId().longValue());
            if (nestedReferences.isEmpty()) continue;
            this.validateReferences(nestedReferences, loadedContents);
        }
    }
}

