/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.maven;

import io.apicurio.registry.maven.RegisterArtifact;
import io.apicurio.registry.maven.RegisterRegistryMojo;
import io.apicurio.registry.noprofile.maven.RegistryMojoTestBase;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class RegistryMojoWithMinifyTest
extends RegistryMojoTestBase {
    RegisterRegistryMojo registerMojo;

    @BeforeEach
    public void createMojo() {
        this.registerMojo = new RegisterRegistryMojo();
        this.registerMojo.setRegistryUrl(TestUtils.getRegistryV2ApiUrl((int)this.testPort));
    }

    @Test
    public void testMinify() throws Exception {
        String groupId = "RegisterWithMinifyRegistryMojoTest";
        File avroFile = new File(this.getClass().getResource("avro.avsc").getFile());
        RegisterArtifact avroMinifiedArtifact = new RegisterArtifact();
        avroMinifiedArtifact.setGroupId(groupId);
        avroMinifiedArtifact.setArtifactId("userInfoMinified");
        avroMinifiedArtifact.setType("AVRO");
        avroMinifiedArtifact.setMinify(Boolean.valueOf(true));
        avroMinifiedArtifact.setFile(avroFile);
        RegisterArtifact avroNotMinifiedArtifact = new RegisterArtifact();
        avroNotMinifiedArtifact.setGroupId(groupId);
        avroNotMinifiedArtifact.setArtifactId("userInfoNotMinified");
        avroNotMinifiedArtifact.setType("AVRO");
        avroNotMinifiedArtifact.setFile(avroFile);
        this.registerMojo.setArtifacts(List.of(avroMinifiedArtifact, avroNotMinifiedArtifact));
        this.registerMojo.execute();
        TestUtils.retry(() -> {
            InputStream artifactInputStream = this.clientV2.getLatestArtifact(groupId, "userInfoMinified");
            String artifactContent = new String(artifactInputStream.readAllBytes(), StandardCharsets.UTF_8);
            Assertions.assertEquals((Object)"{\"type\":\"record\",\"name\":\"userInfo\",\"namespace\":\"my.example\",\"fields\":[{\"name\":\"age\",\"type\":\"int\"}]}", (Object)artifactContent);
        });
        TestUtils.retry(() -> {
            InputStream artifactInputStream = this.clientV2.getLatestArtifact(groupId, "userInfoNotMinified");
            String artifactContent = new String(artifactInputStream.readAllBytes(), StandardCharsets.UTF_8);
            Assertions.assertEquals((Object)"{\n  \"type\" : \"record\",\n  \"name\" : \"userInfo\",\n  \"namespace\" : \"my.example\",\n  \"fields\" : [{\"name\" : \"age\", \"type\" : \"int\"}]\n}", (Object)artifactContent);
        });
    }
}

