/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.maven;

import io.apicurio.registry.maven.DownloadArtifact;
import io.apicurio.registry.maven.DownloadRegistryMojo;
import io.apicurio.registry.maven.RegisterArtifact;
import io.apicurio.registry.maven.RegisterArtifactReference;
import io.apicurio.registry.maven.RegisterRegistryMojo;
import io.apicurio.registry.noprofile.maven.RegistryMojoTestBase;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class RegistryMojoWithReferencesTest
extends RegistryMojoTestBase {
    RegisterRegistryMojo registerMojo;
    DownloadRegistryMojo downloadMojo;

    @BeforeEach
    public void createMojos() {
        this.registerMojo = new RegisterRegistryMojo();
        this.registerMojo.setRegistryUrl(TestUtils.getRegistryV2ApiUrl((int)this.testPort));
        this.downloadMojo = new DownloadRegistryMojo();
        this.downloadMojo.setRegistryUrl(TestUtils.getRegistryV2ApiUrl((int)this.testPort));
    }

    @Test
    public void testMojosWithReferences() throws IOException, MojoFailureException, MojoExecutionException {
        String groupId = "RegisterWithReferencesRegistryMojoTest";
        File exchangeFile = new File(this.getClass().getResource("Exchange.avsc").getFile());
        File tradeKeyFile = new File(this.getClass().getResource("TradeKey.avsc").getFile());
        File tradeRawFile = new File(this.getClass().getResource("TradeRaw.avsc").getFile());
        RegisterArtifact tradeRawArtifact = new RegisterArtifact();
        tradeRawArtifact.setGroupId(groupId);
        tradeRawArtifact.setArtifactId("tradeRaw");
        tradeRawArtifact.setType("AVRO");
        tradeRawArtifact.setFile(tradeRawFile);
        RegisterArtifactReference tradeKeyArtifact = new RegisterArtifactReference();
        tradeKeyArtifact.setGroupId(groupId);
        tradeKeyArtifact.setArtifactId("tradeKey");
        tradeKeyArtifact.setType("AVRO");
        tradeKeyArtifact.setFile(tradeKeyFile);
        tradeKeyArtifact.setName("tradeKey");
        RegisterArtifactReference exchangeArtifact = new RegisterArtifactReference();
        exchangeArtifact.setGroupId(groupId);
        exchangeArtifact.setArtifactId("exchange");
        exchangeArtifact.setType("AVRO");
        exchangeArtifact.setFile(exchangeFile);
        exchangeArtifact.setName("exchange");
        tradeKeyArtifact.setReferences(Collections.singletonList(exchangeArtifact));
        tradeRawArtifact.setReferences(Collections.singletonList(tradeKeyArtifact));
        this.registerMojo.setArtifacts(Collections.singletonList(tradeRawArtifact));
        this.registerMojo.execute();
        DownloadArtifact tradeRawDownload = new DownloadArtifact();
        tradeRawDownload.setArtifactId("tradeRaw");
        tradeRawDownload.setGroupId(groupId);
        tradeRawDownload.setFile(new File(this.tempDirectory, "tradeRaw.avsc"));
        DownloadArtifact tradeKeyDownload = new DownloadArtifact();
        tradeKeyDownload.setArtifactId("tradeKey");
        tradeKeyDownload.setGroupId(groupId);
        tradeKeyDownload.setFile(new File(this.tempDirectory, "tradeKey.avsc"));
        DownloadArtifact exchangeDownload = new DownloadArtifact();
        exchangeDownload.setArtifactId("tradeKey");
        exchangeDownload.setGroupId(groupId);
        exchangeDownload.setFile(new File(this.tempDirectory, "exchange.avsc"));
        tradeKeyDownload.setArtifactReferences(Collections.singletonList(exchangeDownload));
        tradeRawDownload.setArtifactReferences(Collections.singletonList(tradeKeyDownload));
        this.downloadMojo.setArtifacts(Collections.singletonList(tradeRawDownload));
        this.downloadMojo.execute();
    }
}

