/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.maven;

import io.apicurio.registry.maven.TestArtifact;
import io.apicurio.registry.maven.TestUpdateRegistryMojo;
import io.apicurio.registry.noprofile.maven.RegistryMojoTestBase;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.maven.plugin.MojoExecutionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class TestUpdateRegistryMojoTest
extends RegistryMojoTestBase {
    TestUpdateRegistryMojo mojo;

    @BeforeEach
    public void createMojo() {
        this.mojo = new TestUpdateRegistryMojo();
        this.mojo.setRegistryUrl(TestUtils.getRegistryV2ApiUrl((int)this.testPort));
    }

    @Test
    public void testCompatibility() throws Exception {
        String groupId = TestUpdateRegistryMojoTest.class.getName();
        String artifactId = this.generateArtifactId();
        Schema schema = new Schema.Parser().parse("{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"user\", \"fields\": [     {\"name\": \"name\", \"type\": \"string\"},     {\"name\": \"favorite_number\",  \"type\": \"int\"} ]}");
        this.clientV2.createArtifact(groupId, artifactId, "AVRO", (InputStream)new ByteArrayInputStream(schema.toString().getBytes(StandardCharsets.UTF_8)));
        this.waitForArtifact(groupId, artifactId);
        Rule rule = new Rule();
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("BACKWARD");
        this.clientV2.createArtifactRule(groupId, artifactId, rule);
        TestUtils.retry(() -> {
            Rule rconfig = this.clientV2.getArtifactRuleConfig(groupId, artifactId, RuleType.COMPATIBILITY);
            Assertions.assertEquals((Object)"BACKWARD", (Object)rconfig.getConfig());
        });
        Schema schema2 = new Schema.Parser().parse("{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"user\", \"fields\": [     {\"name\": \"name\", \"type\": \"string\"},     {\"name\": \"favorite_number\",  \"type\": \"string\"},     {\"name\": \"favorite_color\", \"type\": \"string\", \"default\": \"green\"} ]}");
        File file = new File(this.tempDirectory, artifactId + ".avsc");
        this.writeContent(file, schema2.toString().getBytes(StandardCharsets.UTF_8));
        ArrayList<TestArtifact> artifacts = new ArrayList<TestArtifact>();
        TestArtifact artifact = new TestArtifact();
        artifact.setGroupId(groupId);
        artifact.setArtifactId(artifactId);
        artifact.setFile(file);
        artifacts.add(artifact);
        this.mojo.setArtifacts(artifacts);
        Assertions.assertThrows(MojoExecutionException.class, () -> this.mojo.execute());
    }
}

