/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.resolver;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.resolver.DefaultSchemaResolver;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.SchemaLookupResult;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.data.Metadata;
import io.apicurio.registry.resolver.data.Record;
import io.apicurio.registry.resolver.strategy.ArtifactReference;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.registry.rest.client.exception.ArtifactNotFoundException;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class SchemaResolverTest
extends AbstractResourceTestBase {
    private RegistryClient restClient;

    @BeforeEach
    public void createIsolatedClient() {
        this.restClient = RegistryClientFactory.create((String)TestUtils.getRegistryV2ApiUrl((int)this.testPort));
    }

    @Test
    public void testDynamicStrategy() throws Exception {
        DefaultSchemaResolver resolver = new DefaultSchemaResolver();
        resolver.setClient(this.restClient);
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("apicurio.registry.find-latest", true);
        resolver.configure(config, (SchemaParser)new SchemaParser<Schema, GenericRecord>(){

            public Schema parseSchema(byte[] rawSchema, Map<String, ParsedSchema<Schema>> resolvedReferences) {
                return null;
            }

            public ParsedSchema<Schema> getSchemaFromData(Record<GenericRecord> data) {
                return null;
            }

            public ParsedSchema<Schema> getSchemaFromData(Record<GenericRecord> data, boolean dereference) {
                return null;
            }

            public boolean supportsExtractSchemaFromData() {
                return false;
            }

            public String artifactType() {
                return "AVRO";
            }
        });
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"myrecord3\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}");
        String artifactId = TestUtils.generateArtifactId();
        this.createArtifact(artifactId, "AVRO", schema.toString());
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("bar", (Object)"somebar");
        CustomResolverRecord record = new CustomResolverRecord((GenericRecord)avroRecord, (ArtifactReference)ArtifactReference.builder().artifactId(artifactId).build());
        SchemaLookupResult lookup = resolver.resolveSchema((Record)record);
        Assertions.assertNull((Object)lookup.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)lookup.getArtifactId());
        Assertions.assertEquals((Object)schema.toString(), (Object)new String(lookup.getParsedSchema().getRawSchema()));
        Assertions.assertNull((Object)lookup.getParsedSchema().getParsedSchema());
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> SchemaResolverTest.lambda$testDynamicStrategy$0((SchemaResolver)resolver, (GenericRecord)avroRecord));
        resolver.close();
    }

    private static /* synthetic */ void lambda$testDynamicStrategy$0(SchemaResolver resolver, GenericRecord avroRecord) throws Throwable {
        resolver.resolveSchema((Record)new CustomResolverRecord(avroRecord, (ArtifactReference)ArtifactReference.builder().artifactId("foo").build()));
    }

    private static class CustomResolverRecord
    implements Record<GenericRecord> {
        private GenericRecord payload;
        private ArtifactReference reference;

        public CustomResolverRecord(GenericRecord payload, ArtifactReference reference) {
            this.payload = payload;
            this.reference = reference;
        }

        public Metadata metadata() {
            return new Metadata(){

                public ArtifactReference artifactReference() {
                    return reference;
                }
            };
        }

        public GenericRecord payload() {
            return this.payload;
        }
    }
}

