/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.rest.v1;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.v1.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v1.beans.IfExistsType;
import io.apicurio.registry.rest.v1.beans.Rule;
import io.apicurio.registry.rest.v1.beans.VersionMetaData;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.CustomMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class ArtifactsResourceTest
extends AbstractResourceTestBase {
    @Test
    public void testCreateArtifact() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact("testCreateArtifact/EmptyAPI/1", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").header("X-Registry-ArtifactId", (Object)"testCreateArtifact/EmptyAPI/2", new Object[0]).body(artifactContent).post("/registry/v1/artifacts", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testCreateArtifact/EmptyAPI/2"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").header("X-Registry-ArtifactId", (Object)"testCreateArtifact/EmptyAPI/1", new Object[0]).body(artifactContent).post("/registry/v1/artifacts", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", Matchers.equalTo((Object)"An artifact with ID 'testCreateArtifact/EmptyAPI/1' in group 'null' already exists."), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=INVALID_ARTIFACT_TYPE").header("X-Registry-ArtifactId", (Object)"testCreateArtifact/InvalidAPI", new Object[0]).body(artifactContent).post("/registry/v1/artifacts", new Object[0])).then()).statusCode(400);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactId", (Object)"testCreateArtifact/EmptyAPI/detect", new Object[0]).body(artifactContent).post("/registry/v1/artifacts", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testCreateArtifact/EmptyAPI/detect"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactId", (Object)"testCreateArtifact/EmptyContent", new Object[0]).body("").post("/registry/v1/artifacts", new Object[0])).then()).statusCode(400);
    }

    @Test
    public void testCreateArtifactInvalidSyntax() throws Exception {
        String invalidArtifactContent = this.resourceToString("openapi-invalid-syntax.json");
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/registry/v1/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v1/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").header("X-Registry-ArtifactId", (Object)"testCreateArtifact/EmptyAPI/invalidSyntax", new Object[0]).body(invalidArtifactContent).post("/registry/v1/artifacts", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", Matchers.equalTo((Object)"Syntax violation for OpenAPI artifact."), new Object[0]);
    }

    @Test
    public void testGetArtifact() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact("testGetArtifact/EmptyAPI", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testGetArtifact/EmptyAPI").get("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testGetArtifact/MissingAPI").get("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(404)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"No artifact with ID 'testGetArtifact/MissingAPI' in group 'null' was found."), new Object[0]);
    }

    @Test
    public void testUpdateArtifact() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String updatedArtifactContent = artifactContent.replace("Empty API", "Empty API (Updated)");
        this.createArtifact("testUpdateArtifact/EmptyAPI", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testUpdateArtifact/EmptyAPI").body(updatedArtifactContent).put("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testUpdateArtifact/EmptyAPI"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testUpdateArtifact/EmptyAPI").get("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API (Updated)"), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testUpdateArtifact/MissingAPI").body(updatedArtifactContent).put("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(404);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testUpdateArtifact/EmptyAPI").body("").put("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(400);
    }

    @Test
    public void testDeleteArtifact() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact("testDeleteArtifact/EmptyAPI", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testDeleteArtifact/EmptyAPI").get("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API"), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testDeleteArtifact/EmptyAPI").delete("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testDeleteArtifact/EmptyAPI").get("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(404)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"No artifact with ID 'testDeleteArtifact/EmptyAPI' in group 'null' was found."), new Object[0]));
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testDeleteArtifact/MissingAPI").delete("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(404);
    }

    @Test
    public void testListArtifactVersions() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact("testListArtifactVersions/EmptyAPI", "OPENAPI", artifactContent);
        for (int idx = 0; idx < 5; ++idx) {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testListArtifactVersions/EmptyAPI").body(artifactContent.replace("Empty API", "Empty API (Update " + idx + ")")).put("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testListArtifactVersions/EmptyAPI"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        }
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testListArtifactVersions/EmptyAPI").get("/registry/v1/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body((Matcher)new CustomMatcher("Unexpected list of artifact versions."){

            public boolean matches(Object item) {
                String val = item.toString();
                if (val == null) {
                    return false;
                }
                if (!val.startsWith("[") || !val.endsWith("]")) {
                    return false;
                }
                return val.split(",").length == 6;
            }
        }, new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testListArtifactVersions/MissingAPI").get("/registry/v1/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(404);
    }

    @Test
    public void testCreateArtifactVersion() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String updatedArtifactContent = artifactContent.replace("Empty API", "Empty API (Updated)");
        this.createArtifact("testCreateArtifactVersion/EmptyAPI", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testCreateArtifactVersion/EmptyAPI").body(updatedArtifactContent).post("/registry/v1/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body("version", Matchers.equalTo((Object)2), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testCreateArtifactVersion/EmptyAPI").get("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API (Updated)"), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testCreateArtifactVersion/MissingAPI").body(updatedArtifactContent).post("/registry/v1/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(404);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testCreateArtifactVersion/EmptyAPI").body("").post("/registry/v1/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(400);
    }

    @Test
    public void testCreateArtifactVersionValidityRuleViolation() throws Exception {
        String artifactContent = this.resourceToString("jsonschema-valid.json");
        String artifactContentInvalidSyntax = this.resourceToString("jsonschema-invalid.json");
        String artifactId = "testCreateArtifact/ValidityRuleViolation";
        this.createArtifact(artifactId, "JSON", artifactContent);
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).pathParam("artifactId", (Object)artifactId).post("/registry/v1/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"JSON", new Object[0]).pathParam("artifactId", (Object)artifactId).body(artifactContentInvalidSyntax).post("/registry/v1/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", CoreMatchers.startsWith((String)"Syntax or semantic violation for JSON Schema artifact."), new Object[0]);
    }

    @Test
    public void testCreateArtifactVersionCompatibilityRuleViolation() throws Exception {
        String artifactContent = this.resourceToString("jsonschema-valid.json");
        String artifactContentInvalidSyntax = this.resourceToString("jsonschema-valid-incompatible.json");
        String artifactId = "testCreateArtifact/ValidJson";
        this.createArtifact(artifactId, "JSON", artifactContent);
        Rule rule = new Rule();
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("BACKWARD");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).pathParam("artifactId", (Object)artifactId).post("/registry/v1/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"BACKWARD"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"JSON", new Object[0]).pathParam("artifactId", (Object)artifactId).body(artifactContentInvalidSyntax).post("/registry/v1/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", CoreMatchers.startsWith((String)"Incompatible artifact: testCreateArtifact/ValidJson [JSON], num of incompatible diffs: {1}, list of diff types: [SUBSCHEMA_TYPE_CHANGED at /properties/age]"), new Object[0])).body("causes[0].description", Matchers.equalTo((Object)DiffType.SUBSCHEMA_TYPE_CHANGED.getDescription()), new Object[0])).body("causes[0].context", Matchers.equalTo((Object)"/properties/age"), new Object[0]);
    }

    @Test
    public void testGetArtifactVersion() throws Exception {
        Integer version;
        int idx;
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact("testGetArtifactVersion/EmptyAPI", "OPENAPI", artifactContent);
        ArrayList<Integer> versions = new ArrayList<Integer>();
        for (idx = 0; idx < 5; ++idx) {
            version = (Integer)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testGetArtifactVersion/EmptyAPI").body(artifactContent.replace("Empty API", "Empty API (Update " + idx + ")")).put("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testGetArtifactVersion/EmptyAPI"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).extract().body().path("version", new String[0]);
            versions.add(version);
        }
        for (idx = 0; idx < 5; ++idx) {
            version = (Integer)versions.get(idx);
            String expected = "Empty API (Update " + idx + ")";
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testGetArtifactVersion/EmptyAPI").pathParam("version", (Object)version).get("/registry/v1/artifacts/{artifactId}/versions/{version}", new Object[0])).then()).statusCode(200)).body("info.title", Matchers.equalTo((Object)expected), new Object[0]);
        }
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testGetArtifactVersion/EmptyAPI").pathParam("version", (Object)12345).get("/registry/v1/artifacts/{artifactId}/versions/{version}", new Object[0])).then()).statusCode(404);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testGetArtifactVersion/MissingAPI").pathParam("version", (Object)1).get("/registry/v1/artifacts/{artifactId}/versions/{version}", new Object[0])).then()).statusCode(404);
    }

    @Test
    public void testGetArtifactMetaDataByContent() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact("testGetArtifactMetaDataByContent/EmptyAPI", "OPENAPI", artifactContent);
        ArrayList<Integer> versions = new ArrayList<Integer>();
        for (int idx = 0; idx < 5; ++idx) {
            Integer version = (Integer)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testGetArtifactMetaDataByContent/EmptyAPI").body(artifactContent.replace("Empty API", "Empty API (Update " + idx + ")")).put("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testGetArtifactMetaDataByContent/EmptyAPI"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).extract().body().path("version", new String[0]);
            versions.add(version);
        }
        String searchContent = artifactContent.replace("Empty API", "Empty API (Update 2)");
        Integer globalId1 = (Integer)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("artifactId", (Object)"testGetArtifactMetaDataByContent/EmptyAPI").body(searchContent).post("/registry/v1/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200)).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).extract().body().path("globalId", new String[0]);
        searchContent = searchContent.replace("{", "{\n").replace("}", "\n}");
        Integer globalId2 = (Integer)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("artifactId", (Object)"testGetArtifactMetaDataByContent/EmptyAPI").queryParam("canonical", new Object[]{"true"}).body(searchContent).post("/registry/v1/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200)).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).extract().body().path("globalId", new String[0]);
        Assertions.assertEquals((Integer)globalId1, (Integer)globalId2);
        searchContent = searchContent.replace("{", "{\n").replace("}", "\n}");
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("artifactId", (Object)"testGetArtifactMetaDataByContent/EmptyAPI").body(searchContent).post("/registry/v1/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(404);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("artifactId", (Object)"testGetArtifactMetaDataByContent/EmptyAPI").body("").post("/registry/v1/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(400);
    }

    @Test
    public void testArtifactRules() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String artifactId = "testArtifactRules/EmptyAPI";
        this.createArtifact(artifactId, "OPENAPI", artifactContent);
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).pathParam("artifactId", (Object)artifactId).post("/registry/v1/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        Rule finalRule = rule;
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)finalRule).pathParam("artifactId", (Object)artifactId).post("/registry/v1/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", Matchers.equalTo((Object)"A rule named 'VALIDITY' already exists."), new Object[0]));
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("BACKWARD");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).pathParam("artifactId", (Object)artifactId).post("/registry/v1/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"BACKWARD"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("[0]", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)"VALIDITY"), Matchers.equalTo((Object)"COMPATIBILITY")}), new Object[0])).body("[1]", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)"VALIDITY"), Matchers.equalTo((Object)"COMPATIBILITY")}), new Object[0])).body("[2]", Matchers.nullValue(), new Object[0]);
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).pathParam("artifactId", (Object)artifactId).put("/registry/v1/artifacts/{artifactId}/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).delete("/registry/v1/artifacts/{artifactId}/rules/COMPATIBILITY", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/rules/COMPATIBILITY", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"No rule named 'COMPATIBILITY' was found."), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("[0]", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)"VALIDITY"), Matchers.equalTo((Object)"COMPATIBILITY")}), new Object[0])).body("[1]", Matchers.nullValue(), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).delete("/registry/v1/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("[0]", Matchers.nullValue(), new Object[0]));
        rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).pathParam("artifactId", (Object)"MissingArtifact").post("/registry/v1/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(404)).body(CoreMatchers.anything(), new Matcher[0]);
    }

    @Test
    public void testArtifactMetaData() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact("testGetArtifactMetaData/EmptyAPI", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testGetArtifactMetaData/EmptyAPI").get("/registry/v1/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testGetArtifactMetaData/EmptyAPI"), new Object[0])).body("version", CoreMatchers.anything(), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).body("createdOn", CoreMatchers.anything(), new Object[0])).body("name", Matchers.equalTo((Object)"Empty API"), new Object[0])).body("description", Matchers.equalTo((Object)"An example API design using OpenAPI."), new Object[0])).extract().as(ArtifactMetaData.class);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testGetArtifactMetaData/MissingAPI").get("/registry/v1/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(404)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"No artifact with ID 'testGetArtifactMetaData/MissingAPI' in group 'null' was found."), new Object[0]);
        String metaData = "{\"name\": \"Empty API Name\", \"description\": \"Empty API description.\", \"labels\":[\"Empty API label 1\",\"Empty API label 2\"], \"properties\":{\"additionalProp1\": \"Empty API additional property\"}}";
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body(metaData).pathParam("artifactId", (Object)"testGetArtifactMetaData/EmptyAPI").put("/registry/v1/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> {
            List<String> expectedLabels = Arrays.asList("Empty API label 1", "Empty API label 2");
            HashMap<String, String> expectedProperties = new HashMap<String, String>();
            expectedProperties.put("additionalProp1", "Empty API additional property");
            int version = (Integer)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testGetArtifactMetaData/EmptyAPI").get("/registry/v1/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testGetArtifactMetaData/EmptyAPI"), new Object[0])).body("version", CoreMatchers.anything(), new Object[0])).body("name", Matchers.equalTo((Object)"Empty API Name"), new Object[0])).body("description", Matchers.equalTo((Object)"Empty API description."), new Object[0])).body("labels", Matchers.equalToObject(expectedLabels), new Object[0])).body("properties", Matchers.equalToObject(expectedProperties), new Object[0])).extract().body().path("version", new String[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testGetArtifactMetaData/EmptyAPI").pathParam("version", (Object)version).get("/registry/v1/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then()).statusCode(200)).body("name", Matchers.equalTo((Object)"Empty API Name"), new Object[0])).body("description", Matchers.equalTo((Object)"Empty API description."), new Object[0])).body("labels", Matchers.equalToObject(expectedLabels), new Object[0])).body("properties", Matchers.equalToObject(expectedProperties), new Object[0])).extract().body().path("version", new String[0]);
        });
        String updatedArtifactContent = artifactContent.replace("Empty API", "Empty API (Updated)");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testGetArtifactMetaData/EmptyAPI").body(updatedArtifactContent).put("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testGetArtifactMetaData/EmptyAPI"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testGetArtifactMetaData/EmptyAPI").get("/registry/v1/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testGetArtifactMetaData/EmptyAPI"), new Object[0])).body("version", CoreMatchers.anything(), new Object[0])).body("name", Matchers.equalTo((Object)"Empty API (Updated)"), new Object[0])).body("description", Matchers.equalTo((Object)"An example API design using OpenAPI."), new Object[0]);
    }

    @Test
    public void testArtifactVersionMetaData() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String updatedArtifactContent_v2 = artifactContent.replace("Empty API", "Empty API (v2)");
        String updatedArtifactContent_v3 = artifactContent.replace("Empty API", "Empty API (v3)");
        this.createArtifact("testArtifactVersionMetaData/EmptyAPI", "OPENAPI", artifactContent);
        int version2 = (Integer)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testArtifactVersionMetaData/EmptyAPI").body(updatedArtifactContent_v2).post("/registry/v1/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body("version", Matchers.notNullValue(), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).extract().body().path("version", new String[0]);
        int version3 = (Integer)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testArtifactVersionMetaData/EmptyAPI").body(updatedArtifactContent_v3).post("/registry/v1/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body("version", Matchers.notNullValue(), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).extract().body().path("version", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testArtifactVersionMetaData/EmptyAPI").pathParam("version", (Object)version2).get("/registry/v1/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then()).statusCode(200)).body("version", Matchers.equalTo((Object)version2), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).body("createdOn", CoreMatchers.anything(), new Object[0])).body("name", Matchers.equalTo((Object)"Empty API (v2)"), new Object[0])).body("description", Matchers.equalTo((Object)"An example API design using OpenAPI."), new Object[0])).extract().as(VersionMetaData.class);
        String metaData = "{\"name\": \"Updated Name\", \"description\": \"Updated description.\"}";
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body(metaData).pathParam("artifactId", (Object)"testArtifactVersionMetaData/EmptyAPI").pathParam("version", (Object)version2).put("/registry/v1/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testArtifactVersionMetaData/EmptyAPI").pathParam("version", (Object)version2).get("/registry/v1/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then()).statusCode(200)).body("version", Matchers.equalTo((Object)version2), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).body("createdOn", CoreMatchers.anything(), new Object[0])).body("name", Matchers.equalTo((Object)"Updated Name"), new Object[0])).body("description", Matchers.equalTo((Object)"Updated description."), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testArtifactVersionMetaData/EmptyAPI").pathParam("version", (Object)version3).get("/registry/v1/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then()).statusCode(200)).body("version", Matchers.equalTo((Object)version3), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).body("createdOn", CoreMatchers.anything(), new Object[0])).body("name", Matchers.equalTo((Object)"Empty API (v3)"), new Object[0])).body("description", Matchers.equalTo((Object)"An example API design using OpenAPI."), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testArtifactVersionMetaData/EmptyAPI").pathParam("version", (Object)12345).get("/registry/v1/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then()).statusCode(404);
    }

    @Test
    public void testYamlContentType() throws Exception {
        String artifactId = "testYamlContentType";
        String artifactType = "OPENAPI";
        String artifactContent = this.resourceToString("openapi-empty.yaml");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().config(RestAssuredConfig.config().encoderConfig(EncoderConfig.encoderConfig().encodeContentTypeAs("application/x-yaml", ContentType.TEXT))).when().contentType("application/x-yaml").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).header("X-Registry-ArtifactType", (Object)artifactType, new Object[0]).body(artifactContent).post("/registry/v1/artifacts", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("name", Matchers.equalTo((Object)"Empty API"), new Object[0])).body("description", Matchers.equalTo((Object)"An example API design using OpenAPI."), new Object[0])).body("type", Matchers.equalTo((Object)artifactType), new Object[0]);
        this.waitForArtifact(artifactId);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testYamlContentType").get("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).header("Content-Type", Matchers.containsString((String)"application/json"))).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API"), new Object[0]);
    }

    @Test
    public void testWsdlArtifact() throws Exception {
        String artifactId = "testWsdlArtifact";
        String artifactType = "WSDL";
        String artifactContent = this.resourceToString("sample.wsdl");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().config(RestAssuredConfig.config().encoderConfig(EncoderConfig.encoderConfig().encodeContentTypeAs("application/xml", ContentType.TEXT))).when().contentType("application/xml").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).header("X-Registry-ArtifactType", (Object)artifactType, new Object[0]).body(artifactContent).post("/registry/v1/artifacts", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("type", Matchers.equalTo((Object)artifactType), new Object[0]);
        this.waitForArtifact(artifactId);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testWsdlArtifact").get("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).header("Content-Type", Matchers.containsString((String)"application/xml"));
    }

    @Test
    public void testCreateAlreadyExistingArtifact() throws Exception {
        String artifactId = UUID.randomUUID().toString();
        String artifactContent = this.resourceToString("openapi-empty.json");
        String updatedArtifactContent = artifactContent.replace("Empty API", "Empty API (Updated)");
        String v3ArtifactContent = artifactContent.replace("Empty API", "Empty API (Version 3)");
        Integer globalId1 = this.createArtifact(artifactId, "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).body(artifactContent).post("/registry/v1/artifacts", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", Matchers.equalTo((Object)("An artifact with ID '" + artifactId + "' in group 'null' already exists.")), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).queryParam("ifExists", new Object[]{IfExistsType.RETURN}).body(artifactContent).post("/registry/v1/artifacts", new Object[0])).then()).statusCode(200)).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).body("version", Matchers.equalTo((Object)1), new Object[0])).body("createdOn", CoreMatchers.anything(), new Object[0])).body("name", Matchers.equalTo((Object)"Empty API"), new Object[0])).body("description", Matchers.equalTo((Object)"An example API design using OpenAPI."), new Object[0]);
        ValidatableResponse resp = (ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).queryParam("ifExists", new Object[]{IfExistsType.UPDATE}).body(updatedArtifactContent).post("/registry/v1/artifacts", new Object[0])).then()).statusCode(200)).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).body("createdOn", CoreMatchers.anything(), new Object[0])).body("version", Matchers.equalTo((Object)2), new Object[0])).body("description", Matchers.equalTo((Object)"An example API design using OpenAPI."), new Object[0]);
        Integer globalId2 = (Integer)resp.extract().body().path("globalId", new String[0]);
        this.waitForGlobalId(globalId2.intValue());
        resp = (ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).queryParam("ifExists", new Object[]{IfExistsType.RETURN_OR_UPDATE}).body(artifactContent).post("/registry/v1/artifacts", new Object[0])).then()).statusCode(200)).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        Integer globalId3 = (Integer)resp.extract().body().path("globalId", new String[0]);
        Assertions.assertEquals((Integer)globalId1, (Integer)globalId3);
        resp = (ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).queryParam("ifExists", new Object[]{IfExistsType.RETURN_OR_UPDATE}).body(v3ArtifactContent).post("/registry/v1/artifacts", new Object[0])).then()).statusCode(200)).body("version", Matchers.equalTo((Object)3), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
    }

    @Test
    public void testDeleteArtifactWithRule() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String artifactId = "testDeleteArtifactWithRule/EmptyAPI";
        this.createArtifact(artifactId, "OPENAPI", artifactContent);
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).pathParam("artifactId", (Object)artifactId).post("/registry/v1/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).delete("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> {
            ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/rules/VALIDITY", new Object[0])).then()).statusCode(404);
            ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(404);
        });
        this.createArtifact(artifactId, "OPENAPI", artifactContent);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/rules/VALIDITY", new Object[0])).then()).statusCode(404);
        rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).pathParam("artifactId", (Object)artifactId).post("/registry/v1/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
    }
}

