/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.rest.v1;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.v1.beans.Rule;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.config.EncoderConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class FullApiTest
extends AbstractResourceTestBase {
    @Test
    public void testGlobalRuleApplicationOpenAPI() throws Exception {
        String artifactType = "OPENAPI";
        String artifactContent = this.resourceToString("openapi-invalid-syntax.json");
        this.createArtifact("testGlobalRuleApplicationOpenAPI/API", artifactType, artifactContent);
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig(ValidityLevel.SYNTAX_ONLY.name());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/registry/v1/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v1/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"SYNTAX_ONLY"), new Object[0]));
        String artifactId = "testGlobalRuleApplicationOpenAPI/InvalidAPI";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).header("X-Registry-ArtifactType", (Object)artifactType, new Object[0]).body(artifactContent).post("/registry/v1/artifacts", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", Matchers.equalTo((Object)"Syntax violation for OpenAPI artifact."), new Object[0]);
    }

    @Test
    public void testGlobalRuleApplicationProtobuf() throws Exception {
        String artifactType = "PROTOBUF";
        String artifactContent = this.resourceToString("protobuf-invalid-syntax.proto");
        this.createArtifact("testGlobalRuleApplicationProtobuf/API", artifactType, artifactContent);
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig(ValidityLevel.SYNTAX_ONLY.name());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/registry/v1/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v1/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"SYNTAX_ONLY"), new Object[0]));
        String artifactId = "testGlobalRuleApplicationProtobuf/InvalidAPI";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().config(RestAssured.config().encoderConfig(new EncoderConfig().encodeContentTypeAs("application/x-protobuf", ContentType.TEXT))).when().contentType("application/x-protobuf").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).header("X-Registry-ArtifactType", (Object)artifactType, new Object[0]).body(artifactContent).post("/registry/v1/artifacts", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", Matchers.equalTo((Object)"Syntax violation for Protobuf artifact."), new Object[0]);
    }

    @Test
    public void testV1CompatibilityPath() throws Exception {
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + this.testPort + "/api").when().contentType("application/json").body((Object)rule).post("/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + this.testPort + "/api").when().get("/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        ((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + this.testPort + "/api").when().delete("/rules", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + this.testPort + "/api").when().get("/rules", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("[0]", Matchers.nullValue(), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + this.testPort + "/api").when().get("/rules/VALIDITY", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"No rule named 'VALIDITY' was found."), new Object[0]);
    }
}

