/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.rest.v1;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.v1.beans.Rule;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class TestResourceTest
extends AbstractResourceTestBase {
    @Test
    public void testTestArtifactNoViolations() throws Exception {
        String artifactContent = this.resourceToString("jsonschema-valid.json");
        String artifactContentValid = this.resourceToString("jsonschema-valid-compatible.json");
        String artifactId = "testCreateArtifact/TestNoViolation";
        this.createArtifact(artifactId, "JSON", artifactContent);
        Rule rule = new Rule();
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("BACKWARD");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).pathParam("artifactId", (Object)artifactId).post("/registry/v1/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"BACKWARD"), new Object[0]));
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"JSON", new Object[0]).pathParam("artifactId", (Object)artifactId).body(artifactContentValid).put("/registry/v1/artifacts/{artifactId}/test", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void testTestArtifactCompatibilityViolation() throws Exception {
        String artifactContent = this.resourceToString("jsonschema-valid.json");
        String artifactContentIncompatible = this.resourceToString("jsonschema-valid-incompatible.json");
        String artifactId = "testTestArtifactCompatibilityViolation";
        this.createArtifact(artifactId, "JSON", artifactContent);
        Rule rule = new Rule();
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("BACKWARD");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).pathParam("artifactId", (Object)artifactId).post("/registry/v1/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"BACKWARD"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"JSON", new Object[0]).pathParam("artifactId", (Object)artifactId).body(artifactContentIncompatible).put("/registry/v1/artifacts/{artifactId}/test", new Object[0])).then()).log().all()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", CoreMatchers.startsWith((String)"Incompatible artifact: testTestArtifactCompatibilityViolation [JSON], num of incompatible diffs: {1}, list of diff types: [SUBSCHEMA_TYPE_CHANGED at /properties/age]"), new Object[0])).body("causes[0].description", Matchers.equalTo((Object)DiffType.SUBSCHEMA_TYPE_CHANGED.getDescription()), new Object[0])).body("causes[0].context", Matchers.equalTo((Object)"/properties/age"), new Object[0]);
    }

    @Test
    public void testTestArtifactValidityViolation() throws Exception {
        String artifactContent = this.resourceToString("jsonschema-valid.json");
        String artifactContentInvalidSyntax = this.resourceToString("jsonschema-invalid.json");
        String artifactId = "testTestArtifactValidityViolation";
        this.createArtifact(artifactId, "JSON", artifactContent);
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).pathParam("artifactId", (Object)artifactId).post("/registry/v1/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"JSON", new Object[0]).pathParam("artifactId", (Object)artifactId).body(artifactContentInvalidSyntax).put("/registry/v1/artifacts/{artifactId}/test", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", CoreMatchers.startsWith((String)"Syntax or semantic violation for JSON Schema artifact."), new Object[0]);
    }

    @Test
    public void testOpenApiValidityViolation() throws Exception {
        String artifactContent = this.resourceToString("openapi-valid-syntax.json");
        String artifactContentInvalid = this.resourceToString("openapi-invalid-singleerror.json");
        String artifactId = "testOpenApiValidityViolation";
        this.createArtifact(artifactId, "OPENAPI", artifactContent);
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).pathParam("artifactId", (Object)artifactId).post("/registry/v1/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)artifactId).body(artifactContentInvalid).put("/registry/v1/artifacts/{artifactId}/test", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", CoreMatchers.startsWith((String)"The OpenAPI artifact is not semantically valid. 1 problems found."), new Object[0])).body("causes[0].description", Matchers.equalTo((Object)"Schema Reference must refer to a valid Schema Definition."), new Object[0])).body("causes[0].context", Matchers.equalTo((Object)"/paths[/widgets]/get/responses[200]/content[application/json]/schema/items"), new Object[0]);
    }
}

