/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.rest.v2;

import com.google.common.hash.Hashing;
import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.client.exception.RuleViolationException;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.ArtifactOwner;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rest.v2.beans.Comment;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.rest.v2.beans.IfExists;
import io.apicurio.registry.rest.v2.beans.NewComment;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.UpdateState;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffType;
import io.apicurio.registry.storage.impl.sql.SqlUtil;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.ReferenceType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.common.mapper.TypeRef;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jose4j.base64url.Base64;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfEnvironmentVariable;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@QuarkusTest
public class GroupsResourceTest
extends AbstractResourceTestBase {
    private static final String GROUP = "GroupsResourceTest";

    @Test
    public void testDefaultGroup() throws Exception {
        String oaiArtifactContent = this.resourceToString("openapi-empty.json");
        String jsonArtifactContent = this.resourceToString("jsonschema-valid.json");
        String nullGroup = "default";
        String group = "testDefaultGroup";
        this.createArtifact(nullGroup, "testDefaultGroup/EmptyAPI/1", "OPENAPI", oaiArtifactContent);
        this.createArtifact(nullGroup, "testDefaultGroup/EmptyAPI/2", "OPENAPI", oaiArtifactContent);
        this.createArtifact(nullGroup, "testDefaultGroup/EmptyAPI/3", "OPENAPI", oaiArtifactContent);
        this.createArtifact(nullGroup, "testDefaultGroup/EmptyAPI/4", "OPENAPI", oaiArtifactContent);
        this.createArtifact(nullGroup, "testDefaultGroup/EmptyAPI/5", "OPENAPI", oaiArtifactContent);
        this.createArtifact(group, "testDefaultGroup/EmptyAPI/1", "OPENAPI", jsonArtifactContent);
        this.createArtifact(group, "testDefaultGroup/EmptyAPI/2", "OPENAPI", jsonArtifactContent);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("group", new Object[]{nullGroup}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(5)), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("group", new Object[]{group}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)2), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)nullGroup).pathParam("artifactId", (Object)"testDefaultGroup/EmptyAPI/1").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)group).pathParam("artifactId", (Object)"testDefaultGroup/EmptyAPI/1").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.not((Matcher)Matchers.equalTo((Object)"3.0.2")), new Object[0])).body("info.title", Matchers.not((Matcher)Matchers.equalTo((Object)"Empty API")), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testDefaultGroup/EmptyAPI/1").get("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API"), new Object[0]);
        this.createArtifact("testDefaultGroup/EmptyAPI/6", "OPENAPI", oaiArtifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)"testDefaultGroup/EmptyAPI/6").get("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)nullGroup).pathParam("artifactId", (Object)"testDefaultGroup/EmptyAPI/6").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API"), new Object[0]);
    }

    @Test
    public void testUpdateArtifactOwner() throws Exception {
        String oaiArtifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact("testUpdateArtifactOwner", "testUpdateArtifactOwner/EmptyAPI/1", "OPENAPI", oaiArtifactContent);
        ArtifactOwner artifactOwner = new ArtifactOwner("newOwner");
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)"testUpdateArtifactOwner").pathParam("artifactId", (Object)"testUpdateArtifactOwner/EmptyAPI/1").body((Object)artifactOwner).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}/owner", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void testUpdateEmptyArtifactOwner() throws Exception {
        String oaiArtifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact("testUpdateEmptyArtifactOwner", "testUpdateEmptyArtifactOwner/EmptyAPI/1", "OPENAPI", oaiArtifactContent);
        ArtifactOwner artifactOwner = new ArtifactOwner("");
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)"testUpdateEmptyArtifactOwner").pathParam("artifactId", (Object)"testUpdateEmptyArtifactOwner/EmptyAPI/1").body((Object)artifactOwner).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}/owner", new Object[0])).then()).statusCode(400);
    }

    @Test
    public void testMultipleGroups() throws Exception {
        String oaiArtifactContent = this.resourceToString("openapi-empty.json");
        String jsonArtifactContent = this.resourceToString("jsonschema-valid.json");
        String group1 = "testMultipleGroups_1";
        String group2 = "testMultipleGroups_2";
        this.createArtifact(group1, "testMultipleGroups/EmptyAPI/1", "OPENAPI", oaiArtifactContent);
        this.createArtifact(group1, "testMultipleGroups/EmptyAPI/2", "OPENAPI", oaiArtifactContent);
        this.createArtifact(group1, "testMultipleGroups/EmptyAPI/3", "OPENAPI", oaiArtifactContent);
        this.createArtifact(group1, "testMultipleGroups/EmptyAPI/4", "OPENAPI", oaiArtifactContent);
        this.createArtifact(group1, "testMultipleGroups/EmptyAPI/5", "OPENAPI", oaiArtifactContent);
        this.createArtifact(group2, "testMultipleGroups/EmptyAPI/1", "OPENAPI", jsonArtifactContent);
        this.createArtifact(group2, "testMultipleGroups/EmptyAPI/2", "OPENAPI", jsonArtifactContent);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)group1).get("/registry/v2/groups/{groupId}", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testMultipleGroups_1"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)group2).get("/registry/v2/groups/{groupId}", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testMultipleGroups_2"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("group", new Object[]{group1}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)5), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("group", new Object[]{group2}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)2), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)group1).pathParam("artifactId", (Object)"testMultipleGroups/EmptyAPI/1").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)group2).pathParam("artifactId", (Object)"testMultipleGroups/EmptyAPI/1").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.not((Matcher)Matchers.equalTo((Object)"3.0.2")), new Object[0])).body("info.title", Matchers.not((Matcher)Matchers.equalTo((Object)"Empty API")), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)group1).delete("/registry/v2/groups/{groupId}", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)group2).delete("/registry/v2/groups/{groupId}", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)group1).get("/registry/v2/groups/{groupId}", new Object[0])).then()).statusCode(404);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)group2).get("/registry/v2/groups/{groupId}", new Object[0])).then()).statusCode(404);
    }

    @Test
    public void testCreateArtifact() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact(GROUP, "testCreateArtifact/EmptyAPI/1", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)"testCreateArtifact/EmptyAPI/2", new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("groupId", Matchers.equalTo((Object)GROUP), new Object[0])).body("version", Matchers.equalTo((Object)"1"), new Object[0])).body("id", Matchers.equalTo((Object)"testCreateArtifact/EmptyAPI/2"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)"testCreateArtifact/EmptyAPI/1", new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", Matchers.equalTo((Object)"An artifact with ID 'testCreateArtifact/EmptyAPI/1' in group 'GroupsResourceTest' already exists."), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=INVALID_ARTIFACT_TYPE").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)"testCreateArtifact/InvalidAPI", new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(400);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)"testCreateArtifact/EmptyAPI/detect", new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testCreateArtifact/EmptyAPI/detect"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)"testCreateArtifact/EmptyContent", new Object[0]).body("").post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(400);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)"testCreateArtifact/EmptyAPI-customVersion", new Object[0]).header("X-Registry-Version", (Object)"1.0.2", new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("groupId", Matchers.equalTo((Object)GROUP), new Object[0])).body("version", Matchers.equalTo((Object)"1.0.2"), new Object[0])).body("id", Matchers.equalTo((Object)"testCreateArtifact/EmptyAPI-customVersion"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        String customName = "CUSTOM NAME";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)"testCreateArtifact/EmptyAPI-customName", new Object[0]).header("X-Registry-Name", (Object)customName, new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("groupId", Matchers.equalTo((Object)GROUP), new Object[0])).body("name", Matchers.equalTo((Object)customName), new Object[0])).body("id", Matchers.equalTo((Object)"testCreateArtifact/EmptyAPI-customName"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        String customDescription = "CUSTOM DESCRIPTION";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)"testCreateArtifact/EmptyAPI-customDescription", new Object[0]).header("X-Registry-Description", (Object)customDescription, new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("groupId", Matchers.equalTo((Object)GROUP), new Object[0])).body("description", Matchers.equalTo((Object)customDescription), new Object[0])).body("id", Matchers.equalTo((Object)"testCreateArtifact/EmptyAPI-customDescription"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
    }

    @Test
    @DisabledIfEnvironmentVariable(named="CURRENT_ENV", matches=".*mas.*")
    @DisabledOnOs(value={OS.WINDOWS})
    public void testCreateArtifactNoAscii() {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String customNoASCIIName = "CUSTOM NAME with NO-ASCII char \u010d";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)"testCreateArtifact/EmptyAPI-customNameEncoded", new Object[0]).header("X-Registry-Name-Encoded", (Object)Base64.encode((byte[])customNoASCIIName.getBytes(StandardCharsets.UTF_8)), new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("groupId", Matchers.equalTo((Object)GROUP), new Object[0])).body("name", Matchers.equalTo((Object)customNoASCIIName), new Object[0])).body("id", Matchers.equalTo((Object)"testCreateArtifact/EmptyAPI-customNameEncoded"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        String customNoASCIIDescription = "CUSTOM DESCRIPTION with NO-ASCII char \u010d";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)"testCreateArtifact/EmptyAPI-customDescriptionEncoded", new Object[0]).header("X-Registry-Description-Encoded", (Object)Base64.encode((byte[])customNoASCIIDescription.getBytes(StandardCharsets.UTF_8)), new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("groupId", Matchers.equalTo((Object)GROUP), new Object[0])).body("description", Matchers.equalTo((Object)customNoASCIIDescription), new Object[0])).body("id", Matchers.equalTo((Object)"testCreateArtifact/EmptyAPI-customDescriptionEncoded"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        String customName = "CUSTOM NAME";
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)"testCreateArtifact/EmptyAPI-customNameConflict", new Object[0]).header("X-Registry-Name", (Object)customName, new Object[0]).header("X-Registry-Name-Encoded", (Object)Base64.encode((byte[])customNoASCIIName.getBytes(StandardCharsets.UTF_8)), new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(409);
    }

    @Test
    public void testGetArtifact() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact(GROUP, "testGetArtifact/EmptyAPI", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testGetArtifact/EmptyAPI").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testGetArtifact/MissingAPI").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(404)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"No artifact with ID 'testGetArtifact/MissingAPI' in group 'GroupsResourceTest' was found."), new Object[0]);
    }

    @Test
    public void testUpdateArtifact() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String updatedArtifactContent = artifactContent.replace("Empty API", "Empty API (Updated)");
        this.createArtifact(GROUP, "testUpdateArtifact/EmptyAPI", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testUpdateArtifact/EmptyAPI").body(updatedArtifactContent).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testUpdateArtifact/EmptyAPI"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testUpdateArtifact/EmptyAPI").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API (Updated)"), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testUpdateArtifact/MissingAPI").body(updatedArtifactContent).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(404);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testUpdateArtifact/EmptyAPI").body("").put("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(400);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).header("X-Registry-Version", (Object)"3.0.0.Final", new Object[0]).pathParam("artifactId", (Object)"testUpdateArtifact/EmptyAPI").body(updatedArtifactContent).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("version", Matchers.equalTo((Object)"3.0.0.Final"), new Object[0])).body("id", Matchers.equalTo((Object)"testUpdateArtifact/EmptyAPI"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        String customName = "CUSTOM NAME";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).header("X-Registry-Name", (Object)customName, new Object[0]).pathParam("artifactId", (Object)"testUpdateArtifact/EmptyAPI").body(updatedArtifactContent).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("name", Matchers.equalTo((Object)customName), new Object[0])).body("id", Matchers.equalTo((Object)"testUpdateArtifact/EmptyAPI"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        String customDescription = "CUSTOM DESCRIPTION";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).header("X-Registry-Description", (Object)customDescription, new Object[0]).pathParam("artifactId", (Object)"testUpdateArtifact/EmptyAPI").body(updatedArtifactContent).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("description", Matchers.equalTo((Object)customDescription), new Object[0])).body("id", Matchers.equalTo((Object)"testUpdateArtifact/EmptyAPI"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
    }

    @Test
    public void testUpdateArtifactState() throws Exception {
        String oaiArtifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact("testUpdateArtifactState", "testUpdateArtifactState/EmptyAPI/1", "OPENAPI", oaiArtifactContent);
        UpdateState updateState = new UpdateState();
        updateState.setState(ArtifactState.DEPRECATED);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)"testUpdateArtifactState").pathParam("artifactId", (Object)"testUpdateArtifactState/EmptyAPI/1").body((Object)updateState).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}/state", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)"testUpdateArtifactState").pathParam("artifactId", (Object)"testUpdateArtifactState/EmptyAPI/1").body((Object)updateState).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}/state", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)"testUpdateArtifactState").pathParam("artifactId", (Object)"testUpdateArtifactState/EmptyAPI/1").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).header("X-Registry-Deprecated", "true");
    }

    @Test
    public void testUpdateArtifactVersionState() throws Exception {
        String oaiArtifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact("testUpdateArtifactVersionState", "testUpdateArtifactVersionState/EmptyAPI", "OPENAPI", oaiArtifactContent);
        UpdateState updateState = new UpdateState();
        updateState.setState(ArtifactState.DEPRECATED);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)"testUpdateArtifactVersionState").pathParam("artifactId", (Object)"testUpdateArtifactVersionState/EmptyAPI").pathParam("versionId", (Object)"1").body((Object)updateState).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{versionId}/state", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)"testUpdateArtifactVersionState").pathParam("artifactId", (Object)"testUpdateArtifactVersionState/EmptyAPI").pathParam("versionId", (Object)"1").body((Object)updateState).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{versionId}/state", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)"testUpdateArtifactVersionState").pathParam("artifactId", (Object)"testUpdateArtifactVersionState/EmptyAPI").pathParam("versionId", (Object)"1").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{versionId}", new Object[0])).then()).statusCode(200)).header("X-Registry-Deprecated", "true");
    }

    @Test
    @DisabledIfEnvironmentVariable(named="CURRENT_ENV", matches=".*mas.*")
    @DisabledOnOs(value={OS.WINDOWS})
    public void testUpdateArtifactNoAscii() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String updatedArtifactContent = artifactContent.replace("Empty API", "Empty API (Updated)");
        this.createArtifact(GROUP, "testUpdateArtifactNoAscii/EmptyAPI", "OPENAPI", artifactContent);
        String customNoASCIIName = "CUSTOM NAME with NO-ASCII char \u011b";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).header("X-Registry-Name-Encoded", (Object)Base64.encode((byte[])customNoASCIIName.getBytes(StandardCharsets.UTF_8)), new Object[0]).pathParam("artifactId", (Object)"testUpdateArtifactNoAscii/EmptyAPI").body(updatedArtifactContent).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("name", Matchers.equalTo((Object)customNoASCIIName), new Object[0])).body("id", Matchers.equalTo((Object)"testUpdateArtifactNoAscii/EmptyAPI"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        String customNoASCIIDescription = "CUSTOM DESCRIPTION with NO-ASCII char \u011b";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).header("X-Registry-Description-Encoded", (Object)Base64.encode((byte[])customNoASCIIDescription.getBytes(StandardCharsets.UTF_8)), new Object[0]).pathParam("artifactId", (Object)"testUpdateArtifactNoAscii/EmptyAPI").body(updatedArtifactContent).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("description", Matchers.equalTo((Object)customNoASCIIDescription), new Object[0])).body("id", Matchers.equalTo((Object)"testUpdateArtifactNoAscii/EmptyAPI"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        String customName = "CUSTOM NAME";
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).header("X-Registry-Name", (Object)customName, new Object[0]).header("X-Registry-Name-Encoded", (Object)Base64.encode((byte[])customNoASCIIName.getBytes(StandardCharsets.UTF_8)), new Object[0]).pathParam("artifactId", (Object)"testUpdateArtifactNoAscii/EmptyAPI").body(updatedArtifactContent).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(409);
    }

    @Test
    public void testDeleteArtifact() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact(GROUP, "testDeleteArtifact/EmptyAPI", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testDeleteArtifact/EmptyAPI").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API"), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testDeleteArtifact/EmptyAPI").delete("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testDeleteArtifact/EmptyAPI").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(404)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"No artifact with ID 'testDeleteArtifact/EmptyAPI' in group 'GroupsResourceTest' was found."), new Object[0]));
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testDeleteArtifact/MissingAPI").delete("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(404);
    }

    @Test
    public void testDeleteArtifactVersion() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String updatedArtifactContent = artifactContent.replace("Empty API", "Empty API (Updated)");
        this.createArtifact(GROUP, "testDeleteArtifactVersion/EmptyAPI", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testDeleteArtifactVersion/EmptyAPI").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testDeleteArtifactVersion/EmptyAPI").body(updatedArtifactContent).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body("version", Matchers.equalTo((Object)"2"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testDeleteArtifactVersion/EmptyAPI").pathParam("version", (Object)"1").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API"), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testDeleteArtifactVersion/EmptyAPI").pathParam("version", (Object)"1").delete("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testDeleteArtifactVersion/EmptyAPI").pathParam("version", (Object)"1").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}", new Object[0])).then()).statusCode(404)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"No version '1' found for artifact with ID 'testDeleteArtifactVersion/EmptyAPI' in group 'GroupsResourceTest'."), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testDeleteArtifactVersion/EmptyAPI").pathParam("version", (Object)"2").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API (Updated)"), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testDeleteArtifactVersion/EmptyAPI").pathParam("version", (Object)"2").delete("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testDeleteArtifactVersion/EmptyAPI").pathParam("version", (Object)"2").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}", new Object[0])).then()).statusCode(404)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"No version '2' found for artifact with ID 'testDeleteArtifactVersion/EmptyAPI' in group 'GroupsResourceTest'."), new Object[0]));
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testDeleteArtifactVersion/EmptyAPI").pathParam("version", (Object)"2").delete("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}", new Object[0])).then()).statusCode(404);
    }

    @Test
    public void testDeleteArtifactsInGroup() throws Exception {
        String group = "testDeleteArtifactsInGroup";
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact(group, "EmptyAPI-1", "OPENAPI", artifactContent);
        this.createArtifact(group, "EmptyAPI-2", "OPENAPI", artifactContent);
        this.createArtifact(group, "EmptyAPI-3", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("group", new Object[]{group}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)3), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)group).delete("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("group", new Object[]{group}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)0), new Object[0]));
    }

    @Test
    public void testListArtifactsInGroup() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String group = "testListArtifactsInGroup";
        this.createArtifact(group, "EmptyAPI-1", "OPENAPI", artifactContent);
        this.createArtifact(group, "EmptyAPI-2", "OPENAPI", artifactContent);
        this.createArtifact(group, "EmptyAPI-3", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)group).get("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)3), new Object[0]);
        this.createArtifact(group, "EmptyAPI-4", "OPENAPI", artifactContent);
        this.createArtifact(group, "EmptyAPI-5", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)group).get("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)5), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)(group + "-doesnotexist")).get("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)0), new Object[0]);
    }

    @Test
    public void testListArtifactVersions() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String artifactId = "testListArtifactVersions/EmptyAPI";
        this.createArtifact(GROUP, artifactId, "OPENAPI", artifactContent);
        for (int idx = 0; idx < 5; ++idx) {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).body(artifactContent.replace("Empty API", "Empty API (Update " + idx + ")")).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        }
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)6), new Object[0])).body("versions[0].version", Matchers.notNullValue(), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testListArtifactVersions/MissingAPI").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(404);
    }

    @Test
    public void testCreateArtifactVersion() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String updatedArtifactContent = artifactContent.replace("Empty API", "Empty API (Updated)");
        this.createArtifact(GROUP, "testCreateArtifactVersion/EmptyAPI", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testCreateArtifactVersion/EmptyAPI").body(updatedArtifactContent).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body("version", Matchers.equalTo((Object)"2"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testCreateArtifactVersion/EmptyAPI").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API (Updated)"), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testCreateArtifactVersion/MissingAPI").body(updatedArtifactContent).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(404);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testCreateArtifactVersion/EmptyAPI").body("").post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(400);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-Version", (Object)"3.0.0.Final", new Object[0]).pathParam("artifactId", (Object)"testCreateArtifactVersion/EmptyAPI").body(updatedArtifactContent).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body("version", Matchers.equalTo((Object)"3.0.0.Final"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        String customName = "CUSTOM NAME";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-Name", (Object)customName, new Object[0]).pathParam("artifactId", (Object)"testCreateArtifactVersion/EmptyAPI").body(updatedArtifactContent).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body("name", Matchers.equalTo((Object)customName), new Object[0]);
        String customDescription = "CUSTOM DESCRIPTION";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-Description", (Object)customDescription, new Object[0]).pathParam("artifactId", (Object)"testCreateArtifactVersion/EmptyAPI").body(updatedArtifactContent).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body("description", Matchers.equalTo((Object)customDescription), new Object[0]);
    }

    @Test
    @DisabledIfEnvironmentVariable(named="CURRENT_ENV", matches=".*mas.*")
    @DisabledOnOs(value={OS.WINDOWS})
    public void testCreateArtifactVersionNoAscii() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String updatedArtifactContent = artifactContent.replace("Empty API", "Empty API (Updated)");
        this.createArtifact(GROUP, "testCreateArtifactVersionNoAscii/EmptyAPI", "OPENAPI", artifactContent);
        String customNameNoASCII = "CUSTOM NAME WITH NO-ASCII CHAR \u011b";
        String customDescriptionNoASCII = "CUSTOM DESCRIPTION WITH NO-ASCII CHAR \u011b";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-Name-Encoded", (Object)Base64.encode((byte[])customNameNoASCII.getBytes(StandardCharsets.UTF_8)), new Object[0]).header("X-Registry-Description-Encoded", (Object)Base64.encode((byte[])customDescriptionNoASCII.getBytes(StandardCharsets.UTF_8)), new Object[0]).pathParam("artifactId", (Object)"testCreateArtifactVersionNoAscii/EmptyAPI").body(updatedArtifactContent).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body("name", Matchers.equalTo((Object)customNameNoASCII), new Object[0])).body("description", Matchers.equalTo((Object)customDescriptionNoASCII), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testCreateArtifactVersionNoAscii/EmptyAPI").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200)).body("name", Matchers.equalTo((Object)customNameNoASCII), new Object[0])).body("description", Matchers.equalTo((Object)customDescriptionNoASCII), new Object[0]);
        String customName = "CUSTOM NAME";
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-Name-Encoded", (Object)Base64.encode((byte[])customNameNoASCII.getBytes(StandardCharsets.UTF_8)), new Object[0]).header("X-Registry-Name", (Object)customName, new Object[0]).pathParam("artifactId", (Object)"testCreateArtifactVersionNoAscii/EmptyAPI").body(updatedArtifactContent).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(409);
    }

    @Test
    public void testCreateArtifactVersionValidityRuleViolation() throws Exception {
        String artifactContent = this.resourceToString("jsonschema-valid.json");
        String artifactContentInvalidSyntax = this.resourceToString("jsonschema-invalid.json");
        String artifactId = "testCreateArtifact/ValidityRuleViolation";
        this.createArtifact(GROUP, artifactId, "JSON", artifactContent);
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).body((Object)rule).pathParam("artifactId", (Object)artifactId).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"JSON", new Object[0]).pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).body(artifactContentInvalidSyntax).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", Matchers.startsWith((String)"Syntax or semantic violation for JSON Schema artifact."), new Object[0]);
    }

    @Test
    public void testCreateArtifactVersionCompatibilityRuleViolation() throws Exception {
        String artifactContent = this.resourceToString("jsonschema-valid.json");
        String artifactContentInvalidSyntax = this.resourceToString("jsonschema-valid-incompatible.json");
        String artifactId = "testCreateArtifact/ValidJson";
        this.createArtifact(GROUP, artifactId, "JSON", artifactContent);
        Rule rule = new Rule();
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("BACKWARD");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).body((Object)rule).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"BACKWARD"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"JSON", new Object[0]).pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).body(artifactContentInvalidSyntax).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", Matchers.startsWith((String)"Incompatible artifact: testCreateArtifact/ValidJson [JSON], num of incompatible diffs: {1}, list of diff types: [SUBSCHEMA_TYPE_CHANGED at /properties/age]"), new Object[0])).body("causes[0].description", Matchers.equalTo((Object)DiffType.SUBSCHEMA_TYPE_CHANGED.getDescription()), new Object[0])).body("causes[0].context", Matchers.equalTo((Object)"/properties/age"), new Object[0]);
    }

    @Test
    public void testGetArtifactVersion() throws Exception {
        String version;
        int idx;
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact(GROUP, "testGetArtifactVersion/EmptyAPI", "OPENAPI", artifactContent);
        ArrayList<String> versions = new ArrayList<String>();
        for (idx = 0; idx < 5; ++idx) {
            version = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testGetArtifactVersion/EmptyAPI").body(artifactContent.replace("Empty API", "Empty API (Update " + idx + ")")).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testGetArtifactVersion/EmptyAPI"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).extract().body().path("version", new String[0]);
            versions.add(version);
        }
        for (idx = 0; idx < 5; ++idx) {
            version = (String)versions.get(idx);
            String expected = "Empty API (Update " + idx + ")";
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testGetArtifactVersion/EmptyAPI").pathParam("version", (Object)version).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}", new Object[0])).then()).statusCode(200)).body("info.title", Matchers.equalTo((Object)expected), new Object[0]);
        }
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testGetArtifactVersion/EmptyAPI").pathParam("version", (Object)12345).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}", new Object[0])).then()).statusCode(404);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testGetArtifactVersion/MissingAPI").pathParam("version", (Object)"1").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}", new Object[0])).then()).statusCode(404);
    }

    @Test
    public void testGetArtifactMetaDataByContent() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact(GROUP, "testGetArtifactMetaDataByContent/EmptyAPI", "OPENAPI", artifactContent);
        for (int idx = 0; idx < 5; ++idx) {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("artifactId", (Object)"testGetArtifactMetaDataByContent/EmptyAPI").body(artifactContent.replace("Empty API", "Empty API (Update " + idx + ")")).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testGetArtifactMetaDataByContent/EmptyAPI"), new Object[0])).body("groupId", Matchers.equalTo((Object)GROUP), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).extract().body().path("version", new String[0]);
        }
        String searchContent = artifactContent.replace("Empty API", "Empty API (Update 2)");
        Integer globalId1 = (Integer)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testGetArtifactMetaDataByContent/EmptyAPI").body(searchContent).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200)).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).extract().body().path("globalId", new String[0]);
        searchContent = searchContent.replace("{", "{\n").replace("}", "\n}");
        Integer globalId2 = (Integer)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testGetArtifactMetaDataByContent/EmptyAPI").queryParam("canonical", new Object[]{"true"}).body(searchContent).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200)).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).extract().body().path("globalId", new String[0]);
        Assertions.assertEquals((Integer)globalId1, (Integer)globalId2);
        searchContent = searchContent.replace("{", "{\n").replace("}", "\n}");
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testGetArtifactMetaDataByContent/EmptyAPI").body(searchContent).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(404);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testGetArtifactMetaDataByContent/EmptyAPI").body("").post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(400);
    }

    @Test
    public void testArtifactRules() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String artifactId = "testArtifactRules/EmptyAPI";
        this.createArtifact(GROUP, artifactId, "OPENAPI", artifactContent);
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).body((Object)rule).pathParam("artifactId", (Object)artifactId).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        Rule finalRule = rule;
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).body((Object)finalRule).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", Matchers.equalTo((Object)"A rule named 'VALIDITY' already exists."), new Object[0]));
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("BACKWARD");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).body((Object)rule).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"BACKWARD"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("[0]", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)"VALIDITY"), Matchers.equalTo((Object)"COMPATIBILITY")}), new Object[0])).body("[1]", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)"VALIDITY"), Matchers.equalTo((Object)"COMPATIBILITY")}), new Object[0])).body("[2]", Matchers.nullValue(), new Object[0]);
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).body((Object)rule).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).delete("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules/COMPATIBILITY", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules/COMPATIBILITY", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"No rule named 'COMPATIBILITY' was found."), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("[0]", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)"VALIDITY"), Matchers.equalTo((Object)"COMPATIBILITY")}), new Object[0])).body("[1]", Matchers.nullValue(), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).delete("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("[0]", Matchers.nullValue(), new Object[0]));
        rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"MissingArtifact").body((Object)rule).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(404)).body(CoreMatchers.anything(), new Matcher[0]);
    }

    @Test
    public void testArtifactMetaData() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact(GROUP, "testGetArtifactMetaData/EmptyAPI", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testGetArtifactMetaData/EmptyAPI").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testGetArtifactMetaData/EmptyAPI"), new Object[0])).body("version", CoreMatchers.anything(), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).body("createdOn", CoreMatchers.anything(), new Object[0])).body("name", Matchers.equalTo((Object)"Empty API"), new Object[0])).body("description", Matchers.equalTo((Object)"An example API design using OpenAPI."), new Object[0])).extract().as(ArtifactMetaData.class);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testGetArtifactMetaData/MissingAPI").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(404)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"No artifact with ID 'testGetArtifactMetaData/MissingAPI' in group 'GroupsResourceTest' was found."), new Object[0]);
        String metaData = "{\"name\": \"Empty API Name\", \"description\": \"Empty API description.\", \"labels\":[\"Empty API label 1\",\"Empty API label 2\"], \"properties\":{\"additionalProp1\": \"Empty API additional property\"}}";
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testGetArtifactMetaData/EmptyAPI").body(metaData).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> {
            List<String> expectedLabels = Arrays.asList("Empty API label 1", "Empty API label 2");
            HashMap<String, String> expectedProperties = new HashMap<String, String>();
            expectedProperties.put("additionalProp1", "Empty API additional property");
            String version = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testGetArtifactMetaData/EmptyAPI").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testGetArtifactMetaData/EmptyAPI"), new Object[0])).body("version", CoreMatchers.anything(), new Object[0])).body("name", Matchers.equalTo((Object)"Empty API Name"), new Object[0])).body("description", Matchers.equalTo((Object)"Empty API description."), new Object[0])).body("labels", Matchers.equalToObject(expectedLabels), new Object[0])).body("properties", Matchers.equalToObject(expectedProperties), new Object[0])).extract().body().path("version", new String[0]);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testGetArtifactMetaData/EmptyAPI").pathParam("version", (Object)version).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then()).statusCode(200)).body("name", Matchers.equalTo((Object)"Empty API Name"), new Object[0])).body("description", Matchers.equalTo((Object)"Empty API description."), new Object[0])).body("labels", Matchers.equalToObject(expectedLabels), new Object[0])).body("properties", Matchers.equalToObject(expectedProperties), new Object[0])).extract().body().path("version", new String[0]);
        });
        String updatedArtifactContent = artifactContent.replace("Empty API", "Empty API (Updated)");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testGetArtifactMetaData/EmptyAPI").body(updatedArtifactContent).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testGetArtifactMetaData/EmptyAPI"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testGetArtifactMetaData/EmptyAPI").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)"testGetArtifactMetaData/EmptyAPI"), new Object[0])).body("version", CoreMatchers.anything(), new Object[0])).body("name", Matchers.equalTo((Object)"Empty API (Updated)"), new Object[0])).body("description", Matchers.equalTo((Object)"An example API design using OpenAPI."), new Object[0]);
    }

    @Test
    public void testPropertyValueNotNull() throws Exception {
        String group = UUID.randomUUID().toString();
        String artifactContent = this.resourceToString("openapi-empty.json");
        int idx = 0;
        String title = "Empty API " + idx;
        String artifactId = "Empty-" + idx;
        this.createArtifact(group, artifactId, "OPENAPI", artifactContent.replaceAll("Empty API", title));
        this.waitForArtifact(group, artifactId);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("test-key", null);
        EditableMetaData metaData = new EditableMetaData();
        metaData.setName(title);
        metaData.setDescription("Some description of an API");
        metaData.setProperties(props);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)group).pathParam("artifactId", (Object)artifactId).body((Object)metaData).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(400);
    }

    @Test
    public void testArtifactVersionMetaData() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String updatedArtifactContent_v2 = artifactContent.replace("Empty API", "Empty API (v2)");
        String updatedArtifactContent_v3 = artifactContent.replace("Empty API", "Empty API (v3)");
        this.createArtifact(GROUP, "testArtifactVersionMetaData/EmptyAPI", "OPENAPI", artifactContent);
        String version2 = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testArtifactVersionMetaData/EmptyAPI").body(updatedArtifactContent_v2).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body("version", Matchers.notNullValue(), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).extract().body().path("version", new String[0]);
        String version3 = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testArtifactVersionMetaData/EmptyAPI").body(updatedArtifactContent_v3).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body("version", Matchers.notNullValue(), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).extract().body().path("version", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testArtifactVersionMetaData/EmptyAPI").pathParam("version", (Object)version2).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then()).statusCode(200)).body("version", Matchers.equalTo((Object)version2), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).body("createdOn", CoreMatchers.anything(), new Object[0])).body("name", Matchers.equalTo((Object)"Empty API (v2)"), new Object[0])).body("description", Matchers.equalTo((Object)"An example API design using OpenAPI."), new Object[0])).extract().as(VersionMetaData.class);
        String metaData = "{\"name\": \"Updated Name\", \"description\": \"Updated description.\"}";
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testArtifactVersionMetaData/EmptyAPI").pathParam("version", (Object)version2).body(metaData).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testArtifactVersionMetaData/EmptyAPI").pathParam("version", (Object)version2).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then()).statusCode(200)).body("version", Matchers.equalTo((Object)version2), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).body("createdOn", CoreMatchers.anything(), new Object[0])).body("name", Matchers.equalTo((Object)"Updated Name"), new Object[0])).body("description", Matchers.equalTo((Object)"Updated description."), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testArtifactVersionMetaData/EmptyAPI").pathParam("version", (Object)version3).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then()).statusCode(200)).body("version", Matchers.equalTo((Object)version3), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).body("createdOn", CoreMatchers.anything(), new Object[0])).body("name", Matchers.equalTo((Object)"Empty API (v3)"), new Object[0])).body("description", Matchers.equalTo((Object)"An example API design using OpenAPI."), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testArtifactVersionMetaData/EmptyAPI").pathParam("version", (Object)12345).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then()).statusCode(404);
    }

    @Test
    public void testYamlContentType() throws Exception {
        String artifactId = "testYamlContentType";
        String artifactType = "OPENAPI";
        String artifactContent = this.resourceToString("openapi-empty.yaml");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().config(RestAssuredConfig.config().encoderConfig(EncoderConfig.encoderConfig().encodeContentTypeAs("application/x-yaml", ContentType.TEXT))).when().contentType("application/x-yaml").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).header("X-Registry-ArtifactType", (Object)artifactType, new Object[0]).pathParam("groupId", (Object)GROUP).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("name", Matchers.equalTo((Object)"Empty API"), new Object[0])).body("description", Matchers.equalTo((Object)"An example API design using OpenAPI."), new Object[0])).body("type", Matchers.equalTo((Object)artifactType), new Object[0]);
        this.waitForArtifact(GROUP, artifactId);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testYamlContentType").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).header("Content-Type", Matchers.containsString((String)"application/json"))).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API"), new Object[0]);
    }

    @Test
    public void testWsdlArtifact() throws Exception {
        String artifactId = "testWsdlArtifact";
        String artifactType = "WSDL";
        String artifactContent = this.resourceToString("sample.wsdl");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().config(RestAssuredConfig.config().encoderConfig(EncoderConfig.encoderConfig().encodeContentTypeAs("application/xml", ContentType.TEXT))).when().contentType("application/xml").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).header("X-Registry-ArtifactType", (Object)artifactType, new Object[0]).pathParam("groupId", (Object)GROUP).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("type", Matchers.equalTo((Object)artifactType), new Object[0]);
        this.waitForArtifact(GROUP, artifactId);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testWsdlArtifact").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).header("Content-Type", Matchers.containsString((String)"application/xml"));
    }

    @Test
    public void testCreateAlreadyExistingArtifact() throws Exception {
        String artifactId = UUID.randomUUID().toString();
        String artifactContent = this.resourceToString("openapi-empty.json");
        String updatedArtifactContent = artifactContent.replace("Empty API", "Empty API (Updated)");
        String v3ArtifactContent = artifactContent.replace("Empty API", "Empty API (Version 3)");
        String artifactName = "ArtifactNameFromHeader";
        String artifactDescription = "ArtifactDescriptionFromHeader";
        Integer globalId1 = this.createArtifact(GROUP, artifactId, "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).pathParam("groupId", (Object)GROUP).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", Matchers.equalTo((Object)("An artifact with ID '" + artifactId + "' in group 'GroupsResourceTest' already exists.")), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).pathParam("groupId", (Object)GROUP).queryParam("ifExists", new Object[]{IfExists.RETURN}).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).body("version", Matchers.equalTo((Object)"1"), new Object[0])).body("createdOn", CoreMatchers.anything(), new Object[0])).body("name", Matchers.equalTo((Object)"Empty API"), new Object[0])).body("description", Matchers.equalTo((Object)"An example API design using OpenAPI."), new Object[0]);
        ValidatableResponse resp = (ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).pathParam("groupId", (Object)GROUP).queryParam("ifExists", new Object[]{IfExists.UPDATE}).body(updatedArtifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).body("createdOn", CoreMatchers.anything(), new Object[0])).body("version", Matchers.equalTo((Object)"2"), new Object[0])).body("description", Matchers.equalTo((Object)"An example API design using OpenAPI."), new Object[0]);
        Integer globalId2 = (Integer)resp.extract().body().path("globalId", new String[0]);
        this.waitForGlobalId(globalId2.intValue());
        resp = (ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).pathParam("groupId", (Object)GROUP).queryParam("ifExists", new Object[]{IfExists.RETURN_OR_UPDATE}).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        Integer globalId3 = (Integer)resp.extract().body().path("globalId", new String[0]);
        Assertions.assertEquals((Integer)globalId1, (Integer)globalId3);
        resp = (ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=OPENAPI").header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).header("X-Registry-Name", (Object)"ArtifactNameFromHeader", new Object[0]).header("X-Registry-Description", (Object)"ArtifactDescriptionFromHeader", new Object[0]).pathParam("groupId", (Object)GROUP).queryParam("ifExists", new Object[]{IfExists.RETURN_OR_UPDATE}).body(v3ArtifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("version", Matchers.equalTo((Object)"3"), new Object[0])).body("name", Matchers.equalTo((Object)"ArtifactNameFromHeader"), new Object[0])).body("description", Matchers.equalTo((Object)"ArtifactDescriptionFromHeader"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
    }

    @Test
    public void testDeleteArtifactWithRule() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String artifactId = "testDeleteArtifactWithRule/EmptyAPI";
        this.createArtifact(GROUP, artifactId, "OPENAPI", artifactContent);
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).body((Object)rule).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).delete("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> {
            ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules/VALIDITY", new Object[0])).then()).statusCode(404);
            ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(404);
        });
        this.createArtifact(GROUP, artifactId, "OPENAPI", artifactContent);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules/VALIDITY", new Object[0])).then()).statusCode(404);
        rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).body((Object)rule).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
    }

    @Test
    public void testCorrectGroup() throws Exception {
        String oaiArtifactContent = this.resourceToString("openapi-empty.json");
        String jsonArtifactContent = this.resourceToString("jsonschema-valid.json");
        String groupId = "test-correct-group";
        String artifactId = "test-artifact-a";
        this.createArtifact(groupId, artifactId, "OPENAPI", oaiArtifactContent);
        this.createArtifact(artifactId, "OPENAPI", jsonArtifactContent);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("group", new Object[]{groupId}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)1), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)groupId).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.not((Matcher)Matchers.equalTo((Object)"3.0.2")), new Object[0])).body("info.title", Matchers.not((Matcher)Matchers.equalTo((Object)"Empty API")), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)groupId).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200)).body("groupId", Matchers.equalTo((Object)groupId), new Object[0])).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("version", CoreMatchers.anything(), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).body("createdOn", CoreMatchers.anything(), new Object[0])).body("name", Matchers.equalTo((Object)"Empty API"), new Object[0])).body("description", Matchers.equalTo((Object)"An example API design using OpenAPI."), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200)).body("groupId", Matchers.nullValue(), new Object[0])).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("version", CoreMatchers.anything(), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).body("createdOn", CoreMatchers.anything(), new Object[0])).body("name", Matchers.not((Matcher)Matchers.equalTo((Object)"Empty API")), new Object[0])).body("description", Matchers.not((Matcher)Matchers.equalTo((Object)"An example API design using OpenAPI.")), new Object[0]);
    }

    @Test
    public void testCustomArtifactVersion() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String groupId = "testCustomArtifactVersion";
        String artifactId = "MyVersionedAPI";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)groupId).header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).header("X-Registry-Version", (Object)"1.0.0", new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("groupId", Matchers.equalTo((Object)groupId), new Object[0])).body("version", Matchers.equalTo((Object)"1.0.0"), new Object[0]);
        this.waitForArtifact(groupId, artifactId);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)groupId).pathParam("artifactId", (Object)artifactId).pathParam("version", (Object)"1.0.0").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)groupId).pathParam("artifactId", (Object)artifactId).pathParam("version", (Object)"1.0.0").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("groupId", Matchers.equalTo((Object)groupId), new Object[0])).body("version", Matchers.equalTo((Object)"1.0.0"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-Version", (Object)"1.0.1", new Object[0]).pathParam("groupId", (Object)groupId).pathParam("artifactId", (Object)artifactId).body(artifactContent.replace("Empty API", "Empty API (Version 1.0.1)")).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("version", Matchers.equalTo((Object)"1.0.1"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)groupId).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)2), new Object[0])).body("versions[0].version", Matchers.equalTo((Object)"1.0.0"), new Object[0])).body("versions[1].version", Matchers.equalTo((Object)"1.0.1"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").header("X-Registry-Version", (Object)"1.0.2", new Object[0]).pathParam("groupId", (Object)groupId).pathParam("artifactId", (Object)artifactId).body(artifactContent.replace("Empty API", "Empty API (Version 1.0.2)")).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("version", Matchers.equalTo((Object)"1.0.2"), new Object[0])).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)groupId).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)3), new Object[0])).body("versions[0].version", Matchers.equalTo((Object)"1.0.0"), new Object[0])).body("versions[1].version", Matchers.equalTo((Object)"1.0.1"), new Object[0])).body("versions[2].version", Matchers.equalTo((Object)"1.0.2"), new Object[0]);
    }

    @Test
    public void testCreateArtifactAfterDelete() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact(GROUP, "testCreateArtifactAfterDelete/EmptyAPI", "OPENAPI", artifactContent);
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testCreateArtifactAfterDelete/EmptyAPI").delete("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(204);
        this.createArtifact(GROUP, "testCreateArtifactAfterDelete/EmptyAPI", "OPENAPI", artifactContent);
    }

    @Test
    public void testCreateArtifactFromURL() throws Exception {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/create.extended+json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)"testCreateArtifactFromURL/Empty", new Object[0]).header("X-Registry-ArtifactType", (Object)"JSON", new Object[0]).body("{ \"content\" : \"http://localhost:" + this.testPort + "/health/group\" }").post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(400)).body("message", Matchers.containsString((String)"Content-Length"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/create.extended+json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)"testCreateArtifactFromURL/OpenApi2", new Object[0]).header("X-Registry-ArtifactType", (Object)"JSON", new Object[0]).header("X-Registry-Content-Hash", (Object)"123", new Object[0]).body("{ \"content\" : \"http://localhost:" + this.testPort + "/api-specifications/registry/v2/openapi.json\" }").post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(400)).body("message", Matchers.containsString((String)"Hash doesn't match"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/create.extended+json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)"testCreateArtifactFromURL/OpenApi2", new Object[0]).header("X-Registry-ArtifactType", (Object)"JSON", new Object[0]).header("X-Registry-Hash-Algorithm", (Object)"ASH652", new Object[0]).header("X-Registry-Content-Hash", (Object)"123", new Object[0]).body("{ \"content\" : \"http://localhost:" + this.testPort + "/api-specifications/registry/v2/openapi.json\" }").post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(400)).body("message", Matchers.containsString((String)"hash algorithm not supported"), new Object[0]);
        String content = ((Response)RestAssured.given().get("http://localhost:" + this.testPort + "/api-specifications/registry/v2/openapi.json", new Object[0])).body().print();
        String artifactSHA = Hashing.sha256().hashString((CharSequence)content, StandardCharsets.UTF_8).toString();
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/create.extended+json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)"testCreateArtifactFromURL/OpenApi3", new Object[0]).header("X-Registry-ArtifactType", (Object)"JSON", new Object[0]).header("X-Registry-Content-Hash", (Object)artifactSHA, new Object[0]).body("{ \"content\" : \"http://localhost:" + this.testPort + "/api-specifications/registry/v2/openapi.json\" }").post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200);
    }

    @Test
    void testArtifactWithReferences() throws Exception {
        ArtifactMetaData metadata;
        String artifactContent = this.getRandomValidJsonSchemaContent();
        ValidatableResponse response = this.createArtifactExtendedRaw("default", null, null, artifactContent, null);
        ArtifactMetaData referencedMD = metadata = (ArtifactMetaData)((ValidatableResponse)response.statusCode(200)).extract().as(ArtifactMetaData.class);
        this.waitForArtifact(metadata.getId());
        List<ArtifactReference> references = List.of(ArtifactReference.builder().groupId(metadata.getGroupId()).artifactId(metadata.getId()).version(metadata.getVersion()).name("foo").build());
        artifactContent = this.getRandomValidJsonSchemaContent();
        response = this.createArtifactExtendedRaw("default", null, null, artifactContent, references);
        metadata = (ArtifactMetaData)((ValidatableResponse)response.statusCode(200)).extract().as(ArtifactMetaData.class);
        this.waitForArtifact(metadata.getId());
        ArtifactMetaData referencingMD = metadata;
        Assertions.assertEquals(references, (Object)metadata.getReferences());
        List<ArtifactReference> references2 = List.of(ArtifactReference.builder().groupId(metadata.getGroupId()).artifactId(metadata.getId()).version(metadata.getVersion()).name("foo2").build());
        response = this.createArtifactExtendedRaw("default", null, null, artifactContent, references2);
        ArtifactMetaData secondMetadata = (ArtifactMetaData)((ValidatableResponse)response.statusCode(200)).extract().as(ArtifactMetaData.class);
        Assertions.assertNotEquals((Long)secondMetadata.getContentId(), (Long)metadata.getContentId());
        response = this.createArtifactExtendedRaw("default2", null, null, artifactContent, references);
        metadata = (ArtifactMetaData)((ValidatableResponse)response.statusCode(200)).extract().as(ArtifactMetaData.class);
        List referenceResponse = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("globalId", (Object)metadata.getGlobalId()).get("/registry/v2/ids/globalIds/{globalId}/references", new Object[0])).then()).statusCode(200)).extract().as((TypeRef)new TypeRef<List<ArtifactReference>>(){});
        Assertions.assertEquals(references, (Object)referenceResponse);
        referenceResponse = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("contentId", (Object)metadata.getContentId()).get("/registry/v2/ids/contentIds/{contentId}/references", new Object[0])).then()).statusCode(200)).extract().as((TypeRef)new TypeRef<List<ArtifactReference>>(){});
        String referencesSerialized = SqlUtil.serializeReferences(this.toReferenceDtos(references));
        String contentHash = DigestUtils.sha256Hex((byte[])this.concatContentAndReferences(artifactContent.getBytes(StandardCharsets.UTF_8), referencesSerialized.getBytes(StandardCharsets.UTF_8)));
        Assertions.assertEquals(references, (Object)referenceResponse);
        referenceResponse = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("contentHash", (Object)contentHash).get("/registry/v2/ids/contentHashes/{contentHash}/references", new Object[0])).then()).statusCode(200)).extract().as((TypeRef)new TypeRef<List<ArtifactReference>>(){});
        Assertions.assertEquals(references, (Object)referenceResponse);
        referenceResponse = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)metadata.getGroupId()).pathParam("artifactId", (Object)metadata.getId()).pathParam("version", (Object)metadata.getVersion()).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}/references", new Object[0])).then()).statusCode(200)).extract().as((TypeRef)new TypeRef<List<ArtifactReference>>(){});
        Assertions.assertEquals(references, (Object)referenceResponse);
        referenceResponse = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)(referencedMD.getGroupId() == null ? "default" : referencedMD.getGroupId())).pathParam("artifactId", (Object)referencedMD.getId()).pathParam("version", (Object)referencedMD.getVersion()).queryParam("refType", new Object[]{ReferenceType.INBOUND}).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}/references", new Object[0])).then()).statusCode(200)).extract().as((TypeRef)new TypeRef<List<ArtifactReference>>(){});
        Assertions.assertFalse((boolean)referenceResponse.isEmpty());
        Assertions.assertEquals((int)2, (int)referenceResponse.size());
        Assertions.assertEquals((Object)referencingMD.getGroupId(), (Object)((ArtifactReference)referenceResponse.get(0)).getGroupId());
        Assertions.assertEquals((Object)referencingMD.getId(), (Object)((ArtifactReference)referenceResponse.get(0)).getArtifactId());
        Assertions.assertEquals((Object)referencingMD.getVersion(), (Object)((ArtifactReference)referenceResponse.get(0)).getVersion());
        referenceResponse = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("globalId", (Object)referencedMD.getGlobalId()).queryParam("refType", new Object[]{ReferenceType.INBOUND}).get("/registry/v2/ids/globalIds/{globalId}/references", new Object[0])).then()).statusCode(200)).extract().as((TypeRef)new TypeRef<List<ArtifactReference>>(){});
        Assertions.assertFalse((boolean)referenceResponse.isEmpty());
        Assertions.assertEquals((int)2, (int)referenceResponse.size());
        Assertions.assertEquals((Object)referencingMD.getGroupId(), (Object)((ArtifactReference)referenceResponse.get(0)).getGroupId());
        Assertions.assertEquals((Object)referencingMD.getId(), (Object)((ArtifactReference)referenceResponse.get(0)).getArtifactId());
        Assertions.assertEquals((Object)referencingMD.getVersion(), (Object)((ArtifactReference)referenceResponse.get(0)).getVersion());
    }

    private byte[] concatContentAndReferences(byte[] contentBytes, byte[] referencesBytes) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(contentBytes.length + referencesBytes.length);
        outputStream.write(contentBytes);
        outputStream.write(referencesBytes);
        return outputStream.toByteArray();
    }

    @Test
    public void testArtifactComments() throws Exception {
        String artifactId = "testArtifactComments/EmptyAPI";
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact(GROUP, artifactId, "OPENAPI", artifactContent);
        List comments = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/latest/comments", new Object[0])).then()).statusCode(200)).extract().as((TypeRef)new TypeRef<List<Comment>>(){});
        Assertions.assertEquals((int)0, (int)comments.size());
        NewComment nc = NewComment.builder().value("COMMENT_1").build();
        Comment comment1 = (Comment)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).body((Object)nc).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/latest/comments", new Object[0])).then()).statusCode(200)).extract().as(Comment.class);
        Assertions.assertNotNull((Object)comment1);
        Assertions.assertNotNull((Object)comment1.getCommentId());
        Assertions.assertNotNull((Object)comment1.getValue());
        Assertions.assertNotNull((Object)comment1.getCreatedOn());
        Assertions.assertEquals((Object)"COMMENT_1", (Object)comment1.getValue());
        nc = NewComment.builder().value("COMMENT_2").build();
        Comment comment2 = (Comment)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).body((Object)nc).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/latest/comments", new Object[0])).then()).statusCode(200)).extract().as(Comment.class);
        Assertions.assertNotNull((Object)comment2);
        Assertions.assertNotNull((Object)comment2.getCommentId());
        Assertions.assertNotNull((Object)comment2.getValue());
        Assertions.assertNotNull((Object)comment2.getCreatedOn());
        Assertions.assertEquals((Object)"COMMENT_2", (Object)comment2.getValue());
        comments = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/latest/comments", new Object[0])).then()).statusCode(200)).extract().as((TypeRef)new TypeRef<List<Comment>>(){});
        Assertions.assertEquals((int)2, (int)comments.size());
        Assertions.assertEquals((Object)"COMMENT_2", (Object)((Comment)comments.get(0)).getValue());
        Assertions.assertEquals((Object)"COMMENT_1", (Object)((Comment)comments.get(1)).getValue());
        nc = NewComment.builder().value("COMMENT_2_UPDATED").build();
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).pathParam("commentId", (Object)comment2.getCommentId()).body((Object)nc).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/latest/comments/{commentId}", new Object[0])).then()).statusCode(204);
        comments = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/latest/comments", new Object[0])).then()).statusCode(200)).extract().as((TypeRef)new TypeRef<List<Comment>>(){});
        Assertions.assertEquals((int)2, (int)comments.size());
        Assertions.assertEquals((Object)"COMMENT_2_UPDATED", (Object)((Comment)comments.get(0)).getValue());
        Assertions.assertEquals((Object)"COMMENT_1", (Object)((Comment)comments.get(1)).getValue());
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).pathParam("commentId", (Object)comment2.getCommentId()).delete("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/latest/comments/{commentId}", new Object[0])).then()).statusCode(204);
        comments = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/latest/comments", new Object[0])).then()).statusCode(200)).extract().as((TypeRef)new TypeRef<List<Comment>>(){});
        Assertions.assertEquals((int)1, (int)comments.size());
        Assertions.assertEquals((Object)"COMMENT_1", (Object)((Comment)comments.get(0)).getValue());
    }

    @Test
    public void testCreateArtifactIntegrityRuleViolation() throws Exception {
        String artifactContent = this.resourceToString("jsonschema-valid.json");
        String artifactId = "testCreateArtifact/IntegrityRuleViolation";
        this.createArtifact(GROUP, artifactId, "JSON", artifactContent);
        Rule rule = new Rule();
        rule.setType(RuleType.INTEGRITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).body((Object)rule).pathParam("artifactId", (Object)artifactId).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/rules/INTEGRITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"INTEGRITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        ByteArrayInputStream data = new ByteArrayInputStream(artifactContent.getBytes(StandardCharsets.UTF_8));
        ArrayList<ArtifactReference> references = new ArrayList<ArtifactReference>();
        references.add(ArtifactReference.builder().groupId(GROUP).artifactId(artifactId).version("1").name("other.json#/defs/Foo").build());
        this.clientV2.updateArtifact(GROUP, artifactId, "2", null, null, (InputStream)data, references);
        data = new ByteArrayInputStream(artifactContent.getBytes(StandardCharsets.UTF_8));
        references = new ArrayList();
        references.add(ArtifactReference.builder().groupId(GROUP).artifactId("ArtifactThatDoesNotExist").version("1").name("other.json#/defs/Foo").build());
        ByteArrayInputStream dataf_1 = data;
        ArrayList<ArtifactReference> referencesf_1 = references;
        Assertions.assertThrows(RuleViolationException.class, () -> this.clientV2.updateArtifact(GROUP, artifactId, "2", null, null, dataf_1, referencesf_1));
        data = new ByteArrayInputStream(artifactContent.getBytes(StandardCharsets.UTF_8));
        references = new ArrayList();
        references.add(ArtifactReference.builder().groupId(GROUP).artifactId(artifactId).version("1").name("other.json#/defs/Foo").build());
        references.add(ArtifactReference.builder().groupId(GROUP).artifactId("ArtifactThatDoesNotExist").version("1").name("other.json#/defs/Bar").build());
        ByteArrayInputStream dataf_2 = data;
        ArrayList<ArtifactReference> referencesf_2 = references;
        Assertions.assertThrows(RuleViolationException.class, () -> this.clientV2.updateArtifact(GROUP, artifactId, "2", null, null, dataf_2, referencesf_2));
        data = new ByteArrayInputStream(artifactContent.getBytes(StandardCharsets.UTF_8));
        references = new ArrayList();
        references.add(ArtifactReference.builder().groupId(GROUP).artifactId(artifactId).version("1").name("other.json#/defs/Foo").build());
        references.add(ArtifactReference.builder().groupId(GROUP).artifactId(artifactId).version("1").name("other.json#/defs/Foo").build());
        ByteArrayInputStream dataf_3 = data;
        ArrayList<ArtifactReference> referencesf_3 = references;
        Assertions.assertThrows(RuleViolationException.class, () -> this.clientV2.updateArtifact(GROUP, artifactId, "2", null, null, dataf_3, referencesf_3));
    }
}

