/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.rest.v2;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class IdsResourceTest
extends AbstractResourceTestBase {
    private static final String GROUP = "IdsResourceTest";

    @Test
    public void testIdsAfterCreate() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact("IdsResourceTest-foo", "Empty-0", "WSDL", this.resourceToString("sample.wsdl"));
        String artifactId1 = "testIdsAfterCreate/Empty-1";
        String artifactId2 = "testIdsAfterCreate/Empty-2";
        ArtifactMetaData amd1 = (ArtifactMetaData)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)artifactId1, new Object[0]).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).extract().as(ArtifactMetaData.class);
        this.waitForArtifact(GROUP, artifactId1);
        ArtifactMetaData amd2 = (ArtifactMetaData)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)artifactId2, new Object[0]).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).extract().as(ArtifactMetaData.class);
        this.waitForArtifact(GROUP, artifactId2);
        Assertions.assertNotNull((Object)amd1.getGlobalId());
        Assertions.assertNotNull((Object)amd1.getContentId());
        Assertions.assertNotEquals((long)0L, (Long)amd1.getContentId());
        Assertions.assertNotEquals((Long)amd1.getGlobalId(), (Long)amd2.getGlobalId());
        Assertions.assertEquals((Long)amd1.getContentId(), (Long)amd2.getContentId());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId1).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200)).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).body("groupId", Matchers.equalTo((Object)GROUP), new Object[0])).body("contentId", Matchers.equalTo((Object)amd1.getContentId().intValue()), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)artifactId2).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200)).body("type", Matchers.equalTo((Object)"OPENAPI"), new Object[0])).body("groupId", Matchers.equalTo((Object)GROUP), new Object[0])).body("contentId", Matchers.equalTo((Object)amd2.getContentId().intValue()), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)amd1.getId()).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)1), new Object[0])).body("versions[0].contentId", Matchers.notNullValue(), new Object[0])).body("versions[0].contentId", Matchers.not((Matcher)Matchers.equalTo((Object)0)), new Object[0])).body("versions[0].contentId", Matchers.equalTo((Object)amd1.getContentId().intValue()), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)amd1.getId()).pathParam("version", (Object)amd1.getVersion()).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then()).statusCode(200)).body("globalId", Matchers.equalTo((Object)amd1.getGlobalId().intValue()), new Object[0])).body("contentId", Matchers.equalTo((Object)amd1.getContentId().intValue()), new Object[0]);
    }

    @Test
    public void testGetByGlobalId() throws Exception {
        String title = "Test By Global ID API";
        String artifactContent = this.resourceToString("openapi-empty.json").replaceAll("Empty API", title);
        String artifactId = "testGetByGlobalId/Empty";
        ArtifactMetaData amd = (ArtifactMetaData)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).extract().as(ArtifactMetaData.class);
        this.waitForArtifact(GROUP, artifactId);
        long globalId = amd.getGlobalId();
        this.waitForGlobalId(globalId);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("globalId", (Object)globalId).get("/registry/v2/ids/globalIds/{globalId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)title), new Object[0]);
    }

    @Test
    public void testGetByGlobalIdIssue1501() throws Exception {
        String title = "Test By Global ID API";
        String artifactContent = this.resourceToString("openapi-empty.json").replaceAll("Empty API", title);
        String group1 = TestUtils.generateGroupId();
        String group2 = TestUtils.generateGroupId();
        String artifactId = "testIssue1501";
        long globalId1 = this.createArtifact(group1, artifactId, "OPENAPI", artifactContent).intValue();
        this.waitForGlobalId(globalId1);
        long globalId2 = this.createArtifact(group2, artifactId, "OPENAPI", artifactContent).intValue();
        this.waitForGlobalId(globalId2);
        this.clientV2.getContentByGlobalId(globalId1);
        this.clientV2.getContentByGlobalId(globalId2);
    }

    @Test
    public void testGetByContentId() throws Exception {
        String title = "Test By Content ID API";
        String artifactContent = this.resourceToString("openapi-empty.json").replaceAll("Empty API", title);
        String artifactId = "testGetByContentId/Empty";
        ArtifactMetaData amd = (ArtifactMetaData)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).extract().as(ArtifactMetaData.class);
        this.waitForArtifact(GROUP, artifactId);
        long contentId = amd.getContentId();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("contentId", (Object)contentId).get("/registry/v2/ids/contentIds/{contentId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)title), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("contentId", (Object)Integer.MAX_VALUE).get("/registry/v2/ids/contentIds/{contentId}", new Object[0])).then()).statusCode(404);
    }

    @Test
    public void testGetByContentHash() throws Exception {
        String title = "Test By Content Hash API";
        String artifactContent = this.resourceToString("openapi-empty.json").replaceAll("Empty API", title);
        String contentHash = DigestUtils.sha256Hex((String)artifactContent);
        String artifactId = "testGetByContentHash/Empty";
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)GROUP).header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).header("X-Registry-ArtifactType", (Object)"OPENAPI", new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200);
        this.waitForArtifact(GROUP, artifactId);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("contentHash", (Object)contentHash).get("/registry/v2/ids/contentHashes/{contentHash}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)title), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("contentHash", (Object)"CONTENT-HASH-NOT-VALID").get("/registry/v2/ids/contentHashes/{contentHash}", new Object[0])).then()).statusCode(404);
    }
}

