/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.rest.v2;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class SearchResourceTest
extends AbstractResourceTestBase {
    @Test
    public void testSearchByGroup() throws Exception {
        int idx;
        String artifactContent = this.resourceToString("openapi-empty.json");
        String group = UUID.randomUUID().toString();
        for (idx = 0; idx < 5; ++idx) {
            String title = "Empty API " + idx;
            String artifactId = "Empty-" + idx;
            this.createArtifact(group, artifactId, "OPENAPI", artifactContent.replaceAll("Empty API", title));
            this.waitForArtifact(group, artifactId);
        }
        for (idx = 0; idx < 5; ++idx) {
            String artifactId = "Empty-" + idx;
            this.createArtifact("SearchResourceTest", artifactId, "OPENAPI", artifactContent);
            this.waitForArtifact(group, artifactId);
        }
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("group", new Object[]{group}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)5), new Object[0])).body("artifacts[0].groupId", Matchers.equalTo((Object)group), new Object[0]);
    }

    @Test
    public void testSearchByName() throws Exception {
        String artifactId;
        int idx;
        String group = UUID.randomUUID().toString();
        String name = UUID.randomUUID().toString();
        String artifactContent = this.resourceToString("openapi-empty.json");
        for (idx = 0; idx < 2; ++idx) {
            artifactId = "Empty-" + idx;
            this.createArtifact(group, artifactId, "OPENAPI", artifactContent.replaceAll("Empty API", name));
            this.waitForArtifact(group, artifactId);
        }
        for (idx = 2; idx < 5; ++idx) {
            artifactId = "Empty-" + idx;
            this.createArtifact(group, artifactId, "OPENAPI", artifactContent);
            this.waitForArtifact(group, artifactId);
        }
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("name", new Object[]{name}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)2), new Object[0]);
    }

    @Test
    public void testSearchByDescription() throws Exception {
        String artifactId;
        int idx;
        String group = UUID.randomUUID().toString();
        String description = "The description is " + UUID.randomUUID().toString();
        String artifactContent = this.resourceToString("openapi-empty.json");
        for (idx = 0; idx < 2; ++idx) {
            artifactId = "Empty-" + idx;
            this.createArtifact(group, artifactId, "OPENAPI", artifactContent.replaceAll("An example API design using OpenAPI.", description));
            this.waitForArtifact(group, artifactId);
        }
        for (idx = 2; idx < 5; ++idx) {
            artifactId = "Empty-" + idx;
            this.createArtifact(group, artifactId, "OPENAPI", artifactContent);
            this.waitForArtifact(group, artifactId);
        }
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("description", new Object[]{description}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)2), new Object[0]);
    }

    @Test
    public void testSearchByLabels() throws Exception {
        String group = UUID.randomUUID().toString();
        String artifactContent = this.resourceToString("openapi-empty.json");
        for (int idx = 0; idx < 5; ++idx) {
            String title = "Empty API " + idx;
            String artifactId = "Empty-" + idx;
            this.createArtifact(group, artifactId, "OPENAPI", artifactContent.replaceAll("Empty API", title));
            this.waitForArtifact(group, artifactId);
            ArrayList<Object> labels = new ArrayList<Object>(2);
            labels.add("testSearchByLabels");
            labels.add("testSearchByLabels-" + idx);
            EditableMetaData metaData = new EditableMetaData();
            metaData.setName(title);
            metaData.setDescription("Some description of an API");
            metaData.setLabels(labels);
            ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)group).pathParam("artifactId", (Object)artifactId).body((Object)metaData).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(204);
        }
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("labels", new Object[]{"testSearchByLabels"}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)5), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("labels", new Object[]{"testSearchByLabels-2"}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)1), new Object[0]));
    }

    @Test
    public void testSearchByProperties() throws Exception {
        String group = UUID.randomUUID().toString();
        String artifactContent = this.resourceToString("openapi-empty.json");
        for (int idx = 0; idx < 5; ++idx) {
            String title = "Empty API " + idx;
            String artifactId = "Empty-" + idx;
            this.createArtifact(group, artifactId, "OPENAPI", artifactContent.replaceAll("Empty API", title));
            this.waitForArtifact(group, artifactId);
            HashMap<Object, Object> props = new HashMap<Object, Object>();
            props.put("all-key", "all-value");
            props.put("key-" + idx, "value-" + idx);
            props.put("another-key-" + idx, "another-value-" + idx);
            EditableMetaData metaData = new EditableMetaData();
            metaData.setName(title);
            metaData.setDescription("Some description of an API");
            metaData.setProperties(props);
            ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)group).pathParam("artifactId", (Object)artifactId).body((Object)metaData).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(204);
        }
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("properties", new Object[]{"all-key:all-value"}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)5), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("properties", new Object[]{"key-1:value-1"}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)1), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("properties", new Object[]{"key-1:value-1"}).queryParam("properties", new Object[]{"another-key-1:another-value-1"}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)1), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("properties", new Object[]{"key-1:value-1"}).queryParam("properties", new Object[]{"key-2:value-2"}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)0), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("properties", new Object[]{"key-1:value-1:"}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)0), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((Response)RestAssured.given().when().queryParam("properties", new Object[]{"key-1:"}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(400));
        TestUtils.retry(() -> ((ValidatableResponse)((Response)RestAssured.given().when().queryParam("properties", new Object[]{":value-1"}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(400));
    }

    @Test
    public void testSearchByPropertyKey() throws Exception {
        String group = UUID.randomUUID().toString();
        String artifactContent = this.resourceToString("openapi-empty.json");
        for (int idx = 0; idx < 5; ++idx) {
            String title = "Empty API " + idx;
            String artifactId = "Empty-" + idx;
            this.createArtifact(group, artifactId, "OPENAPI", artifactContent.replaceAll("Empty API", title));
            this.waitForArtifact(group, artifactId);
            HashMap<Object, String> props = new HashMap<Object, String>();
            props.put("all-key", "lorem ipsum");
            props.put("a-key-" + idx, "lorem ipsum");
            props.put("an-another-key-" + idx, "lorem ipsum");
            props.put("extra-key-" + idx % 2, "lorem ipsum");
            EditableMetaData metaData = new EditableMetaData();
            metaData.setName(title);
            metaData.setDescription("Some description of an API");
            metaData.setProperties(props);
            ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)group).pathParam("artifactId", (Object)artifactId).body((Object)metaData).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(204);
        }
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("properties", new Object[]{"all-key"}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)5), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("properties", new Object[]{"a-key-1"}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)1), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("properties", new Object[]{"extra-key-0"}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)3), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("properties", new Object[]{"extra-key-2"}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)0), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((Response)RestAssured.given().when().queryParam("properties", new Object[]{":all-key"}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(400));
        TestUtils.retry(() -> ((ValidatableResponse)((Response)RestAssured.given().when().queryParam("properties", new Object[]{"all-key:"}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(400));
    }

    @Test
    public void testOrderBy() throws Exception {
        String group = UUID.randomUUID().toString();
        String artifactContent = this.resourceToString("openapi-empty.json");
        for (int idx = 0; idx < 5; ++idx) {
            String artifactId = "Empty-" + idx;
            String name = "empty-" + idx;
            this.createArtifact(group, artifactId, "OPENAPI", artifactContent.replaceAll("Empty API", name));
            this.waitForArtifact(group, artifactId);
        }
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("orderby", new Object[]{"name"}).queryParam("order", new Object[]{"asc"}).queryParam("group", new Object[]{group}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)5), new Object[0])).body("artifacts[0].name", Matchers.equalTo((Object)"empty-0"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("orderby", new Object[]{"name"}).queryParam("order", new Object[]{"desc"}).queryParam("group", new Object[]{group}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)5), new Object[0])).body("artifacts[0].name", Matchers.equalTo((Object)"empty-4"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("orderby", new Object[]{"createdOn"}).queryParam("order", new Object[]{"asc"}).queryParam("group", new Object[]{group}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)5), new Object[0])).body("artifacts[0].name", Matchers.equalTo((Object)"empty-0"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("orderby", new Object[]{"createdOn"}).queryParam("order", new Object[]{"desc"}).queryParam("group", new Object[]{group}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)5), new Object[0])).body("artifacts[0].name", Matchers.equalTo((Object)"empty-4"), new Object[0]);
    }

    @Test
    public void testLimitAndOffset() throws Exception {
        String group = UUID.randomUUID().toString();
        String artifactContent = this.resourceToString("openapi-empty.json");
        for (int idx = 0; idx < 20; ++idx) {
            String artifactId = "Empty-" + idx;
            String name = "empty-" + idx;
            this.createArtifact(group, artifactId, "OPENAPI", artifactContent.replaceAll("Empty API", name));
            this.waitForArtifact(group, artifactId);
        }
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("orderby", new Object[]{"createdOn"}).queryParam("order", new Object[]{"asc"}).queryParam("limit", new Object[]{5}).queryParam("group", new Object[]{group}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)20), new Object[0])).body("artifacts.size()", Matchers.equalTo((Object)5), new Object[0])).body("artifacts[0].name", Matchers.equalTo((Object)"empty-0"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("orderby", new Object[]{"createdOn"}).queryParam("order", new Object[]{"asc"}).queryParam("limit", new Object[]{15}).queryParam("group", new Object[]{group}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)20), new Object[0])).body("artifacts.size()", Matchers.equalTo((Object)15), new Object[0])).body("artifacts[0].name", Matchers.equalTo((Object)"empty-0"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("orderby", new Object[]{"createdOn"}).queryParam("order", new Object[]{"asc"}).queryParam("limit", new Object[]{5}).queryParam("offset", new Object[]{10}).queryParam("group", new Object[]{group}).get("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)20), new Object[0])).body("artifacts.size()", Matchers.equalTo((Object)5), new Object[0])).body("artifacts[0].name", Matchers.equalTo((Object)"empty-10"), new Object[0]);
    }

    @Test
    public void testSearchByContent() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String group = "testSearchByContent";
        String searchByContent = artifactContent.replaceAll("Empty API", "testSearchByContent-empty-api-2");
        String searchByCanonicalContent = searchByContent.replaceAll("\\{", "   {\n");
        for (int idx = 0; idx < 5; ++idx) {
            String title = "testSearchByContent-empty-api-" + idx;
            String artifactId = "Empty-1-" + idx;
            this.createArtifact(group, artifactId, "OPENAPI", artifactContent.replaceAll("Empty API", title));
            this.waitForArtifact(group, artifactId);
            artifactId = "Empty-2-" + idx;
            this.createArtifact(group, artifactId, "OPENAPI", artifactContent.replaceAll("Empty API", title));
            this.waitForArtifact(group, artifactId);
        }
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body(searchByContent).post("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)2), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body(searchByCanonicalContent).post("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)0), new Object[0]);
    }

    @Test
    public void testSearchByCanonicalContent() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String group = "testSearchByCanonicalContent";
        String searchByContent = artifactContent.replaceAll("Empty API", "testSearchByCanonicalContent-empty-api-2").replaceAll("\\{", "   {\n");
        System.out.println(searchByContent);
        for (int idx = 0; idx < 5; ++idx) {
            String title = "testSearchByCanonicalContent-empty-api-" + idx;
            String artifactId = "Empty-1-" + idx;
            this.createArtifact(group, artifactId, "OPENAPI", artifactContent.replaceAll("Empty API", title));
            this.waitForArtifact(group, artifactId);
            artifactId = "Empty-2-" + idx;
            this.createArtifact(group, artifactId, "OPENAPI", artifactContent.replaceAll("Empty API", title));
            this.waitForArtifact(group, artifactId);
        }
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("canonical", new Object[]{"true"}).queryParam("artifactType", new Object[]{"OPENAPI"}).body(searchByContent).post("/registry/v2/search/artifacts", new Object[0])).then()).statusCode(200)).body("count", Matchers.equalTo((Object)2), new Object[0]);
    }
}

