/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.rest.v2.impexp;

import io.apicurio.registry.rest.client.AdminClient;
import io.apicurio.registry.rest.client.AdminClientFactory;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.types.RuleType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;

public class ExportLoader {
    private static final String CONTENT = "{\r\n    \"openapi\": \"3.0.2\",\r\n    \"info\": {\r\n        \"title\": \"Empty API\",\r\n        \"version\": \"1.0.0\",\r\n        \"description\": \"An example API design using OpenAPI.\"\r\n    }\r\n}";

    public static void main(String[] args) throws IOException {
        ByteArrayInputStream data;
        RegistryClient client = RegistryClientFactory.create((String)"http://localhost:8080/apis/registry/v2");
        AdminClient adminClient = AdminClientFactory.create((String)"http://localhost:8080/apis/registry/v2");
        for (int idx = 0; idx < 1000; ++idx) {
            System.out.println("Iteration: " + idx);
            data = new ByteArrayInputStream(CONTENT.replace("1.0.0", "1.0." + idx).getBytes());
            try {
                String artifactId = UUID.randomUUID().toString();
                client.createArtifact("default", artifactId, (InputStream)data);
                client.deleteArtifact("default", artifactId);
                continue;
            }
            finally {
                data.close();
            }
        }
        String testContent = CONTENT.replace("Empty API", "Test Artifact");
        data = new ByteArrayInputStream(testContent.replace("1.0.0", "1.0.1").getBytes());
        client.createArtifact("ImportTest", "Artifact-1", "1.0.1", (InputStream)data);
        data = new ByteArrayInputStream(testContent.replace("1.0.0", "1.0.2").getBytes());
        client.createArtifactVersion("ImportTest", "Artifact-1", "1.0.2", (InputStream)data);
        data = new ByteArrayInputStream(testContent.replace("1.0.0", "1.0.3").getBytes());
        client.createArtifactVersion("ImportTest", "Artifact-1", "1.0.3", (InputStream)data);
        data = new ByteArrayInputStream(testContent.replace("1.0.0", "1.0.1").getBytes());
        client.createArtifact("ImportTest", "Artifact-2", "1.0.1", (InputStream)data);
        data = new ByteArrayInputStream(testContent.replace("1.0.0", "1.0.2").getBytes());
        client.createArtifact("ImportTest", "Artifact-3", "1.0.2", (InputStream)data);
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("SYNTAX_ONLY");
        client.createArtifactRule("ImportTest", "Artifact-1", rule);
        rule = new Rule();
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("BACKWARD");
        adminClient.createGlobalRule(rule);
    }
}

