/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.serde;

import com.kubetrade.schema.trade.AvroSchemaA;
import com.kubetrade.schema.trade.AvroSchemaB;
import com.kubetrade.schema.trade.AvroSchemaC;
import com.kubetrade.schema.trade.AvroSchemaD;
import com.kubetrade.schema.trade.AvroSchemaE;
import com.kubetrade.schema.trade.AvroSchemaF;
import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceResolverStrategy;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.serde.avro.AvroKafkaDeserializer;
import io.apicurio.registry.serde.avro.AvroKafkaSerializer;
import io.apicurio.registry.serde.avro.DefaultAvroDatumProvider;
import io.apicurio.registry.serde.avro.ReflectAvroDatumProvider;
import io.apicurio.registry.serde.avro.strategy.QualifiedRecordIdStrategy;
import io.apicurio.registry.serde.avro.strategy.RecordIdStrategy;
import io.apicurio.registry.serde.avro.strategy.TopicRecordIdStrategy;
import io.apicurio.registry.serde.config.IdOption;
import io.apicurio.registry.serde.strategy.TopicIdStrategy;
import io.apicurio.registry.support.Tester;
import io.apicurio.registry.utils.tests.TestUtils;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.quarkus.test.junit.QuarkusTest;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
public class AvroSerdeTest
extends AbstractResourceTestBase {
    private RegistryClient restClient;

    @BeforeEach
    public void createIsolatedClient() {
        this.restClient = RegistryClientFactory.create((String)TestUtils.getRegistryV2ApiUrl((int)this.testPort));
    }

    @Test
    public void testConfiguration() throws Exception {
        String recordName = "myrecord3";
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"" + recordName + "\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}");
        String groupId = TestUtils.generateGroupId();
        String topic = this.generateArtifactId();
        Integer globalId = this.createArtifact(groupId, topic + "-" + recordName, "AVRO", schema.toString());
        this.waitForGlobalId(globalId.intValue());
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("apicurio.registry.url", TestUtils.getRegistryV2ApiUrl((int)this.testPort));
        config.put("apicurio.registry.artifact.group-id", groupId);
        config.put("apicurio.registry.artifact.version", "1");
        config.put("apicurio.registry.artifact-resolver-strategy", TopicRecordIdStrategy.class.getName());
        config.put("apicurio.registry.avro-datum-provider", DefaultAvroDatumProvider.class.getName());
        AvroKafkaSerializer serializer = new AvroKafkaSerializer();
        serializer.configure(config, true);
        AvroKafkaDeserializer deserializer = new AvroKafkaDeserializer();
        TestUtils.retry(() -> this.lambda$testConfiguration$0(schema, (Serializer)serializer, topic, (Deserializer)deserializer, config));
        serializer.close();
        deserializer.close();
    }

    @Test
    public void testAvro() throws Exception {
        this.testAvroAutoRegisterIdInBody(RecordIdStrategy.class, () -> this.restClient.getArtifactMetaData("test-group-avro", "myrecord3"));
    }

    @Test
    public void testAvroQualifiedRecordIdStrategy() throws Exception {
        this.testAvroAutoRegisterIdInBody(QualifiedRecordIdStrategy.class, () -> this.restClient.getArtifactMetaData(null, "test-group-avro.myrecord3"));
    }

    private void testAvroAutoRegisterIdInBody(Class<? extends ArtifactReferenceResolverStrategy<?, ?>> strategy, Supplier<ArtifactMetaData> artifactFinder) throws Exception {
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"myrecord3\",\"namespace\":\"test-group-avro\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}");
        try (AvroKafkaSerializer serializer = new AvroKafkaSerializer(this.restClient);
             AvroKafkaDeserializer deserializer = new AvroKafkaDeserializer(this.restClient);){
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("apicurio.registry.artifact-resolver-strategy", strategy);
            config.put("apicurio.registry.auto-register", "true");
            config.put("apicurio.registry.headers.enabled", "false");
            serializer.configure(config, false);
            config = new HashMap();
            deserializer.configure(config, false);
            GenericData.Record record = new GenericData.Record(schema);
            record.put("bar", (Object)"somebar");
            String topic = this.generateArtifactId();
            byte[] bytes = serializer.serialize(topic, (Object)record);
            TestUtils.waitForSchema(globalId -> {
                if (this.restClient.getContentByGlobalId(globalId.longValue()) != null) {
                    ArtifactMetaData artifactMetadata = (ArtifactMetaData)artifactFinder.get();
                    Assertions.assertEquals((Long)globalId, (Long)artifactMetadata.getGlobalId());
                    return true;
                }
                return false;
            }, (byte[])bytes);
            GenericData.Record ir = (GenericData.Record)deserializer.deserialize(topic, bytes);
            Assertions.assertEquals((Object)record, (Object)ir);
            Assertions.assertEquals((Object)"somebar", (Object)ir.get("bar").toString());
        }
    }

    @Test
    public void testAvroJSON() throws Exception {
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"myrecord3\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}");
        try (AvroKafkaSerializer serializer = new AvroKafkaSerializer(this.restClient);
             AvroKafkaDeserializer deserializer = new AvroKafkaDeserializer(this.restClient);){
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("apicurio.registry.avro.encoding", "JSON");
            config.put("apicurio.registry.auto-register", "true");
            config.put("apicurio.registry.headers.enabled", "false");
            serializer.configure(config, false);
            config = new HashMap();
            config.put("apicurio.registry.avro.encoding", "JSON");
            deserializer.configure(config, false);
            GenericData.Record record = new GenericData.Record(schema);
            record.put("bar", (Object)"somebar");
            String artifactId = this.generateArtifactId();
            byte[] bytes = serializer.serialize(artifactId, (Object)record);
            JSONObject msgAsJson = new JSONObject(new String(Arrays.copyOfRange(bytes, 9, bytes.length)));
            Assertions.assertEquals((Object)"somebar", (Object)msgAsJson.getString("bar"));
            TestUtils.waitForSchema(globalId -> this.restClient.getContentByGlobalId(globalId.longValue()) != null, (byte[])bytes);
            GenericData.Record ir = (GenericData.Record)deserializer.deserialize(artifactId, bytes);
            Assertions.assertEquals((Object)record, (Object)ir);
            Assertions.assertEquals((Object)"somebar", (Object)ir.get("bar").toString());
        }
    }

    @Test
    public void avroJsonWithReferences() throws Exception {
        try (AvroKafkaSerializer serializer = new AvroKafkaSerializer(this.restClient);
             AvroKafkaDeserializer deserializer = new AvroKafkaDeserializer(this.restClient);){
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("apicurio.registry.avro.encoding", "JSON");
            config.put("apicurio.registry.auto-register", "true");
            config.put("apicurio.registry.headers.enabled", "false");
            serializer.configure(config, false);
            config = new HashMap();
            config.put("apicurio.registry.avro.encoding", "JSON");
            config.putIfAbsent("apicurio.registry.avro-datum-provider", ReflectAvroDatumProvider.class.getName());
            deserializer.configure(config, false);
            AvroSchemaB avroSchemaB = new AvroSchemaB();
            AvroSchemaA avroSchemaA = AvroSchemaA.GEMINI;
            AvroSchemaA avroSchemaA2 = AvroSchemaA.GEMINI;
            AvroSchemaC avroSchemaC = new AvroSchemaC();
            AvroSchemaD avroSchemaD = new AvroSchemaD();
            AvroSchemaE avroSchemaE = new AvroSchemaE();
            AvroSchemaF avroSchemaF = new AvroSchemaF();
            avroSchemaF.setPayload("Fschema");
            avroSchemaF.setSymbol("Fsymbol");
            avroSchemaE.setPayload("ESchema");
            avroSchemaE.setSymbol("ESymbol");
            avroSchemaD.setSchemaE(avroSchemaE);
            avroSchemaD.setSymbol("Dsymbol");
            avroSchemaC.setSymbol("CSymbol");
            avroSchemaC.setPayload("CSchema");
            avroSchemaC.setSchemaD(avroSchemaD);
            avroSchemaB.setSchemaC(avroSchemaC);
            avroSchemaB.setSchemaA(avroSchemaA);
            avroSchemaB.setSchemaA2(avroSchemaA2);
            avroSchemaB.setKey(UUID.randomUUID().toString());
            avroSchemaB.setUnionTest(avroSchemaF);
            avroSchemaB.setArrayTest(List.of(avroSchemaF));
            avroSchemaB.setMapTest(Map.of("mapKey", avroSchemaF));
            String artifactId = this.generateArtifactId();
            byte[] bytes = serializer.serialize(artifactId, (Object)avroSchemaB);
            JSONObject msgAsJson = new JSONObject(new String(Arrays.copyOfRange(bytes, 9, bytes.length)));
            Assertions.assertEquals((Object)"CSymbol", (Object)msgAsJson.getJSONObject("schemaC").getString("symbol"));
            TestUtils.waitForSchema(globalId -> this.restClient.getContentByGlobalId(globalId.longValue()) != null, (byte[])bytes);
            AvroSchemaB ir = (AvroSchemaB)deserializer.deserialize(artifactId, bytes);
            Assertions.assertEquals((Object)avroSchemaB, (Object)ir);
            Assertions.assertEquals((Object)AvroSchemaA.GEMINI, (Object)ir.getSchemaA());
        }
    }

    @Test
    public void avroJsonWithReferencesDereferenced() throws Exception {
        try (AvroKafkaSerializer serializer = new AvroKafkaSerializer(this.restClient);
             AvroKafkaDeserializer deserializer = new AvroKafkaDeserializer(this.restClient);){
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("apicurio.registry.avro.encoding", "JSON");
            config.put("apicurio.registry.auto-register", "true");
            config.put("apicurio.registry.headers.enabled", "false");
            config.put("apicurio.registry.dereference-schema", "true");
            serializer.configure(config, false);
            config = new HashMap();
            config.put("apicurio.registry.avro.encoding", "JSON");
            config.putIfAbsent("apicurio.registry.avro-datum-provider", ReflectAvroDatumProvider.class.getName());
            deserializer.configure(config, false);
            AvroSchemaB avroSchemaB = new AvroSchemaB();
            AvroSchemaA avroSchemaA = AvroSchemaA.GEMINI;
            AvroSchemaA avroSchemaA2 = AvroSchemaA.GEMINI;
            AvroSchemaC avroSchemaC = new AvroSchemaC();
            AvroSchemaD avroSchemaD = new AvroSchemaD();
            AvroSchemaE avroSchemaE = new AvroSchemaE();
            AvroSchemaF avroSchemaF = new AvroSchemaF();
            avroSchemaF.setPayload("Fschema");
            avroSchemaF.setSymbol("Fsymbol");
            avroSchemaE.setPayload("ESchema");
            avroSchemaE.setSymbol("ESymbol");
            avroSchemaD.setSchemaE(avroSchemaE);
            avroSchemaD.setSymbol("Dsymbol");
            avroSchemaC.setSymbol("CSymbol");
            avroSchemaC.setPayload("CSchema");
            avroSchemaC.setSchemaD(avroSchemaD);
            avroSchemaB.setSchemaC(avroSchemaC);
            avroSchemaB.setSchemaA(avroSchemaA);
            avroSchemaB.setSchemaA2(avroSchemaA2);
            avroSchemaB.setKey(UUID.randomUUID().toString());
            avroSchemaB.setUnionTest(avroSchemaF);
            avroSchemaB.setArrayTest(List.of(avroSchemaF));
            avroSchemaB.setMapTest(Map.of("mapKey", avroSchemaF));
            String artifactId = this.generateArtifactId();
            byte[] bytes = serializer.serialize(artifactId, (Object)avroSchemaB);
            JSONObject msgAsJson = new JSONObject(new String(Arrays.copyOfRange(bytes, 9, bytes.length)));
            Assertions.assertEquals((Object)"CSymbol", (Object)msgAsJson.getJSONObject("schemaC").getString("symbol"));
            TestUtils.waitForSchema(globalId -> this.restClient.getContentByGlobalId(globalId.longValue()) != null, (byte[])bytes);
            AvroSchemaB ir = (AvroSchemaB)deserializer.deserialize(artifactId, bytes);
            Assertions.assertEquals((Object)avroSchemaB, (Object)ir);
            Assertions.assertEquals((Object)AvroSchemaA.GEMINI, (Object)ir.getSchemaA());
        }
    }

    @Test
    public void testAvroUsingHeaders() throws Exception {
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"myrecord3\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}");
        try (AvroKafkaSerializer serializer = new AvroKafkaSerializer(this.restClient);
             AvroKafkaDeserializer deserializer = new AvroKafkaDeserializer(this.restClient);){
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("apicurio.registry.headers.enabled", "true");
            config.put("apicurio.registry.auto-register", "true");
            serializer.configure(config, false);
            config = new HashMap();
            config.put("apicurio.registry.headers.enabled", "true");
            deserializer.configure(config, false);
            GenericData.Record record = new GenericData.Record(schema);
            record.put("bar", (Object)"somebar");
            String artifactId = this.generateArtifactId();
            RecordHeaders headers = new RecordHeaders();
            byte[] bytes = serializer.serialize(artifactId, (Headers)headers, (Object)record);
            Assertions.assertNotNull((Object)headers.lastHeader("apicurio.value.globalId"));
            Header globalId = headers.lastHeader("apicurio.value.globalId");
            long id = ByteBuffer.wrap(globalId.value()).getLong();
            this.waitForGlobalId(id);
            GenericData.Record ir = (GenericData.Record)deserializer.deserialize(artifactId, (Headers)headers, bytes);
            Assertions.assertEquals((Object)record, (Object)ir);
            Assertions.assertEquals((Object)"somebar", (Object)ir.get("bar").toString());
        }
    }

    @Test
    public void testReferenceRaw() throws Exception {
        Schema.Parser parser = new Schema.Parser();
        Schema eventTypeSchema = parser.parse("{\n    \"type\": \"enum\",\n    \"namespace\": \"test\",\n    \"name\": \"EventType\",\n    \"symbols\": [\"CREATED\", \"DELETED\", \"UNDEFINED\", \"UPDATED\"]\n  }\n");
        try (AvroKafkaSerializer serializer = new AvroKafkaSerializer(this.restClient);
             AvroKafkaDeserializer deserializer = new AvroKafkaDeserializer(this.restClient);){
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("apicurio.registry.headers.enabled", "true");
            config.put("apicurio.registry.auto-register", "true");
            config.put("apicurio.registry.artifact-resolver-strategy", RecordIdStrategy.class.getName());
            serializer.configure(config, false);
            config = new HashMap();
            config.put("apicurio.registry.headers.enabled", "true");
            deserializer.configure(config, false);
            GenericData.EnumSymbol record = new GenericData.EnumSymbol(eventTypeSchema, "UNDEFINED");
            String artifactId = this.generateArtifactId();
            RecordHeaders headers = new RecordHeaders();
            byte[] bytes = serializer.serialize(artifactId, (Headers)headers, (Object)record);
            Assertions.assertNotNull((Object)headers.lastHeader("apicurio.value.globalId"));
            Header globalId = headers.lastHeader("apicurio.value.globalId");
            long id = ByteBuffer.wrap(globalId.value()).getLong();
            this.waitForGlobalId(id);
            GenericData.EnumSymbol ir = (GenericData.EnumSymbol)deserializer.deserialize(artifactId, (Headers)headers, bytes);
            Assertions.assertEquals((Object)record, (Object)ir);
        }
    }

    @ParameterizedTest
    @ValueSource(classes={TopicIdStrategy.class, QualifiedRecordIdStrategy.class, RecordIdStrategy.class, TopicRecordIdStrategy.class})
    public void testAvroReflect(Class<?> artifactResolverStrategyClass) throws Exception {
        try (AvroKafkaSerializer serializer = new AvroKafkaSerializer(this.restClient);
             AvroKafkaDeserializer deserializer = new AvroKafkaDeserializer(this.restClient);){
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("apicurio.registry.auto-register", "true");
            config.put("apicurio.registry.headers.enabled", "false");
            config.put("apicurio.registry.avro-datum-provider", ReflectAvroDatumProvider.class.getName());
            config.put("apicurio.registry.artifact-resolver-strategy", artifactResolverStrategyClass.getName());
            serializer.configure(config, false);
            config = new HashMap();
            config.put("apicurio.registry.avro-datum-provider", ReflectAvroDatumProvider.class.getName());
            deserializer.configure(config, false);
            String artifactId = this.generateArtifactId();
            Tester tester = new Tester("Apicurio", Tester.TesterState.ONLINE);
            byte[] bytes = serializer.serialize(artifactId, (Object)tester);
            TestUtils.waitForSchema(globalId -> this.restClient.getContentByGlobalId(globalId.longValue()) != null, (byte[])bytes);
            Tester deserializedTester = (Tester)deserializer.deserialize(artifactId, bytes);
            Assertions.assertEquals((Object)tester, (Object)deserializedTester);
            Assertions.assertEquals((Object)"Apicurio", (Object)deserializedTester.getName());
        }
    }

    private SchemaRegistryClient buildClient() {
        return new CachedSchemaRegistryClient("http://localhost:" + this.testPort + "/apis/ccompat/v6", 3);
    }

    @Test
    public void testSerdeMix() throws Exception {
        GenericData.Record ir;
        SchemaRegistryClient schemaClient = this.buildClient();
        String subject = this.generateArtifactId();
        String rawSchema = "{\"type\":\"record\",\"name\":\"myrecord5\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}";
        AvroSchema schema = new AvroSchema(rawSchema);
        schemaClient.register(subject + "-value", (ParsedSchema)schema);
        GenericData.Record record = new GenericData.Record(new Schema.Parser().parse(rawSchema));
        record.put("bar", (Object)"somebar");
        try (KafkaAvroSerializer serializer1 = new KafkaAvroSerializer(schemaClient);
             AvroKafkaDeserializer deserializer1 = new AvroKafkaDeserializer(this.restClient);){
            byte[] bytes = serializer1.serialize(subject, (Object)record);
            TestUtils.retry(() -> TestUtils.waitForSchema(globalId -> this.restClient.getContentById(globalId.longValue()) != null, (byte[])bytes, bb -> bb.getInt()));
            deserializer1.asLegacyId();
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("apicurio.registry.use-id", IdOption.contentId.name());
            deserializer1.configure(config, false);
            ir = (GenericData.Record)deserializer1.deserialize(subject, bytes);
            Assertions.assertEquals((Object)"somebar", (Object)ir.get("bar").toString());
        }
        try (KafkaAvroDeserializer deserializer2 = new KafkaAvroDeserializer(schemaClient);
             AvroKafkaSerializer serializer2 = new AvroKafkaSerializer(this.restClient);){
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("apicurio.registry.use-id", IdOption.contentId.name());
            serializer2.asLegacyId();
            serializer2.configure(config, false);
            byte[] bytes = serializer2.serialize(subject, (Object)record);
            ir = (GenericData.Record)deserializer2.deserialize(subject, bytes);
            Assertions.assertEquals((Object)"somebar", (Object)ir.get("bar").toString());
        }
    }

    private /* synthetic */ void lambda$testConfiguration$0(Schema schema, Serializer serializer, String topic, Deserializer deserializer, Map config) throws Exception {
        GenericData.Record record = new GenericData.Record(schema);
        record.put("bar", (Object)"somebar");
        byte[] bytes = serializer.serialize(topic, (Object)record);
        HashMap<String, String> deserializerConfig = new HashMap<String, String>();
        deserializerConfig.put("apicurio.registry.url", TestUtils.getRegistryV2ApiUrl((int)this.testPort));
        deserializer.configure(deserializerConfig, true);
        GenericData.Record deserializedRecord = (GenericData.Record)deserializer.deserialize(topic, bytes);
        Assertions.assertEquals((Object)record, (Object)deserializedRecord);
        Assertions.assertEquals((Object)"somebar", (Object)record.get("bar").toString());
        config.put("apicurio.registry.artifact-resolver-strategy", TopicRecordIdStrategy.class);
        config.put("apicurio.registry.avro-datum-provider", DefaultAvroDatumProvider.class);
        serializer.configure(config, true);
        bytes = serializer.serialize(topic, (Object)record);
        deserializer.configure(deserializerConfig, true);
        record = (GenericData.Record)deserializer.deserialize(topic, bytes);
        Assertions.assertEquals((Object)"somebar", (Object)record.get("bar").toString());
        config.put("apicurio.registry.artifact-resolver-strategy", TopicRecordIdStrategy.class.getName());
        config.put("apicurio.registry.avro-datum-provider", DefaultAvroDatumProvider.class.getName());
        serializer.configure(config, true);
        bytes = serializer.serialize(topic, (Object)record);
        deserializer.configure(deserializerConfig, true);
        record = (GenericData.Record)deserializer.deserialize(topic, bytes);
        Assertions.assertEquals((Object)"somebar", (Object)record.get("bar").toString());
    }
}

