/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.serde;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.resolver.DefaultSchemaResolver;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.SchemaResolverConfig;
import io.apicurio.registry.resolver.strategy.ArtifactReference;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceImpl;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.IfExists;
import io.apicurio.registry.serde.SchemaResolverConfigurer;
import io.apicurio.registry.serde.jsonschema.JsonSchema;
import io.apicurio.registry.serde.jsonschema.JsonSchemaKafkaDeserializer;
import io.apicurio.registry.serde.jsonschema.JsonSchemaKafkaSerializer;
import io.apicurio.registry.serde.jsonschema.JsonSchemaParser;
import io.apicurio.registry.serde.strategy.SimpleTopicIdStrategy;
import io.apicurio.registry.support.Citizen;
import io.apicurio.registry.support.CitizenIdentifier;
import io.apicurio.registry.support.City;
import io.apicurio.registry.support.Person;
import io.apicurio.registry.support.Qualification;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.everit.json.schema.ValidationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class JsonSchemaSerdeTest
extends AbstractResourceTestBase {
    private RegistryClient restClient;

    @BeforeEach
    public void createIsolatedClient() {
        this.restClient = RegistryClientFactory.create((String)TestUtils.getRegistryV2ApiUrl((int)this.testPort));
    }

    @Test
    public void testJsonSchemaSerde() throws Exception {
        InputStream jsonSchema = this.getClass().getResourceAsStream("/io/apicurio/registry/util/json-schema.json");
        Assertions.assertNotNull((Object)jsonSchema);
        String groupId = TestUtils.generateGroupId();
        String artifactId = this.generateArtifactId();
        Integer globalId = this.createArtifact(groupId, artifactId, "JSON", IoUtil.toString((InputStream)jsonSchema));
        this.waitForGlobalId(globalId.intValue());
        Person person = new Person("Ales", "Justin", 23);
        try (JsonSchemaKafkaSerializer serializer = new JsonSchemaKafkaSerializer(this.restClient, Boolean.valueOf(true));
             JsonSchemaKafkaDeserializer deserializer = new JsonSchemaKafkaDeserializer(this.restClient, Boolean.valueOf(true));){
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("apicurio.registry.artifact.group-id", groupId);
            config.put("apicurio.registry.artifact-resolver-strategy", SimpleTopicIdStrategy.class.getName());
            serializer.configure(config, false);
            deserializer.configure(Collections.emptyMap(), false);
            RecordHeaders headers = new RecordHeaders();
            byte[] bytes = serializer.serialize(artifactId, (Headers)headers, (Object)person);
            person = (Person)deserializer.deserialize(artifactId, (Headers)headers, bytes);
            Assertions.assertEquals((Object)"Ales", (Object)person.getFirstName());
            Assertions.assertEquals((Object)"Justin", (Object)person.getLastName());
            Assertions.assertEquals((int)23, (int)person.getAge());
            person.setAge(-1);
            try {
                serializer.serialize(artifactId, (Headers)new RecordHeaders(), (Object)person);
                Assertions.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            serializer.setValidationEnabled(Boolean.valueOf(false));
            bytes = serializer.serialize(artifactId, (Headers)headers, (Object)person);
            try {
                deserializer.deserialize(artifactId, (Headers)headers, bytes);
                Assertions.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testJsonSchemaSerdeAutoRegister() throws Exception {
        String groupId = TestUtils.generateGroupId();
        String artifactId = this.generateArtifactId();
        Person person = new Person("Carles", "Arnal", 30);
        try (JsonSchemaKafkaSerializer serializer = new JsonSchemaKafkaSerializer(this.restClient, Boolean.valueOf(true));
             JsonSchemaKafkaDeserializer deserializer = new JsonSchemaKafkaDeserializer(this.restClient, Boolean.valueOf(true));){
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("apicurio.registry.artifact.group-id", groupId);
            config.put("apicurio.registry.artifact-resolver-strategy", SimpleTopicIdStrategy.class.getName());
            config.put("apicurio.registry.artifact.schema.location", "/io/apicurio/registry/util/json-schema.json");
            config.put("apicurio.registry.auto-register", true);
            serializer.configure(config, false);
            deserializer.configure(Collections.emptyMap(), false);
            RecordHeaders headers = new RecordHeaders();
            byte[] bytes = serializer.serialize(artifactId, (Headers)headers, (Object)person);
            person = (Person)deserializer.deserialize(artifactId, (Headers)headers, bytes);
            Assertions.assertEquals((Object)"Carles", (Object)person.getFirstName());
            Assertions.assertEquals((Object)"Arnal", (Object)person.getLastName());
            Assertions.assertEquals((int)30, (int)person.getAge());
            person.setAge(-1);
            try {
                serializer.serialize(artifactId, (Headers)new RecordHeaders(), (Object)person);
                Assertions.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            serializer.setValidationEnabled(Boolean.valueOf(false));
            bytes = serializer.serialize(artifactId, (Headers)headers, (Object)person);
            try {
                deserializer.deserialize(artifactId, (Headers)headers, bytes);
                Assertions.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testJsonSchemaSerdeHeaders() throws Exception {
        InputStream jsonSchema = this.getClass().getResourceAsStream("/io/apicurio/registry/util/json-schema.json");
        Assertions.assertNotNull((Object)jsonSchema);
        String groupId = TestUtils.generateGroupId();
        String artifactId = this.generateArtifactId();
        Integer globalId = this.createArtifact(groupId, artifactId, "JSON", IoUtil.toString((InputStream)jsonSchema));
        this.waitForGlobalId(globalId.intValue());
        Person person = new Person("Ales", "Justin", 23);
        try (JsonSchemaKafkaSerializer serializer = new JsonSchemaKafkaSerializer(this.restClient, Boolean.valueOf(true));
             JsonSchemaKafkaDeserializer deserializer = new JsonSchemaKafkaDeserializer(this.restClient, Boolean.valueOf(true));){
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("apicurio.registry.artifact.group-id", groupId);
            config.put("apicurio.registry.artifact-resolver-strategy", SimpleTopicIdStrategy.class.getName());
            serializer.configure(config, false);
            deserializer.configure(Collections.emptyMap(), false);
            RecordHeaders headers = new RecordHeaders();
            byte[] bytes = serializer.serialize(artifactId, (Headers)headers, (Object)person);
            Assertions.assertNotNull((Object)headers.lastHeader("apicurio.value.globalId"));
            Header headerGlobalId = headers.lastHeader("apicurio.value.globalId");
            long id = ByteBuffer.wrap(headerGlobalId.value()).getLong();
            Assertions.assertEquals((int)globalId, (int)Long.valueOf(id).intValue());
            Assertions.assertNotNull((Object)headers.lastHeader("apicurio.value.msgType"));
            Header headerMsgType = headers.lastHeader("apicurio.value.msgType");
            Assertions.assertEquals((Object)person.getClass().getName(), (Object)IoUtil.toString((byte[])headerMsgType.value()));
            person = (Person)deserializer.deserialize(artifactId, (Headers)headers, bytes);
            Assertions.assertEquals((Object)"Ales", (Object)person.getFirstName());
            Assertions.assertEquals((Object)"Justin", (Object)person.getLastName());
            Assertions.assertEquals((int)23, (int)person.getAge());
        }
    }

    @Test
    public void testJsonSchemaSerdeMagicByte() throws Exception {
        InputStream jsonSchema = this.getClass().getResourceAsStream("/io/apicurio/registry/util/json-schema-with-java-type.json");
        Assertions.assertNotNull((Object)jsonSchema);
        String groupId = TestUtils.generateGroupId();
        String artifactId = this.generateArtifactId();
        Integer globalId = this.createArtifact(groupId, artifactId, "JSON", IoUtil.toString((InputStream)jsonSchema));
        this.waitForGlobalId(globalId.intValue());
        Person person = new Person("Ales", "Justin", 23);
        try (JsonSchemaKafkaSerializer serializer = new JsonSchemaKafkaSerializer(this.restClient, Boolean.valueOf(true));
             JsonSchemaKafkaDeserializer deserializer = new JsonSchemaKafkaDeserializer(this.restClient, Boolean.valueOf(true));){
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("apicurio.registry.artifact.group-id", groupId);
            config.put("apicurio.registry.artifact-resolver-strategy", SimpleTopicIdStrategy.class.getName());
            serializer.configure(config, false);
            deserializer.configure(Collections.emptyMap(), false);
            byte[] bytes = serializer.serialize(artifactId, (Object)person);
            TestUtils.waitForSchema(schemaGlobalId -> {
                Assertions.assertEquals((int)globalId, (int)schemaGlobalId.intValue());
                return true;
            }, (byte[])bytes);
            person = (Person)deserializer.deserialize(artifactId, bytes);
            Assertions.assertEquals((Object)"Ales", (Object)person.getFirstName());
            Assertions.assertEquals((Object)"Justin", (Object)person.getLastName());
            Assertions.assertEquals((int)23, (int)person.getAge());
        }
    }

    @Test
    public void testJsonSchemaSerdeWithReferences() throws Exception {
        InputStream citySchema = this.getClass().getResourceAsStream("/io/apicurio/registry/util/city.json");
        InputStream citizenSchema = this.getClass().getResourceAsStream("/io/apicurio/registry/util/citizen.json");
        InputStream citizenIdentifier = this.getClass().getResourceAsStream("/io/apicurio/registry/util/citizenIdentifier.json");
        InputStream qualificationSchema = this.getClass().getResourceAsStream("/io/apicurio/registry/util/qualification.json");
        InputStream addressSchema = this.getClass().getResourceAsStream("/io/apicurio/registry/util/sample.address.json");
        Assertions.assertNotNull((Object)citizenSchema);
        Assertions.assertNotNull((Object)citySchema);
        Assertions.assertNotNull((Object)citizenIdentifier);
        Assertions.assertNotNull((Object)qualificationSchema);
        Assertions.assertNotNull((Object)addressSchema);
        String groupId = TestUtils.generateGroupId();
        String cityArtifactId = this.generateArtifactId();
        String qualificationsId = this.generateArtifactId();
        String identifierArtifactId = this.generateArtifactId();
        String addressId = this.generateArtifactId();
        Integer cityDependencyGlobalId = this.createArtifact(groupId, cityArtifactId, "JSON", IoUtil.toString((InputStream)citySchema));
        this.waitForGlobalId(cityDependencyGlobalId.intValue());
        Integer qualificationsGlobalId = this.createArtifact(groupId, qualificationsId, "JSON", IoUtil.toString((InputStream)qualificationSchema));
        this.waitForGlobalId(qualificationsGlobalId.intValue());
        io.apicurio.registry.rest.v2.beans.ArtifactReference qualificationsReference = new io.apicurio.registry.rest.v2.beans.ArtifactReference();
        qualificationsReference.setVersion("1");
        qualificationsReference.setGroupId(groupId);
        qualificationsReference.setArtifactId(qualificationsId);
        qualificationsReference.setName("qualification.json");
        Integer addressGlobalID = this.createArtifact(groupId, addressId, "JSON", IoUtil.toString((InputStream)addressSchema));
        this.waitForGlobalId(addressGlobalID.intValue());
        io.apicurio.registry.rest.v2.beans.ArtifactReference addressReference = new io.apicurio.registry.rest.v2.beans.ArtifactReference();
        addressReference.setVersion("1");
        addressReference.setGroupId(groupId);
        addressReference.setArtifactId(addressId);
        addressReference.setName("sample.address.json");
        io.apicurio.registry.rest.v2.beans.ArtifactReference cityReference = new io.apicurio.registry.rest.v2.beans.ArtifactReference();
        cityReference.setVersion("1");
        cityReference.setGroupId(groupId);
        cityReference.setArtifactId(cityArtifactId);
        cityReference.setName("city.json");
        Integer identifierDependencyGlobalId = this.createArtifact(groupId, identifierArtifactId, "JSON", IoUtil.toString((InputStream)citizenIdentifier));
        this.waitForGlobalId(identifierDependencyGlobalId.intValue());
        io.apicurio.registry.rest.v2.beans.ArtifactReference identifierReference = new io.apicurio.registry.rest.v2.beans.ArtifactReference();
        identifierReference.setVersion("1");
        identifierReference.setGroupId(groupId);
        identifierReference.setArtifactId(identifierArtifactId);
        identifierReference.setName("citizenIdentifier.json");
        String artifactId = this.generateArtifactId();
        Integer globalId = this.createArtifactWithReferences(groupId, artifactId, "JSON", IoUtil.toString((InputStream)citizenSchema), List.of(qualificationsReference, cityReference, identifierReference, addressReference));
        this.waitForGlobalId(globalId.intValue());
        City city = new City("New York", 10001);
        CitizenIdentifier identifier = new CitizenIdentifier(123456789);
        Citizen citizen = new Citizen("Carles", "Arnal", 23, city, identifier, Collections.emptyList());
        try (JsonSchemaKafkaSerializer serializer = new JsonSchemaKafkaSerializer(this.restClient, Boolean.valueOf(true));
             JsonSchemaKafkaDeserializer deserializer = new JsonSchemaKafkaDeserializer(this.restClient, Boolean.valueOf(true));){
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("apicurio.registry.artifact.group-id", groupId);
            config.put("apicurio.registry.artifact-resolver-strategy", SimpleTopicIdStrategy.class.getName());
            serializer.configure(config, false);
            deserializer.configure(Collections.emptyMap(), false);
            RecordHeaders headers = new RecordHeaders();
            byte[] bytes = serializer.serialize(artifactId, (Headers)headers, (Object)citizen);
            citizen = (Citizen)deserializer.deserialize(artifactId, (Headers)headers, bytes);
            Assertions.assertEquals((Object)"Carles", (Object)citizen.getFirstName());
            Assertions.assertEquals((Object)"Arnal", (Object)citizen.getLastName());
            Assertions.assertEquals((int)23, (int)citizen.getAge());
            Assertions.assertEquals((Object)"New York", (Object)citizen.getCity().getName());
            citizen.setAge(-1);
            try {
                serializer.serialize(artifactId, (Headers)new RecordHeaders(), (Object)citizen);
                Assertions.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            citizen.setAge(23);
            city = new City("Kansas CIty", -31);
            citizen.setCity(city);
            try {
                serializer.serialize(artifactId, (Headers)new RecordHeaders(), (Object)citizen);
                Assertions.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            identifier = new CitizenIdentifier(-1234356);
            citizen.setIdentifier(identifier);
            city = new City("Kansas CIty", 22222);
            citizen.setCity(city);
            try {
                serializer.serialize(artifactId, (Headers)new RecordHeaders(), (Object)citizen);
                Assertions.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            citizen.setIdentifier(null);
            serializer.serialize(artifactId, (Headers)new RecordHeaders(), (Object)citizen);
            citizen.setQualifications(List.of(new Qualification(UUID.randomUUID().toString(), 6), new Qualification(UUID.randomUUID().toString(), 7), new Qualification(UUID.randomUUID().toString(), 8)));
            serializer.serialize(artifactId, (Headers)new RecordHeaders(), (Object)citizen);
            citizen.setQualifications(List.of(new Qualification(UUID.randomUUID().toString(), 6), new Qualification(UUID.randomUUID().toString(), -7), new Qualification(UUID.randomUUID().toString(), 8)));
            try {
                serializer.serialize(artifactId, (Headers)new RecordHeaders(), (Object)citizen);
                Assertions.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void complexObjectValidation() throws Exception {
        String version = "8";
        RegistryClient client = this.createRestClientV2();
        InputStream account = this.getClass().getClassLoader().getResourceAsStream("/io/apicurio/registry/util/sample.account.json");
        InputStream address = this.getClass().getClassLoader().getResourceAsStream("/io/apicurio/registry/util/sample.address.json");
        InputStream email = this.getClass().getClassLoader().getResourceAsStream("/io/apicurio/registry/util/sample.email.json");
        InputStream phone = this.getClass().getClassLoader().getResourceAsStream("/io/apicurio/registry/util/sample.phone.json");
        Assertions.assertNotNull((Object)account);
        Assertions.assertNotNull((Object)address);
        Assertions.assertNotNull((Object)email);
        Assertions.assertNotNull((Object)phone);
        ArtifactMetaData amdAddress = client.createArtifact("GLOBAL", "sample.address.json", version, "JSON", IfExists.UPDATE, Boolean.valueOf(false), null, null, "application/create.extended+json", null, null, address, null);
        ArtifactMetaData amdEmail = client.createArtifact("GLOBAL", "sample.email.json", version, "JSON", IfExists.UPDATE, Boolean.valueOf(false), null, null, "application/create.extended+json", null, null, email, null);
        ArtifactMetaData amdPhone = client.createArtifact("GLOBAL", "sample.phone.json", version, "JSON", IfExists.UPDATE, Boolean.valueOf(false), null, null, "application/create.extended+json", null, null, phone, null);
        io.apicurio.registry.rest.v2.beans.ArtifactReference addressReference = new io.apicurio.registry.rest.v2.beans.ArtifactReference();
        addressReference.setVersion(amdAddress.getVersion());
        addressReference.setGroupId(amdAddress.getGroupId());
        addressReference.setArtifactId(amdAddress.getId());
        addressReference.setName("sample.address.json");
        io.apicurio.registry.rest.v2.beans.ArtifactReference emailReference = new io.apicurio.registry.rest.v2.beans.ArtifactReference();
        emailReference.setVersion(amdEmail.getVersion());
        emailReference.setGroupId(amdEmail.getGroupId());
        emailReference.setArtifactId(amdEmail.getId());
        emailReference.setName("sample.email.json");
        io.apicurio.registry.rest.v2.beans.ArtifactReference phoneReference = new io.apicurio.registry.rest.v2.beans.ArtifactReference();
        phoneReference.setVersion(amdPhone.getVersion());
        phoneReference.setGroupId(amdPhone.getGroupId());
        phoneReference.setArtifactId(amdPhone.getId());
        phoneReference.setName("sample.phone.json");
        ArrayList<io.apicurio.registry.rest.v2.beans.ArtifactReference> artifactReferences = new ArrayList<io.apicurio.registry.rest.v2.beans.ArtifactReference>();
        artifactReferences.add(addressReference);
        artifactReferences.add(emailReference);
        artifactReferences.add(phoneReference);
        client.createArtifact("GLOBAL", "sample.account.json", version, "JSON", IfExists.UPDATE, Boolean.valueOf(false), null, null, "application/create.extended+json", null, null, account, artifactReferences);
        String data = "{\n  \"id\": \"abc\",\n  \n  \"accountPhones\": [{\n  \"phoneRelationTypeCd\": \"ABCDEFGHIJ\",\n  \"effectiveDate\": \"201-09-29T18:46:19Z\"\n  \n  \n  }]\n}";
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode validationFor = objectMapper.readTree(data);
        ArtifactMetaData global = client.getArtifactMetaData("GLOBAL", "sample.account.json");
        ArtifactReferenceImpl artifactReference = ArtifactReference.builder().globalId(global.getGlobalId()).groupId("GLOBAL").artifactId("sample.account.json").build();
        SchemaResolverConfigurer src = new SchemaResolverConfigurer(client);
        SchemaResolver sr = src.getSchemaResolver();
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put(SchemaResolverConfig.ARTIFACT_RESOLVER_STRATEGY_DEFAULT, DefaultSchemaResolver.class.getName());
        configs.put("apicurio.registry.check-period-ms", "600000");
        sr.configure(configs, (SchemaParser)new JsonSchemaParser());
        ParsedSchema ps = sr.resolveSchemaByArtifactReference((ArtifactReference)artifactReference).getParsedSchema();
        JsonSchemaSerdeTest.validateDataWithSchema((ParsedSchema<JsonSchema>)ps, objectMapper.writeValueAsBytes((Object)validationFor), objectMapper);
    }

    protected static void validateDataWithSchema(ParsedSchema<JsonSchema> schema, byte[] data, ObjectMapper mapper) throws IOException {
        try {
            ((JsonSchema)schema.getParsedSchema()).validate((Object)mapper.readTree(data));
        }
        catch (ValidationException e) {
            System.out.println(e.getAllMessages());
        }
    }
}

