/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.serde;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import io.api.sample.TableNotification;
import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.serde.protobuf.ProtobufKafkaDeserializer;
import io.apicurio.registry.serde.protobuf.ProtobufKafkaSerializer;
import io.apicurio.registry.serde.strategy.SimpleTopicIdStrategy;
import io.apicurio.registry.support.TestCmmn;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class ProtobufSerdeTest
extends AbstractResourceTestBase {
    private RegistryClient restClient;
    private String groupId = "protobuf-serde-test";

    @BeforeEach
    public void createIsolatedClient() {
        this.restClient = RegistryClientFactory.create((String)TestUtils.getRegistryV2ApiUrl((int)this.testPort));
    }

    @Test
    public void testProto() throws Exception {
        try (ProtobufKafkaSerializer serializer = new ProtobufKafkaSerializer(this.restClient);
             ProtobufKafkaDeserializer deserializer = new ProtobufKafkaDeserializer(this.restClient);){
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("apicurio.registry.artifact-resolver-strategy", SimpleTopicIdStrategy.class);
            config.put("apicurio.registry.auto-register", "true");
            config.put("apicurio.registry.artifact.group-id", this.groupId);
            config.put("apicurio.registry.fallback.group-id", this.groupId);
            serializer.configure(config, false);
            deserializer.configure(config, false);
            TestCmmn.UUID record = TestCmmn.UUID.newBuilder().setLsb(2L).setMsb(1L).build();
            String topic = this.generateArtifactId();
            byte[] bytes = serializer.serialize(topic, (Object)record);
            TestUtils.waitForSchema(globalId -> {
                if (this.restClient.getContentByGlobalId(globalId.longValue()) != null) {
                    ArtifactMetaData artifactMetadata = this.restClient.getArtifactMetaData(this.groupId, topic);
                    Assertions.assertEquals((Long)globalId, (Long)artifactMetadata.getGlobalId());
                    return true;
                }
                return false;
            }, (byte[])bytes);
            DynamicMessage dm = (DynamicMessage)deserializer.deserialize(topic, bytes);
            this.assertProtobufEquals(record, dm);
        }
    }

    @Test
    public void testProtobufSchemaWithReferences() {
        try (ProtobufKafkaSerializer serializer = new ProtobufKafkaSerializer(this.restClient);
             ProtobufKafkaDeserializer deserializer = new ProtobufKafkaDeserializer(this.restClient);){
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("apicurio.registry.artifact-resolver-strategy", SimpleTopicIdStrategy.class);
            config.put("apicurio.registry.auto-register", "true");
            config.put("apicurio.registry.artifact.group-id", this.groupId);
            config.put("apicurio.registry.fallback.group-id", this.groupId);
            serializer.configure(config, false);
            deserializer.configure(config, false);
            byte[] data = serializer.serialize("test", (Object)TableNotification.newBuilder().build());
            deserializer.deserialize("test", data);
        }
    }

    private void assertProtobufEquals(TestCmmn.UUID record, DynamicMessage dm) {
        Descriptors.Descriptor descriptor = dm.getDescriptorForType();
        Descriptors.FieldDescriptor lsb = descriptor.findFieldByName("lsb");
        Assertions.assertNotNull((Object)lsb);
        Assertions.assertEquals((Object)record.getLsb(), (Object)dm.getField(lsb));
        Descriptors.FieldDescriptor msb = descriptor.findFieldByName("msb");
        Assertions.assertNotNull((Object)msb);
        Assertions.assertEquals((Object)record.getMsb(), (Object)dm.getField(msb));
    }
}

