/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.storage;

import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.common.apps.multitenancy.ApicurioTenantContext;
import io.apicurio.common.apps.multitenancy.TenantContext;
import io.apicurio.common.apps.multitenancy.context.ApicurioTenantContextImpl;
import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.mt.MockTenantMetadataService;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.RuleAlreadyExistsException;
import io.apicurio.registry.storage.RuleNotFoundException;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.CommentDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.SearchedArtifactDto;
import io.apicurio.registry.storage.dto.SearchedVersionDto;
import io.apicurio.registry.storage.dto.StoredArtifactDto;
import io.apicurio.registry.storage.dto.VersionSearchResultsDto;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.impexp.EntityType;
import io.apicurio.registry.utils.tests.TestUtils;
import io.apicurio.tenantmanager.api.datamodel.ApicurioTenant;
import io.apicurio.tenantmanager.api.datamodel.TenantStatusValue;
import jakarta.inject.Inject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;

public abstract class AbstractRegistryStorageTest
extends AbstractResourceTestBase {
    private static final String GROUP_ID = AbstractRegistryStorageTest.class.getSimpleName();
    protected static final String OPENAPI_CONTENT = "{    \"openapi\": \"3.0.2\",    \"info\": {        \"title\": \"Empty API\",        \"version\": \"1.0.0\",        \"description\": \"An example API design using OpenAPI.\"    }}";
    protected static final String OPENAPI_CONTENT_V2 = "{    \"openapi\": \"3.0.2\",    \"info\": {        \"title\": \"Empty API 2\",        \"version\": \"1.0.1\",        \"description\": \"An example API design using OpenAPI.\"    }}";
    protected static final String OPENAPI_CONTENT_TEMPLATE = "{    \"openapi\": \"3.0.2\",    \"info\": {        \"title\": \"Empty API 2\",        \"version\": \"VERSION\",        \"description\": \"An example API design using OpenAPI.\"    }}";
    @Inject
    Logger log;
    @Inject
    TenantContext tenantCtx;
    @Inject
    MockTenantMetadataService tms;
    ApicurioTenantContext tenantId1;
    ApicurioTenantContext tenantId2;

    @BeforeEach
    protected void setTenantIds() throws Exception {
        this.tenantId1 = new ApicurioTenantContextImpl(UUID.randomUUID().toString(), null, null, TenantStatusValue.READY, null);
        ApicurioTenant rt1 = new ApicurioTenant();
        rt1.setTenantId(this.tenantId1.getTenantId());
        rt1.setStatus(this.tenantId1.getStatus());
        this.tms.createTenant(rt1);
        this.tenantId2 = new ApicurioTenantContextImpl(UUID.randomUUID().toString(), null, null, TenantStatusValue.READY, null);
        ApicurioTenant rt2 = new ApicurioTenant();
        rt2.setTenantId(this.tenantId2.getTenantId());
        rt2.setStatus(this.tenantId2.getStatus());
        this.tms.createTenant(rt2);
    }

    @AfterEach
    protected void resetTenant() throws Exception {
        this.tenantCtx.clearContext();
    }

    protected abstract RegistryStorage storage();

    @Test
    public void testGetArtifactIds() throws Exception {
        int size = this.storage().getArtifactIds(null).size();
        String artifactIdPrefix = "testGetArtifactIds-";
        for (int idx = 1; idx <= 10; ++idx) {
            String artifactId = artifactIdPrefix + idx;
            ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
            ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
            Assertions.assertNotNull((Object)dto);
            Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
            Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
            GroupMetaDataDto groupMetaDataDto = this.storage().getGroupMetaData(GROUP_ID);
            Assertions.assertNotNull((Object)groupMetaDataDto);
            Assertions.assertEquals((Object)GROUP_ID, (Object)groupMetaDataDto.getGroupId());
        }
        int newsize = this.storage().getArtifactIds(null).size();
        int newids = newsize - size;
        Assertions.assertEquals((int)10, (int)newids);
    }

    @Test
    public void testCreateArtifact() throws Exception {
        String artifactId = "testCreateArtifact-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        Assertions.assertEquals((Object)"Empty API", (Object)dto.getName());
        Assertions.assertEquals((Object)"An example API design using OpenAPI.", (Object)dto.getDescription());
        Assertions.assertNull((Object)dto.getLabels());
        Assertions.assertNull((Object)dto.getProperties());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dto.getState());
        Assertions.assertEquals((Object)"1", (Object)dto.getVersion());
        StoredArtifactDto storedArtifact = this.storage().getArtifact(GROUP_ID, artifactId);
        Assertions.assertNotNull((Object)storedArtifact);
        Assertions.assertEquals((Object)OPENAPI_CONTENT, (Object)storedArtifact.getContent().content());
        Assertions.assertEquals((long)dto.getGlobalId(), (Long)storedArtifact.getGlobalId());
        Assertions.assertEquals((Object)dto.getVersion(), (Object)storedArtifact.getVersion());
        ArtifactMetaDataDto amdDto = this.storage().getArtifactMetaData(GROUP_ID, artifactId);
        Assertions.assertNotNull((Object)amdDto);
        Assertions.assertEquals((long)dto.getGlobalId(), (long)amdDto.getGlobalId());
        Assertions.assertEquals((Object)"Empty API", (Object)amdDto.getName());
        Assertions.assertEquals((Object)"An example API design using OpenAPI.", (Object)amdDto.getDescription());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)amdDto.getState());
        Assertions.assertEquals((Object)"1", (Object)amdDto.getVersion());
        Assertions.assertNull((Object)amdDto.getLabels());
        Assertions.assertNull((Object)amdDto.getProperties());
        ArtifactVersionMetaDataDto versionMetaDataDto = this.storage().getArtifactVersionMetaData(GROUP_ID, artifactId, "1");
        Assertions.assertNotNull((Object)versionMetaDataDto);
        Assertions.assertEquals((long)dto.getGlobalId(), (long)versionMetaDataDto.getGlobalId());
        Assertions.assertEquals((Object)"Empty API", (Object)versionMetaDataDto.getName());
        Assertions.assertEquals((Object)"An example API design using OpenAPI.", (Object)versionMetaDataDto.getDescription());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)versionMetaDataDto.getState());
        Assertions.assertEquals((Object)"1", (Object)versionMetaDataDto.getVersion());
        StoredArtifactDto storedVersion = this.storage().getArtifactVersion(dto.getGlobalId());
        Assertions.assertNotNull((Object)storedVersion);
        Assertions.assertEquals((Object)OPENAPI_CONTENT, (Object)storedVersion.getContent().content());
        Assertions.assertEquals((long)dto.getGlobalId(), (Long)storedVersion.getGlobalId());
        Assertions.assertEquals((Object)dto.getVersion(), (Object)storedVersion.getVersion());
        storedVersion = this.storage().getArtifactVersion(GROUP_ID, artifactId, "1");
        Assertions.assertNotNull((Object)storedVersion);
        Assertions.assertEquals((Object)OPENAPI_CONTENT, (Object)storedVersion.getContent().content());
        Assertions.assertEquals((long)dto.getGlobalId(), (Long)storedVersion.getGlobalId());
        Assertions.assertEquals((Object)dto.getVersion(), (Object)storedVersion.getVersion());
        List versions = this.storage().getArtifactVersions(GROUP_ID, artifactId);
        Assertions.assertNotNull((Object)versions);
        Assertions.assertEquals((Object)"1", versions.iterator().next());
    }

    @Test
    public void testCreateArtifactWithMetaData() throws Exception {
        String artifactId = "testCreateArtifactWithMetaData-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        EditableArtifactMetaDataDto metaData = new EditableArtifactMetaDataDto("NAME", "DESCRIPTION", Collections.singletonList("LABEL-1"), Collections.singletonMap("KEY", "VALUE"));
        ArtifactMetaDataDto dto = this.storage().createArtifactWithMetadata(GROUP_ID, artifactId, null, "OPENAPI", content, metaData, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        Assertions.assertEquals((Object)"NAME", (Object)dto.getName());
        Assertions.assertEquals((Object)"DESCRIPTION", (Object)dto.getDescription());
        Assertions.assertNotNull((Object)dto.getLabels());
        Assertions.assertNotNull((Object)dto.getProperties());
        Assertions.assertEquals((Object)metaData.getLabels(), (Object)dto.getLabels());
        Assertions.assertEquals((Object)metaData.getProperties(), (Object)dto.getProperties());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dto.getState());
        Assertions.assertEquals((Object)"1", (Object)dto.getVersion());
        StoredArtifactDto storedArtifact = this.storage().getArtifact(GROUP_ID, artifactId);
        Assertions.assertNotNull((Object)storedArtifact);
        Assertions.assertEquals((Object)OPENAPI_CONTENT, (Object)storedArtifact.getContent().content());
        Assertions.assertEquals((long)dto.getGlobalId(), (Long)storedArtifact.getGlobalId());
        Assertions.assertEquals((Object)dto.getVersion(), (Object)storedArtifact.getVersion());
        ArtifactMetaDataDto amdDto = this.storage().getArtifactMetaData(GROUP_ID, artifactId);
        Assertions.assertNotNull((Object)amdDto);
        Assertions.assertEquals((long)dto.getGlobalId(), (long)amdDto.getGlobalId());
        Assertions.assertEquals((Object)"NAME", (Object)amdDto.getName());
        Assertions.assertEquals((Object)"DESCRIPTION", (Object)amdDto.getDescription());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)amdDto.getState());
        Assertions.assertEquals((Object)"1", (Object)amdDto.getVersion());
        Assertions.assertEquals((Object)metaData.getLabels(), (Object)amdDto.getLabels());
        Assertions.assertEquals((Object)metaData.getProperties(), (Object)amdDto.getProperties());
        artifactId = "testCreateArtifactWithMetaData-2";
        metaData = new EditableArtifactMetaDataDto();
        metaData.setName(AbstractRegistryStorageTest.generateString(600));
        metaData.setDescription(AbstractRegistryStorageTest.generateString(2000));
        metaData.setLabels(new ArrayList());
        metaData.getLabels().add("label-" + AbstractRegistryStorageTest.generateString(300));
        metaData.setProperties(new HashMap());
        metaData.getProperties().put("key-" + AbstractRegistryStorageTest.generateString(300), "value-" + AbstractRegistryStorageTest.generateString(2000));
        dto = this.storage().createArtifactWithMetadata(GROUP_ID, artifactId, null, "OPENAPI", content, metaData, null);
        dto = this.storage().getArtifactMetaData(dto.getGlobalId());
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        Assertions.assertEquals((int)512, (int)dto.getName().length());
        Assertions.assertEquals((int)1024, (int)dto.getDescription().length());
        Assertions.assertTrue((boolean)dto.getDescription().endsWith("..."));
        Assertions.assertNotNull((Object)dto.getLabels());
        Assertions.assertNotNull((Object)dto.getProperties());
        Assertions.assertEquals((int)1, (int)dto.getLabels().size());
        Assertions.assertEquals((int)1, (int)dto.getProperties().size());
    }

    @Test
    public void testCreateDuplicateArtifact() throws Exception {
        String artifactId = "testCreateDuplicateArtifact-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertThrows(ArtifactAlreadyExistsException.class, () -> this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null));
    }

    @Test
    public void testArtifactNotFound() throws Exception {
        String artifactId = "testArtifactNotFound-1";
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.storage().getArtifact(GROUP_ID, artifactId));
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.storage().getArtifactMetaData(GROUP_ID, artifactId));
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.storage().getArtifactVersion(GROUP_ID, artifactId, "1"));
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.storage().getArtifactVersionMetaData(GROUP_ID, artifactId, "1"));
    }

    @Test
    public void testCreateArtifactVersion() throws Exception {
        String artifactId = "testCreateArtifactVersion-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        List versions = this.storage().getArtifactVersions(GROUP_ID, artifactId);
        Assertions.assertNotNull((Object)versions);
        Assertions.assertFalse((boolean)versions.isEmpty());
        Assertions.assertEquals((int)1, (int)versions.size());
        ContentHandle contentv2 = ContentHandle.create((String)OPENAPI_CONTENT_V2);
        ArtifactMetaDataDto dtov2 = this.storage().updateArtifact(GROUP_ID, artifactId, null, "OPENAPI", contentv2, null);
        Assertions.assertNotNull((Object)dtov2);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dtov2.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dtov2.getId());
        Assertions.assertEquals((Object)"2", (Object)dtov2.getVersion());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dtov2.getState());
        versions = this.storage().getArtifactVersions(GROUP_ID, artifactId);
        Assertions.assertNotNull((Object)versions);
        Assertions.assertFalse((boolean)versions.isEmpty());
        Assertions.assertEquals((int)2, (int)versions.size());
    }

    @Test
    public void testGetArtifactVersions() throws Exception {
        String artifactId = "testGetArtifactVersions";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        StoredArtifactDto storedArtifact = this.storage().getArtifact(GROUP_ID, artifactId);
        this.verifyArtifact(storedArtifact, OPENAPI_CONTENT, dto);
        storedArtifact = this.storage().getArtifactVersion(GROUP_ID, artifactId, "1");
        this.verifyArtifact(storedArtifact, OPENAPI_CONTENT, dto);
        storedArtifact = this.storage().getArtifactVersion(dto.getGlobalId());
        this.verifyArtifact(storedArtifact, OPENAPI_CONTENT, dto);
        ArtifactMetaDataDto dtov1 = this.storage().getArtifactMetaData(dto.getGlobalId());
        this.verifyArtifactMetadata(dtov1, dto);
        List versions = this.storage().getArtifactVersions(GROUP_ID, artifactId);
        Assertions.assertNotNull((Object)versions);
        Assertions.assertFalse((boolean)versions.isEmpty());
        Assertions.assertEquals((int)1, (int)versions.size());
        ContentHandle contentv2 = ContentHandle.create((String)OPENAPI_CONTENT_V2);
        ArtifactMetaDataDto dtov2 = this.storage().updateArtifact(GROUP_ID, artifactId, null, "OPENAPI", contentv2, null);
        Assertions.assertNotNull((Object)dtov2);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dtov2.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dtov2.getId());
        Assertions.assertEquals((Object)"2", (Object)dtov2.getVersion());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dtov2.getState());
        versions = this.storage().getArtifactVersions(GROUP_ID, artifactId);
        Assertions.assertNotNull((Object)versions);
        Assertions.assertFalse((boolean)versions.isEmpty());
        Assertions.assertEquals((int)2, (int)versions.size());
        storedArtifact = this.storage().getArtifact(GROUP_ID, artifactId);
        this.verifyArtifact(storedArtifact, OPENAPI_CONTENT_V2, dtov2);
        storedArtifact = this.storage().getArtifactVersion(GROUP_ID, artifactId, "2");
        this.verifyArtifact(storedArtifact, OPENAPI_CONTENT_V2, dtov2);
        storedArtifact = this.storage().getArtifactVersion(dtov2.getGlobalId());
        this.verifyArtifact(storedArtifact, OPENAPI_CONTENT_V2, dtov2);
        ArtifactMetaDataDto dtov2Stored = this.storage().getArtifactMetaData(dtov2.getGlobalId());
        this.verifyArtifactMetadata(dtov2Stored, dtov2);
        storedArtifact = this.storage().getArtifactVersion(GROUP_ID, artifactId, "1");
        this.verifyArtifact(storedArtifact, OPENAPI_CONTENT, dto);
        storedArtifact = this.storage().getArtifactVersion(dto.getGlobalId());
        this.verifyArtifact(storedArtifact, OPENAPI_CONTENT, dto);
        dtov1 = this.storage().getArtifactMetaData(dto.getGlobalId());
        this.verifyArtifactMetadata(dtov1, dto);
    }

    private void verifyArtifact(StoredArtifactDto storedArtifact, String content, ArtifactMetaDataDto expectedMetadata) {
        Assertions.assertNotNull((Object)storedArtifact);
        Assertions.assertEquals((Object)content, (Object)storedArtifact.getContent().content());
        Assertions.assertEquals((long)expectedMetadata.getGlobalId(), (Long)storedArtifact.getGlobalId());
        Assertions.assertEquals((Object)expectedMetadata.getVersion(), (Object)storedArtifact.getVersion());
    }

    private void verifyArtifactMetadata(ArtifactMetaDataDto actualMetadata, ArtifactMetaDataDto expectedMetadata) {
        Assertions.assertNotNull((Object)actualMetadata);
        Assertions.assertNotNull((Object)expectedMetadata);
        Assertions.assertEquals((long)expectedMetadata.getGlobalId(), (long)actualMetadata.getGlobalId());
        Assertions.assertEquals((Object)expectedMetadata.getVersion(), (Object)actualMetadata.getVersion());
    }

    @Test
    public void testCreateArtifactVersionWithMetaData() throws Exception {
        String artifactId = "testCreateArtifactVersionWithMetaData-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        List versions = this.storage().getArtifactVersions(GROUP_ID, artifactId);
        Assertions.assertNotNull((Object)versions);
        Assertions.assertFalse((boolean)versions.isEmpty());
        Assertions.assertEquals((int)1, (int)versions.size());
        ContentHandle contentv2 = ContentHandle.create((String)OPENAPI_CONTENT_V2);
        EditableArtifactMetaDataDto metaData = new EditableArtifactMetaDataDto("NAME", "DESC", Collections.singletonList("LBL"), Collections.singletonMap("K", "V"));
        ArtifactMetaDataDto dtov2 = this.storage().updateArtifactWithMetadata(GROUP_ID, artifactId, null, "OPENAPI", contentv2, metaData, null);
        Assertions.assertNotNull((Object)dtov2);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dtov2.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dtov2.getId());
        Assertions.assertEquals((Object)"2", (Object)dtov2.getVersion());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dtov2.getState());
        Assertions.assertEquals((Object)"NAME", (Object)dtov2.getName());
        Assertions.assertEquals((Object)"DESC", (Object)dtov2.getDescription());
        Assertions.assertEquals((Object)metaData.getLabels(), (Object)dtov2.getLabels());
        Assertions.assertEquals((Object)metaData.getProperties(), (Object)dtov2.getProperties());
        versions = this.storage().getArtifactVersions(GROUP_ID, artifactId);
        Assertions.assertNotNull((Object)versions);
        Assertions.assertFalse((boolean)versions.isEmpty());
        Assertions.assertEquals((int)2, (int)versions.size());
        ArtifactVersionMetaDataDto vmd = this.storage().getArtifactVersionMetaData(GROUP_ID, artifactId, "2");
        Assertions.assertNotNull((Object)vmd);
        Assertions.assertEquals((Object)"NAME", (Object)vmd.getName());
        Assertions.assertEquals((Object)"DESC", (Object)vmd.getDescription());
    }

    @Test
    public void testGetArtifactMetaDataByGlobalId() throws Exception {
        String artifactId = "testGetArtifactMetaDataByGlobalId-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        Assertions.assertEquals((Object)"Empty API", (Object)dto.getName());
        Assertions.assertEquals((Object)"An example API design using OpenAPI.", (Object)dto.getDescription());
        Assertions.assertNull((Object)dto.getLabels());
        Assertions.assertNull((Object)dto.getProperties());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dto.getState());
        Assertions.assertEquals((Object)"1", (Object)dto.getVersion());
        long globalId = dto.getGlobalId();
        dto = this.storage().getArtifactMetaData(globalId);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        Assertions.assertEquals((Object)"Empty API", (Object)dto.getName());
        Assertions.assertEquals((Object)"An example API design using OpenAPI.", (Object)dto.getDescription());
        Assertions.assertNull((Object)dto.getLabels());
        Assertions.assertNull((Object)dto.getProperties());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dto.getState());
        Assertions.assertEquals((Object)"1", (Object)dto.getVersion());
    }

    @Test
    public void testUpdateArtifactMetaData() throws Exception {
        String artifactId = "testUpdateArtifactMetaData-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        Assertions.assertEquals((Object)"Empty API", (Object)dto.getName());
        Assertions.assertEquals((Object)"An example API design using OpenAPI.", (Object)dto.getDescription());
        Assertions.assertNull((Object)dto.getLabels());
        Assertions.assertNull((Object)dto.getProperties());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dto.getState());
        Assertions.assertEquals((Object)"1", (Object)dto.getVersion());
        String newName = "Updated Name";
        String newDescription = "Updated description.";
        List<String> newLabels = Collections.singletonList("foo");
        HashMap<String, String> newProperties = new HashMap<String, String>();
        newProperties.put("foo", "bar");
        newProperties.put("ting", "bin");
        EditableArtifactMetaDataDto emd = new EditableArtifactMetaDataDto(newName, newDescription, newLabels, newProperties);
        this.storage().updateArtifactMetaData(GROUP_ID, artifactId, emd);
        ArtifactMetaDataDto metaData = this.storage().getArtifactMetaData(GROUP_ID, artifactId);
        Assertions.assertNotNull((Object)metaData);
        Assertions.assertEquals((Object)newName, (Object)metaData.getName());
        Assertions.assertEquals((Object)newDescription, (Object)metaData.getDescription());
        Assertions.assertEquals(newLabels, (Object)metaData.getLabels());
        Assertions.assertEquals(newProperties, (Object)metaData.getProperties());
    }

    @Test
    public void testUpdateArtifactState() throws Exception {
        String artifactId = "testUpdateArtifactState-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dto.getState());
        this.storage().updateArtifactState(GROUP_ID, artifactId, ArtifactState.DEPRECATED);
        ArtifactMetaDataDto metaData = this.storage().getArtifactMetaData(GROUP_ID, artifactId);
        Assertions.assertNotNull((Object)metaData);
        Assertions.assertEquals((Object)ArtifactState.DEPRECATED, (Object)metaData.getState());
    }

    @Test
    public void testUpdateArtifactVersionState() throws Exception {
        String artifactId = "testUpdateArtifactVersionState-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dto.getState());
        ContentHandle contentv2 = ContentHandle.create((String)OPENAPI_CONTENT_V2);
        ArtifactMetaDataDto dtov2 = this.storage().updateArtifact(GROUP_ID, artifactId, null, "OPENAPI", contentv2, null);
        Assertions.assertNotNull((Object)dtov2);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dtov2.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dtov2.getId());
        Assertions.assertEquals((Object)"2", (Object)dtov2.getVersion());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dtov2.getState());
        this.storage().updateArtifactState(GROUP_ID, artifactId, "1", ArtifactState.DISABLED);
        this.storage().updateArtifactState(GROUP_ID, artifactId, "2", ArtifactState.DEPRECATED);
        ArtifactVersionMetaDataDto v1 = this.storage().getArtifactVersionMetaData(GROUP_ID, artifactId, "1");
        ArtifactVersionMetaDataDto v2 = this.storage().getArtifactVersionMetaData(GROUP_ID, artifactId, "2");
        Assertions.assertNotNull((Object)v1);
        Assertions.assertNotNull((Object)v2);
        Assertions.assertEquals((Object)ArtifactState.DISABLED, (Object)v1.getState());
        Assertions.assertEquals((Object)ArtifactState.DEPRECATED, (Object)v2.getState());
    }

    @Test
    public void testUpdateArtifactVersionMetaData() throws Exception {
        String artifactId = "testUpdateArtifactVersionMetaData-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        Assertions.assertEquals((Object)"Empty API", (Object)dto.getName());
        Assertions.assertEquals((Object)"An example API design using OpenAPI.", (Object)dto.getDescription());
        Assertions.assertNull((Object)dto.getLabels());
        Assertions.assertNull((Object)dto.getProperties());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dto.getState());
        Assertions.assertEquals((Object)"1", (Object)dto.getVersion());
        String newName = "Updated Name";
        String newDescription = "Updated description.";
        List<String> newLabels = Collections.singletonList("foo");
        HashMap<String, String> newProperties = new HashMap<String, String>();
        newProperties.put("foo", "bar");
        newProperties.put("ting", "bin");
        EditableArtifactMetaDataDto emd = new EditableArtifactMetaDataDto(newName, newDescription, newLabels, newProperties);
        this.storage().updateArtifactVersionMetaData(GROUP_ID, artifactId, "1", emd);
        ArtifactVersionMetaDataDto metaData = this.storage().getArtifactVersionMetaData(GROUP_ID, artifactId, "1");
        Assertions.assertNotNull((Object)metaData);
        Assertions.assertEquals((Object)newName, (Object)metaData.getName());
        Assertions.assertEquals((Object)newDescription, (Object)metaData.getDescription());
    }

    @Test
    public void testDeleteArtifact() throws Exception {
        String artifactId = "testDeleteArtifact-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        Assertions.assertEquals((Object)"Empty API", (Object)dto.getName());
        Assertions.assertEquals((Object)"An example API design using OpenAPI.", (Object)dto.getDescription());
        Assertions.assertNull((Object)dto.getLabels());
        Assertions.assertNull((Object)dto.getProperties());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dto.getState());
        Assertions.assertEquals((Object)"1", (Object)dto.getVersion());
        this.storage().getArtifact(GROUP_ID, artifactId);
        this.storage().deleteArtifact(GROUP_ID, artifactId);
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.storage().getArtifact(GROUP_ID, artifactId));
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.storage().getArtifactMetaData(GROUP_ID, artifactId));
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.storage().getArtifactVersion(GROUP_ID, artifactId, "1"));
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.storage().getArtifactVersionMetaData(GROUP_ID, artifactId, "1"));
    }

    @Test
    public void testDeleteArtifactVersion() throws Exception {
        String artifactId = "testDeleteArtifactVersion-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dto.getState());
        Assertions.assertEquals((Object)"1", (Object)dto.getVersion());
        this.storage().deleteArtifactVersion(GROUP_ID, artifactId, "1");
        String aid1 = artifactId;
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.storage().getArtifact(GROUP_ID, aid1));
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.storage().getArtifactMetaData(GROUP_ID, aid1));
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.storage().getArtifactVersion(GROUP_ID, aid1, "1"));
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.storage().getArtifactVersionMetaData(GROUP_ID, aid1, "1"));
        artifactId = "testDeleteArtifactVersion-2";
        content = ContentHandle.create((String)OPENAPI_CONTENT);
        dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dto.getState());
        Assertions.assertEquals((Object)"1", (Object)dto.getVersion());
        ContentHandle contentv2 = ContentHandle.create((String)OPENAPI_CONTENT_V2);
        ArtifactMetaDataDto dtov2 = this.storage().updateArtifact(GROUP_ID, artifactId, null, "OPENAPI", contentv2, null);
        Assertions.assertNotNull((Object)dtov2);
        Assertions.assertEquals((Object)"2", (Object)dtov2.getVersion());
        this.storage().deleteArtifactVersion(GROUP_ID, artifactId, "1");
        String aid2 = artifactId;
        this.storage().getArtifact(GROUP_ID, aid2);
        this.storage().getArtifactMetaData(GROUP_ID, aid2);
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.storage().getArtifactVersion(GROUP_ID, aid2, "1"));
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.storage().getArtifactVersionMetaData(GROUP_ID, aid2, "1"));
        ArtifactMetaDataDto dtov3 = this.storage().updateArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dtov3);
        Assertions.assertEquals((Object)"3", (Object)dtov3.getVersion());
        this.storage().updateArtifactState(GROUP_ID, artifactId, "2", ArtifactState.DISABLED);
        this.storage().deleteArtifactVersion(GROUP_ID, artifactId, "3");
        ArtifactMetaDataDto artifactMetaData = this.storage().getArtifactMetaData(GROUP_ID, aid2, RegistryStorage.ArtifactRetrievalBehavior.DEFAULT);
        Assertions.assertNotNull((Object)artifactMetaData);
        Assertions.assertEquals((Object)"2", (Object)artifactMetaData.getVersion());
        Assertions.assertEquals((Object)aid2, (Object)artifactMetaData.getId());
        Assertions.assertEquals((Object)ArtifactState.DISABLED, (Object)artifactMetaData.getState());
        artifactId = "testDeleteArtifactVersion-3";
        content = ContentHandle.create((String)OPENAPI_CONTENT);
        dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dto.getState());
        Assertions.assertEquals((Object)"1", (Object)dto.getVersion());
        contentv2 = ContentHandle.create((String)OPENAPI_CONTENT_V2);
        dtov2 = this.storage().updateArtifact(GROUP_ID, artifactId, null, "OPENAPI", contentv2, null);
        Assertions.assertNotNull((Object)dtov2);
        String aid3 = artifactId;
        this.storage().deleteArtifactVersion(GROUP_ID, aid3, "2");
        List versions = this.storage().getArtifactVersions(GROUP_ID, aid3);
        Assertions.assertNotNull((Object)versions);
        Assertions.assertFalse((boolean)versions.isEmpty());
        Assertions.assertEquals((int)1, (int)versions.size());
        Assertions.assertEquals((Object)"1", versions.iterator().next());
        VersionSearchResultsDto result = this.storage().searchVersions(GROUP_ID, aid3, 0, 10);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((long)1L, (long)result.getCount());
        Assertions.assertEquals((Object)"1", (Object)((SearchedVersionDto)result.getVersions().iterator().next()).getVersion());
        artifactMetaData = this.storage().getArtifactMetaData(GROUP_ID, aid3);
        Assertions.assertNotNull((Object)artifactMetaData);
        Assertions.assertEquals((Object)"1", (Object)artifactMetaData.getVersion());
        Assertions.assertEquals((Object)aid3, (Object)artifactMetaData.getId());
        this.storage().getArtifact(GROUP_ID, aid3);
        ArtifactMetaDataDto metaData = this.storage().getArtifactMetaData(GROUP_ID, aid3);
        Assertions.assertNotNull((Object)metaData);
        Assertions.assertEquals((Object)"1", (Object)metaData.getVersion());
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.storage().getArtifactVersion(GROUP_ID, aid3, "2"));
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.storage().getArtifactVersionMetaData(GROUP_ID, aid3, "2"));
        this.storage().deleteArtifactVersion(GROUP_ID, aid3, "1");
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.storage().getArtifact(GROUP_ID, aid3, RegistryStorage.ArtifactRetrievalBehavior.DEFAULT));
    }

    @Test
    public void testDeleteArtifactVersionMetaData() throws Exception {
        String artifactId = "testDeleteArtifactVersionMetaData-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        Assertions.assertEquals((Object)"Empty API", (Object)dto.getName());
        Assertions.assertEquals((Object)"An example API design using OpenAPI.", (Object)dto.getDescription());
        Assertions.assertNull((Object)dto.getLabels());
        Assertions.assertNull((Object)dto.getProperties());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dto.getState());
        Assertions.assertEquals((Object)"1", (Object)dto.getVersion());
        this.storage().deleteArtifactVersionMetaData(GROUP_ID, artifactId, "1");
        ArtifactVersionMetaDataDto metaData = this.storage().getArtifactVersionMetaData(GROUP_ID, artifactId, "1");
        Assertions.assertNotNull((Object)metaData);
        Assertions.assertNull((Object)metaData.getName());
        Assertions.assertNull((Object)metaData.getDescription());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)metaData.getState());
        Assertions.assertEquals((Object)"1", (Object)metaData.getVersion());
    }

    @Test
    public void testCreateArtifactRule() throws Exception {
        String artifactId = "testCreateArtifactRule-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        List artifactRules = this.storage().getArtifactRules(GROUP_ID, artifactId);
        Assertions.assertNotNull((Object)artifactRules);
        Assertions.assertTrue((boolean)artifactRules.isEmpty());
        RuleConfigurationDto configDto = new RuleConfigurationDto("FULL");
        this.storage().createArtifactRule(GROUP_ID, artifactId, RuleType.VALIDITY, configDto);
        artifactRules = this.storage().getArtifactRules(GROUP_ID, artifactId);
        Assertions.assertNotNull((Object)artifactRules);
        Assertions.assertFalse((boolean)artifactRules.isEmpty());
        Assertions.assertEquals((int)1, (int)artifactRules.size());
        Assertions.assertEquals((Object)RuleType.VALIDITY, artifactRules.get(0));
    }

    @Test
    public void testUpdateArtifactRule() throws Exception {
        String artifactId = "testUpdateArtifactRule-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        RuleConfigurationDto configDto = new RuleConfigurationDto("FULL");
        this.storage().createArtifactRule(GROUP_ID, artifactId, RuleType.VALIDITY, configDto);
        RuleConfigurationDto rule = this.storage().getArtifactRule(GROUP_ID, artifactId, RuleType.VALIDITY);
        Assertions.assertNotNull((Object)rule);
        Assertions.assertEquals((Object)"FULL", (Object)rule.getConfiguration());
        RuleConfigurationDto updatedConfig = new RuleConfigurationDto("NONE");
        this.storage().updateArtifactRule(GROUP_ID, artifactId, RuleType.VALIDITY, updatedConfig);
        rule = this.storage().getArtifactRule(GROUP_ID, artifactId, RuleType.VALIDITY);
        Assertions.assertNotNull((Object)rule);
        Assertions.assertEquals((Object)"NONE", (Object)rule.getConfiguration());
    }

    @Test
    public void testDeleteArtifactRule() throws Exception {
        String artifactId = "testDeleteArtifactRule-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        RuleConfigurationDto configDto = new RuleConfigurationDto("FULL");
        this.storage().createArtifactRule(GROUP_ID, artifactId, RuleType.VALIDITY, configDto);
        RuleConfigurationDto rule = this.storage().getArtifactRule(GROUP_ID, artifactId, RuleType.VALIDITY);
        Assertions.assertNotNull((Object)rule);
        Assertions.assertEquals((Object)"FULL", (Object)rule.getConfiguration());
        this.storage().deleteArtifactRule(GROUP_ID, artifactId, RuleType.VALIDITY);
        Assertions.assertThrows(RuleNotFoundException.class, () -> this.storage().getArtifactRule(GROUP_ID, artifactId, RuleType.VALIDITY));
    }

    @Test
    public void testDeleteAllArtifactRules() throws Exception {
        String artifactId = "testDeleteAllArtifactRulse-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        RuleConfigurationDto configDto = new RuleConfigurationDto("FULL");
        this.storage().createArtifactRule(GROUP_ID, artifactId, RuleType.VALIDITY, configDto);
        this.storage().createArtifactRule(GROUP_ID, artifactId, RuleType.COMPATIBILITY, configDto);
        List rules = this.storage().getArtifactRules(GROUP_ID, artifactId);
        Assertions.assertEquals((int)2, (int)rules.size());
        this.storage().deleteArtifactRules(GROUP_ID, artifactId);
        Assertions.assertThrows(RuleNotFoundException.class, () -> this.storage().getArtifactRule(GROUP_ID, artifactId, RuleType.VALIDITY));
        Assertions.assertThrows(RuleNotFoundException.class, () -> this.storage().getArtifactRule(GROUP_ID, artifactId, RuleType.COMPATIBILITY));
    }

    @Test
    public void testGlobalRules() {
        List globalRules = this.storage().getGlobalRules();
        Assertions.assertNotNull((Object)globalRules);
        Assertions.assertTrue((boolean)globalRules.isEmpty());
        RuleConfigurationDto config = new RuleConfigurationDto();
        config.setConfiguration("FULL");
        this.storage().createGlobalRule(RuleType.COMPATIBILITY, config);
        RuleConfigurationDto rule = this.storage().getGlobalRule(RuleType.COMPATIBILITY);
        Assertions.assertEquals((Object)rule.getConfiguration(), (Object)config.getConfiguration());
        globalRules = this.storage().getGlobalRules();
        Assertions.assertNotNull((Object)globalRules);
        Assertions.assertFalse((boolean)globalRules.isEmpty());
        Assertions.assertEquals((int)globalRules.size(), (int)1);
        Assertions.assertEquals(globalRules.get(0), (Object)RuleType.COMPATIBILITY);
        Assertions.assertThrows(RuleAlreadyExistsException.class, () -> this.storage().createGlobalRule(RuleType.COMPATIBILITY, config));
        RuleConfigurationDto updatedConfig = new RuleConfigurationDto("FORWARD");
        this.storage().updateGlobalRule(RuleType.COMPATIBILITY, updatedConfig);
        rule = this.storage().getGlobalRule(RuleType.COMPATIBILITY);
        Assertions.assertEquals((Object)rule.getConfiguration(), (Object)updatedConfig.getConfiguration());
        Assertions.assertThrows(RuleNotFoundException.class, () -> this.storage().updateGlobalRule(RuleType.VALIDITY, config));
        this.storage().deleteGlobalRules();
        globalRules = this.storage().getGlobalRules();
        Assertions.assertNotNull((Object)globalRules);
        Assertions.assertTrue((boolean)globalRules.isEmpty());
        this.storage().createGlobalRule(RuleType.COMPATIBILITY, config);
        this.storage().deleteGlobalRule(RuleType.COMPATIBILITY);
        globalRules = this.storage().getGlobalRules();
        Assertions.assertNotNull((Object)globalRules);
        Assertions.assertTrue((boolean)globalRules.isEmpty());
    }

    @Test
    public void testSearchArtifacts() throws Exception {
        String artifactIdPrefix = "testSearchArtifacts-";
        for (int idx = 1; idx <= 50; ++idx) {
            String idxs = (idx < 10 ? "0" : "") + idx;
            String artifactId = artifactIdPrefix + idxs;
            ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
            List<CallSite> labels = Collections.singletonList("label-" + idx);
            Map<String, CallSite> properties = Collections.singletonMap("key", "value-" + idx);
            EditableArtifactMetaDataDto metaData = new EditableArtifactMetaDataDto(artifactId + "-name", artifactId + "-description", labels, properties);
            this.storage().createArtifactWithMetadata(GROUP_ID, artifactId, null, "OPENAPI", content, metaData, null);
        }
        long start = System.currentTimeMillis();
        Set<Object> filters = Collections.singleton(SearchFilter.ofName((String)"testSearchArtifacts"));
        ArtifactSearchResultsDto results = this.storage().searchArtifacts(filters, OrderBy.name, OrderDirection.asc, 0, 10);
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((long)50L, (long)results.getCount());
        Assertions.assertNotNull((Object)results.getArtifacts());
        Assertions.assertEquals((int)10, (int)results.getArtifacts().size());
        filters = Collections.singleton(SearchFilter.ofName((String)"testSearchArtifacts-19-name"));
        results = this.storage().searchArtifacts(filters, OrderBy.name, OrderDirection.asc, 0, 10);
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((long)1L, (long)results.getCount());
        Assertions.assertNotNull((Object)results.getArtifacts());
        Assertions.assertEquals((int)1, (int)results.getArtifacts().size());
        Assertions.assertEquals((Object)"testSearchArtifacts-19-name", (Object)((SearchedArtifactDto)results.getArtifacts().get(0)).getName());
        filters = Collections.singleton(SearchFilter.ofDescription((String)"testSearchArtifacts-33-description"));
        results = this.storage().searchArtifacts(filters, OrderBy.name, OrderDirection.asc, 0, 10);
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((long)1L, (long)results.getCount());
        Assertions.assertNotNull((Object)results.getArtifacts());
        Assertions.assertEquals((int)1, (int)results.getArtifacts().size());
        Assertions.assertEquals((Object)"testSearchArtifacts-33-name", (Object)((SearchedArtifactDto)results.getArtifacts().get(0)).getName());
        filters = Collections.emptySet();
        results = this.storage().searchArtifacts(filters, OrderBy.name, OrderDirection.asc, 0, 10);
        Assertions.assertNotNull((Object)results);
        Assertions.assertNotNull((Object)results.getArtifacts());
        Assertions.assertEquals((int)10, (int)results.getArtifacts().size());
        filters = Collections.singleton(SearchFilter.ofEverything((String)"testSearchArtifacts"));
        results = this.storage().searchArtifacts(filters, OrderBy.name, OrderDirection.asc, 0, 1000);
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((long)50L, (long)results.getCount());
        Assertions.assertNotNull((Object)results.getArtifacts());
        Assertions.assertEquals((int)50, (int)results.getArtifacts().size());
        Assertions.assertEquals((Object)"testSearchArtifacts-01-name", (Object)((SearchedArtifactDto)results.getArtifacts().get(0)).getName());
        Assertions.assertEquals((Object)"testSearchArtifacts-02-name", (Object)((SearchedArtifactDto)results.getArtifacts().get(1)).getName());
        filters = Collections.singleton(SearchFilter.ofLabel((String)"label-17"));
        results = this.storage().searchArtifacts(filters, OrderBy.name, OrderDirection.asc, 0, 10);
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((long)1L, (long)results.getCount());
        Assertions.assertNotNull((Object)results.getArtifacts());
        Assertions.assertEquals((int)1, (int)results.getArtifacts().size());
        Assertions.assertEquals((Object)"testSearchArtifacts-17-name", (Object)((SearchedArtifactDto)results.getArtifacts().get(0)).getName());
        filters = Collections.singleton(SearchFilter.ofEverything((String)"label-17"));
        results = this.storage().searchArtifacts(filters, OrderBy.name, OrderDirection.asc, 0, 10);
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((long)1L, (long)results.getCount());
        Assertions.assertNotNull((Object)results.getArtifacts());
        Assertions.assertEquals((int)1, (int)results.getArtifacts().size());
        Assertions.assertEquals((Object)"testSearchArtifacts-17-name", (Object)((SearchedArtifactDto)results.getArtifacts().get(0)).getName());
        long end = System.currentTimeMillis();
        System.out.println("Search time: " + (end - start) + "ms");
    }

    @Test
    public void testSearchVersions() throws Exception {
        String artifactId = "testSearchVersions-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        for (int idx = 2; idx <= 50; ++idx) {
            content = ContentHandle.create((String)OPENAPI_CONTENT_TEMPLATE.replaceAll("VERSION", "1.0." + idx));
            EditableArtifactMetaDataDto metaData = new EditableArtifactMetaDataDto(artifactId + "-name-" + idx, artifactId + "-description-" + idx, null, null);
            this.storage().updateArtifactWithMetadata(GROUP_ID, artifactId, null, "OPENAPI", content, metaData, null);
        }
        TestUtils.retry(() -> {
            VersionSearchResultsDto results = this.storage().searchVersions(GROUP_ID, artifactId, 0, 10);
            Assertions.assertNotNull((Object)results);
            Assertions.assertEquals((long)50L, (long)results.getCount());
            Assertions.assertEquals((int)10, (int)results.getVersions().size());
            results = this.storage().searchVersions(GROUP_ID, artifactId, 0, 1000);
            Assertions.assertNotNull((Object)results);
            Assertions.assertEquals((long)50L, (long)results.getCount());
            Assertions.assertEquals((int)50, (int)results.getVersions().size());
        });
    }

    private void createSomeUserData() {
        String group1 = "testGroup-1";
        String group2 = "testGroup-2";
        String artifactId1 = "testArtifact-1";
        String artifactId2 = "testArtifact-2";
        String principal = "testPrincipal";
        String role = "testRole";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto artifactDto1 = this.storage().createArtifact("testGroup-1", "testArtifact-1", null, "OPENAPI", content, null);
        this.storage().createArtifactRule("testGroup-1", "testArtifact-1", RuleType.VALIDITY, RuleConfigurationDto.builder().configuration("FULL").build());
        ArtifactMetaDataDto artifactDto2 = this.storage().createArtifactWithMetadata("testGroup-2", "testArtifact-2", null, "OPENAPI", content, EditableArtifactMetaDataDto.builder().name("test").build(), null);
        this.storage().createGlobalRule(RuleType.VALIDITY, RuleConfigurationDto.builder().configuration("FULL").build());
        this.storage().createRoleMapping("testPrincipal", "testRole", null);
        Assertions.assertNotNull((Object)this.storage().getArtifactVersion("testGroup-1", "testArtifact-1", artifactDto1.getVersion()));
        Assertions.assertEquals((int)1, (int)this.storage().getArtifactRules("testGroup-1", "testArtifact-1").size());
        Assertions.assertNotNull((Object)this.storage().getArtifactVersion("testGroup-2", "testArtifact-2", artifactDto2.getVersion()));
        Assertions.assertEquals((int)1, (int)this.storage().getGlobalRules().size());
        Assertions.assertEquals((Object)"testRole", (Object)this.storage().getRoleForPrincipal("testPrincipal"));
    }

    private int countStorageEntities() {
        AtomicInteger count = new AtomicInteger(0);
        this.storage().exportData(e -> {
            if (e.getEntityType() != EntityType.Manifest) {
                this.log.debug("Counting from export: {}", e);
                count.incrementAndGet();
            }
            return null;
        });
        int res = count.get();
        return res += this.storage().getRoleMappings().size();
    }

    @Test
    public void testDeleteAllUserData() {
        this.storage().deleteAllUserData();
        this.createSomeUserData();
        Assertions.assertEquals((int)8, (int)this.countStorageEntities());
        this.storage().deleteAllUserData();
        Assertions.assertEquals((int)0, (int)this.countStorageEntities());
    }

    @Test
    public void testMultiTenant_DeleteAllUserData() throws Exception {
        this.tenantCtx.setContext(this.tenantId1);
        this.createSomeUserData();
        Assertions.assertEquals((int)8, (int)this.countStorageEntities());
        this.tenantCtx.setContext(this.tenantId2);
        this.createSomeUserData();
        Assertions.assertEquals((int)8, (int)this.countStorageEntities());
        this.tenantCtx.setContext(this.tenantId1);
        this.storage().deleteAllUserData();
        Assertions.assertEquals((int)0, (int)this.countStorageEntities());
        this.tenantCtx.setContext(this.tenantId2);
        Assertions.assertEquals((int)8, (int)this.countStorageEntities());
        this.storage().deleteAllUserData();
        Assertions.assertEquals((int)0, (int)this.countStorageEntities());
    }

    @Test
    public void testMultiTenant_CreateArtifact() throws Exception {
        this.tenantCtx.setContext(this.tenantId1);
        String artifactId = "testMultiTenant_CreateArtifact";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        Assertions.assertEquals((Object)"Empty API", (Object)dto.getName());
        Assertions.assertEquals((Object)"An example API design using OpenAPI.", (Object)dto.getDescription());
        Assertions.assertNull((Object)dto.getLabels());
        Assertions.assertNull((Object)dto.getProperties());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dto.getState());
        Assertions.assertEquals((Object)"1", (Object)dto.getVersion());
        StoredArtifactDto storedArtifact = this.storage().getArtifact(GROUP_ID, artifactId);
        Assertions.assertNotNull((Object)storedArtifact);
        Assertions.assertEquals((Object)OPENAPI_CONTENT, (Object)storedArtifact.getContent().content());
        Assertions.assertEquals((long)dto.getGlobalId(), (Long)storedArtifact.getGlobalId());
        Assertions.assertEquals((Object)dto.getVersion(), (Object)storedArtifact.getVersion());
        ArtifactMetaDataDto amdDto = this.storage().getArtifactMetaData(GROUP_ID, artifactId);
        Assertions.assertNotNull((Object)amdDto);
        Assertions.assertEquals((long)dto.getGlobalId(), (long)amdDto.getGlobalId());
        Assertions.assertEquals((Object)"Empty API", (Object)amdDto.getName());
        Assertions.assertEquals((Object)"An example API design using OpenAPI.", (Object)amdDto.getDescription());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)amdDto.getState());
        Assertions.assertEquals((Object)"1", (Object)amdDto.getVersion());
        Assertions.assertNull((Object)amdDto.getLabels());
        Assertions.assertNull((Object)amdDto.getProperties());
        this.tenantCtx.setContext(this.tenantId2);
        try {
            this.storage().getArtifact(GROUP_ID, artifactId);
            Assertions.fail((String)"Expected 404 not found for TENANT-2");
        }
        catch (ArtifactNotFoundException artifactNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testMultiTenant_CreateSameArtifact() throws Exception {
        this.tenantCtx.setContext(this.tenantId1);
        String artifactId = "testMultiTenant_CreateSameArtifact";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        Assertions.assertEquals((Object)"Empty API", (Object)dto.getName());
        Assertions.assertEquals((Object)"An example API design using OpenAPI.", (Object)dto.getDescription());
        Assertions.assertNull((Object)dto.getLabels());
        Assertions.assertNull((Object)dto.getProperties());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dto.getState());
        Assertions.assertEquals((Object)"1", (Object)dto.getVersion());
        this.tenantCtx.setContext(this.tenantId2);
        content = ContentHandle.create((String)OPENAPI_CONTENT);
        dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        Assertions.assertEquals((Object)"Empty API", (Object)dto.getName());
        Assertions.assertEquals((Object)"An example API design using OpenAPI.", (Object)dto.getDescription());
        Assertions.assertNull((Object)dto.getLabels());
        Assertions.assertNull((Object)dto.getProperties());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)dto.getState());
        Assertions.assertEquals((Object)"1", (Object)dto.getVersion());
    }

    @Test
    public void testMultiTenant_Search() throws Exception {
        this.tenantCtx.setContext(this.tenantId1);
        String artifactIdPrefix = "testMultiTenant_Search-";
        for (int idx = 1; idx <= 10; ++idx) {
            String artifactId = artifactIdPrefix + idx;
            ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
            List<String> labels = Collections.singletonList("testMultiTenant_Search");
            Map properties = Collections.emptyMap();
            EditableArtifactMetaDataDto metaData = new EditableArtifactMetaDataDto(artifactId + "-name", artifactId + "-description", labels, properties);
            this.storage().createArtifactWithMetadata(GROUP_ID, artifactId, null, "OPENAPI", content, metaData, null);
        }
        this.tenantCtx.setContext(this.tenantId2);
        Set<SearchFilter> filters = Collections.singleton(SearchFilter.ofLabel((String)"testMultiTenant_Search"));
        ArtifactSearchResultsDto searchResults = this.storage().searchArtifacts(filters, OrderBy.name, OrderDirection.asc, 0, 100);
        Assertions.assertNotNull((Object)searchResults);
        Assertions.assertEquals((long)0L, (long)searchResults.getCount());
        Assertions.assertTrue((boolean)searchResults.getArtifacts().isEmpty());
        this.tenantCtx.setContext(this.tenantId1);
        searchResults = this.storage().searchArtifacts(filters, OrderBy.name, OrderDirection.asc, 0, 100);
        Assertions.assertNotNull((Object)searchResults);
        Assertions.assertEquals((long)10L, (long)searchResults.getCount());
        Assertions.assertEquals((int)10, (int)searchResults.getArtifacts().size());
    }

    @Test
    public void testMultiTenant_GlobalRules() {
        this.tenantCtx.setContext(this.tenantId1);
        List globalRules = this.storage().getGlobalRules();
        Assertions.assertNotNull((Object)globalRules);
        Assertions.assertTrue((boolean)globalRules.isEmpty());
        RuleConfigurationDto config = new RuleConfigurationDto();
        config.setConfiguration("FULL");
        this.storage().createGlobalRule(RuleType.COMPATIBILITY, config);
        try {
            this.storage().createGlobalRule(RuleType.COMPATIBILITY, config);
            Assertions.fail((String)("Expected a RuleAlreadyExistsException for " + RuleType.COMPATIBILITY));
        }
        catch (RuleAlreadyExistsException ruleAlreadyExistsException) {
            // empty catch block
        }
        RuleConfigurationDto rule = this.storage().getGlobalRule(RuleType.COMPATIBILITY);
        Assertions.assertEquals((Object)rule.getConfiguration(), (Object)config.getConfiguration());
        globalRules = this.storage().getGlobalRules();
        Assertions.assertNotNull((Object)globalRules);
        Assertions.assertFalse((boolean)globalRules.isEmpty());
        Assertions.assertEquals((int)globalRules.size(), (int)1);
        Assertions.assertEquals(globalRules.get(0), (Object)RuleType.COMPATIBILITY);
        this.tenantCtx.setContext(this.tenantId2);
        globalRules = this.storage().getGlobalRules();
        Assertions.assertNotNull((Object)globalRules);
        Assertions.assertTrue((boolean)globalRules.isEmpty());
        config = new RuleConfigurationDto();
        config.setConfiguration("FULL");
        this.storage().createGlobalRule(RuleType.COMPATIBILITY, config);
        try {
            this.storage().createGlobalRule(RuleType.COMPATIBILITY, config);
            Assertions.fail((String)("Expected a RuleAlreadyExistsException for " + RuleType.COMPATIBILITY));
        }
        catch (RuleAlreadyExistsException ruleAlreadyExistsException) {
            // empty catch block
        }
        rule = this.storage().getGlobalRule(RuleType.COMPATIBILITY);
        Assertions.assertEquals((Object)rule.getConfiguration(), (Object)config.getConfiguration());
        globalRules = this.storage().getGlobalRules();
        Assertions.assertNotNull((Object)globalRules);
        Assertions.assertFalse((boolean)globalRules.isEmpty());
        Assertions.assertEquals((int)globalRules.size(), (int)1);
        Assertions.assertEquals(globalRules.get(0), (Object)RuleType.COMPATIBILITY);
    }

    @Test
    public void testMultiTenant_ArtifactNotFound() throws Exception {
        this.tenantCtx.setContext(this.tenantId1);
        this.testArtifactNotFound();
        this.tenantCtx.setContext(this.tenantId2);
        this.testArtifactNotFound();
    }

    @Test
    public void testMultiTenant_CreateArtifactRule() throws Exception {
        this.tenantCtx.setContext(this.tenantId1);
        this.testCreateArtifactRule();
        this.tenantCtx.setContext(this.tenantId2);
        this.testCreateArtifactRule();
    }

    @Test
    public void testMultiTenant_CreateArtifactVersionWithMetaData() throws Exception {
        this.tenantCtx.setContext(this.tenantId1);
        this.testCreateArtifactVersionWithMetaData();
        this.tenantCtx.setContext(this.tenantId2);
        this.testCreateArtifactVersionWithMetaData();
    }

    @Test
    public void testMultiTenant_CreateDuplicateArtifact() throws Exception {
        this.tenantCtx.setContext(this.tenantId1);
        this.testCreateDuplicateArtifact();
        this.tenantCtx.setContext(this.tenantId2);
        this.testCreateDuplicateArtifact();
    }

    @Test
    public void testMultiTenant_UpdateArtifactMetaData() throws Exception {
        this.tenantCtx.setContext(this.tenantId1);
        this.testUpdateArtifactMetaData();
        this.tenantCtx.setContext(this.tenantId2);
        this.testUpdateArtifactMetaData();
    }

    @Test
    public void testMultiTenant_UpdateArtifactRule() throws Exception {
        this.tenantCtx.setContext(this.tenantId1);
        this.testUpdateArtifactRule();
        this.tenantCtx.setContext(this.tenantId2);
        this.testUpdateArtifactRule();
    }

    @Test
    public void testMultiTenant_UpdateArtifactState() throws Exception {
        this.tenantCtx.setContext(this.tenantId1);
        this.testUpdateArtifactState();
        this.tenantCtx.setContext(this.tenantId2);
        this.testUpdateArtifactState();
    }

    @Test
    public void testMultiTenant_UpdateArtifactVersionMetaData() throws Exception {
        this.tenantCtx.setContext(this.tenantId1);
        this.testUpdateArtifactVersionMetaData();
        this.tenantCtx.setContext(this.tenantId2);
        this.testUpdateArtifactVersionMetaData();
    }

    @Test
    public void testMultiTenant_UpdateArtifactVersionState() throws Exception {
        this.tenantCtx.setContext(this.tenantId1);
        this.testUpdateArtifactVersionState();
        this.tenantCtx.setContext(this.tenantId2);
        this.testUpdateArtifactVersionState();
    }

    @Test
    public void testConfigProperties() throws Exception {
        List properties = this.storage().getConfigProperties();
        Assertions.assertNotNull((Object)properties);
        Assertions.assertTrue((boolean)properties.isEmpty());
        this.storage().setConfigProperty(new DynamicConfigPropertyDto("registry.test.property-string", "test-value"));
        this.storage().setConfigProperty(new DynamicConfigPropertyDto("registry.test.property-boolean", "true"));
        this.storage().setConfigProperty(new DynamicConfigPropertyDto("registry.test.property-long", "12345"));
        properties = this.storage().getConfigProperties();
        Assertions.assertNotNull((Object)properties);
        Assertions.assertFalse((boolean)properties.isEmpty());
        Assertions.assertEquals((int)3, (int)properties.size());
        DynamicConfigPropertyDto stringProp = this.getProperty(properties, "registry.test.property-string");
        DynamicConfigPropertyDto boolProp = this.getProperty(properties, "registry.test.property-boolean");
        DynamicConfigPropertyDto longProp = this.getProperty(properties, "registry.test.property-long");
        Assertions.assertNotNull((Object)stringProp);
        Assertions.assertNotNull((Object)boolProp);
        Assertions.assertNotNull((Object)longProp);
        Assertions.assertEquals((Object)"test-value", (Object)stringProp.getValue());
        Assertions.assertEquals((Object)"true", (Object)boolProp.getValue());
        Assertions.assertEquals((Object)"12345", (Object)longProp.getValue());
    }

    private DynamicConfigPropertyDto getProperty(List<DynamicConfigPropertyDto> properties, String propertyName) {
        for (DynamicConfigPropertyDto prop : properties) {
            if (!prop.getName().equals(propertyName)) continue;
            return prop;
        }
        return null;
    }

    @Test
    public void testMultiTenant_ConfigProperties() throws Exception {
        this.tenantCtx.setContext(this.tenantId1);
        this.testConfigProperties();
        this.tenantCtx.setContext(this.tenantId2);
        this.testConfigProperties();
    }

    @Test
    public void testComments() throws Exception {
        String artifactId = "testComments-1";
        ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT);
        ArtifactMetaDataDto dto = this.storage().createArtifact(GROUP_ID, artifactId, null, "OPENAPI", content, null);
        Assertions.assertNotNull((Object)dto);
        Assertions.assertEquals((Object)GROUP_ID, (Object)dto.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)dto.getId());
        List comments = this.storage().getArtifactVersionComments(GROUP_ID, artifactId, "latest");
        Assertions.assertTrue((boolean)comments.isEmpty());
        this.storage().createArtifactVersionComment(GROUP_ID, artifactId, "latest", "TEST_COMMENT_1");
        this.storage().createArtifactVersionComment(GROUP_ID, artifactId, "latest", "TEST_COMMENT_2");
        this.storage().createArtifactVersionComment(GROUP_ID, artifactId, "latest", "TEST_COMMENT_3");
        comments = this.storage().getArtifactVersionComments(GROUP_ID, artifactId, "latest");
        Assertions.assertEquals((int)3, (int)comments.size());
        this.storage().deleteArtifactVersionComment(GROUP_ID, artifactId, "latest", ((CommentDto)comments.get(1)).getCommentId());
        comments = this.storage().getArtifactVersionComments(GROUP_ID, artifactId, "latest");
        Assertions.assertEquals((int)2, (int)comments.size());
        this.storage().updateArtifactVersionComment(GROUP_ID, artifactId, "latest", ((CommentDto)comments.get(0)).getCommentId(), "TEST_COMMENT_4");
        comments = this.storage().getArtifactVersionComments(GROUP_ID, artifactId, "latest");
        Assertions.assertEquals((int)2, (int)comments.size());
        Assertions.assertEquals((Object)"TEST_COMMENT_4", (Object)((CommentDto)comments.get(0)).getValue());
    }

    private static String generateString(int size) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            builder.append("a");
        }
        Assertions.assertEquals((int)size, (int)builder.toString().length());
        return builder.toString();
    }
}

