/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.storage;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.StoredArtifactDto;
import io.apicurio.registry.types.Current;
import io.quarkus.test.junit.QuarkusTest;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class RegistryStoragePerformanceTest {
    private static final String GROUP_ID = RegistryStoragePerformanceTest.class.getSimpleName();
    private static final int NUM_ARTIFACTS = 50000;
    private static final String OPENAPI_CONTENT_TEMPLATE = "{    \"openapi\": \"3.0.2\",    \"info\": {        \"title\": \"TITLE\",        \"version\": \"VERSION\",        \"description\": \"DESCRIPTION\"    }}";
    @Inject
    @Current
    RegistryStorage storage;

    protected RegistryStorage getStorage() {
        return this.storage;
    }

    private boolean isTestEnabled() {
        return "enabled".equals(System.getProperty(RegistryStoragePerformanceTest.class.getSimpleName()));
    }

    @Test
    public void testStoragePerformance() throws Exception {
        if (!this.isTestEnabled()) {
            return;
        }
        System.out.println("========================================================================");
        System.out.println("= Running artifactStore performance test.  Please wait...                    =");
        System.out.println("========================================================================");
        String artifactIdPrefix = "testStoragePerformance-";
        long startCreate = System.currentTimeMillis();
        for (int idx = 1; idx <= 50000; ++idx) {
            String artifactId = artifactIdPrefix + idx;
            String title = "API " + artifactId;
            String description = "Number " + idx + " all time on the top APIs list.";
            ArrayList<Object> labels = new ArrayList<Object>();
            labels.add("the-label");
            labels.add("label-" + idx);
            HashMap<Object, Object> properties = new HashMap<Object, Object>();
            properties.put("key", "value");
            properties.put("key-" + idx, "value-" + idx);
            ContentHandle content = ContentHandle.create((String)OPENAPI_CONTENT_TEMPLATE.replaceAll("TITLE", title).replaceAll("DESCRIPTION", description).replaceAll("VERSION", String.valueOf(idx)));
            EditableArtifactMetaDataDto metaData = new EditableArtifactMetaDataDto(title, description, labels, properties);
            this.storage.createArtifactWithMetadata(GROUP_ID, artifactId, null, "OPENAPI", content, metaData, null);
            System.out.print(".");
            if (idx % 100 != 0) continue;
            System.out.println(" " + idx);
        }
        long endCreate = System.currentTimeMillis();
        long startGetArtifact = System.currentTimeMillis();
        StoredArtifactDto storedArtifact = this.storage.getArtifact(GROUP_ID, artifactIdPrefix + "77");
        long endGetArtifact = System.currentTimeMillis();
        Assertions.assertNotNull((Object)storedArtifact);
        long startGetArtifactMetaData = System.currentTimeMillis();
        ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(GROUP_ID, artifactIdPrefix + "998");
        long endGetArtifactMetaData = System.currentTimeMillis();
        Assertions.assertNotNull((Object)dto);
        long startAllSearch = System.currentTimeMillis();
        Set<Object> filters = Collections.emptySet();
        ArtifactSearchResultsDto results = this.storage.searchArtifacts(filters, OrderBy.name, OrderDirection.asc, 0, 20);
        long endAllSearch = System.currentTimeMillis();
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((long)50000L, (long)results.getCount());
        long startNameSearch = System.currentTimeMillis();
        filters = Collections.singleton(SearchFilter.ofName((String)"testStoragePerformance-9999"));
        results = this.storage.searchArtifacts(filters, OrderBy.name, OrderDirection.asc, 0, 10);
        long endNameSearch = System.currentTimeMillis();
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((long)1L, (long)results.getCount());
        long startAllNameSearch = System.currentTimeMillis();
        filters = Collections.singleton(SearchFilter.ofName((String)"testStoragePerformance"));
        results = this.storage.searchArtifacts(filters, OrderBy.name, OrderDirection.asc, 0, 10);
        long endAllNameSearch = System.currentTimeMillis();
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((long)50000L, (long)results.getCount());
        long startLabelSearch = System.currentTimeMillis();
        filters = Collections.singleton(SearchFilter.ofLabel((String)"label-49999"));
        results = this.storage.searchArtifacts(filters, OrderBy.name, OrderDirection.asc, 0, 10);
        long endLabelSearch = System.currentTimeMillis();
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((long)1L, (long)results.getCount());
        long startAllLabelSearch = System.currentTimeMillis();
        filters = Collections.singleton(SearchFilter.ofLabel((String)"the-label"));
        results = this.storage.searchArtifacts(filters, OrderBy.name, OrderDirection.asc, 0, 10);
        long endAllLabelSearch = System.currentTimeMillis();
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((long)50000L, (long)results.getCount());
        long startEverythingSearch = System.currentTimeMillis();
        filters = Collections.singleton(SearchFilter.ofEverything((String)"test"));
        results = this.storage.searchArtifacts(filters, OrderBy.name, OrderDirection.asc, 0, 10);
        long endEverythingSearch = System.currentTimeMillis();
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((long)50000L, (long)results.getCount());
        System.out.println("========================================================================");
        System.out.println("= Storage Performance Results                                          =");
        System.out.println("=----------------------------------------------------------------------=");
        System.out.println("| Time to create 50000 artifacts: " + (endCreate - startCreate) + "ms");
        System.out.println("| ");
        System.out.println("| Get Artifact Content:   " + (endGetArtifact - startGetArtifact) + "ms");
        System.out.println("| Get Artifact Meta-Data: " + (endGetArtifactMetaData - startGetArtifactMetaData) + "ms");
        System.out.println("| ");
        System.out.println("| All Artifact Search:    " + (endAllSearch - startAllSearch) + "ms");
        System.out.println("| Single Name Search:     " + (endNameSearch - startNameSearch) + "ms");
        System.out.println("| All Name Search:        " + (endAllNameSearch - startAllNameSearch) + "ms");
        System.out.println("| Label Search:           " + (endLabelSearch - startLabelSearch) + "ms");
        System.out.println("| All Label Search:       " + (endAllLabelSearch - startAllLabelSearch) + "ms");
        System.out.println("| Everything Search:      " + (endEverythingSearch - startEverythingSearch) + "ms");
        System.out.println("========================================================================");
    }
}

