/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.storage;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.StoredArtifactDto;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import jakarta.inject.Inject;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class RegistryStorageSmokeTest
extends AbstractResourceTestBase {
    private static final String GROUP_ID = RegistryStorageSmokeTest.class.getSimpleName();
    static final String ARTIFACT_ID_1 = "artifactId1";
    static final String ARTIFACT_ID_2 = "artifactId2";
    static final String ARTIFACT_ID_3 = "artifactId3";
    @Inject
    @Current
    RegistryStorage storage;

    protected RegistryStorage getStorage() {
        return this.storage;
    }

    private void delete(String artifactId, boolean rule) {
        try {
            if (rule) {
                this.getStorage().deleteArtifactRules(GROUP_ID, artifactId);
            } else {
                this.getStorage().deleteArtifact(GROUP_ID, artifactId);
            }
        }
        catch (ArtifactNotFoundException artifactNotFoundException) {
            // empty catch block
        }
    }

    @Override
    @BeforeEach
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.getStorage().deleteGlobalRules();
        this.delete(ARTIFACT_ID_1, false);
        this.delete(ARTIFACT_ID_2, false);
        this.delete(ARTIFACT_ID_3, false);
        this.delete(ARTIFACT_ID_1, true);
        this.delete(ARTIFACT_ID_2, true);
        this.delete(ARTIFACT_ID_3, true);
    }

    @Test
    public void testArtifactsAndMeta() throws Exception {
        String artifactId1 = TestUtils.generateArtifactId();
        this.createArtifact(artifactId1, "JSON", "{}");
        int size = this.getStorage().getArtifactIds(null).size();
        ArtifactMetaDataDto meta1 = this.getStorage().createArtifact(GROUP_ID, ARTIFACT_ID_1, null, "JSON", ContentHandle.create((String)"content1"), null);
        this.waitForArtifact(GROUP_ID, ARTIFACT_ID_1);
        ArtifactMetaDataDto meta2 = this.getStorage().updateArtifact(GROUP_ID, ARTIFACT_ID_1, null, "JSON", ContentHandle.create((String)"content2"), null);
        this.waitForGlobalId(meta2.getGlobalId());
        this.getStorage().createArtifact(GROUP_ID, ARTIFACT_ID_2, null, "AVRO", ContentHandle.create((String)"content3"), null);
        this.waitForArtifact(GROUP_ID, ARTIFACT_ID_2);
        Assertions.assertEquals((int)(size + 2), (int)this.getStorage().getArtifactIds(null).size());
        Assertions.assertTrue((boolean)this.getStorage().getArtifactIds(null).contains(ARTIFACT_ID_1));
        StoredArtifactDto a1 = this.getStorage().getArtifact(GROUP_ID, ARTIFACT_ID_1);
        Assertions.assertNotNull((Object)a1);
        Assertions.assertNotNull((Object)a1.getGlobalId());
        Assertions.assertNotNull((Object)a1.getVersion());
        Assertions.assertNotNull((Object)a1.getContent());
        ArtifactMetaDataDto metaLatest = this.getStorage().getArtifactMetaData(GROUP_ID, ARTIFACT_ID_1);
        Assertions.assertEquals((Object)meta2, (Object)metaLatest);
        List versions = this.getStorage().getArtifactVersions(GROUP_ID, ARTIFACT_ID_1);
        Assertions.assertEquals((int)2, (int)versions.size());
        Assertions.assertTrue((boolean)versions.contains(a1.getVersion()));
        Assertions.assertEquals((Object)a1, (Object)this.getStorage().getArtifact(GROUP_ID, ARTIFACT_ID_1));
        this.getStorage().updateArtifactVersionMetaData(GROUP_ID, ARTIFACT_ID_1, meta1.getVersion(), EditableArtifactMetaDataDto.builder().name("foo").build());
        TestUtils.retry(() -> {
            ArtifactVersionMetaDataDto vmeta1 = this.getStorage().getArtifactVersionMetaData(GROUP_ID, ARTIFACT_ID_1, meta1.getVersion());
            ArtifactVersionMetaDataDto vmeta2 = this.getStorage().getArtifactVersionMetaData(GROUP_ID, ARTIFACT_ID_1, meta2.getVersion());
            Assertions.assertNotEquals((Object)vmeta1, (Object)vmeta2);
            Assertions.assertEquals((Object)"foo", (Object)vmeta1.getName());
            Assertions.assertNull((Object)vmeta2.getName());
            return null;
        });
        List deleted = this.getStorage().deleteArtifact(GROUP_ID, ARTIFACT_ID_1);
        Assertions.assertEquals((int)2, (int)deleted.size());
        Assertions.assertTrue((boolean)deleted.contains(a1.getVersion()));
        TestUtils.retry(() -> {
            try {
                this.getStorage().getArtifactMetaData(GROUP_ID, ARTIFACT_ID_1);
                Assertions.fail();
            }
            catch (ArtifactNotFoundException artifactNotFoundException) {
                // empty catch block
            }
            List set = this.getStorage().deleteArtifact(GROUP_ID, ARTIFACT_ID_2);
            Assertions.assertEquals((int)1, (int)set.size());
            return set;
        });
    }

    @Test
    public void testRules() throws Exception {
        this.getStorage().createArtifact(GROUP_ID, ARTIFACT_ID_3, null, "JSON", ContentHandle.create((String)"content1"), null);
        this.waitForArtifact(GROUP_ID, ARTIFACT_ID_3);
        Assertions.assertEquals((int)0, (int)this.getStorage().getArtifactRules(GROUP_ID, ARTIFACT_ID_3).size());
        Assertions.assertEquals((int)0, (int)this.getStorage().getGlobalRules().size());
        this.getStorage().createArtifactRule(GROUP_ID, ARTIFACT_ID_3, RuleType.VALIDITY, RuleConfigurationDto.builder().configuration("config").build());
        this.getStorage().createGlobalRule(RuleType.VALIDITY, RuleConfigurationDto.builder().configuration("config").build());
        TestUtils.retry(() -> {
            Assertions.assertEquals((int)1, (int)this.getStorage().getArtifactRules(GROUP_ID, ARTIFACT_ID_3).size());
            Assertions.assertTrue((boolean)this.getStorage().getArtifactRules(GROUP_ID, ARTIFACT_ID_3).contains(RuleType.VALIDITY));
            Assertions.assertEquals((Object)"config", (Object)this.getStorage().getArtifactRule(GROUP_ID, ARTIFACT_ID_3, RuleType.VALIDITY).getConfiguration());
            Assertions.assertEquals((int)1, (int)this.getStorage().getGlobalRules().size());
            Assertions.assertTrue((boolean)this.getStorage().getGlobalRules().contains(RuleType.VALIDITY));
            return null;
        });
        this.getStorage().deleteArtifact(GROUP_ID, ARTIFACT_ID_3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLimitGetArtifactIds() throws Exception {
        String testId0 = TestUtils.generateArtifactId();
        String testId1 = TestUtils.generateArtifactId();
        String testId2 = TestUtils.generateArtifactId();
        try {
            this.getStorage().createArtifact(GROUP_ID, testId0, null, "JSON", ContentHandle.create((String)"{}"), null);
            this.waitForArtifact(GROUP_ID, testId0);
            int size = this.getStorage().getArtifactIds(null).size();
            this.getStorage().createArtifact(GROUP_ID, testId1, null, "JSON", ContentHandle.create((String)"{}"), null);
            this.getStorage().createArtifact(GROUP_ID, testId2, null, "JSON", ContentHandle.create((String)"{}"), null);
            this.waitForArtifact(GROUP_ID, testId1);
            this.waitForArtifact(GROUP_ID, testId2);
            int newSize = this.getStorage().getArtifactIds(null).size();
            int limitedSize = this.getStorage().getArtifactIds(Integer.valueOf(1)).size();
            Assertions.assertEquals((int)(size + 2), (int)newSize);
            Assertions.assertEquals((int)1, (int)limitedSize);
        }
        finally {
            this.getStorage().deleteArtifact(GROUP_ID, testId1);
            this.getStorage().deleteArtifact(GROUP_ID, testId2);
        }
    }
}

