/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.validity;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.client.exception.RuleViolationException;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.IoUtil;
import io.quarkus.test.junit.QuarkusTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class ValidityRuleApplicationTest
extends AbstractResourceTestBase {
    private static final String SCHEMA_SIMPLE = "{\"type\": \"string\"}";
    private static final String INVALID_SCHEMA = "{\"type\": \"string";
    private static final String SCHEMA_WITH_MAP = "{\r\n    \"type\": \"record\",\r\n    \"name\": \"userInfo\",\r\n    \"namespace\": \"my.example\",\r\n    \"fields\": [\r\n        {\r\n            \"name\": \"name\",\r\n            \"type\": \"string\",\r\n            \"default\": \"NONE\"\r\n        },\r\n        {\r\n            \"name\": \"props\",\r\n            \"type\": {\r\n                \"type\": \"map\",\r\n                \"values\": \"string\"\r\n            }\r\n        }\r\n    ]\r\n}";
    private static final String INVALID_SCHEMA_WITH_MAP = "{\r\n    \"type\": \"record\",\r\n    \"name\": \"userInfo\",\r\n    \"namespace\": \"my.example\",\r\n    \"fields\": [\r\n        {\r\n            \"name\": \"name\",\r\n            \"type\": \"string\",\r\n            \"default\": \"NONE\"\r\n        },\r\n        {\r\n            \"name\": \"props\",\r\n            \"type\": {\r\n                \"type\": \"map\",\r\n                \"values\": \"string\"\r\n            },\r\n            \"default\": \"{}\"\r\n        }\r\n    ]\r\n}";

    @Test
    public void testValidityRuleApplication() throws Exception {
        String artifactId = "ValidityRuleApplicationTest";
        this.createArtifact(artifactId, "AVRO", SCHEMA_SIMPLE);
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig(ValidityLevel.FULL.name());
        this.clientV2.createArtifactRule("default", artifactId, rule);
        Assertions.assertThrows(RuleViolationException.class, () -> this.clientV2.updateArtifact("default", artifactId, IoUtil.toStream((String)INVALID_SCHEMA)));
    }

    @Test
    public void testValidityRuleApplication_Map() throws Exception {
        String artifactId = "testValidityRuleApplication_Map";
        this.createArtifact(artifactId, "AVRO", SCHEMA_WITH_MAP);
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig(ValidityLevel.FULL.name());
        this.clientV2.createArtifactRule("default", artifactId, rule);
        Assertions.assertThrows(RuleViolationException.class, () -> this.clientV2.updateArtifact("default", artifactId, IoUtil.toStream((String)INVALID_SCHEMA_WITH_MAP)));
    }
}

