/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rbac;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.client.exception.RoleMappingAlreadyExistsException;
import io.apicurio.registry.rest.client.exception.RoleMappingNotFoundException;
import io.apicurio.registry.rest.v2.beans.LogConfiguration;
import io.apicurio.registry.rest.v2.beans.NamedLogConfiguration;
import io.apicurio.registry.rest.v2.beans.RoleMapping;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.types.LogLevel;
import io.apicurio.registry.types.RoleType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.ApplicationRbacEnabledProfile;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=ApplicationRbacEnabledProfile.class)
@Tag(value="slow")
public class AdminClientTest
extends AbstractResourceTestBase {
    @Test
    public void smokeGlobalRules() throws Exception {
        this.createGlobalRule(RuleType.COMPATIBILITY, "BACKWARD");
        this.createGlobalRule(RuleType.VALIDITY, "FORWARD");
        TestUtils.retry(() -> {
            List globalRules = this.adminClientV2.listGlobalRules();
            Assertions.assertEquals((int)2, (int)globalRules.size());
            Assertions.assertTrue((boolean)globalRules.contains(RuleType.COMPATIBILITY));
            Assertions.assertTrue((boolean)globalRules.contains(RuleType.VALIDITY));
        });
        this.adminClientV2.deleteAllGlobalRules();
        TestUtils.retry(() -> {
            List updatedRules = this.adminClientV2.listGlobalRules();
            Assertions.assertEquals((int)0, (int)updatedRules.size());
        });
    }

    @Test
    public void getGlobalRuleConfig() throws Exception {
        this.createGlobalRule(RuleType.COMPATIBILITY, "BACKWARD");
        TestUtils.retry(() -> {
            Rule globalRuleConfig = this.adminClientV2.getGlobalRuleConfig(RuleType.COMPATIBILITY);
            Assertions.assertEquals((Object)globalRuleConfig.getConfig(), (Object)"BACKWARD");
        });
    }

    @Test
    public void updateGlobalRuleConfig() throws Exception {
        this.createGlobalRule(RuleType.COMPATIBILITY, "BACKWARD");
        TestUtils.retry(() -> {
            Rule globalRuleConfig = this.adminClientV2.getGlobalRuleConfig(RuleType.COMPATIBILITY);
            Assertions.assertEquals((Object)globalRuleConfig.getConfig(), (Object)"BACKWARD");
        });
        Rule toUpdate = new Rule();
        toUpdate.setType(RuleType.COMPATIBILITY);
        toUpdate.setConfig("FORWARD");
        Rule updated = this.adminClientV2.updateGlobalRuleConfig(RuleType.COMPATIBILITY, toUpdate);
        Assertions.assertEquals((Object)updated.getConfig(), (Object)"FORWARD");
    }

    @Test
    public void deleteGlobalRule() throws Exception {
        this.createGlobalRule(RuleType.COMPATIBILITY, "BACKWARD");
        TestUtils.retry(() -> {
            Rule globalRuleConfig = this.adminClientV2.getGlobalRuleConfig(RuleType.COMPATIBILITY);
            Assertions.assertEquals((Object)globalRuleConfig.getConfig(), (Object)"BACKWARD");
        });
        this.adminClientV2.deleteGlobalRule(RuleType.COMPATIBILITY);
        TestUtils.retry(() -> {
            List ruleTypes = this.adminClientV2.listGlobalRules();
            Assertions.assertEquals((int)0, (int)ruleTypes.size());
        });
    }

    @Test
    public void smokeLogLevels() {
        String logger = "smokeLogLevels";
        List namedLogConfigurations = this.adminClientV2.listLogConfigurations();
        Assertions.assertEquals((int)0, (int)namedLogConfigurations.size());
        this.setLogLevel("smokeLogLevels", LogLevel.DEBUG);
        NamedLogConfiguration logConfiguration = this.adminClientV2.getLogConfiguration("smokeLogLevels");
        Assertions.assertEquals((Object)LogLevel.DEBUG, (Object)logConfiguration.getLevel());
        Assertions.assertEquals((Object)"smokeLogLevels", (Object)logConfiguration.getName());
        List logConfigurations = this.adminClientV2.listLogConfigurations();
        Assertions.assertEquals((int)1, (int)logConfigurations.size());
        this.adminClientV2.removeLogConfiguration("smokeLogLevels");
    }

    @Test
    public void testRoleMappings() throws Exception {
        List roleMappings = this.adminClientV2.listRoleMappings();
        Assertions.assertTrue((boolean)roleMappings.isEmpty());
        RoleMapping mapping = new RoleMapping();
        mapping.setPrincipalId("TestUser");
        mapping.setRole(RoleType.DEVELOPER);
        this.adminClientV2.createRoleMapping(mapping);
        TestUtils.retry(() -> {
            RoleMapping roleMapping = this.adminClientV2.getRoleMapping("TestUser");
            Assertions.assertEquals((Object)"TestUser", (Object)roleMapping.getPrincipalId());
            Assertions.assertEquals((Object)RoleType.DEVELOPER, (Object)roleMapping.getRole());
        });
        TestUtils.retry(() -> {
            List mappings = this.adminClientV2.listRoleMappings();
            Assertions.assertEquals((int)1, (int)mappings.size());
            Assertions.assertEquals((Object)"TestUser", (Object)((RoleMapping)mappings.get(0)).getPrincipalId());
            Assertions.assertEquals((Object)RoleType.DEVELOPER, (Object)((RoleMapping)mappings.get(0)).getRole());
        });
        TestUtils.retry(() -> Assertions.assertThrows(RoleMappingAlreadyExistsException.class, () -> this.adminClientV2.createRoleMapping(mapping)));
        mapping.setPrincipalId("TestUser2");
        mapping.setRole(RoleType.ADMIN);
        this.adminClientV2.createRoleMapping(mapping);
        TestUtils.retry(() -> {
            List mappings = this.adminClientV2.listRoleMappings();
            Assertions.assertEquals((int)2, (int)mappings.size());
        });
        RoleMapping tu2Mapping = this.adminClientV2.getRoleMapping("TestUser2");
        Assertions.assertEquals((Object)"TestUser2", (Object)tu2Mapping.getPrincipalId());
        Assertions.assertEquals((Object)RoleType.ADMIN, (Object)tu2Mapping.getRole());
        this.adminClientV2.updateRoleMapping("TestUser", RoleType.READ_ONLY);
        TestUtils.retry(() -> {
            RoleMapping tum = this.adminClientV2.getRoleMapping("TestUser");
            Assertions.assertEquals((Object)"TestUser", (Object)tum.getPrincipalId());
            Assertions.assertEquals((Object)RoleType.READ_ONLY, (Object)tum.getRole());
        });
        Assertions.assertThrows(RoleMappingNotFoundException.class, () -> this.adminClientV2.updateRoleMapping("UnknownPrincipal", RoleType.ADMIN));
        this.adminClientV2.deleteRoleMapping("TestUser2");
        TestUtils.retry(() -> Assertions.assertThrows(RoleMappingNotFoundException.class, () -> this.adminClientV2.getRoleMapping("TestUser2")));
        TestUtils.retry(() -> {
            List mappings = this.adminClientV2.listRoleMappings();
            Assertions.assertEquals((int)1, (int)mappings.size());
            Assertions.assertEquals((Object)"TestUser", (Object)((RoleMapping)mappings.get(0)).getPrincipalId());
        });
        this.adminClientV2.deleteRoleMapping("TestUser");
    }

    private void setLogLevel(String log, LogLevel logLevel) {
        LogConfiguration logConfiguration = new LogConfiguration();
        logConfiguration.setLevel(logLevel);
        this.adminClientV2.setLogConfiguration(log, logConfiguration);
    }

    @Override
    protected Rule createGlobalRule(RuleType ruleType, String ruleConfig) {
        Rule rule = new Rule();
        rule.setConfig(ruleConfig);
        rule.setType(ruleType);
        this.adminClientV2.createGlobalRule(rule);
        return rule;
    }
}

