/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rbac;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.client.exception.ArtifactNotFoundException;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v2.beans.Comment;
import io.apicurio.registry.rest.v2.beans.LogConfiguration;
import io.apicurio.registry.rest.v2.beans.NamedLogConfiguration;
import io.apicurio.registry.rest.v2.beans.RoleMapping;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.UpdateConfigurationProperty;
import io.apicurio.registry.rest.v2.beans.UpdateRole;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.rules.integrity.IntegrityLevel;
import io.apicurio.registry.types.LogLevel;
import io.apicurio.registry.types.RoleType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.ApplicationRbacEnabledProfile;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.vertx.core.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=ApplicationRbacEnabledProfile.class)
@Tag(value="slow")
public class AdminResourceTest
extends AbstractResourceTestBase {
    @ConfigProperty(name="quarkus.log.level")
    @Info(category="log", description="Log level", availableSince="2.0.0.Final")
    String defaultLogLevel;

    @Test
    public void testGlobalRulesEndpoint() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").get("/registry/v2/admin/rules", new Object[0])).then()).statusCode(200)).body(CoreMatchers.anything(), new Matcher[0]);
    }

    @Test
    public void testCreateGlobalRule() throws Exception {
        Rule nullType = new Rule();
        nullType.setType(null);
        nullType.setConfig("TestConfig");
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)nullType).post("/registry/v2/admin/rules", new Object[0])).then()).statusCode(400);
        Rule nullConfig = new Rule();
        nullConfig.setType(RuleType.VALIDITY);
        nullConfig.setConfig(null);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)nullConfig).post("/registry/v2/admin/rules", new Object[0])).then()).statusCode(400);
        Rule emptyConfig = new Rule();
        emptyConfig.setType(RuleType.VALIDITY);
        emptyConfig.setConfig("");
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)emptyConfig).post("/registry/v2/admin/rules", new Object[0])).then()).statusCode(400);
    }

    @Test
    public void testGlobalRules() throws Exception {
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/registry/v2/admin/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/registry/v2/admin/rules", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", Matchers.equalTo((Object)"A rule named 'VALIDITY' already exists."), new Object[0]));
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("BACKWARD");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/registry/v2/admin/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/rules", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("[0]", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)"VALIDITY"), Matchers.equalTo((Object)"COMPATIBILITY")}), new Object[0])).body("[1]", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)"VALIDITY"), Matchers.equalTo((Object)"COMPATIBILITY")}), new Object[0])).body("[2]", Matchers.nullValue(), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"BACKWARD"), new Object[0]);
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).put("/registry/v2/admin/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().delete("/registry/v2/admin/rules/COMPATIBILITY", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/rules/COMPATIBILITY", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"No rule named 'COMPATIBILITY' was found."), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/rules", new Object[0])).then()).log().all()).statusCode(200)).contentType(ContentType.JSON)).body("[0]", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("[1]", Matchers.nullValue(), new Object[0]));
        ((ValidatableResponse)((Response)RestAssured.given().when().delete("/registry/v2/admin/rules", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/rules", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("[0]", Matchers.nullValue(), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/rules/VALIDITY", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"No rule named 'VALIDITY' was found."), new Object[0]);
    }

    @Test
    public void testIntegrityRule() throws Exception {
        Rule rule = new Rule();
        rule.setType(RuleType.INTEGRITY);
        rule.setConfig(IntegrityLevel.NO_DUPLICATES.name());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/registry/v2/admin/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/rules/INTEGRITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"INTEGRITY"), new Object[0])).body("config", Matchers.equalTo((Object)"NO_DUPLICATES"), new Object[0]));
        String newConfig = IntegrityLevel.NO_DUPLICATES + "," + IntegrityLevel.REFS_EXIST;
        rule.setType(RuleType.INTEGRITY);
        rule.setConfig(newConfig);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).put("/registry/v2/admin/rules/INTEGRITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"INTEGRITY"), new Object[0])).body("config", Matchers.equalTo((Object)newConfig), new Object[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/rules/INTEGRITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"INTEGRITY"), new Object[0])).body("config", Matchers.equalTo((Object)newConfig), new Object[0]));
    }

    @Test
    public void testDeleteAllGlobalRules() throws Exception {
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/registry/v2/admin/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        ((ValidatableResponse)((Response)RestAssured.given().when().delete("/registry/v2/admin/rules", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/rules/VALIDITY", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"No rule named 'VALIDITY' was found."), new Object[0]));
    }

    @Test
    public void testCompatilibityLevelNone() throws Exception {
        Rule rule = new Rule();
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig(CompatibilityLevel.NONE.name());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/registry/v2/admin/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"NONE"), new Object[0]));
    }

    @Test
    void testLoggerSetsLevel() throws Exception {
        String testLoggerName = "foo.logger.testLoggerSetsLevel";
        Logger logger = Logger.getLogger(testLoggerName);
        logger.setLevel(Level.parse(this.defaultLogLevel));
        String defaultLogLevel = Logger.getLogger(testLoggerName).getLevel().getName();
        TestUtils.retry(() -> this.verifyLogLevel(testLoggerName, LogLevel.fromValue((String)defaultLogLevel)));
        List levels = EnumSet.allOf(LogLevel.class).stream().filter(l -> !l.value().equals(defaultLogLevel)).collect(Collectors.toList());
        for (LogLevel level : levels) {
            LogConfiguration lc = new LogConfiguration();
            lc.setLevel(level);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body((Object)lc).contentType(ContentType.JSON).pathParam("logger", (Object)testLoggerName).put("/registry/v2/admin/loggers/{logger}", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("level", Matchers.is((Object)level.value()), new Object[0]);
            TestUtils.retry(() -> Assertions.assertEquals((Object)level.value(), (Object)Logger.getLogger(testLoggerName).getLevel().getName()));
        }
        this.clearLogConfig(testLoggerName);
    }

    @Test
    void testLoggerInvalidLevel() {
        JsonObject lc = new JsonObject().put("level", (Object)"FOO");
        ((ValidatableResponse)((Response)RestAssured.given().when().body((Object)lc).contentType(ContentType.JSON).pathParam("logger", (Object)"foo.logger.invalid").put("/registry/v2/admin/loggers/{logger}", new Object[0])).then()).statusCode(400);
    }

    private void verifyLogLevel(String loggerName, LogLevel level) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("logger", (Object)loggerName).get("/registry/v2/admin/loggers/{logger}", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("level", Matchers.is((Object)level.value()), new Object[0]);
    }

    private void clearLogConfig(String loggerName) throws Exception {
        ((ValidatableResponse)((Response)RestAssured.given().when().pathParam("logger", (Object)loggerName).delete("/registry/v2/admin/loggers/{logger}", new Object[0])).then()).statusCode(200);
        TestUtils.retry(() -> {
            Response res = (Response)((Response)RestAssured.given().when().get("/registry/v2/admin/loggers", new Object[0])).thenReturn();
            Assertions.assertEquals((int)200, (int)res.statusCode());
            NamedLogConfiguration[] configs = (NamedLogConfiguration[])res.as(NamedLogConfiguration[].class);
            Assertions.assertTrue((boolean)Stream.of(configs).filter(named -> named.getName().equals(loggerName)).findAny().isEmpty());
        }, (String)"Clear log config", (int)50);
    }

    @Test
    void testLoggersCRUD() throws Exception {
        String testLoggerName = "foo.logger.testLoggersCRUD";
        Logger logger = Logger.getLogger(testLoggerName);
        logger.setLevel(Level.parse(this.defaultLogLevel));
        String defaultLogLevel = Logger.getLogger(testLoggerName).getLevel().getName();
        TestUtils.retry(() -> this.verifyLogLevel(testLoggerName, LogLevel.fromValue((String)defaultLogLevel)));
        Consumer<LogLevel> setLog = level -> {
            LogConfiguration lc = new LogConfiguration();
            lc.setLevel(level);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body((Object)lc).contentType(ContentType.JSON).pathParam("logger", (Object)testLoggerName).put("/registry/v2/admin/loggers/{logger}", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("level", Matchers.is((Object)level.value()), new Object[0]);
        };
        Consumer<LogLevel> verifyLevel = level -> {
            Response res = (Response)((Response)RestAssured.given().when().get("/registry/v2/admin/loggers", new Object[0])).thenReturn();
            NamedLogConfiguration[] configs = (NamedLogConfiguration[])res.as(NamedLogConfiguration[].class);
            Assertions.assertTrue((boolean)Stream.of(configs).filter(named -> named.getName().equals(testLoggerName) && named.getLevel().equals(level)).findAny().isPresent());
            String actualLevel = Logger.getLogger(testLoggerName).getLevel().getName();
            Assertions.assertEquals((Object)level.value(), (Object)actualLevel, (String)("Log value for logger " + testLoggerName + " was NOT set to '" + level.value() + "' it was '" + actualLevel + "', even though the server reported it was."));
        };
        List levels = EnumSet.allOf(LogLevel.class).stream().filter(l -> !l.value().equals(defaultLogLevel)).collect(Collectors.toList());
        Random r = new Random();
        HashMap testLevels = new HashMap();
        TestUtils.retry(() -> {
            testLevels.put("first", (LogLevel)levels.get(r.nextInt(levels.size())));
            testLevels.put("second", (LogLevel)levels.get(r.nextInt(levels.size())));
            Assertions.assertNotEquals(testLevels.get("first"), testLevels.get("second"));
        });
        LogLevel firstLevel = (LogLevel)testLevels.get("first");
        LogLevel secondLevel = (LogLevel)testLevels.get("second");
        System.out.println("Going to test log level change from " + defaultLogLevel + " to " + firstLevel.name() + " and then to " + secondLevel.name());
        setLog.accept(firstLevel);
        TestUtils.retry(() -> {
            this.verifyLogLevel(testLoggerName, firstLevel);
            verifyLevel.accept(firstLevel);
        });
        setLog.accept(secondLevel);
        TestUtils.retry(() -> {
            this.verifyLogLevel(testLoggerName, secondLevel);
            verifyLevel.accept(secondLevel);
        });
        this.clearLogConfig(testLoggerName);
        TestUtils.retry(() -> {
            Response res = (Response)((Response)RestAssured.given().when().pathParam("logger", (Object)testLoggerName).get("/registry/v2/admin/loggers/{logger}", new Object[0])).thenReturn();
            Assertions.assertEquals((int)200, (int)res.statusCode());
            NamedLogConfiguration cfg = (NamedLogConfiguration)res.getBody().as(NamedLogConfiguration.class);
            Assertions.assertEquals((Object)cfg.getLevel().value(), (Object)Logger.getLogger(testLoggerName).getLevel().getName());
        });
    }

    @Test
    void testExport() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String group = "testExport";
        for (int idx = 0; idx < 5; ++idx) {
            String title = "Empty API " + idx;
            String artifactId = "Empty-" + idx;
            this.createArtifact(group, artifactId, "OPENAPI", artifactContent.replaceAll("Empty API", title));
            this.waitForArtifact(group, artifactId);
        }
        ValidatableResponse response = (ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/export", new Object[0])).then()).statusCode(200);
        InputStream body = response.extract().asInputStream();
        ZipInputStream zip = new ZipInputStream(body);
        AtomicInteger contentCounter = new AtomicInteger(0);
        AtomicInteger versionCounter = new AtomicInteger(0);
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            if (name.endsWith(".Content.json")) {
                contentCounter.incrementAndGet();
            } else if (name.endsWith(".ArtifactVersion.json")) {
                versionCounter.incrementAndGet();
            }
            entry = zip.getNextEntry();
        }
        Assertions.assertTrue((contentCounter.get() >= 5 ? 1 : 0) != 0);
        Assertions.assertTrue((versionCounter.get() >= 5 ? 1 : 0) != 0);
    }

    @Test
    void testExportForBrowser() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        String group = "testExportForBrowser";
        String suffix = UUID.randomUUID().toString();
        for (int idx = 0; idx < 5; ++idx) {
            String title = "Empty API " + idx + " " + suffix;
            String artifactId = "Empty-" + idx;
            List<ArtifactReference> refs = idx > 0 ? this.getSingletonRefList(group, "Empty-" + (idx - 1), "1", "ref") : Collections.emptyList();
            this.createArtifactWithReferences(group, artifactId, "OPENAPI", artifactContent.replaceAll("Empty API", title), refs);
            this.waitForArtifact(group, artifactId);
        }
        String downloadHref = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("forBrowser", new Object[]{"true"}).get("/registry/v2/admin/export", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("downloadId", Matchers.notNullValue(), new Object[0])).body("href", Matchers.notNullValue(), new Object[0])).extract().body().path("href", new String[0]);
        Assertions.assertTrue((boolean)downloadHref.startsWith("/apis/"));
        downloadHref = downloadHref.substring(5);
        ValidatableResponse response = (ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get(downloadHref, new Object[0])).then()).statusCode(200);
        InputStream body = response.extract().asInputStream();
        ZipInputStream zip = new ZipInputStream(body);
        AtomicInteger contentCounter = new AtomicInteger(0);
        AtomicInteger versionCounter = new AtomicInteger(0);
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            if (name.endsWith(".Content.json")) {
                contentCounter.incrementAndGet();
            } else if (name.endsWith(".ArtifactVersion.json")) {
                versionCounter.incrementAndGet();
            }
            entry = zip.getNextEntry();
        }
        Assertions.assertTrue((contentCounter.get() >= 5 ? 1 : 0) != 0);
        Assertions.assertTrue((versionCounter.get() >= 5 ? 1 : 0) != 0);
        ((ValidatableResponse)((Response)RestAssured.given().when().get(downloadHref, new Object[0])).then()).statusCode(404);
    }

    @Test
    void testImport() throws Exception {
        ArtifactSearchResults result = this.clientV2.searchArtifacts(null, null, null, null, null, null, null, Integer.valueOf(0), Integer.valueOf(5));
        int artifactsBefore = result.getCount();
        try (InputStream data = this.resourceToInputStream("../rest/v2/export.zip");){
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/zip").body(data).post("/registry/v2/admin/import", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        }
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/rules/COMPATIBILITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"COMPATIBILITY"), new Object[0])).body("config", Matchers.equalTo((Object)"BACKWARD"), new Object[0]));
        result = this.clientV2.searchArtifacts(null, null, null, null, null, null, null, Integer.valueOf(0), Integer.valueOf(5));
        int newArtifacts = result.getCount() - artifactsBefore;
        Assertions.assertEquals((int)3, (int)newArtifacts);
        List comments = this.clientV2.getArtifactVersionComments("ImportTest", "Artifact-1", "1.0.2");
        Assertions.assertNotNull((Object)comments);
        Assertions.assertEquals((int)2, (int)comments.size());
        Assertions.assertEquals((Object)"COMMENT-2", (Object)((Comment)comments.get(0)).getValue());
        Assertions.assertEquals((Object)"COMMENT-1", (Object)((Comment)comments.get(1)).getValue());
        comments = this.clientV2.getArtifactVersionComments("ImportTest", "Artifact-2", "1.0.1");
        Assertions.assertNotNull((Object)comments);
        Assertions.assertEquals((int)1, (int)comments.size());
        Assertions.assertEquals((Object)"COMMENT-3", (Object)((Comment)comments.get(0)).getValue());
        Rule rule = this.clientV2.getArtifactRuleConfig("ImportTest", "Artifact-1", RuleType.VALIDITY);
        Assertions.assertNotNull((Object)rule);
        Assertions.assertEquals((Object)"SYNTAX_ONLY", (Object)rule.getConfig());
        Assertions.assertNotNull((Object)this.clientV2.getContentByGlobalId(1005L));
        ArtifactMetaData lastArtifactMeta = this.clientV2.getArtifactMetaData("ImportTest", "Artifact-3");
        Assertions.assertEquals((Object)"1.0.2", (Object)lastArtifactMeta.getVersion());
        Assertions.assertEquals((long)1005L, (Long)lastArtifactMeta.getGlobalId());
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.clientV2.getContentByGlobalId(1006L));
        ArtifactMetaData meta = this.clientV2.createArtifact(null, "newartifact", "JSON", (InputStream)new ByteArrayInputStream("{}".getBytes()));
        Assertions.assertEquals((int)1006, (int)meta.getGlobalId().intValue());
    }

    @Test
    public void testRoleMappings() throws Exception {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/roleMappings", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("[0]", Matchers.nullValue(), new Object[0]);
        RoleMapping mapping = new RoleMapping();
        mapping.setPrincipalId("TestUser");
        mapping.setRole(RoleType.DEVELOPER);
        mapping.setPrincipalName("Foo bar");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)mapping).post("/registry/v2/admin/roleMappings", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/roleMappings/TestUser", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("principalId", Matchers.equalTo((Object)"TestUser"), new Object[0])).body("principalName", Matchers.equalTo((Object)"Foo bar"), new Object[0])).body("role", Matchers.equalTo((Object)"DEVELOPER"), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/roleMappings", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("[0].principalId", Matchers.equalTo((Object)"TestUser"), new Object[0])).body("[0].principalName", Matchers.equalTo((Object)"Foo bar"), new Object[0])).body("[0].role", Matchers.equalTo((Object)"DEVELOPER"), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)mapping).post("/registry/v2/admin/roleMappings", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", Matchers.equalTo((Object)"A role mapping for this principal already exists."), new Object[0]));
        mapping.setPrincipalId("TestUser2");
        mapping.setRole(RoleType.ADMIN);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)mapping).post("/registry/v2/admin/roleMappings", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/roleMappings", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("[0].principalId", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)"TestUser"), Matchers.equalTo((Object)"TestUser2")}), new Object[0])).body("[1].principalId", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)"TestUser"), Matchers.equalTo((Object)"TestUser2")}), new Object[0])).body("[2]", Matchers.nullValue(), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/roleMappings/TestUser2", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("principalId", Matchers.equalTo((Object)"TestUser2"), new Object[0])).body("role", Matchers.equalTo((Object)"ADMIN"), new Object[0]);
        UpdateRole update = new UpdateRole();
        update.setRole(RoleType.READ_ONLY);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)update).put("/registry/v2/admin/roleMappings/TestUser", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/roleMappings/TestUser", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("principalId", Matchers.equalTo((Object)"TestUser"), new Object[0])).body("role", Matchers.equalTo((Object)"READ_ONLY"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)update).put("/registry/v2/admin/roleMappings/UnknownPrincipal", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"Role mapping not found for principal."), new Object[0]);
        update.setRole(null);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)update).put("/registry/v2/admin/roleMappings/TestUser", new Object[0])).then()).statusCode(400);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().delete("/registry/v2/admin/roleMappings/TestUser2", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/roleMappings/TestUser2", new Object[0])).then()).statusCode(404)).contentType(ContentType.JSON)).body("error_code", Matchers.equalTo((Object)404), new Object[0])).body("message", Matchers.equalTo((Object)"Role mapping not found for principal."), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/roleMappings", new Object[0])).then()).log().all()).statusCode(200)).contentType(ContentType.JSON)).body("[0].principalId", Matchers.equalTo((Object)"TestUser"), new Object[0])).body("[1]", Matchers.nullValue(), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().delete("/registry/v2/admin/roleMappings/TestUser", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
    }

    @Test
    public void testConfigProperties() throws Exception {
        String property1Name = "registry.ccompat.legacy-id-mode.enabled";
        String property2Name = "registry.ui.features.readOnly";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v2/admin/config/properties", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("propertyName", (Object)property1Name).get("/registry/v2/admin/config/properties/{propertyName}", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("name", Matchers.equalTo((Object)property1Name), new Object[0])).body("value", Matchers.equalTo((Object)"false"), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("propertyName", (Object)property2Name).get("/registry/v2/admin/config/properties/{propertyName}", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("name", Matchers.equalTo((Object)property2Name), new Object[0])).body("value", Matchers.equalTo((Object)"false"), new Object[0]));
        UpdateConfigurationProperty update = new UpdateConfigurationProperty();
        update.setValue("true");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)update).pathParam("propertyName", (Object)property1Name).put("/registry/v2/admin/config/properties/{propertyName}", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("propertyName", (Object)property1Name).get("/registry/v2/admin/config/properties/{propertyName}", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("name", Matchers.equalTo((Object)property1Name), new Object[0])).body("value", Matchers.equalTo((Object)"true"), new Object[0]));
        update = new UpdateConfigurationProperty();
        update.setValue("true");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)update).pathParam("propertyName", (Object)property2Name).put("/registry/v2/admin/config/properties/{propertyName}", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("propertyName", (Object)property2Name).get("/registry/v2/admin/config/properties/{propertyName}", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("name", Matchers.equalTo((Object)property2Name), new Object[0])).body("value", Matchers.equalTo((Object)"true"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("propertyName", (Object)property2Name).delete("/registry/v2/admin/config/properties/{propertyName}", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("propertyName", (Object)property2Name).get("/registry/v2/admin/config/properties/{propertyName}", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("name", Matchers.equalTo((Object)property2Name), new Object[0])).body("value", Matchers.equalTo((Object)"false"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)update).pathParam("propertyName", (Object)property1Name).delete("/registry/v2/admin/config/properties/{propertyName}", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("propertyName", (Object)property1Name).get("/registry/v2/admin/config/properties/{propertyName}", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("name", Matchers.equalTo((Object)property1Name), new Object[0])).body("value", Matchers.equalTo((Object)"false"), new Object[0]));
        update = new UpdateConfigurationProperty();
        update.setValue("foobar");
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)update).pathParam("propertyName", (Object)"property-does-not-exist").put("/registry/v2/admin/config/properties/{propertyName}", new Object[0])).then()).statusCode(404);
        update = new UpdateConfigurationProperty();
        update.setValue("foobar");
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)update).pathParam("propertyName", (Object)"registry.download.href.ttl").put("/registry/v2/admin/config/properties/{propertyName}", new Object[0])).then()).statusCode(400);
    }

    private List<ArtifactReference> getSingletonRefList(String groupId, String artifactId, String version, String name) {
        ArtifactReference artifactReference = new ArtifactReference();
        artifactReference.setGroupId(groupId);
        artifactReference.setArtifactId(artifactId);
        artifactReference.setVersion(version);
        artifactReference.setName(name);
        return Collections.singletonList(artifactReference);
    }
}

