/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rbac;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rbac.MockAuditLogService;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.registry.rest.client.exception.ArtifactNotFoundException;
import io.apicurio.registry.rest.client.exception.ConfigPropertyNotFoundException;
import io.apicurio.registry.rest.client.exception.GroupNotFoundException;
import io.apicurio.registry.rest.client.exception.InvalidPropertyValueException;
import io.apicurio.registry.rest.client.exception.RateLimitedClientException;
import io.apicurio.registry.rest.client.exception.RoleMappingAlreadyExistsException;
import io.apicurio.registry.rest.client.exception.RoleMappingNotFoundException;
import io.apicurio.registry.rest.v2.beans.ArtifactContent;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v2.beans.ConfigurationProperty;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.rest.v2.beans.GroupMetaData;
import io.apicurio.registry.rest.v2.beans.GroupSearchResults;
import io.apicurio.registry.rest.v2.beans.IfExists;
import io.apicurio.registry.rest.v2.beans.LogConfiguration;
import io.apicurio.registry.rest.v2.beans.NamedLogConfiguration;
import io.apicurio.registry.rest.v2.beans.RoleMapping;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.SearchedArtifact;
import io.apicurio.registry.rest.v2.beans.SearchedGroup;
import io.apicurio.registry.rest.v2.beans.SearchedVersion;
import io.apicurio.registry.rest.v2.beans.SortBy;
import io.apicurio.registry.rest.v2.beans.SortOrder;
import io.apicurio.registry.rest.v2.beans.UpdateState;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.rest.v2.beans.VersionSearchResults;
import io.apicurio.registry.storage.impl.sql.SqlUtil;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.LogLevel;
import io.apicurio.registry.types.RoleType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.tests.ApplicationRbacEnabledProfile;
import io.apicurio.registry.utils.tests.TestUtils;
import io.apicurio.registry.utils.tests.TooManyRequestsMock;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import jakarta.inject.Inject;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfEnvironmentVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusTest
@TestProfile(value=ApplicationRbacEnabledProfile.class)
@Tag(value="slow")
public class RegistryClientTest
extends AbstractResourceTestBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryClientTest.class);
    private static final String ARTIFACT_OPENAPI_YAML_CONTENT = "openapi: \"3.0.2\"\ninfo:\n  description: \"Description\"\n  version: \"1.0.0\"\n  title: \"OpenAPI\"\npaths:";
    private static final String UPDATED_OPENAPI_YAML_CONTENT = "openapi: \"3.0.2\"\ninfo:\n  description: \"Description v2\"\n  version: \"2.0.0\"\n  title: \"OpenAPI\"\npaths:";
    private static final String ARTIFACT_OPENAPI_JSON_CONTENT = "{\n  \"openapi\" : \"3.0.2\",\n  \"info\" : {\n    \"description\" : \"Description\",\n    \"version\" : \"1.0.0\",\n    \"title\" : \"OpenAPI\"\n  },\n  \"paths\" : null\n}";
    private static final String UPDATED_OPENAPI_JSON_CONTENT = "{\n  \"openapi\" : \"3.0.2\",\n  \"info\" : {\n    \"description\" : \"Description v2\",\n    \"version\" : \"2.0.0\",\n    \"title\" : \"OpenAPI\"\n  },\n  \"paths\" : null\n}";
    private static final String SCHEMA_WITH_REFERENCE = "{\r\n    \"namespace\":\"com.example.common\",\r\n    \"name\":\"Item\",\r\n    \"type\":\"record\",\r\n    \"fields\":[\r\n        {\r\n            \"name\":\"itemId\",\r\n            \"type\":\"com.example.common.ItemId\"\r\n        }]\r\n}";
    private static final String REFERENCED_SCHEMA = "{\"namespace\": \"com.example.common\", \"type\": \"record\", \"name\": \"ItemId\", \"fields\":[{\"name\":\"id\", \"type\":\"int\"}]}";
    private static final String ARTIFACT_CONTENT = "{\"name\":\"redhat\"}";
    private static final String UPDATED_CONTENT = "{\"name\":\"ibm\"}";
    @Inject
    MockAuditLogService auditLogService;

    @Test
    public void testCreateArtifact() throws Exception {
        String groupId = "testCreateArtifact";
        String artifactId = this.generateArtifactId();
        String version = "1";
        String name = "testCreateArtifactName";
        String description = "testCreateArtifactDescription";
        InputStream stream = IoUtil.toStream((byte[])ARTIFACT_CONTENT.getBytes(StandardCharsets.UTF_8));
        ArtifactMetaData created = this.clientV2.createArtifact("testCreateArtifact", artifactId, "1", "JSON", IfExists.FAIL, Boolean.valueOf(false), "testCreateArtifactName", "testCreateArtifactDescription", stream);
        this.waitForArtifact("testCreateArtifact", artifactId);
        Assertions.assertNotNull((Object)created);
        Assertions.assertEquals((Object)"testCreateArtifact", (Object)created.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)created.getId());
        Assertions.assertEquals((Object)"1", (Object)created.getVersion());
        Assertions.assertEquals((Object)"testCreateArtifactName", (Object)created.getName());
        Assertions.assertEquals((Object)"testCreateArtifactDescription", (Object)created.getDescription());
        Assertions.assertEquals((Object)ARTIFACT_CONTENT, (Object)IoUtil.toString((InputStream)this.clientV2.getLatestArtifact("testCreateArtifact", artifactId)));
    }

    @Test
    public void groupsCrud() throws Exception {
        String groupId = UUID.randomUUID().toString();
        GroupMetaData groupMetaData = new GroupMetaData();
        groupMetaData.setId(groupId);
        groupMetaData.setDescription("Groups test crud");
        groupMetaData.setProperties(Map.of("p1", "v1", "p2", "v2"));
        this.clientV2.createArtifactGroup(groupMetaData);
        GroupMetaData artifactGroup = this.clientV2.getArtifactGroup(groupId);
        Assertions.assertEquals((Object)groupMetaData.getId(), (Object)artifactGroup.getId());
        Assertions.assertEquals((Object)groupMetaData.getDescription(), (Object)artifactGroup.getDescription());
        Assertions.assertEquals((Object)groupMetaData.getProperties(), (Object)artifactGroup.getProperties());
        String group1Id = UUID.randomUUID().toString();
        String group2Id = UUID.randomUUID().toString();
        String group3Id = UUID.randomUUID().toString();
        groupMetaData.setId(group1Id);
        this.clientV2.createArtifactGroup(groupMetaData);
        groupMetaData.setId(group2Id);
        this.clientV2.createArtifactGroup(groupMetaData);
        groupMetaData.setId(group3Id);
        this.clientV2.createArtifactGroup(groupMetaData);
        GroupSearchResults groupSearchResults = this.clientV2.listGroups(SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(100));
        Assertions.assertTrue((groupSearchResults.getCount() >= 4 ? 1 : 0) != 0);
        List groupIds = groupSearchResults.getGroups().stream().map(SearchedGroup::getId).collect(Collectors.toList());
        Assertions.assertTrue((boolean)groupIds.containsAll(List.of(groupId, group1Id, group2Id, group3Id)));
        this.clientV2.deleteArtifactGroup(groupId);
        Assertions.assertThrows(GroupNotFoundException.class, () -> this.clientV2.getArtifactGroup(groupId));
    }

    @Test
    public void testCreateYamlArtifact() throws Exception {
        String groupId = "testCreateYamlArtifact";
        String artifactId = this.generateArtifactId();
        String version = "1";
        String name = "testCreateYamlArtifactName";
        String description = "testCreateYamlArtifactDescription";
        InputStream stream = IoUtil.toStream((byte[])ARTIFACT_OPENAPI_YAML_CONTENT.getBytes(StandardCharsets.UTF_8));
        ArtifactMetaData created = this.clientV2.createArtifact("testCreateYamlArtifact", artifactId, "1", "OPENAPI", IfExists.FAIL, Boolean.valueOf(false), "testCreateYamlArtifactName", "testCreateYamlArtifactDescription", "application/x-yaml", null, null, stream);
        this.waitForArtifact("testCreateYamlArtifact", artifactId);
        Assertions.assertNotNull((Object)created);
        Assertions.assertEquals((Object)"testCreateYamlArtifact", (Object)created.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)created.getId());
        Assertions.assertEquals((Object)"1", (Object)created.getVersion());
        Assertions.assertEquals((Object)"testCreateYamlArtifactName", (Object)created.getName());
        Assertions.assertEquals((Object)"testCreateYamlArtifactDescription", (Object)created.getDescription());
        RegistryClientTest.assertMultilineTextEquals(ARTIFACT_OPENAPI_JSON_CONTENT, IoUtil.toString((InputStream)this.clientV2.getLatestArtifact("testCreateYamlArtifact", artifactId)));
    }

    @Test
    public void testCreateArtifactVersion() throws Exception {
        String groupId = "testCreateArtifactVersion";
        String artifactId = this.generateArtifactId();
        String version = "2";
        String name = "testCreateArtifactVersionName";
        String description = "testCreateArtifactVersionDescription";
        this.createArtifact("testCreateArtifactVersion", artifactId);
        InputStream stream = IoUtil.toStream((byte[])UPDATED_CONTENT.getBytes(StandardCharsets.UTF_8));
        VersionMetaData versionMetaData = this.clientV2.createArtifactVersion("testCreateArtifactVersion", artifactId, "2", "testCreateArtifactVersionName", "testCreateArtifactVersionDescription", stream);
        this.waitForVersion("testCreateArtifactVersion", artifactId, 2);
        ArtifactMetaData amd = this.clientV2.getArtifactMetaData("testCreateArtifactVersion", artifactId);
        Assertions.assertNotNull((Object)versionMetaData);
        Assertions.assertEquals((Object)"2", (Object)versionMetaData.getVersion());
        Assertions.assertEquals((Object)"testCreateArtifactVersionName", (Object)versionMetaData.getName());
        Assertions.assertEquals((Object)"testCreateArtifactVersionDescription", (Object)versionMetaData.getDescription());
        Assertions.assertNotNull((Object)amd);
        Assertions.assertEquals((Object)"2", (Object)amd.getVersion());
        Assertions.assertEquals((Object)"testCreateArtifactVersionName", (Object)amd.getName());
        Assertions.assertEquals((Object)"testCreateArtifactVersionDescription", (Object)amd.getDescription());
        Assertions.assertEquals((Object)UPDATED_CONTENT, (Object)IoUtil.toString((InputStream)this.clientV2.getLatestArtifact("testCreateArtifactVersion", artifactId)));
    }

    @Test
    public void testCreateYamlArtifactVersion() throws Exception {
        String groupId = "testCreateYamlArtifactVersion";
        String artifactId = this.generateArtifactId();
        String version = "2";
        String name = "testCreateYamlArtifactVersionName";
        String description = "testCreateYamlArtifactVersionDescription";
        this.createOpenAPIArtifact("testCreateYamlArtifactVersion", artifactId);
        InputStream stream = IoUtil.toStream((byte[])UPDATED_OPENAPI_YAML_CONTENT.getBytes(StandardCharsets.UTF_8));
        VersionMetaData versionMetaData = this.clientV2.createArtifactVersion("testCreateYamlArtifactVersion", artifactId, "2", "testCreateYamlArtifactVersionName", "testCreateYamlArtifactVersionDescription", "application/x-yaml", stream);
        this.waitForVersion("testCreateYamlArtifactVersion", artifactId, 2);
        ArtifactMetaData amd = this.clientV2.getArtifactMetaData("testCreateYamlArtifactVersion", artifactId);
        Assertions.assertNotNull((Object)versionMetaData);
        Assertions.assertEquals((Object)"2", (Object)versionMetaData.getVersion());
        Assertions.assertEquals((Object)"testCreateYamlArtifactVersionName", (Object)versionMetaData.getName());
        Assertions.assertEquals((Object)"testCreateYamlArtifactVersionDescription", (Object)versionMetaData.getDescription());
        Assertions.assertNotNull((Object)amd);
        Assertions.assertEquals((Object)"2", (Object)amd.getVersion());
        Assertions.assertEquals((Object)"testCreateYamlArtifactVersionName", (Object)amd.getName());
        Assertions.assertEquals((Object)"testCreateYamlArtifactVersionDescription", (Object)amd.getDescription());
        RegistryClientTest.assertMultilineTextEquals(UPDATED_OPENAPI_JSON_CONTENT, IoUtil.toString((InputStream)this.clientV2.getLatestArtifact("testCreateYamlArtifactVersion", artifactId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncCRUD() throws Exception {
        this.auditLogService.resetAuditLogs();
        String groupId = "testAsyncCRUD";
        String artifactId = this.generateArtifactId();
        try {
            InputStream stream = IoUtil.toStream((byte[])ARTIFACT_CONTENT.getBytes(StandardCharsets.UTF_8));
            ArtifactMetaData amd = this.clientV2.createArtifact("testAsyncCRUD", artifactId, "JSON", stream);
            Assertions.assertNotNull((Object)amd);
            this.waitForArtifact("testAsyncCRUD", artifactId);
            EditableMetaData emd = new EditableMetaData();
            emd.setName("testAsyncCRUD");
            this.clientV2.updateArtifactMetaData("testAsyncCRUD", artifactId, emd);
            TestUtils.retry(() -> {
                ArtifactMetaData artifactMetaData = this.clientV2.getArtifactMetaData("testAsyncCRUD", artifactId);
                Assertions.assertNotNull((Object)artifactMetaData);
                Assertions.assertEquals((Object)"testAsyncCRUD", (Object)artifactMetaData.getName());
            });
            stream = IoUtil.toStream((byte[])UPDATED_CONTENT.getBytes(StandardCharsets.UTF_8));
            this.clientV2.updateArtifact("testAsyncCRUD", artifactId, stream);
            Assertions.assertEquals((Object)UPDATED_CONTENT, (Object)IoUtil.toString((InputStream)this.clientV2.getLatestArtifact("testAsyncCRUD", artifactId)));
            List<Map<String, String>> auditLogs = this.auditLogService.getAuditLogs();
            Assertions.assertFalse((boolean)auditLogs.isEmpty());
            Assertions.assertEquals((int)3, (int)auditLogs.size());
        }
        finally {
            this.clientV2.deleteArtifact("testAsyncCRUD", artifactId);
        }
    }

    @Test
    public void testSmoke() throws Exception {
        String groupId = "testSmoke";
        String artifactId1 = this.generateArtifactId();
        String artifactId2 = this.generateArtifactId();
        this.createArtifact("testSmoke", artifactId1);
        this.createArtifact("testSmoke", artifactId2);
        ArtifactSearchResults searchResults = this.clientV2.listArtifactsInGroup("testSmoke", SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(2));
        Assertions.assertNotNull((Object)this.clientV2.toString());
        Assertions.assertEquals((int)this.clientV2.hashCode(), (int)this.clientV2.hashCode());
        Assertions.assertEquals((int)2, (Integer)searchResults.getCount());
        this.clientV2.deleteArtifact("testSmoke", artifactId1);
        this.clientV2.deleteArtifact("testSmoke", artifactId2);
        TestUtils.retry(() -> {
            ArtifactSearchResults deletedResults = this.clientV2.listArtifactsInGroup("testSmoke", SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(2));
            Assertions.assertEquals((int)0, (Integer)deletedResults.getCount());
        });
    }

    @Test
    void testSearchArtifact() throws Exception {
        String groupId = "testSearchArtifact";
        this.clientV2.listArtifactsInGroup("testSearchArtifact");
        String artifactId = UUID.randomUUID().toString();
        String name = "n" + ThreadLocalRandom.current().nextInt(1000000);
        InputStream artifactData = IoUtil.toStream((byte[])("{\"type\":\"record\",\"title\":\"" + name + "\",\"fields\":[{\"name\":\"foo\",\"type\":\"string\"}]}").getBytes(StandardCharsets.UTF_8));
        ArtifactMetaData amd = this.clientV2.createArtifact("testSearchArtifact", artifactId, "JSON", artifactData);
        long id = amd.getGlobalId();
        this.waitForGlobalId(id);
        ArtifactSearchResults results = this.clientV2.searchArtifacts(null, name, null, null, null, SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((int)1, (Integer)results.getCount());
        Assertions.assertEquals((int)1, (int)results.getArtifacts().size());
        Assertions.assertEquals((Object)name, (Object)((SearchedArtifact)results.getArtifacts().get(0)).getName());
        results = this.clientV2.searchArtifacts(null, null, null, null, null, null, null, null, null);
        Assertions.assertNotNull((Object)results);
        Assertions.assertTrue((results.getCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    void testSearchArtifactSortByCreatedOn() throws Exception {
        String groupId = "testSearchArtifactSortByCreatedOn";
        this.clientV2.listArtifactsInGroup("testSearchArtifactSortByCreatedOn");
        String artifactId = UUID.randomUUID().toString();
        String name = "n" + ThreadLocalRandom.current().nextInt(1000000);
        byte[] content = ("{\"type\":\"record\",\"title\":\"" + name + "\",\"fields\":[{\"name\":\"foo\",\"type\":\"string\"}]}").getBytes(StandardCharsets.UTF_8);
        ArtifactMetaData amd = this.clientV2.createArtifact("testSearchArtifactSortByCreatedOn", artifactId, "JSON", IoUtil.toStream((byte[])content));
        long id = amd.getGlobalId();
        this.waitForGlobalId(id);
        LOGGER.info("created " + amd.getId() + " - " + amd.getCreatedOn());
        Thread.sleep(1500L);
        String artifactId2 = UUID.randomUUID().toString();
        ArtifactMetaData amd2 = this.clientV2.createArtifact("testSearchArtifactSortByCreatedOn", artifactId2, "JSON", IoUtil.toStream((byte[])content));
        this.waitForGlobalId(amd2.getGlobalId());
        LOGGER.info("created " + amd2.getId() + " - " + amd2.getCreatedOn());
        ArtifactSearchResults results = this.clientV2.searchArtifacts(null, name, null, null, null, SortBy.createdOn, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((int)2, (Integer)results.getCount());
        Assertions.assertEquals((int)2, (int)results.getArtifacts().size());
        LOGGER.info("search");
        LOGGER.info(((SearchedArtifact)results.getArtifacts().get(0)).getId() + " - " + ((SearchedArtifact)results.getArtifacts().get(0)).getCreatedOn());
        LOGGER.info(((SearchedArtifact)results.getArtifacts().get(1)).getId() + " - " + ((SearchedArtifact)results.getArtifacts().get(1)).getCreatedOn());
        Assertions.assertEquals((Object)artifactId, (Object)((SearchedArtifact)results.getArtifacts().get(0)).getId());
        results = this.clientV2.searchArtifacts(null, null, null, null, null, null, null, null, null);
        Assertions.assertNotNull((Object)results);
        Assertions.assertTrue((results.getCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    void testSearchArtifactByIds() throws Exception {
        String groupId = "testSearchArtifactByIds";
        this.clientV2.listArtifactsInGroup("testSearchArtifactByIds");
        String artifactId = UUID.randomUUID().toString();
        String name = "n" + ThreadLocalRandom.current().nextInt(1000000);
        byte[] content = ("{\"type\":\"record\",\"title\":\"" + name + "\",\"fields\":[{\"name\":\"foo\",\"type\":\"string\"}]}").getBytes(StandardCharsets.UTF_8);
        ArtifactMetaData amd = this.clientV2.createArtifact("testSearchArtifactByIds", artifactId, "JSON", IoUtil.toStream((byte[])content));
        long id = amd.getGlobalId();
        this.waitForGlobalId(id);
        LOGGER.info("created " + amd.getId() + " - " + amd.getCreatedOn());
        Thread.sleep(1500L);
        String artifactId2 = UUID.randomUUID().toString();
        ArtifactMetaData amd2 = this.clientV2.createArtifact("testSearchArtifactByIds", artifactId2, "JSON", IoUtil.toStream((byte[])content));
        this.waitForGlobalId(amd2.getGlobalId());
        LOGGER.info("created " + amd2.getId() + " - " + amd2.getCreatedOn());
        ArtifactSearchResults results = this.clientV2.searchArtifacts(null, null, null, null, null, amd.getGlobalId(), null, SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((int)1, (Integer)results.getCount());
        Assertions.assertEquals((int)1, (int)results.getArtifacts().size());
        Assertions.assertEquals((Object)artifactId, (Object)((SearchedArtifact)results.getArtifacts().get(0)).getId());
        ArtifactSearchResults resultsByContentId = this.clientV2.searchArtifacts(null, null, null, null, null, null, amd.getContentId(), SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertNotNull((Object)resultsByContentId);
        Assertions.assertEquals((int)2, (Integer)resultsByContentId.getCount());
        Assertions.assertEquals((int)2, (int)resultsByContentId.getArtifacts().size());
        Assertions.assertEquals((long)2L, (long)resultsByContentId.getArtifacts().stream().filter(sa -> sa.getId().equals(amd.getId()) || sa.getId().equals(amd2.getId())).count());
    }

    @Test
    void testSearchVersion() throws Exception {
        String groupId = "testSearchVersion";
        this.clientV2.listArtifactsInGroup("testSearchVersion");
        String artifactId = UUID.randomUUID().toString();
        String name = "n" + ThreadLocalRandom.current().nextInt(1000000);
        InputStream artifactData = IoUtil.toStream((byte[])("{\"type\":\"record\",\"title\":\"" + name + "\",\"fields\":[{\"name\":\"foo\",\"type\":\"string\"}]}").getBytes(StandardCharsets.UTF_8));
        ArtifactMetaData amd = this.clientV2.createArtifact("testSearchVersion", artifactId, "JSON", artifactData);
        long id1 = amd.getGlobalId();
        this.waitForGlobalId(id1);
        artifactData.reset();
        VersionMetaData vmd = this.clientV2.createArtifactVersion("testSearchVersion", artifactId, null, artifactData);
        long id2 = vmd.getGlobalId();
        this.waitForGlobalId(id2);
        VersionSearchResults results = this.clientV2.listArtifactVersions("testSearchVersion", artifactId, Integer.valueOf(0), Integer.valueOf(2));
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((int)2, (Integer)results.getCount());
        Assertions.assertEquals((int)2, (int)results.getVersions().size());
        Assertions.assertEquals((Object)name, (Object)((SearchedVersion)results.getVersions().get(0)).getName());
    }

    @Test
    void testSearchDisabledArtifacts() throws Exception {
        String groupId = "testSearchDisabledArtifacts";
        this.clientV2.listArtifactsInGroup("testSearchDisabledArtifacts");
        String root = "testSearchDisabledArtifact" + ThreadLocalRandom.current().nextInt(1000000);
        ArrayList<CallSite> artifactIds = new ArrayList<CallSite>();
        ArrayList<String> versions = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            String artifactId = root + UUID.randomUUID().toString();
            String name = root + i;
            InputStream artifactData = IoUtil.toStream((byte[])("{\"type\":\"record\",\"title\":\"" + name + "\",\"fields\":[{\"name\":\"foo\",\"type\":\"string\"}]}").getBytes(StandardCharsets.UTF_8));
            ArtifactMetaData md = this.clientV2.createArtifact("testSearchDisabledArtifacts", artifactId, "JSON", artifactData);
            this.waitForArtifact("testSearchDisabledArtifacts", artifactId);
            artifactIds.add((CallSite)((Object)artifactId));
            versions.add(md.getVersion());
        }
        ArtifactSearchResults results = this.clientV2.searchArtifacts(null, root, null, null, null, SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((int)5, (Integer)results.getCount());
        Assertions.assertEquals((int)5, (int)results.getArtifacts().size());
        Assertions.assertTrue((boolean)results.getArtifacts().stream().map(SearchedArtifact::getId).collect(Collectors.toList()).containsAll(artifactIds));
        UpdateState us = new UpdateState();
        us.setState(ArtifactState.DISABLED);
        this.clientV2.updateArtifactState("testSearchDisabledArtifacts", (String)artifactIds.get(0), us);
        this.waitForVersionState("testSearchDisabledArtifacts", (String)artifactIds.get(0), (String)versions.get(0), ArtifactState.DISABLED);
        this.clientV2.updateArtifactState("testSearchDisabledArtifacts", (String)artifactIds.get(3), us);
        this.waitForVersionState("testSearchDisabledArtifacts", (String)artifactIds.get(3), (String)versions.get(0), ArtifactState.DISABLED);
        results = this.clientV2.searchArtifacts(null, root, null, null, null, SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((int)5, (Integer)results.getCount());
        Assertions.assertEquals((int)5, (int)results.getArtifacts().size());
        Assertions.assertTrue((boolean)results.getArtifacts().stream().map(SearchedArtifact::getId).collect(Collectors.toList()).containsAll(artifactIds));
        Assertions.assertEquals((long)2L, (long)results.getArtifacts().stream().filter(searchedArtifact -> ArtifactState.DISABLED.equals((Object)searchedArtifact.getState())).count());
        Assertions.assertEquals((long)3L, (long)results.getArtifacts().stream().filter(searchedArtifact -> ArtifactState.ENABLED.equals((Object)searchedArtifact.getState())).count());
    }

    @Test
    void testSearchDisabledVersions() throws Exception {
        String groupId = "testSearchDisabledVersions";
        this.clientV2.listArtifactsInGroup("testSearchDisabledVersions");
        String artifactId = UUID.randomUUID().toString();
        String name = "testSearchDisabledVersions" + ThreadLocalRandom.current().nextInt(1000000);
        InputStream artifactData = IoUtil.toStream((byte[])("{\"type\":\"record\",\"title\":\"" + name + "\",\"fields\":[{\"name\":\"foo\",\"type\":\"string\"}]}").getBytes(StandardCharsets.UTF_8));
        this.clientV2.createArtifact("testSearchDisabledVersions", artifactId, "JSON", artifactData);
        this.waitForArtifact("testSearchDisabledVersions", artifactId);
        artifactData.reset();
        this.clientV2.createArtifactVersion("testSearchDisabledVersions", artifactId, null, artifactData);
        this.waitForVersion("testSearchDisabledVersions", artifactId, 2);
        artifactData.reset();
        this.clientV2.createArtifactVersion("testSearchDisabledVersions", artifactId, null, artifactData);
        this.waitForVersion("testSearchDisabledVersions", artifactId, 3);
        VersionSearchResults results = this.clientV2.listArtifactVersions("testSearchDisabledVersions", artifactId, Integer.valueOf(0), Integer.valueOf(5));
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((int)3, (Integer)results.getCount());
        Assertions.assertEquals((int)3, (int)results.getVersions().size());
        Assertions.assertTrue((boolean)results.getVersions().stream().allMatch(searchedVersion -> name.equals(searchedVersion.getName()) && ArtifactState.ENABLED.equals((Object)searchedVersion.getState())));
        UpdateState us = new UpdateState();
        us.setState(ArtifactState.DISABLED);
        this.clientV2.updateArtifactVersionState("testSearchDisabledVersions", artifactId, "1", us);
        this.waitForVersionState("testSearchDisabledVersions", artifactId, "1", ArtifactState.DISABLED);
        this.clientV2.updateArtifactVersionState("testSearchDisabledVersions", artifactId, "3", us);
        this.waitForVersionState("testSearchDisabledVersions", artifactId, "3", ArtifactState.DISABLED);
        results = this.clientV2.listArtifactVersions("testSearchDisabledVersions", artifactId, Integer.valueOf(0), Integer.valueOf(5));
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((int)3, (Integer)results.getCount());
        Assertions.assertEquals((int)3, (int)results.getVersions().size());
        Assertions.assertTrue((boolean)results.getVersions().stream().allMatch(searchedVersion -> name.equals(searchedVersion.getName())));
        Assertions.assertEquals((long)2L, (long)results.getVersions().stream().filter(searchedVersion -> ArtifactState.DISABLED.equals((Object)searchedVersion.getState())).count());
        Assertions.assertEquals((long)1L, (long)results.getVersions().stream().filter(searchedVersion -> ArtifactState.ENABLED.equals((Object)searchedVersion.getState())).count());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLabels() throws Exception {
        String groupId = "testLabels";
        String artifactId = this.generateArtifactId();
        try {
            InputStream stream = IoUtil.toStream((byte[])ARTIFACT_CONTENT.getBytes(StandardCharsets.UTF_8));
            this.clientV2.createArtifact("testLabels", artifactId, "JSON", stream);
            this.waitForArtifact("testLabels", artifactId);
            EditableMetaData emd = new EditableMetaData();
            emd.setName("testLabels");
            List<String> artifactLabels = Arrays.asList("Open Api", "Awesome Artifact", "JSON", "registry-client-test-testLabels");
            emd.setLabels(artifactLabels);
            this.clientV2.updateArtifactMetaData("testLabels", artifactId, emd);
            TestUtils.retry(() -> {
                ArtifactMetaData artifactMetaData = this.clientV2.getArtifactMetaData("testLabels", artifactId);
                Assertions.assertNotNull((Object)artifactMetaData);
                Assertions.assertEquals((Object)"testLabels", (Object)artifactMetaData.getName());
                Assertions.assertEquals((int)4, (int)artifactMetaData.getLabels().size());
                Assertions.assertTrue((boolean)artifactMetaData.getLabels().containsAll(artifactLabels));
            });
            TestUtils.retry(() -> {
                ArtifactSearchResults results = this.clientV2.searchArtifacts(null, "testLabels", null, null, null, SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
                Assertions.assertNotNull((Object)results);
                Assertions.assertEquals((int)1, (Integer)results.getCount());
                Assertions.assertEquals((int)1, (int)results.getArtifacts().size());
                Assertions.assertTrue((boolean)((SearchedArtifact)results.getArtifacts().get(0)).getLabels().containsAll(artifactLabels));
            });
        }
        finally {
            this.clientV2.deleteArtifact("testLabels", artifactId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProperties() throws Exception {
        String groupId = "testProperties";
        String artifactId = this.generateArtifactId();
        try {
            InputStream stream = IoUtil.toStream((byte[])ARTIFACT_CONTENT.getBytes(StandardCharsets.UTF_8));
            this.clientV2.createArtifact("testProperties", artifactId, "JSON", stream);
            this.waitForArtifact("testProperties", artifactId);
            EditableMetaData emd = new EditableMetaData();
            emd.setName("testProperties");
            HashMap<String, String> artifactProperties = new HashMap<String, String>();
            artifactProperties.put("extraProperty1", "value for extra property 1");
            artifactProperties.put("extraProperty2", "value for extra property 2");
            artifactProperties.put("extraProperty3", "value for extra property 3");
            emd.setProperties(artifactProperties);
            this.clientV2.updateArtifactMetaData("testProperties", artifactId, emd);
            TestUtils.retry(() -> {
                ArtifactMetaData artifactMetaData = this.clientV2.getArtifactMetaData("testProperties", artifactId);
                Assertions.assertNotNull((Object)artifactMetaData);
                Assertions.assertEquals((Object)"testProperties", (Object)artifactMetaData.getName());
                Assertions.assertEquals((int)3, (int)artifactMetaData.getProperties().size());
                Assertions.assertTrue((boolean)artifactMetaData.getProperties().keySet().containsAll(artifactProperties.keySet()));
                for (String key : artifactMetaData.getProperties().keySet()) {
                    Assertions.assertEquals(artifactMetaData.getProperties().get(key), artifactProperties.get(key));
                }
            });
        }
        finally {
            this.clientV2.deleteArtifact("testProperties", artifactId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void nameOrderingTest() throws Exception {
        String groupId = "nameOrderingTest";
        String firstArtifactId = this.generateArtifactId();
        String secondArtifactId = this.generateArtifactId();
        String thirdArtifactId = "cccTestorder";
        try {
            this.clientV2.listArtifactsInGroup("nameOrderingTest");
            String firstName = "aaaTestorder" + ThreadLocalRandom.current().nextInt(1000000);
            InputStream artifactData = IoUtil.toStream((byte[])("{\"type\":\"record\",\"title\":\"" + firstName + "\",\"fields\":[{\"name\":\"foo\",\"type\":\"string\"}]}").getBytes(StandardCharsets.UTF_8));
            ArtifactMetaData amd = this.clientV2.createArtifact("nameOrderingTest", firstArtifactId, "JSON", artifactData);
            long id = amd.getGlobalId();
            this.waitForGlobalId(id);
            String secondName = "bbbTestorder" + ThreadLocalRandom.current().nextInt(1000000);
            InputStream secondData = IoUtil.toStream((byte[])("{\"type\":\"record\",\"title\":\"" + secondName + "\",\"fields\":[{\"name\":\"foo\",\"type\":\"string\"}]}").getBytes(StandardCharsets.UTF_8));
            ArtifactMetaData secondCs = this.clientV2.createArtifact("nameOrderingTest", secondArtifactId, "JSON", secondData);
            long secondId = secondCs.getGlobalId();
            this.waitForGlobalId(secondId);
            InputStream thirdData = IoUtil.toStream((byte[])"{\"openapi\":\"3.0.2\",\"info\":{\"description\":\"testorder\"}}".getBytes(StandardCharsets.UTF_8));
            ArtifactMetaData thirdCs = this.clientV2.createArtifact("nameOrderingTest", "cccTestorder", "OPENAPI", thirdData);
            long thirdId = thirdCs.getGlobalId();
            this.waitForGlobalId(thirdId);
            TestUtils.retry(() -> {
                ArtifactMetaData artifactMetaData = this.clientV2.getArtifactMetaData("nameOrderingTest", "cccTestorder");
                Assertions.assertNotNull((Object)artifactMetaData);
                Assertions.assertEquals((Object)"testorder", (Object)artifactMetaData.getDescription());
            });
            ArtifactSearchResults ascResults = this.clientV2.searchArtifacts("nameOrderingTest", "Testorder", null, null, null, SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
            Assertions.assertNotNull((Object)ascResults);
            Assertions.assertEquals((int)3, (Integer)ascResults.getCount());
            Assertions.assertEquals((int)3, (int)ascResults.getArtifacts().size());
            Assertions.assertEquals((Object)firstName, (Object)((SearchedArtifact)ascResults.getArtifacts().get(0)).getName());
            Assertions.assertEquals((Object)secondName, (Object)((SearchedArtifact)ascResults.getArtifacts().get(1)).getName());
            Assertions.assertNull((Object)((SearchedArtifact)ascResults.getArtifacts().get(2)).getName());
            ArtifactSearchResults descResults = this.clientV2.searchArtifacts("nameOrderingTest", "Testorder", null, null, null, SortBy.name, SortOrder.desc, Integer.valueOf(0), Integer.valueOf(10));
            Assertions.assertNotNull((Object)descResults);
            Assertions.assertEquals((int)3, (Integer)descResults.getCount());
            Assertions.assertEquals((int)3, (int)descResults.getArtifacts().size());
            Assertions.assertNull((Object)((SearchedArtifact)descResults.getArtifacts().get(0)).getName());
            Assertions.assertEquals((Object)secondName, (Object)((SearchedArtifact)descResults.getArtifacts().get(1)).getName());
            Assertions.assertEquals((Object)firstName, (Object)((SearchedArtifact)descResults.getArtifacts().get(2)).getName());
        }
        finally {
            this.clientV2.deleteArtifact("nameOrderingTest", firstArtifactId);
            this.clientV2.deleteArtifact("nameOrderingTest", secondArtifactId);
            this.clientV2.deleteArtifact("nameOrderingTest", "cccTestorder");
        }
    }

    @Test
    public void getLatestArtifact() throws Exception {
        String groupId = "getLatestArtifact";
        String artifactId = this.generateArtifactId();
        this.createArtifact("getLatestArtifact", artifactId);
        InputStream amd = this.clientV2.getLatestArtifact("getLatestArtifact", artifactId);
        Assertions.assertNotNull((Object)amd);
        Assertions.assertEquals((Object)ARTIFACT_CONTENT, (Object)IoUtil.toString((InputStream)amd));
    }

    @Test
    public void getContentById() throws Exception {
        String groupId = "getContentById";
        String artifactId = this.generateArtifactId();
        ArtifactMetaData amd = this.createArtifact("getContentById", artifactId);
        Assertions.assertNotNull((Object)amd.getContentId());
        InputStream content = this.clientV2.getContentById(amd.getContentId().longValue());
        Assertions.assertNotNull((Object)content);
        Assertions.assertEquals((Object)ARTIFACT_CONTENT, (Object)IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void testArtifactNotFound() {
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> this.clientV2.getArtifactMetaData(UUID.randomUUID().toString(), UUID.randomUUID().toString()));
    }

    @Test
    public void getArtifactVersionMetadataByContent() throws Exception {
        String groupId = "getArtifactVersionMetadataByContent";
        String artifactId = this.generateArtifactId();
        this.createArtifact("getArtifactVersionMetadataByContent", artifactId);
        VersionMetaData versionMetaData = this.clientV2.getArtifactVersionMetaDataByContent("getArtifactVersionMetadataByContent", artifactId, IoUtil.toStream((String)ARTIFACT_CONTENT));
        Assertions.assertNotNull((Object)versionMetaData);
        String secondArtifactId = this.generateArtifactId();
        ArtifactReference artifactReference = new ArtifactReference();
        artifactReference.setName("testReference");
        artifactReference.setArtifactId(artifactId);
        artifactReference.setGroupId("getArtifactVersionMetadataByContent");
        artifactReference.setVersion("1");
        List<ArtifactReference> artifactReferences = List.of(artifactReference);
        this.createArtifactWithReferences("getArtifactVersionMetadataByContent", secondArtifactId, artifactReferences);
        ArtifactContent artifactContent = new ArtifactContent();
        artifactContent.setContent(ARTIFACT_CONTENT);
        artifactContent.setReferences(artifactReferences);
        VersionMetaData secondVersionMetadata = this.clientV2.getArtifactVersionMetaDataByContent("getArtifactVersionMetadataByContent", secondArtifactId, artifactContent);
        Assertions.assertNotEquals((Long)secondVersionMetadata.getContentId(), (Long)versionMetaData.getContentId());
    }

    @Test
    public void getContentByHash() throws Exception {
        String groupId = "getContentByHash";
        String artifactId = this.generateArtifactId();
        String contentHash = DigestUtils.sha256Hex((String)ARTIFACT_CONTENT);
        this.createArtifact("getContentByHash", artifactId);
        InputStream content = this.clientV2.getContentByHash(contentHash);
        Assertions.assertNotNull((Object)content);
        String artifactContent = IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)ARTIFACT_CONTENT, (Object)artifactContent);
        String secondArtifactId = this.generateArtifactId();
        ArtifactReference artifactReference = new ArtifactReference();
        artifactReference.setName("testReference");
        artifactReference.setArtifactId(artifactId);
        artifactReference.setGroupId("getContentByHash");
        artifactReference.setVersion("1");
        List<ArtifactReference> artifactReferences = List.of(artifactReference);
        this.createArtifactWithReferences("getContentByHash", secondArtifactId, artifactReferences);
        String referencesSerialized = SqlUtil.serializeReferences(this.toReferenceDtos(artifactReferences));
        contentHash = DigestUtils.sha256Hex((byte[])this.concatContentAndReferences(ARTIFACT_CONTENT.getBytes(StandardCharsets.UTF_8), referencesSerialized));
        content = this.clientV2.getContentByHash(contentHash);
        Assertions.assertNotNull((Object)content);
        artifactContent = IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)ARTIFACT_CONTENT, (Object)artifactContent);
    }

    @Test
    public void getContentByGlobalId() throws Exception {
        String groupId = "getContentByGlobalId";
        String artifactId = this.generateArtifactId();
        ArtifactMetaData amd = this.createArtifact("getContentByGlobalId", artifactId);
        TestUtils.retry(() -> {
            InputStream content = this.clientV2.getContentByGlobalId(amd.getGlobalId().longValue());
            Assertions.assertNotNull((Object)content);
            String artifactContent = IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8);
            Assertions.assertEquals((Object)ARTIFACT_CONTENT, (Object)artifactContent);
        });
    }

    @Test
    public void getArtifactVersionMetaDataByContent() throws Exception {
        String groupId = "getArtifactVersionMetaDataByContent";
        String artifactId = this.generateArtifactId();
        ArtifactMetaData amd = this.createArtifact("getArtifactVersionMetaDataByContent", artifactId);
        VersionMetaData vmd = this.clientV2.getArtifactVersionMetaDataByContent("getArtifactVersionMetaDataByContent", artifactId, IoUtil.toStream((byte[])ARTIFACT_CONTENT.getBytes()));
        Assertions.assertEquals((Long)amd.getGlobalId(), (Long)vmd.getGlobalId());
        Assertions.assertEquals((Object)amd.getId(), (Object)vmd.getId());
        Assertions.assertEquals((Long)amd.getContentId(), (Long)vmd.getContentId());
    }

    @Test
    public void listArtifactRules() throws Exception {
        String groupId = "listArtifactRules";
        String artifactId = this.generateArtifactId();
        this.createArtifact("listArtifactRules", artifactId);
        TestUtils.retry(() -> {
            List emptyRules = this.clientV2.listArtifactRules("listArtifactRules", artifactId);
            Assertions.assertNotNull((Object)emptyRules);
            Assertions.assertTrue((boolean)emptyRules.isEmpty());
        });
        this.createArtifactRule("listArtifactRules", artifactId, RuleType.COMPATIBILITY, "BACKWARD");
        TestUtils.retry(() -> {
            List ruleTypes = this.clientV2.listArtifactRules("listArtifactRules", artifactId);
            Assertions.assertNotNull((Object)ruleTypes);
            Assertions.assertFalse((boolean)ruleTypes.isEmpty());
        });
    }

    @Test
    public void testCompatibilityWithReferences() throws Exception {
        String groupId = "testCompatibilityWithReferences";
        String artifactId = this.generateArtifactId();
        this.createArtifact("testCompatibilityWithReferences", artifactId, "AVRO", REFERENCED_SCHEMA);
        ArtifactReference artifactReference = new ArtifactReference();
        artifactReference.setArtifactId(artifactId);
        artifactReference.setGroupId("testCompatibilityWithReferences");
        artifactReference.setVersion("1");
        artifactReference.setName("com.example.common.ItemId");
        String secondArtifactId = this.generateArtifactId();
        Integer globalId = this.createArtifactWithReferences("testCompatibilityWithReferences", secondArtifactId, "AVRO", SCHEMA_WITH_REFERENCE, List.of(artifactReference));
        this.createArtifactRule("testCompatibilityWithReferences", secondArtifactId, RuleType.COMPATIBILITY, "BACKWARD");
        this.updateArtifactWithReferences("testCompatibilityWithReferences", secondArtifactId, "AVRO", SCHEMA_WITH_REFERENCE, List.of(artifactReference));
        this.clientV2.deleteArtifact("testCompatibilityWithReferences", artifactId);
        this.clientV2.deleteArtifact("testCompatibilityWithReferences", secondArtifactId);
    }

    @Test
    public void deleteArtifactRules() throws Exception {
        String groupId = "deleteArtifactRules";
        String artifactId = this.generateArtifactId();
        this.prepareRuleTest("deleteArtifactRules", artifactId, RuleType.COMPATIBILITY, "BACKWARD");
        this.clientV2.deleteArtifactRules("deleteArtifactRules", artifactId);
        TestUtils.retry(() -> {
            List emptyRules = this.clientV2.listArtifactRules("deleteArtifactRules", artifactId);
            Assertions.assertNotNull((Object)emptyRules);
            Assertions.assertTrue((boolean)emptyRules.isEmpty());
        });
    }

    @Test
    public void getArtifactRuleConfig() throws Exception {
        String groupId = "getArtifactRuleConfig";
        String artifactId = this.generateArtifactId();
        this.prepareRuleTest("getArtifactRuleConfig", artifactId, RuleType.COMPATIBILITY, "BACKWARD");
        TestUtils.retry(() -> {
            Rule rule = this.clientV2.getArtifactRuleConfig("getArtifactRuleConfig", artifactId, RuleType.COMPATIBILITY);
            Assertions.assertNotNull((Object)rule);
            Assertions.assertEquals((Object)"BACKWARD", (Object)rule.getConfig());
        });
    }

    @Test
    public void updateArtifactRuleConfig() throws Exception {
        String groupId = "updateArtifactRuleConfig";
        String artifactId = this.generateArtifactId();
        this.prepareRuleTest("updateArtifactRuleConfig", artifactId, RuleType.COMPATIBILITY, "BACKWARD");
        TestUtils.retry(() -> {
            Rule rule = this.clientV2.getArtifactRuleConfig("updateArtifactRuleConfig", artifactId, RuleType.COMPATIBILITY);
            Assertions.assertNotNull((Object)rule);
            Assertions.assertEquals((Object)"BACKWARD", (Object)rule.getConfig());
        });
        Rule toUpdate = new Rule();
        toUpdate.setType(RuleType.COMPATIBILITY);
        toUpdate.setConfig("FULL");
        Rule updated = this.clientV2.updateArtifactRuleConfig("updateArtifactRuleConfig", artifactId, RuleType.COMPATIBILITY, toUpdate);
        Assertions.assertNotNull((Object)updated);
        Assertions.assertEquals((Object)"FULL", (Object)updated.getConfig());
    }

    @Test
    public void testUpdateArtifact() throws Exception {
        String groupId = "testUpdateArtifact";
        String artifactId = this.generateArtifactId();
        this.createArtifact("testUpdateArtifact", artifactId);
        String updatedContent = UPDATED_CONTENT;
        String version = "3";
        String name = "testUpdateArtifactName";
        String description = "testUpdateArtifactDescription";
        InputStream stream = IoUtil.toStream((byte[])UPDATED_CONTENT.getBytes(StandardCharsets.UTF_8));
        this.clientV2.updateArtifact("testUpdateArtifact", artifactId, "3", "testUpdateArtifactName", "testUpdateArtifactDescription", stream);
        Assertions.assertEquals((Object)UPDATED_CONTENT, (Object)IoUtil.toString((InputStream)this.clientV2.getLatestArtifact("testUpdateArtifact", artifactId)));
        ArtifactMetaData artifactMetaData = this.clientV2.getArtifactMetaData("testUpdateArtifact", artifactId);
        Assertions.assertNotNull((Object)artifactMetaData);
        Assertions.assertEquals((Object)"3", (Object)artifactMetaData.getVersion());
        Assertions.assertEquals((Object)"testUpdateArtifactName", (Object)artifactMetaData.getName());
        Assertions.assertEquals((Object)"testUpdateArtifactDescription", (Object)artifactMetaData.getDescription());
    }

    @Test
    public void testUpdateYamlArtifact() throws Exception {
        String groupId = "testUpdateYamlArtifact";
        String artifactId = this.generateArtifactId();
        this.createOpenAPIArtifact("testUpdateYamlArtifact", artifactId);
        String version = "3";
        String name = "testUpdateYamlArtifactName";
        String description = "testUpdateYamlArtifactDescription";
        InputStream stream = IoUtil.toStream((byte[])UPDATED_OPENAPI_YAML_CONTENT.getBytes(StandardCharsets.UTF_8));
        this.clientV2.updateArtifact("testUpdateYamlArtifact", artifactId, "3", "testUpdateYamlArtifactName", "testUpdateYamlArtifactDescription", "application/x-yaml", stream);
        RegistryClientTest.assertMultilineTextEquals(UPDATED_OPENAPI_JSON_CONTENT, IoUtil.toString((InputStream)this.clientV2.getLatestArtifact("testUpdateYamlArtifact", artifactId)));
        ArtifactMetaData artifactMetaData = this.clientV2.getArtifactMetaData("testUpdateYamlArtifact", artifactId);
        Assertions.assertNotNull((Object)artifactMetaData);
        Assertions.assertEquals((Object)"3", (Object)artifactMetaData.getVersion());
        Assertions.assertEquals((Object)"testUpdateYamlArtifactName", (Object)artifactMetaData.getName());
        Assertions.assertEquals((Object)"testUpdateYamlArtifactDescription", (Object)artifactMetaData.getDescription());
    }

    @Test
    public void deleteArtifactsInGroup() throws Exception {
        String groupId = "deleteArtifactsInGroup";
        String firstArtifactId = this.generateArtifactId();
        String secondArtifactId = this.generateArtifactId();
        this.createArtifact("deleteArtifactsInGroup", firstArtifactId);
        this.createArtifact("deleteArtifactsInGroup", secondArtifactId);
        ArtifactSearchResults searchResults = this.clientV2.listArtifactsInGroup("deleteArtifactsInGroup");
        Assertions.assertFalse((boolean)searchResults.getArtifacts().isEmpty());
        Assertions.assertEquals((int)2, (int)searchResults.getCount());
        this.clientV2.deleteArtifactsInGroup("deleteArtifactsInGroup");
        TestUtils.retry(() -> {
            ArtifactSearchResults deleted = this.clientV2.listArtifactsInGroup("deleteArtifactsInGroup");
            Assertions.assertTrue((boolean)deleted.getArtifacts().isEmpty());
            Assertions.assertEquals((int)0, (int)deleted.getCount());
        });
    }

    @Test
    public void searchArtifactsByContent() throws Exception {
        String groupId = "searchArtifactsByContent";
        String firstArtifactId = this.generateArtifactId();
        String secondArtifactId = this.generateArtifactId();
        String content = "{\"name\":\"" + TestUtils.generateSubject() + "\"}";
        this.createArtifact("searchArtifactsByContent", firstArtifactId, "AVRO", content);
        this.createArtifact("searchArtifactsByContent", secondArtifactId, "AVRO", content);
        ArtifactSearchResults searchResults = this.clientV2.searchArtifactsByContent(IoUtil.toStream((String)content), null, null, null, null);
        Assertions.assertEquals((int)2, (Integer)searchResults.getCount());
    }

    @Test
    public void smokeGlobalRules() throws Exception {
        this.createGlobalRule(RuleType.COMPATIBILITY, "BACKWARD");
        this.createGlobalRule(RuleType.VALIDITY, "FORWARD");
        TestUtils.retry(() -> {
            List globalRules = this.clientV2.listGlobalRules();
            Assertions.assertEquals((int)2, (int)globalRules.size());
            Assertions.assertTrue((boolean)globalRules.contains(RuleType.COMPATIBILITY));
            Assertions.assertTrue((boolean)globalRules.contains(RuleType.VALIDITY));
        });
        this.clientV2.deleteAllGlobalRules();
        TestUtils.retry(() -> {
            List updatedRules = this.clientV2.listGlobalRules();
            Assertions.assertEquals((int)0, (int)updatedRules.size());
        });
    }

    @Test
    public void getGlobalRuleConfig() throws Exception {
        this.createGlobalRule(RuleType.COMPATIBILITY, "BACKWARD");
        TestUtils.retry(() -> {
            Rule globalRuleConfig = this.clientV2.getGlobalRuleConfig(RuleType.COMPATIBILITY);
            Assertions.assertEquals((Object)globalRuleConfig.getConfig(), (Object)"BACKWARD");
        });
    }

    @Test
    public void updateGlobalRuleConfig() throws Exception {
        this.createGlobalRule(RuleType.COMPATIBILITY, "BACKWARD");
        TestUtils.retry(() -> {
            Rule globalRuleConfig = this.clientV2.getGlobalRuleConfig(RuleType.COMPATIBILITY);
            Assertions.assertEquals((Object)globalRuleConfig.getConfig(), (Object)"BACKWARD");
        });
        Rule toUpdate = new Rule();
        toUpdate.setType(RuleType.COMPATIBILITY);
        toUpdate.setConfig("FORWARD");
        Rule updated = this.clientV2.updateGlobalRuleConfig(RuleType.COMPATIBILITY, toUpdate);
        Assertions.assertEquals((Object)updated.getConfig(), (Object)"FORWARD");
    }

    @Test
    public void deleteGlobalRule() throws Exception {
        this.createGlobalRule(RuleType.COMPATIBILITY, "BACKWARD");
        TestUtils.retry(() -> {
            Rule globalRuleConfig = this.clientV2.getGlobalRuleConfig(RuleType.COMPATIBILITY);
            Assertions.assertEquals((Object)globalRuleConfig.getConfig(), (Object)"BACKWARD");
        });
        this.clientV2.deleteGlobalRule(RuleType.COMPATIBILITY);
        TestUtils.retry(() -> {
            List ruleTypes = this.clientV2.listGlobalRules();
            Assertions.assertEquals((int)0, (int)ruleTypes.size());
        });
    }

    @Test
    public void smokeLogLevels() throws Exception {
        String logger = "smokeLogLevels";
        this.clientV2.listLogConfigurations();
        this.setLogLevel("smokeLogLevels", LogLevel.DEBUG);
        NamedLogConfiguration logConfiguration = this.clientV2.getLogConfiguration("smokeLogLevels");
        Assertions.assertEquals((Object)LogLevel.DEBUG, (Object)logConfiguration.getLevel());
        Assertions.assertEquals((Object)"smokeLogLevels", (Object)logConfiguration.getName());
        List logConfigurations = this.clientV2.listLogConfigurations();
        Assertions.assertTrue((logConfigurations.size() >= 1 ? 1 : 0) != 0);
        this.clientV2.removeLogConfiguration("smokeLogLevels");
    }

    @Test
    @DisabledIfEnvironmentVariable(named="CURRENT_ENV", matches=".*mas.*")
    public void testDefaultGroup() throws Exception {
        String nullDefaultGroup = null;
        String artifactId1 = "testDefaultGroup-" + UUID.randomUUID().toString();
        this.createArtifact(nullDefaultGroup, artifactId1);
        this.verifyGroupNullInMetadata(artifactId1, IoUtil.toStream((byte[])ARTIFACT_CONTENT.getBytes(StandardCharsets.UTF_8)));
        String defaultDefaultGroup = "default";
        String artifactId2 = "testDefaultGroup-" + UUID.randomUUID().toString();
        this.createArtifact(defaultDefaultGroup, artifactId2);
        this.verifyGroupNullInMetadata(artifactId2, IoUtil.toStream((byte[])ARTIFACT_CONTENT.getBytes(StandardCharsets.UTF_8)));
        String dummyGroup = "dummy";
        String artifactId3 = "testDefaultGroup-" + UUID.randomUUID().toString();
        this.createArtifact(dummyGroup, artifactId3);
        ArtifactSearchResults result = this.clientV2.searchArtifacts(null, null, null, null, null, null, null, null, Integer.valueOf(100));
        SearchedArtifact artifact1 = result.getArtifacts().stream().filter(s -> s.getId().equals(artifactId1)).findFirst().orElseThrow();
        Assertions.assertNull((Object)artifact1.getGroupId());
        SearchedArtifact artifact2 = result.getArtifacts().stream().filter(s -> s.getId().equals(artifactId2)).findFirst().orElseThrow();
        Assertions.assertNull((Object)artifact2.getGroupId());
        SearchedArtifact artifact3 = result.getArtifacts().stream().filter(s -> s.getId().equals(artifactId3)).findFirst().orElseThrow();
        Assertions.assertEquals((Object)dummyGroup, (Object)artifact3.getGroupId());
    }

    private void verifyGroupNullInMetadata(String artifactId, InputStream content) {
        ArtifactMetaData meta = this.clientV2.getArtifactMetaData(null, artifactId);
        Assertions.assertNull((Object)meta.getGroupId());
        VersionMetaData vmeta = this.clientV2.getArtifactVersionMetaData(null, artifactId, meta.getVersion());
        Assertions.assertNull((Object)vmeta.getGroupId());
        vmeta = this.clientV2.getArtifactVersionMetaDataByContent(null, artifactId, content);
        Assertions.assertNull((Object)vmeta.getGroupId());
        this.clientV2.listArtifactsInGroup(null).getArtifacts().stream().filter(s -> s.getId().equals(artifactId)).forEach(s -> Assertions.assertNull((Object)s.getGroupId()));
    }

    private ArtifactMetaData createArtifact(String groupId, String artifactId) throws Exception {
        InputStream stream = IoUtil.toStream((byte[])ARTIFACT_CONTENT.getBytes(StandardCharsets.UTF_8));
        ArtifactMetaData created = this.clientV2.createArtifact(groupId, artifactId, null, "JSON", IfExists.FAIL, Boolean.valueOf(false), stream);
        return this.checkArtifact(groupId, artifactId, created);
    }

    private ArtifactMetaData createArtifactWithReferences(String groupId, String artifactId, List<ArtifactReference> artifactReferences) throws Exception {
        InputStream stream = IoUtil.toStream((byte[])ARTIFACT_CONTENT.getBytes(StandardCharsets.UTF_8));
        ArtifactMetaData created = this.clientV2.createArtifact(groupId, artifactId, null, "JSON", IfExists.FAIL, Boolean.valueOf(false), null, null, "application/create.extended+json", null, null, stream, artifactReferences);
        return this.checkArtifact(groupId, artifactId, created);
    }

    @NotNull
    private ArtifactMetaData checkArtifact(String groupId, String artifactId, ArtifactMetaData created) throws Exception {
        this.waitForArtifact(groupId, artifactId);
        Assertions.assertNotNull((Object)created);
        if (groupId == null || groupId.equals("default")) {
            Assertions.assertNull((Object)created.getGroupId());
        } else {
            Assertions.assertEquals((Object)groupId, (Object)created.getGroupId());
        }
        Assertions.assertEquals((Object)artifactId, (Object)created.getId());
        return created;
    }

    private ArtifactMetaData createOpenAPIArtifact(String groupId, String artifactId) throws Exception {
        InputStream stream = IoUtil.toStream((byte[])ARTIFACT_OPENAPI_JSON_CONTENT.getBytes(StandardCharsets.UTF_8));
        ArtifactMetaData created = this.clientV2.createArtifact(groupId, artifactId, null, "OPENAPI", IfExists.FAIL, Boolean.valueOf(false), stream);
        return this.checkArtifact(groupId, artifactId, created);
    }

    private ArtifactMetaData createOpenAPIYamlArtifact(String groupId, String artifactId) throws Exception {
        InputStream stream = IoUtil.toStream((byte[])ARTIFACT_OPENAPI_YAML_CONTENT.getBytes(StandardCharsets.UTF_8));
        ArtifactMetaData created = this.clientV2.createArtifact(groupId, artifactId, null, "OPENAPI", IfExists.FAIL, Boolean.valueOf(false), stream);
        return this.checkArtifact(groupId, artifactId, created);
    }

    private void prepareRuleTest(String groupId, String artifactId, RuleType ruleType, String ruleConfig) throws Exception {
        this.createArtifact(groupId, artifactId);
        this.createArtifactRule(groupId, artifactId, ruleType, ruleConfig);
    }

    private void setLogLevel(String log, LogLevel logLevel) {
        LogConfiguration logConfiguration = new LogConfiguration();
        logConfiguration.setLevel(logLevel);
        this.clientV2.setLogConfiguration(log, logConfiguration);
    }

    @Test
    void headersCustomizationTest() throws Exception {
        String groupId = "headersCustomizationTest";
        Map<String, String> firstRequestHeaders = Collections.singletonMap("FirstHeaderKey", "firstheadervalue");
        Map<String, String> secondRequestHeaders = Collections.singletonMap("SecondHeaderKey", "secondheaderkey");
        this.testConcurrentClientCalls("headersCustomizationTest", this.clientV2, firstRequestHeaders, secondRequestHeaders);
        this.testNonConcurrentClientCalls("headersCustomizationTest", this.clientV2, firstRequestHeaders, secondRequestHeaders);
    }

    @Test
    public void testRoleMappings() throws Exception {
        List roleMappings = this.clientV2.listRoleMappings();
        Assertions.assertTrue((boolean)roleMappings.isEmpty());
        RoleMapping mapping = new RoleMapping();
        mapping.setPrincipalId("TestUser");
        mapping.setRole(RoleType.DEVELOPER);
        this.clientV2.createRoleMapping(mapping);
        TestUtils.retry(() -> {
            RoleMapping roleMapping = this.clientV2.getRoleMapping("TestUser");
            Assertions.assertEquals((Object)"TestUser", (Object)roleMapping.getPrincipalId());
            Assertions.assertEquals((Object)RoleType.DEVELOPER, (Object)roleMapping.getRole());
        });
        TestUtils.retry(() -> {
            List mappings = this.clientV2.listRoleMappings();
            Assertions.assertEquals((int)1, (int)mappings.size());
            Assertions.assertEquals((Object)"TestUser", (Object)((RoleMapping)mappings.get(0)).getPrincipalId());
            Assertions.assertEquals((Object)RoleType.DEVELOPER, (Object)((RoleMapping)mappings.get(0)).getRole());
        });
        TestUtils.retry(() -> Assertions.assertThrows(RoleMappingAlreadyExistsException.class, () -> this.clientV2.createRoleMapping(mapping)));
        mapping.setPrincipalId("TestUser2");
        mapping.setRole(RoleType.ADMIN);
        this.clientV2.createRoleMapping(mapping);
        TestUtils.retry(() -> {
            List mappings = this.clientV2.listRoleMappings();
            Assertions.assertEquals((int)2, (int)mappings.size());
        });
        RoleMapping tu2Mapping = this.clientV2.getRoleMapping("TestUser2");
        Assertions.assertEquals((Object)"TestUser2", (Object)tu2Mapping.getPrincipalId());
        Assertions.assertEquals((Object)RoleType.ADMIN, (Object)tu2Mapping.getRole());
        this.clientV2.updateRoleMapping("TestUser", RoleType.READ_ONLY);
        TestUtils.retry(() -> {
            RoleMapping tum = this.clientV2.getRoleMapping("TestUser");
            Assertions.assertEquals((Object)"TestUser", (Object)tum.getPrincipalId());
            Assertions.assertEquals((Object)RoleType.READ_ONLY, (Object)tum.getRole());
        });
        Assertions.assertThrows(RoleMappingNotFoundException.class, () -> this.clientV2.updateRoleMapping("UnknownPrincipal", RoleType.ADMIN));
        this.clientV2.deleteRoleMapping("TestUser2");
        TestUtils.retry(() -> Assertions.assertThrows(RoleMappingNotFoundException.class, () -> this.clientV2.getRoleMapping("TestUser2")));
        TestUtils.retry(() -> {
            List mappings = this.clientV2.listRoleMappings();
            Assertions.assertEquals((int)1, (int)mappings.size());
            Assertions.assertEquals((Object)"TestUser", (Object)((RoleMapping)mappings.get(0)).getPrincipalId());
        });
        this.clientV2.deleteRoleMapping("TestUser");
    }

    @Test
    public void testConfigProperties() throws Exception {
        String property1Name = "registry.ccompat.legacy-id-mode.enabled";
        String property2Name = "registry.ui.features.readOnly";
        List configProperties = this.clientV2.listConfigProperties();
        Assertions.assertFalse((boolean)configProperties.isEmpty());
        Optional<ConfigurationProperty> anonymousRead = configProperties.stream().filter(cp -> cp.getName().equals(property1Name)).findFirst();
        Assertions.assertTrue((boolean)anonymousRead.isPresent());
        Assertions.assertEquals((Object)"false", (Object)anonymousRead.get().getValue());
        Optional<ConfigurationProperty> obacLimit = configProperties.stream().filter(cp -> cp.getName().equals(property2Name)).findFirst();
        Assertions.assertTrue((boolean)obacLimit.isPresent());
        Assertions.assertEquals((Object)"false", (Object)obacLimit.get().getValue());
        this.clientV2.setConfigProperty(property1Name, "true");
        TestUtils.retry(() -> {
            ConfigurationProperty prop = this.clientV2.getConfigProperty(property1Name);
            Assertions.assertEquals((Object)property1Name, (Object)prop.getName());
            Assertions.assertEquals((Object)"true", (Object)prop.getValue());
        });
        TestUtils.retry(() -> {
            List properties = this.clientV2.listConfigProperties();
            ConfigurationProperty prop = properties.stream().filter(cp -> cp.getName().equals(property1Name)).findFirst().get();
            Assertions.assertEquals((Object)property1Name, (Object)prop.getName());
            Assertions.assertEquals((Object)"true", (Object)prop.getValue());
        });
        this.clientV2.setConfigProperty(property2Name, "true");
        TestUtils.retry(() -> {
            ConfigurationProperty prop = this.clientV2.getConfigProperty(property2Name);
            Assertions.assertEquals((Object)property2Name, (Object)prop.getName());
            Assertions.assertEquals((Object)"true", (Object)prop.getValue());
        });
        TestUtils.retry(() -> {
            List properties = this.clientV2.listConfigProperties();
            ConfigurationProperty prop = properties.stream().filter(cp -> cp.getName().equals(property2Name)).findFirst().get();
            Assertions.assertEquals((Object)"true", (Object)prop.getValue());
        });
        this.clientV2.deleteConfigProperty(property2Name);
        TestUtils.retry(() -> {
            ConfigurationProperty prop = this.clientV2.getConfigProperty(property2Name);
            Assertions.assertEquals((Object)property2Name, (Object)prop.getName());
            Assertions.assertEquals((Object)"false", (Object)prop.getValue());
        });
        TestUtils.retry(() -> {
            List properties = this.clientV2.listConfigProperties();
            ConfigurationProperty prop = properties.stream().filter(cp -> cp.getName().equals(property2Name)).findFirst().get();
            Assertions.assertEquals((Object)"false", (Object)prop.getValue());
        });
        this.clientV2.deleteConfigProperty(property1Name);
        TestUtils.retry(() -> {
            ConfigurationProperty prop = this.clientV2.getConfigProperty(property1Name);
            Assertions.assertEquals((Object)property1Name, (Object)prop.getName());
            Assertions.assertEquals((Object)"false", (Object)prop.getValue());
        });
        TestUtils.retry(() -> {
            List properties = this.clientV2.listConfigProperties();
            ConfigurationProperty prop = properties.stream().filter(cp -> cp.getName().equals(property1Name)).findFirst().get();
            Assertions.assertEquals((Object)property1Name, (Object)prop.getName());
            Assertions.assertEquals((Object)"false", (Object)prop.getValue());
        });
        Assertions.assertThrows(ConfigPropertyNotFoundException.class, () -> this.clientV2.setConfigProperty("property-does-not-exist", "foobar"));
        Assertions.assertThrows(InvalidPropertyValueException.class, () -> this.clientV2.setConfigProperty("registry.download.href.ttl", "foobar"));
    }

    private void testNonConcurrentClientCalls(String groupId, RegistryClient client, Map<String, String> firstRequestHeaders, Map<String, String> secondRequestHeaders) throws InterruptedException {
        client.setNextRequestHeaders(firstRequestHeaders);
        Assertions.assertTrue((boolean)client.getHeaders().keySet().containsAll(firstRequestHeaders.keySet()));
        client.listArtifactsInGroup(groupId);
        Assertions.assertFalse((boolean)client.getHeaders().keySet().containsAll(secondRequestHeaders.keySet()));
        Assertions.assertFalse((boolean)client.getHeaders().keySet().containsAll(firstRequestHeaders.keySet()));
        client.setNextRequestHeaders(secondRequestHeaders);
        Assertions.assertTrue((boolean)client.getHeaders().keySet().containsAll(secondRequestHeaders.keySet()));
        client.listArtifactsInGroup(groupId);
        Assertions.assertFalse((boolean)client.getHeaders().keySet().containsAll(secondRequestHeaders.keySet()));
        Assertions.assertFalse((boolean)client.getHeaders().keySet().containsAll(firstRequestHeaders.keySet()));
    }

    private void testConcurrentClientCalls(String groupId, RegistryClient client, Map<String, String> firstRequestHeaders, Map<String, String> secondRequestHeaders) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(2);
        new Thread(() -> {
            client.setNextRequestHeaders(firstRequestHeaders);
            Assertions.assertTrue((boolean)client.getHeaders().keySet().containsAll(firstRequestHeaders.keySet()));
            client.listArtifactsInGroup(groupId);
            Assertions.assertFalse((boolean)client.getHeaders().keySet().containsAll(secondRequestHeaders.keySet()));
            Assertions.assertFalse((boolean)client.getHeaders().keySet().containsAll(firstRequestHeaders.keySet()));
            latch.countDown();
        }).start();
        new Thread(() -> {
            client.setNextRequestHeaders(secondRequestHeaders);
            Assertions.assertTrue((boolean)client.getHeaders().keySet().containsAll(secondRequestHeaders.keySet()));
            client.listArtifactsInGroup(groupId);
            Assertions.assertFalse((boolean)client.getHeaders().keySet().containsAll(secondRequestHeaders.keySet()));
            Assertions.assertFalse((boolean)client.getHeaders().keySet().containsAll(firstRequestHeaders.keySet()));
            latch.countDown();
        }).start();
        latch.await();
    }

    @Test
    public void testForceArtifactType() throws Exception {
        InputStream artifactContent = this.resourceToInputStream("sample.wsdl");
        String groupId = TestUtils.generateGroupId();
        String artifactId = TestUtils.generateArtifactId();
        this.clientV2.createArtifact(groupId, artifactId, "AVRO", artifactContent);
        this.waitForArtifact(groupId, artifactId);
        ArtifactMetaData meta = this.clientV2.getArtifactMetaData(groupId, artifactId);
        Assertions.assertEquals((Object)"AVRO", (Object)meta.getType());
        Assertions.assertNotNull((Object)this.clientV2.getLatestArtifact(groupId, artifactId));
    }

    @Test
    public void testClientRateLimitError() {
        TooManyRequestsMock mock = new TooManyRequestsMock();
        mock.start();
        try {
            RegistryClient client = RegistryClientFactory.create((String)mock.getMockUrl());
            Assertions.assertThrows(RateLimitedClientException.class, () -> client.getLatestArtifact("test", "test"));
            Assertions.assertThrows(RateLimitedClientException.class, () -> client.createArtifact(null, "aaa", IoUtil.toStream((String)"{}")));
            Assertions.assertThrows(RateLimitedClientException.class, () -> client.getContentByGlobalId(5L));
        }
        finally {
            mock.stop();
        }
    }

    @Test
    public void testGetArtifactVersionByContent_DuplicateContent() throws Exception {
        String groupId = "testGetArtifactVersionByContent_DuplicateContent";
        String artifactId = this.generateArtifactId();
        ArtifactMetaData v1md = this.createArtifact("testGetArtifactVersionByContent_DuplicateContent", artifactId);
        InputStream v2stream = IoUtil.toStream((byte[])ARTIFACT_CONTENT.getBytes(StandardCharsets.UTF_8));
        VersionMetaData v2md = this.clientV2.createArtifactVersion("testGetArtifactVersionByContent_DuplicateContent", artifactId, null, v2stream);
        VersionMetaData vmd = this.clientV2.getArtifactVersionMetaDataByContent("testGetArtifactVersionByContent_DuplicateContent", artifactId, IoUtil.toStream((byte[])ARTIFACT_CONTENT.getBytes()));
        Assertions.assertNotEquals((Long)v1md.getGlobalId(), (Long)v2md.getGlobalId());
        Assertions.assertEquals((Long)v1md.getContentId(), (Long)v2md.getContentId());
        Assertions.assertEquals((Long)v2md.getGlobalId(), (Long)vmd.getGlobalId());
        Assertions.assertEquals((Object)v2md.getId(), (Object)vmd.getId());
        Assertions.assertEquals((Long)v2md.getContentId(), (Long)vmd.getContentId());
    }
}

