/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.CustomizeDateFormatTestProfile;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.inject.Inject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=CustomizeDateFormatTestProfile.class)
public class CustomizeDateFormatTest
extends AbstractResourceTestBase {
    private static final String GROUP = "CustomizeDateFormatTest";
    @Inject
    @ConfigProperty(name="registry.apis.v2.date-format")
    String dateFormat;
    @Inject
    @ConfigProperty(name="registry.apis.v2.date-format-timezone")
    String timezone;
    SimpleDateFormat newPattern;

    @BeforeAll
    public void init() {
        this.newPattern = new SimpleDateFormat(this.dateFormat);
        this.newPattern.setTimeZone(TimeZone.getTimeZone(this.timezone));
    }

    @Test
    public void testOpenApiCompliantDateFormat() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact(GROUP, "testGetArtifactMetaData/EmptyAPI", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testGetArtifactMetaData/EmptyAPI").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200)).body("createdOn", (Matcher)new BaseMatcher<Object>(){

            public void describeTo(Description description) {
            }

            public boolean matches(Object o) {
                try {
                    CustomizeDateFormatTest.this.newPattern.parse(o.toString());
                    return true;
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
        }, new Object[0]);
    }
}

