/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.DisableApisTestProfile;
import io.apicurio.registry.services.DisabledApisMatcherService;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.inject.Inject;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=DisableApisTestProfile.class)
@Tag(value="slow")
public class DisableApisFlagsTest
extends AbstractResourceTestBase {
    @Inject
    DisabledApisMatcherService matcherService;
    private static final String GROUP = "DisableApisFlagsTest";

    @Test
    public void testRegexp() {
        Assertions.assertTrue((boolean)this.matcherService.isDisabled("/apis/ibmcompat/v1/schemas"));
        Assertions.assertTrue((boolean)this.matcherService.isDisabled("/apis/ccompat/v6/subjects/abcfoo/versions"));
        Assertions.assertFalse((boolean)this.matcherService.isDisabled("/apis/ccompat/v6/subjects"));
        Assertions.assertTrue((boolean)this.matcherService.isDisabled("/ui/artifacts"));
    }

    @Test
    public void testRestApi() throws Exception {
        this.doTestDisabledApis(false);
    }

    public void doTestDisabledApis(boolean disabledDirectAccess) throws Exception {
        DisableApisFlagsTest.doTestDisabledSubPathRegexp(disabledDirectAccess);
        DisableApisFlagsTest.doTestDisabledPathExactMatch();
        DisableApisFlagsTest.doTestDisabledChildPathByParentPath(disabledDirectAccess);
        this.doTestUIDisabled();
        this.doTestArtifactVersionDeletionDisabled();
    }

    private void doTestArtifactVersionDeletionDisabled() throws Exception {
        String artifactContent = this.resourceToString("openapi-empty.json");
        this.createArtifact(GROUP, "testDeleteArtifactVersion/EmptyAPI", "OPENAPI", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testDeleteArtifactVersion/EmptyAPI").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testDeleteArtifactVersion/EmptyAPI").pathParam("version", (Object)"1").get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}", new Object[0])).then()).statusCode(200)).body("openapi", Matchers.equalTo((Object)"3.0.2"), new Object[0])).body("info.title", Matchers.equalTo((Object)"Empty API"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().pathParam("groupId", (Object)GROUP).pathParam("artifactId", (Object)"testDeleteArtifactVersion/EmptyAPI").pathParam("version", (Object)"1").delete("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}", new Object[0])).then()).statusCode(405)).body("message", Matchers.equalTo((Object)"Artifact version deletion operation is not enabled."), new Object[0]);
    }

    private void doTestUIDisabled() {
        ((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + this.testPort).when().get("/ui", new Object[0])).then()).statusCode(404);
    }

    private static void doTestDisabledSubPathRegexp(boolean disabledDirectAccess) {
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").body("{\"schema\":\"{\\\"type\\\": \\\"string\\\"}\"}").post("/ccompat/v6/subjects/{subject}/versions", new Object[]{UUID.randomUUID().toString()})).then()).statusCode(404);
        ValidatableResponse req = (ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").get("/ccompat/v6/subjects", new Object[0])).then();
        if (disabledDirectAccess) {
            req.statusCode(404);
        } else {
            ((ValidatableResponse)req.statusCode(200)).body(CoreMatchers.anything(), new Matcher[0]);
        }
    }

    private static void doTestDisabledPathExactMatch() {
        String schemaDefinition = "{\"type\":\"record\",\"name\":\"myrecord1\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}";
        String schemaName = "testVerifySchema_userInfo";
        String versionName = "testversion_1.0.0";
        ((ValidatableResponse)((Response)RestAssured.given().when().queryParam("verify", new Object[]{"true"}).contentType("application/json").body("{\"name\":\"" + schemaName + "\",\"version\":\"" + versionName + "\",\"definition\":\"" + schemaDefinition + "\"}").post("/ibmcompat/v1/schemas", new Object[0])).then()).statusCode(404);
    }

    private static void doTestDisabledChildPathByParentPath(boolean disabledDirectAccess) throws Exception {
        String artifactContent = "{\"type\":\"record\",\"name\":\"myrecord1\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}";
        String schemaId = TestUtils.generateArtifactId();
        ValidatableResponse req = (ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=AVRO").pathParam("groupId", (Object)"default").header("X-Registry-ArtifactId", (Object)schemaId, new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then();
        if (disabledDirectAccess) {
            req.statusCode(404);
        } else {
            req.statusCode(200);
        }
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/ibmcompat/v1/schemas/" + schemaId, new Object[0])).then()).statusCode(404);
    }
}

