/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import io.apicurio.registry.mt.MockTenantMetadataService;
import io.apicurio.registry.rest.MultipleRequestFiltersTestProfile;
import io.apicurio.registry.utils.tests.TestUtils;
import io.apicurio.tenantmanager.api.datamodel.ApicurioTenant;
import io.apicurio.tenantmanager.api.datamodel.TenantStatusValue;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.inject.Inject;
import java.util.UUID;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=MultipleRequestFiltersTestProfile.class)
@Tag(value="slow")
public class MultitenancyAndDisabledApisTest {
    @Inject
    MockTenantMetadataService tenantMetadataService;
    @ConfigProperty(name="quarkus.http.test-port")
    public int testPort;

    @Test
    public void testRestApi() throws Exception {
        this.doTestDisabledApis(true);
        ApicurioTenant tenant1 = new ApicurioTenant();
        tenant1.setTenantId("abc");
        tenant1.setOrganizationId("aaa");
        tenant1.setStatus(TenantStatusValue.READY);
        this.tenantMetadataService.createTenant(tenant1);
        ((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + this.testPort).when().contentType("application/vnd.schemaregistry+json").body("{\"schema\":\"{\\\"type\\\": \\\"string\\\"}\"}").post("/t/abc/apis/ccompat/v6/subjects/{subject}/versions", new Object[]{UUID.randomUUID().toString()})).then()).statusCode(404);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + this.testPort).when().contentType("application/json").get("/t/abc/apis/ccompat/v6/subjects", new Object[0])).then()).statusCode(200)).body(CoreMatchers.anything(), new Matcher[0]);
    }

    public void doTestDisabledApis(boolean disabledDirectAccess) throws Exception {
        MultitenancyAndDisabledApisTest.doTestDisabledSubPathRegexp(disabledDirectAccess);
        this.doTestDisabledPathExactMatch();
        this.doTestDisabledChildPathByParentPath(disabledDirectAccess);
        this.doTestUIDisabled();
    }

    private void doTestUIDisabled() {
        ((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + this.testPort).when().get("/ui", new Object[0])).then()).statusCode(404);
    }

    private static void doTestDisabledSubPathRegexp(boolean disabledDirectAccess) {
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").body("{\"schema\":\"{\\\"type\\\": \\\"string\\\"}\"}").post("/ccompat/v6/subjects/{subject}/versions", new Object[]{UUID.randomUUID().toString()})).then()).statusCode(404);
        ValidatableResponse req = (ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").get("/ccompat/v6/subjects", new Object[0])).then();
        if (disabledDirectAccess) {
            req.statusCode(404);
        } else {
            ((ValidatableResponse)req.statusCode(200)).body(CoreMatchers.anything(), new Matcher[0]);
        }
    }

    private void doTestDisabledPathExactMatch() {
        String schemaDefinition = "{\"type\":\"record\",\"name\":\"myrecord1\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}";
        String schemaName = "testVerifySchema_userInfo";
        String versionName = "testversion_1.0.0";
        ((ValidatableResponse)((Response)RestAssured.given().when().queryParam("verify", new Object[]{"true"}).contentType("application/json").body("{\"name\":\"" + schemaName + "\",\"version\":\"" + versionName + "\",\"definition\":\"" + schemaDefinition + "\"}").post("/ibmcompat/v1/schemas", new Object[0])).then()).statusCode(404);
    }

    private void doTestDisabledChildPathByParentPath(boolean disabledDirectAccess) throws Exception {
        String artifactContent = "{\"type\":\"record\",\"name\":\"myrecord1\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}";
        String schemaId = TestUtils.generateArtifactId();
        ValidatableResponse req = (ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json; artifactType=AVRO").pathParam("groupId", (Object)"default").header("X-Registry-ArtifactId", (Object)schemaId, new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then();
        if (disabledDirectAccess) {
            req.statusCode(404);
        } else {
            req.statusCode(200);
        }
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/ibmcompat/v1/schemas/" + schemaId, new Object[0])).then()).statusCode(404);
    }
}

