/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.defaultglobal;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.v1.beans.Rule;
import io.apicurio.registry.rules.defaultglobal.DefaultGlobalRulesProfile;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=DefaultGlobalRulesProfile.class)
@Tag(value="slow")
public class DefaultGlobalRulesResourceTest
extends AbstractResourceTestBase {
    @Override
    @BeforeEach
    protected void beforeEach() throws Exception {
        this.setupRestAssured();
        this.deleteGlobalRules(1);
    }

    @Test
    public void testGlobalRulesEndpoint() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").get("/registry/v1/rules", new Object[0])).then()).statusCode(200)).body("size()", Matchers.is((Object)1), new Object[0])).body("[0]", Matchers.equalTo((Object)"VALIDITY"), new Object[0]);
    }

    @Test
    public void testDefaultGlobalRules() throws Exception {
        this.createArtifact(this.generateArtifactId(), "JSON", "{}");
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v1/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        Rule rule = new Rule();
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("FULL");
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/registry/v1/rules", new Object[0])).then()).statusCode(409)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", Matchers.equalTo((Object)"A rule named 'VALIDITY' already exists."), new Object[0]));
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("BACKWARD");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).post("/registry/v1/rules", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v1/rules", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("[0]", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)"VALIDITY"), Matchers.equalTo((Object)"COMPATIBILITY")}), new Object[0])).body("[1]", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)"VALIDITY"), Matchers.equalTo((Object)"COMPATIBILITY")}), new Object[0])).body("[2]", Matchers.nullValue(), new Object[0]));
        rule.setType(RuleType.VALIDITY);
        rule.setConfig("SYNTAX_ONLY");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body((Object)rule).put("/registry/v1/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"SYNTAX_ONLY"), new Object[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v1/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"SYNTAX_ONLY"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().delete("/registry/v1/rules/VALIDITY", new Object[0])).then()).statusCode(204)).body(CoreMatchers.anything(), new Matcher[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v1/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v1/rules", new Object[0])).then()).log().all()).statusCode(200)).contentType(ContentType.JSON)).body("[0]", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)"VALIDITY"), Matchers.equalTo((Object)"COMPATIBILITY")}), new Object[0])).body("[1]", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)"VALIDITY"), Matchers.equalTo((Object)"COMPATIBILITY")}), new Object[0])).body("[2]", Matchers.nullValue(), new Object[0]));
        ((ValidatableResponse)((Response)RestAssured.given().when().delete("/registry/v1/rules", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v1/rules", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("size()", Matchers.is((Object)1), new Object[0])).body("[0]", Matchers.equalTo((Object)"VALIDITY"), new Object[0]));
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v1/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)"VALIDITY"), new Object[0])).body("config", Matchers.equalTo((Object)"FULL"), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().delete("/registry/v1/rules/VALIDITY", new Object[0])).then()).statusCode(409)).contentType(ContentType.JSON)).body("error_code", Matchers.equalTo((Object)409), new Object[0])).body("message", Matchers.equalTo((Object)"Default rule 'VALIDITY' cannot be deleted."), new Object[0]);
    }
}

