/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.client.AdminClient;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.RoleMapping;
import io.apicurio.registry.storage.impl.sql.SqlStorageUpgradeTestProfile;
import io.apicurio.registry.types.RoleType;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=SqlStorageUpgradeTestProfile.class)
@Disabled
public class SqlStorageUpgradeTest
extends AbstractResourceTestBase {
    @Test
    public void testUpgradeFromV1toV2() throws Exception {
        RegistryClient client = this.createRestClientV2();
        AdminClient adminClient = this.createAdminClientV2();
        ArtifactMetaData metaData = client.getArtifactMetaData("TestGroup", "TestArtifact");
        Assertions.assertEquals((long)101L, (Long)metaData.getContentId());
        Assertions.assertEquals((long)5001L, (Long)metaData.getGlobalId());
        Assertions.assertEquals((Object)"JSON", (Object)metaData.getType());
        RoleMapping mapping = new RoleMapping();
        mapping.setPrincipalId("test_user");
        mapping.setRole(RoleType.ADMIN);
        adminClient.createRoleMapping(mapping);
        mapping = adminClient.getRoleMapping("test_user");
        Assertions.assertEquals((Object)RoleType.ADMIN, (Object)mapping.getRole());
    }
}

