/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.apicurio.registry.storage.impl.sql.DdlParser;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.quarkus.test.junit.QuarkusTestProfile;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class SqlStorageUpgradeTestProfile
implements QuarkusTestProfile {
    private static final String JDBC_URL = "jdbc:h2:file:./target/test_dbs/" + UUID.randomUUID().toString();
    private static final String V1_DB_DDL = "https://raw.githubusercontent.com/Apicurio/apicurio-registry/2.0.x/app/src/main/resources/io/apicurio/registry/storage/impl/sql/h2.ddl";

    public Map<String, String> getConfigOverrides() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("registry.auth.role-based-authorization", "true");
        props.put("registry.auth.role-source", "application");
        return props;
    }

    public List<QuarkusTestProfile.TestResourceEntry> testResources() {
        return Arrays.asList(new QuarkusTestProfile.TestResourceEntry(H2Initializer.class));
    }

    public static class H2Initializer
    implements QuarkusTestResourceLifecycleManager {
        private Connection connection;

        public void init(Map<String, String> initArgs) {
            super.init(initArgs);
        }

        public Map<String, String> start() {
            String jdbcUrl = JDBC_URL;
            try {
                PreparedStatement ps;
                List dbStatements;
                this.connection = DriverManager.getConnection(jdbcUrl);
                this.connection.setAutoCommit(true);
                DdlParser parser = new DdlParser();
                try (Iterator input = new URL(SqlStorageUpgradeTestProfile.V1_DB_DDL).openStream();){
                    if (input == null) {
                        throw new SQLException("DDL not found!");
                    }
                    dbStatements = parser.parse((InputStream)((Object)input));
                }
                for (String statement : dbStatements) {
                    ps = this.connection.prepareStatement(statement);
                    ps.executeUpdate();
                    ps.close();
                }
                input = this.getClass().getClassLoader().getResourceAsStream("SqlStorageUpgradeTest.dml");
                try {
                    if (input == null) {
                        throw new SQLException("DML not found!");
                    }
                    dbStatements = parser.parse((InputStream)((Object)input));
                }
                finally {
                    if (input != null) {
                        ((InputStream)((Object)input)).close();
                    }
                }
                for (String statement : dbStatements) {
                    ps = this.connection.prepareStatement(statement);
                    ps.executeUpdate();
                    ps.close();
                }
                this.connection.commit();
                this.connection.close();
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("quarkus.datasource.jdbc.url", jdbcUrl);
                return props;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void stop() {
        }
    }
}

