/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.apicurio.registry.storage.impl.sql.SqlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SqlUtilTest {
    SqlUtilTest() {
    }

    @Test
    void testSerializeLabels() {
        List<String> labels = Collections.singletonList("foo");
        String actual = SqlUtil.serializeLabels(labels);
        Assertions.assertEquals((Object)"[\"foo\"]", (Object)actual);
        labels = new ArrayList<String>();
        labels.add("one");
        labels.add("two");
        labels.add("three");
        actual = SqlUtil.serializeLabels(labels);
        Assertions.assertEquals((Object)"[\"one\",\"two\",\"three\"]", (Object)actual);
    }

    @Test
    void testDeserializeLabels() {
        String labelsStr = "[\"one\",\"two\",\"three\"]";
        List actual = SqlUtil.deserializeLabels((String)labelsStr);
        Assertions.assertNotNull((Object)actual);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("one");
        expected.add("two");
        expected.add("three");
        Assertions.assertEquals(expected, (Object)actual);
    }

    @Test
    void testSerializeProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("one", "1");
        props.put("two", "2");
        props.put("three", "3");
        String actual = SqlUtil.serializeProperties(props);
        String expected = "{\"one\":\"1\",\"two\":\"2\",\"three\":\"3\"}";
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testDeserializeProperties() {
        String propsStr = "{\"one\":\"1\",\"two\":\"2\",\"three\":\"3\"}";
        Map actual = SqlUtil.deserializeProperties((String)propsStr);
        Assertions.assertNotNull((Object)actual);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("one", "1");
        expected.put("two", "2");
        expected.put("three", "3");
        Assertions.assertEquals(expected, (Object)actual);
    }
}

