/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.util;

import io.apicurio.registry.AbstractRegistryTestBase;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.InvalidArtifactTypeException;
import io.apicurio.registry.util.ArtifactTypeUtil;
import java.util.List;
import org.apache.avro.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ArtifactTypeUtilTest
extends AbstractRegistryTestBase {
    static List<String> availableTypes = List.of("JSON", "OPENAPI", "ASYNCAPI", "AVRO", "PROTOBUF", "WSDL", "XML", "XSD", "GRAPHQL");

    ArtifactTypeUtilTest() {
    }

    @Test
    void testDiscoverType_JSON() {
        ContentHandle content = this.resourceToContentHandle("json-schema.json");
        String type = ArtifactTypeUtil.determineArtifactType((ContentHandle)content, null, null, availableTypes);
        Assertions.assertEquals((Object)"JSON", (Object)type);
    }

    @Test
    void testDiscoverType_Avro() {
        ContentHandle content = this.resourceToContentHandle("avro.json");
        String type = ArtifactTypeUtil.determineArtifactType((ContentHandle)content, null, null, availableTypes);
        Assertions.assertEquals((Object)"AVRO", (Object)type);
    }

    @Test
    void testDiscoverType_Avro_Simple() {
        ContentHandle content = this.resourceToContentHandle("avro-simple.avsc");
        Schema s = new Schema.Parser().parse(content.content());
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)s.getType());
        String type = ArtifactTypeUtil.determineArtifactType((ContentHandle)content, null, null, availableTypes);
        Assertions.assertEquals((Object)"AVRO", (Object)type);
    }

    @Test
    void testDiscoverType_Proto() {
        ContentHandle content = this.resourceToContentHandle("protobuf.proto");
        String type = ArtifactTypeUtil.determineArtifactType((ContentHandle)content, null, null, availableTypes);
        Assertions.assertEquals((Object)"PROTOBUF", (Object)type);
        content = this.resourceToContentHandle("protobuf.proto");
        type = ArtifactTypeUtil.determineArtifactType((ContentHandle)content, null, (String)"application/x-protobuf", availableTypes);
        Assertions.assertEquals((Object)"PROTOBUF", (Object)type);
    }

    @Test
    void testDiscoverType_OpenApi() {
        ContentHandle content = this.resourceToContentHandle("openapi.json");
        String type = ArtifactTypeUtil.determineArtifactType((ContentHandle)content, null, null, availableTypes);
        Assertions.assertEquals((Object)"OPENAPI", (Object)type);
        content = this.resourceToContentHandle("swagger.json");
        type = ArtifactTypeUtil.determineArtifactType((ContentHandle)content, null, null, availableTypes);
        Assertions.assertEquals((Object)"OPENAPI", (Object)type);
        content = this.resourceToContentHandle("swagger.json");
        type = ArtifactTypeUtil.determineArtifactType((ContentHandle)content, null, (String)"application/json", availableTypes);
        Assertions.assertEquals((Object)"OPENAPI", (Object)type);
    }

    @Test
    void testDiscoverType_AsyncApi() {
        ContentHandle content = this.resourceToContentHandle("asyncapi.json");
        String type = ArtifactTypeUtil.determineArtifactType((ContentHandle)content, null, null, availableTypes);
        Assertions.assertEquals((Object)"ASYNCAPI", (Object)type);
    }

    @Test
    void testDiscoverType_GraphQL() {
        ContentHandle content = this.resourceToContentHandle("example.graphql");
        String type = ArtifactTypeUtil.determineArtifactType((ContentHandle)content, null, null, availableTypes);
        Assertions.assertEquals((Object)"GRAPHQL", (Object)type);
    }

    @Test
    void testDiscoverType_DefaultNotFound() {
        Assertions.assertThrows(InvalidArtifactTypeException.class, () -> {
            ContentHandle content = this.resourceToContentHandle("example.txt");
            ArtifactTypeUtil.determineArtifactType((ContentHandle)content, null, null, availableTypes);
        });
    }

    @Test
    void testDiscoverType_Xml() {
        ContentHandle content = this.resourceToContentHandle("xml.xml");
        String type = ArtifactTypeUtil.determineArtifactType((ContentHandle)content, null, null, availableTypes);
        Assertions.assertEquals((Object)"XML", (Object)type);
    }

    @Test
    void testDiscoverType_Xsd() {
        ContentHandle content = this.resourceToContentHandle("xml-schema.xsd");
        String type = ArtifactTypeUtil.determineArtifactType((ContentHandle)content, null, null, availableTypes);
        Assertions.assertEquals((Object)"XSD", (Object)type);
    }

    @Test
    void testDiscoverType_Wsdl() {
        ContentHandle content = this.resourceToContentHandle("wsdl.wsdl");
        String type = ArtifactTypeUtil.determineArtifactType((ContentHandle)content, null, null, availableTypes);
        Assertions.assertEquals((Object)"WSDL", (Object)type);
        content = this.resourceToContentHandle("wsdl-2.0.wsdl");
        type = ArtifactTypeUtil.determineArtifactType((ContentHandle)content, null, null, availableTypes);
        Assertions.assertEquals((Object)"WSDL", (Object)type);
    }
}

