/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlDataImporter;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlRegistryStorage;
import io.apicurio.registry.storage.impl.sql.SqlUtil;
import io.apicurio.registry.utils.impexp.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.ContentEntity;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;

public class ContentIdNotPreserveKafkaSqlDataImporter
extends KafkaSqlDataImporter {
    public ContentIdNotPreserveKafkaSqlDataImporter(Logger logger, KafkaSqlRegistryStorage registryStorage, boolean preserveGlobalId) {
        super(logger, registryStorage, preserveGlobalId);
    }

    @Override
    public void importContent(ContentEntity entity) {
        List references = SqlUtil.deserializeReferences((String)entity.serializedReferences);
        if (entity.canonicalHash == null) {
            if (entity.artifactType != null) {
                ContentHandle canonicalContent = this.getRegistryStorage().canonicalizeContent(entity.artifactType, ContentHandle.create((byte[])entity.contentBytes), references);
                entity.canonicalHash = DigestUtils.sha256Hex((byte[])canonicalContent.bytes());
            } else {
                throw new RegistryStorageException("There is not enough information about content. Artifact Type and CanonicalHash are both missing.");
            }
        }
        long newContentId = this.getRegistryStorage().ensureContentAndGetContentId(ContentHandle.create((byte[])entity.contentBytes), entity.canonicalHash, references);
        this.getContentIdMapping().put(entity.contentId, newContentId);
        List<ArtifactVersionEntity> artifactsToImport = this.getWaitingForContent().stream().filter(artifactVersion -> artifactVersion.contentId == entity.contentId).collect(Collectors.toList());
        artifactsToImport.forEach(this::importArtifactVersion);
        this.getWaitingForContent().removeAll(artifactsToImport);
    }
}

