/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlRegistryStorage;
import io.apicurio.registry.storage.impl.sql.SqlUtil;
import io.apicurio.registry.util.AbstractDataImporter;
import io.apicurio.registry.utils.impexp.ArtifactRuleEntity;
import io.apicurio.registry.utils.impexp.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.CommentEntity;
import io.apicurio.registry.utils.impexp.ContentEntity;
import io.apicurio.registry.utils.impexp.GlobalRuleEntity;
import io.apicurio.registry.utils.impexp.GroupEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;

public class KafkaSqlDataImporter
extends AbstractDataImporter {
    private final KafkaSqlRegistryStorage registryStorage;
    private final boolean preserveGlobalId;
    private final Map<Long, Long> contentIdMapping = new HashMap<Long, Long>();
    private final ArrayList<ArtifactVersionEntity> waitingForContent = new ArrayList();
    private final Set<Long> globalIds = new HashSet<Long>();
    private final ArrayList<CommentEntity> waitingForVersion = new ArrayList();

    public KafkaSqlDataImporter(Logger logger, KafkaSqlRegistryStorage registryStorage, boolean preserveGlobalId) {
        super(logger);
        this.registryStorage = registryStorage;
        this.preserveGlobalId = preserveGlobalId;
    }

    public void importArtifactRule(ArtifactRuleEntity entity) {
        this.registryStorage.importArtifactRule(entity);
    }

    public void importArtifactVersion(ArtifactVersionEntity entity) {
        if (!this.contentIdMapping.containsKey(entity.contentId)) {
            this.waitingForContent.add(entity);
            return;
        }
        entity.contentId = this.contentIdMapping.get(entity.contentId);
        if (!this.preserveGlobalId) {
            entity.globalId = -1L;
        }
        this.registryStorage.importArtifactVersion(entity);
        this.globalIds.add(entity.globalId);
        List<CommentEntity> commentsToImport = this.waitingForVersion.stream().filter(comment -> comment.globalId == entity.globalId).collect(Collectors.toList());
        commentsToImport.forEach(this::importComment);
        this.waitingForVersion.removeAll(commentsToImport);
    }

    public void importContent(ContentEntity entity) {
        List references = SqlUtil.deserializeReferences((String)entity.serializedReferences);
        if (entity.canonicalHash == null && entity.artifactType != null) {
            ContentHandle canonicalContent = this.registryStorage.canonicalizeContent(entity.artifactType, ContentHandle.create((byte[])entity.contentBytes), references);
            entity.canonicalHash = DigestUtils.sha256Hex((byte[])canonicalContent.bytes());
        }
        this.getContentIdMapping().put(entity.contentId, entity.contentId);
        this.registryStorage.importContent(entity);
        List<ArtifactVersionEntity> artifactsToImport = this.waitingForContent.stream().filter(artifactVersion -> artifactVersion.contentId == entity.contentId).collect(Collectors.toList());
        artifactsToImport.forEach(this::importArtifactVersion);
        this.waitingForContent.removeAll(artifactsToImport);
    }

    public void importGlobalRule(GlobalRuleEntity entity) {
        this.registryStorage.importGlobalRule(entity);
    }

    public void importGroup(GroupEntity entity) {
        this.registryStorage.importGroup(entity);
    }

    public void importComment(CommentEntity entity) {
        if (!this.globalIds.contains(entity.globalId)) {
            this.waitingForVersion.add(entity);
            return;
        }
        this.registryStorage.importComment(entity);
    }

    protected Map<Long, Long> getContentIdMapping() {
        return this.contentIdMapping;
    }

    protected ArrayList<ArtifactVersionEntity> getWaitingForContent() {
        return this.waitingForContent;
    }

    protected KafkaSqlRegistryStorage getRegistryStorage() {
        return this.registryStorage;
    }
}

