/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql;

import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlConfiguration;
import io.apicurio.registry.storage.impl.kafkasql.keys.MessageKey;
import io.apicurio.registry.storage.impl.kafkasql.serde.KafkaSqlKeyDeserializer;
import io.apicurio.registry.storage.impl.kafkasql.serde.KafkaSqlKeySerializer;
import io.apicurio.registry.storage.impl.kafkasql.serde.KafkaSqlPartitioner;
import io.apicurio.registry.storage.impl.kafkasql.serde.KafkaSqlValueDeserializer;
import io.apicurio.registry.storage.impl.kafkasql.serde.KafkaSqlValueSerializer;
import io.apicurio.registry.storage.impl.kafkasql.values.MessageValue;
import io.apicurio.registry.utils.RegistryProperties;
import io.apicurio.registry.utils.kafka.AsyncProducer;
import io.apicurio.registry.utils.kafka.ProducerActions;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class KafkaSqlFactory {
    @Inject
    Logger log;
    @Inject
    @ConfigProperty(name="registry.kafkasql.bootstrap.servers")
    String bootstrapServers;
    @Inject
    @ConfigProperty(name="registry.kafkasql.topic", defaultValue="kafkasql-journal")
    String topic;
    @Inject
    @RegistryProperties(value={"registry.kafkasql.topic"})
    Properties topicProperties;
    @Inject
    @ConfigProperty(name="registry.kafkasql.topic.auto-create", defaultValue="true")
    Boolean topicAutoCreate;
    @Inject
    @ConfigProperty(name="registry.kafkasql.consumer.startupLag", defaultValue="-1")
    @Deprecated(since="2.4.2", forRemoval=true)
    Integer startupLag;
    @Inject
    @ConfigProperty(name="registry.kafkasql.consumer.poll.timeout", defaultValue="1000")
    Integer pollTimeout;
    @Inject
    @ConfigProperty(name="registry.kafkasql.coordinator.response-timeout", defaultValue="30000")
    Integer responseTimeout;
    @Inject
    @RegistryProperties(value={"registry.kafka.common", "registry.kafkasql.producer"}, empties={"ssl.endpoint.identification.algorithm="})
    Properties producerProperties;
    @Inject
    @RegistryProperties(value={"registry.kafka.common", "registry.kafkasql.consumer"}, empties={"ssl.endpoint.identification.algorithm="})
    Properties consumerProperties;
    @Inject
    @RegistryProperties(value={"registry.kafka.common", "registry.kafkasql.admin"}, empties={"ssl.endpoint.identification.algorithm="})
    Properties adminProperties;
    @ConfigProperty(name="registry.kafkasql.security.sasl.enabled", defaultValue="false")
    boolean saslEnabled;
    @ConfigProperty(name="registry.kafkasql.security.protocol", defaultValue="")
    Optional<String> protocol;
    @ConfigProperty(name="registry.kafkasql.security.sasl.mechanism", defaultValue="")
    String saslMechanism;
    @ConfigProperty(name="registry.kafkasql.security.sasl.client-id", defaultValue="")
    String clientId;
    @ConfigProperty(name="registry.kafkasql.security.sasl.client-secret", defaultValue="")
    String clientSecret;
    @ConfigProperty(name="registry.kafkasql.security.sasl.token.endpoint", defaultValue="")
    String tokenEndpoint;
    @ConfigProperty(name="registry.kafkasql.security.sasl.login.callback.handler.class", defaultValue="")
    String loginCallbackHandler;
    @ConfigProperty(name="registry.kafkasql.security.ssl.truststore.location")
    Optional<String> trustStoreLocation;
    @ConfigProperty(name="registry.kafkasql.security.ssl.truststore.type")
    Optional<String> trustStoreType;
    @ConfigProperty(name="registry.kafkasql.ssl.truststore.password")
    Optional<String> trustStorePassword;
    @ConfigProperty(name="registry.kafkasql.ssl.keystore.location")
    Optional<String> keyStoreLocation;
    @ConfigProperty(name="registry.kafkasql.ssl.keystore.type")
    Optional<String> keyStoreType;
    @ConfigProperty(name="registry.kafkasql.ssl.keystore.password")
    Optional<String> keyStorePassword;
    @ConfigProperty(name="registry.kafkasql.ssl.key.password")
    Optional<String> keyPassword;

    @ApplicationScoped
    @Produces
    public KafkaSqlConfiguration createConfiguration() {
        if (this.startupLag != -1) {
            this.log.warn("Configuration property 'registry.kafkasql.consumer.startupLag' is no longer used and is ignored.");
        }
        return new KafkaSqlConfiguration(){

            @Override
            public String bootstrapServers() {
                return KafkaSqlFactory.this.bootstrapServers;
            }

            @Override
            public String topic() {
                return KafkaSqlFactory.this.topic;
            }

            @Override
            public Properties topicProperties() {
                return KafkaSqlFactory.this.topicProperties;
            }

            @Override
            public boolean isTopicAutoCreate() {
                return KafkaSqlFactory.this.topicAutoCreate;
            }

            @Override
            public Integer pollTimeout() {
                return KafkaSqlFactory.this.pollTimeout;
            }

            @Override
            public Integer responseTimeout() {
                return KafkaSqlFactory.this.responseTimeout;
            }

            @Override
            public Properties producerProperties() {
                return KafkaSqlFactory.this.producerProperties;
            }

            @Override
            public Properties consumerProperties() {
                return KafkaSqlFactory.this.consumerProperties;
            }

            @Override
            public Properties adminProperties() {
                KafkaSqlFactory.this.tryToConfigureSecurity(KafkaSqlFactory.this.adminProperties);
                return KafkaSqlFactory.this.adminProperties;
            }
        };
    }

    @ApplicationScoped
    @Produces
    public ProducerActions<MessageKey, MessageValue> createKafkaProducer() {
        Properties props = (Properties)this.producerProperties.clone();
        props.putIfAbsent("bootstrap.servers", this.bootstrapServers);
        props.putIfAbsent("client.id", "Producer-" + UUID.randomUUID().toString());
        props.putIfAbsent("acks", "all");
        props.putIfAbsent("linger.ms", (Object)10);
        props.putIfAbsent("partitioner.class", KafkaSqlPartitioner.class);
        this.tryToConfigureSecurity(props);
        KafkaSqlKeySerializer keySerializer = new KafkaSqlKeySerializer();
        KafkaSqlValueSerializer valueSerializer = new KafkaSqlValueSerializer();
        return new AsyncProducer(props, (Serializer)keySerializer, (Serializer)valueSerializer);
    }

    @ApplicationScoped
    @Produces
    public KafkaConsumer<MessageKey, MessageValue> createKafkaConsumer() {
        Properties props = (Properties)this.consumerProperties.clone();
        props.putIfAbsent("bootstrap.servers", this.bootstrapServers);
        props.putIfAbsent("group.id", UUID.randomUUID().toString());
        props.putIfAbsent("enable.auto.commit", "true");
        props.putIfAbsent("auto.commit.interval.ms", "1000");
        props.putIfAbsent("auto.offset.reset", "earliest");
        this.tryToConfigureSecurity(props);
        KafkaSqlKeyDeserializer keyDeserializer = new KafkaSqlKeyDeserializer();
        KafkaSqlValueDeserializer valueDeserializer = new KafkaSqlValueDeserializer();
        KafkaConsumer<MessageKey, MessageValue> consumer = new KafkaConsumer<MessageKey, MessageValue>(props, (Deserializer<MessageKey>)keyDeserializer, (Deserializer<MessageValue>)valueDeserializer);
        return consumer;
    }

    private void tryToConfigureSecurity(Properties props) {
        if (this.protocol.isPresent()) {
            props.putIfAbsent("security.protocol", this.protocol.get());
        }
        if (this.saslEnabled) {
            props.putIfAbsent("sasl.jaas.config", String.format("org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required   oauth.client.id=\"%s\"   oauth.client.secret=\"%s\"   oauth.token.endpoint.uri=\"%s\" ;", this.clientId, this.clientSecret, this.tokenEndpoint));
            props.putIfAbsent("sasl.mechanism", this.saslMechanism);
            props.putIfAbsent("sasl.login.callback.handler.class", this.loginCallbackHandler);
        }
        if (this.trustStoreLocation.isPresent() && this.trustStorePassword.isPresent() && this.trustStoreType.isPresent()) {
            props.putIfAbsent("ssl.truststore.type", this.trustStoreType.get());
            props.putIfAbsent("ssl.truststore.location", this.trustStoreLocation.get());
            props.putIfAbsent("ssl.truststore.password", this.trustStorePassword.get());
        }
        if (this.keyStoreLocation.isPresent() && this.keyStorePassword.isPresent() && this.keyStoreType.isPresent()) {
            props.putIfAbsent("ssl.keystore.type", this.keyStoreType.get());
            props.putIfAbsent("ssl.keystore.location", this.keyStoreLocation.get());
            props.putIfAbsent("ssl.keystore.password", this.keyStorePassword.get());
            this.keyPassword.ifPresent(s -> props.putIfAbsent("ssl.key.password", s));
        }
    }
}

