/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.canon.ProtobufContentCanonicalizer;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlSubmitter;
import io.apicurio.registry.storage.impl.kafkasql.values.ActionType;
import io.apicurio.registry.storage.impl.sql.IDbUpgrader;
import io.apicurio.registry.storage.impl.sql.jdb.Handle;
import io.apicurio.registry.storage.impl.sql.jdb.Query;
import io.apicurio.registry.storage.impl.sql.jdb.RowMapper;
import io.apicurio.registry.storage.impl.sql.mappers.ContentEntityMapper;
import io.apicurio.registry.utils.impexp.ContentEntity;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class KafkaSqlProtobufCanonicalizerUpgrader
implements IDbUpgrader {
    @Inject
    Logger logger;
    @Inject
    KafkaSqlSubmitter submitter;

    public void upgrade(Handle dbHandle) throws Exception {
        Stream stream;
        String sql = "SELECT c.contentId, c.content, c.canonicalHash, c.contentHash, c.artifactreferences, v.tenantId FROM versions v JOIN content c on c.contentId = v.contentId JOIN artifacts a ON v.tenantId = a.tenantId AND v.groupId = a.groupId AND v.artifactId = a.artifactId WHERE a.type = ?";
        try (Stream stream2 = stream = ((Query)dbHandle.createQuery(sql).setFetchSize(50).bind(0, "PROTOBUF")).map((RowMapper)new TenantContentEntityRowMapper()).stream();){
            stream.forEach(this::updateCanonicalHash);
        }
    }

    protected void updateCanonicalHash(TenantContentEntity tenantContentEntity) {
        ContentEntity contentEntity = tenantContentEntity.contentEntity;
        ContentHandle content = ContentHandle.create((byte[])contentEntity.contentBytes);
        ContentHandle canonicalContent = this.canonicalizeContent(content);
        byte[] canonicalContentBytes = canonicalContent.bytes();
        String canonicalContentHash = DigestUtils.sha256Hex((byte[])canonicalContentBytes);
        if (canonicalContentHash.equals(tenantContentEntity.contentEntity.canonicalHash)) {
            this.logger.debug("Skipping content because the canonical hash is up to date, updating contentId {}", (Object)contentEntity.contentId);
            return;
        }
        this.logger.debug("Protobuf content canonicalHash outdated value detected, updating contentId {}", (Object)contentEntity.contentId);
        this.submitter.submitContent(tenantContentEntity.tenantId, contentEntity.contentId, contentEntity.contentHash, ActionType.UPDATE, canonicalContentHash, null, contentEntity.serializedReferences != null ? contentEntity.serializedReferences : null);
    }

    protected ContentHandle canonicalizeContent(ContentHandle content) {
        try {
            ProtobufContentCanonicalizer canonicalizer = new ProtobufContentCanonicalizer();
            return canonicalizer.canonicalize(content, Collections.emptyMap());
        }
        catch (Exception e) {
            this.logger.debug("Failed to canonicalize content of type: {}", (Object)"PROTOBUF");
            return content;
        }
    }

    public static class TenantContentEntityRowMapper
    implements RowMapper<TenantContentEntity> {
        public TenantContentEntity map(ResultSet rs) throws SQLException {
            TenantContentEntity e = new TenantContentEntity();
            e.tenantId = rs.getString("tenantId");
            e.contentEntity = ContentEntityMapper.instance.map(rs);
            return e;
        }
    }

    public static class TenantContentEntity {
        String tenantId;
        ContentEntity contentEntity;
    }
}

