/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql;

import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.common.apps.logging.Logged;
import io.apicurio.common.apps.multitenancy.TenantContext;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import io.apicurio.registry.content.extract.ContentExtractor;
import io.apicurio.registry.content.extract.ExtractedMetaData;
import io.apicurio.registry.metrics.StorageMetricsApply;
import io.apicurio.registry.metrics.health.liveness.PersistenceExceptionLivenessApply;
import io.apicurio.registry.metrics.health.readiness.PersistenceTimeoutReadinessApply;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.ArtifactStateExt;
import io.apicurio.registry.storage.ContentNotFoundException;
import io.apicurio.registry.storage.GroupAlreadyExistsException;
import io.apicurio.registry.storage.GroupNotFoundException;
import io.apicurio.registry.storage.LogConfigurationNotFoundException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.storage.RoleMappingNotFoundException;
import io.apicurio.registry.storage.RuleAlreadyExistsException;
import io.apicurio.registry.storage.RuleNotFoundException;
import io.apicurio.registry.storage.StorageEvent;
import io.apicurio.registry.storage.StorageEventType;
import io.apicurio.registry.storage.VersionAlreadyExistsException;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactOwnerDto;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.CommentDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.DownloadContextDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.dto.GroupSearchResultsDto;
import io.apicurio.registry.storage.dto.LogConfigurationDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.RoleMappingDto;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.StoredArtifactDto;
import io.apicurio.registry.storage.dto.VersionSearchResultsDto;
import io.apicurio.registry.storage.impexp.EntityInputStream;
import io.apicurio.registry.storage.impl.kafkasql.ContentIdNotPreserveKafkaSqlDataImporter;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlConfiguration;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlCoordinator;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlDataImporter;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlSubmitter;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlUpgrader;
import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.BootstrapKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.MessageKey;
import io.apicurio.registry.storage.impl.kafkasql.sql.KafkaSqlSink;
import io.apicurio.registry.storage.impl.kafkasql.sql.KafkaSqlStore;
import io.apicurio.registry.storage.impl.kafkasql.values.ActionType;
import io.apicurio.registry.storage.impl.kafkasql.values.MessageValue;
import io.apicurio.registry.storage.impl.sql.SqlStorageEvent;
import io.apicurio.registry.storage.impl.sql.SqlStorageEventType;
import io.apicurio.registry.storage.impl.sql.SqlUtil;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.apicurio.registry.utils.ConcurrentUtil;
import io.apicurio.registry.utils.impexp.ArtifactRuleEntity;
import io.apicurio.registry.utils.impexp.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.CommentEntity;
import io.apicurio.registry.utils.impexp.ContentEntity;
import io.apicurio.registry.utils.impexp.Entity;
import io.apicurio.registry.utils.impexp.GlobalRuleEntity;
import io.apicurio.registry.utils.impexp.GroupEntity;
import io.apicurio.registry.utils.kafka.KafkaUtil;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.TopicExistsException;
import org.slf4j.Logger;

@ApplicationScoped
@PersistenceExceptionLivenessApply
@PersistenceTimeoutReadinessApply
@StorageMetricsApply
@Logged
public class KafkaSqlRegistryStorage
implements RegistryStorage {
    @Inject
    Logger log;
    @Inject
    KafkaSqlConfiguration configuration;
    @Inject
    KafkaSqlCoordinator coordinator;
    @Inject
    KafkaSqlSink kafkaSqlSink;
    @Inject
    KafkaSqlStore sqlStore;
    @Inject
    ArtifactTypeUtilProviderFactory factory;
    @Inject
    TenantContext tenantContext;
    @Inject
    KafkaConsumer<MessageKey, MessageValue> consumer;
    @Inject
    KafkaSqlSubmitter submitter;
    @Inject
    SecurityIdentity securityIdentity;
    @Inject
    ArtifactStateExt artifactStateEx;
    @Inject
    KafkaSqlUpgrader upgrader;
    @Inject
    Event<StorageEvent> storageEvent;
    private volatile boolean bootstrapped = false;
    private volatile boolean stopped = true;

    @PostConstruct
    void onConstruct() {
        this.log.info("Using Kafka-SQL artifactStore.");
        if (this.configuration.isTopicAutoCreate()) {
            this.autoCreateTopics();
        }
    }

    public void handleSqlStorageEvent(@Observes SqlStorageEvent event) {
        if (SqlStorageEventType.READY.equals((Object)event.getType())) {
            this.log.info("SQL store initialized, starting consumer thread.");
            this.startConsumerThread(this.consumer);
        }
    }

    public String storageName() {
        return "kafkasql";
    }

    public boolean supportsMultiTenancy() {
        return true;
    }

    public boolean isReady() {
        return this.bootstrapped;
    }

    public boolean isAlive() {
        return this.bootstrapped && !this.stopped;
    }

    @PreDestroy
    void onDestroy() {
        this.stopped = true;
    }

    private void autoCreateTopics() {
        LinkedHashSet<String> topicNames = new LinkedHashSet<String>();
        topicNames.add(this.configuration.topic());
        HashMap<String, String> topicProperties = new HashMap<String, String>();
        this.configuration.topicProperties().entrySet().forEach(entry -> topicProperties.put(entry.getKey().toString(), entry.getValue().toString()));
        topicProperties.putIfAbsent("cleanup.policy", "compact");
        Properties adminProperties = this.configuration.adminProperties();
        adminProperties.putIfAbsent("bootstrap.servers", this.configuration.bootstrapServers());
        try {
            KafkaUtil.createTopics((Properties)adminProperties, topicNames, topicProperties);
        }
        catch (TopicExistsException e) {
            this.log.info("Topic {} already exists, skipping.", (Object)this.configuration.topic());
        }
    }

    private void startConsumerThread(KafkaConsumer<MessageKey, MessageValue> consumer) {
        this.log.info("Starting KSQL consumer thread on topic: {}", (Object)this.configuration.topic());
        this.log.info("Bootstrap servers: {}", (Object)this.configuration.bootstrapServers());
        String bootstrapId = UUID.randomUUID().toString();
        this.submitter.submitBootstrap(bootstrapId);
        long bootstrapStart = System.currentTimeMillis();
        Runnable runner = () -> {
            try {
                this.log.info("Subscribing to {}", (Object)this.configuration.topic());
                Set<String> topics = Collections.singleton(this.configuration.topic());
                consumer.subscribe(topics);
                while (!this.stopped) {
                    ConsumerRecords records = consumer.poll(Duration.ofMillis(this.configuration.pollTimeout().intValue()));
                    if (records == null || records.isEmpty()) continue;
                    this.log.debug("Consuming {} journal records.", (Object)records.count());
                    records.forEach(record -> {
                        if (record.key() == null) {
                            this.log.info("Discarded an unreadable/unrecognized message.");
                            return;
                        }
                        if (((MessageKey)record.key()).getType() == MessageType.Bootstrap) {
                            BootstrapKey bkey = (BootstrapKey)record.key();
                            if (bkey.getBootstrapId().equals(bootstrapId)) {
                                this.upgrader.upgrade();
                                this.bootstrapped = true;
                                this.storageEvent.fireAsync((Object)StorageEvent.builder().type(StorageEventType.READY).build());
                                this.log.info("KafkaSQL storage bootstrapped in {} ms.", (Object)(System.currentTimeMillis() - bootstrapStart));
                            }
                            return;
                        }
                        if (record.value() == null) {
                            this.log.info("Discarded a (presumed) tombstone message with key: {}", record.key());
                            return;
                        }
                        this.kafkaSqlSink.processMessage((ConsumerRecord<MessageKey, MessageValue>)record);
                    });
                }
            }
            finally {
                consumer.close();
            }
        };
        this.stopped = false;
        Thread thread = new Thread(runner);
        thread.setDaemon(true);
        thread.setName("KSQL Kafka Consumer Thread");
        thread.start();
    }

    private long nextClusterGlobalId() {
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitGlobalId(this.tenantContext.tenantId(), ActionType.CREATE));
        return (Long)this.coordinator.waitForResponse(uuid);
    }

    private long nextClusterContentId() {
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitContentId(this.tenantContext.tenantId(), ActionType.CREATE));
        return (Long)this.coordinator.waitForResponse(uuid);
    }

    private long nextClusterCommentId() {
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitCommentId(this.tenantContext.tenantId(), ActionType.CREATE));
        return (Long)this.coordinator.waitForResponse(uuid);
    }

    private String ensureContent(ContentHandle content, String groupId, String artifactId, String artifactType, List<ArtifactReferenceDto> references) {
        try {
            String referencesSerialized = SqlUtil.serializeReferences(references);
            byte[] contentBytes = content.bytes();
            String contentHash = DigestUtils.sha256Hex((byte[])this.concatContentAndReferences(contentBytes, referencesSerialized));
            if (!this.sqlStore.isContentExists(contentHash)) {
                long contentId = this.nextClusterContentId();
                ContentHandle canonicalContent = this.canonicalizeContent(artifactType, content, references);
                byte[] canonicalContentBytes = canonicalContent.bytes();
                String canonicalContentHash = DigestUtils.sha256Hex((byte[])this.concatContentAndReferences(canonicalContentBytes, referencesSerialized));
                CompletableFuture<UUID> future = this.submitter.submitContent(this.tenantContext.tenantId(), contentId, contentHash, ActionType.CREATE, canonicalContentHash, content, SqlUtil.serializeReferences(references));
                UUID uuid = (UUID)ConcurrentUtil.get(future);
                this.coordinator.waitForResponse(uuid);
            }
            return contentHash;
        }
        catch (IOException e) {
            throw new RegistryStorageException((Throwable)e);
        }
    }

    protected long ensureContentAndGetContentId(ContentHandle content, String canonicalContentHash, List<ArtifactReferenceDto> references) {
        byte[] contentBytes = content.bytes();
        String contentHash = DigestUtils.sha256Hex((byte[])contentBytes);
        if (!this.sqlStore.isContentExists(contentHash)) {
            long contentId = this.nextClusterContentId();
            CompletableFuture<UUID> future = this.submitter.submitContent(this.tenantContext.tenantId(), contentId, contentHash, ActionType.CREATE, canonicalContentHash, content, SqlUtil.serializeReferences(references));
            UUID uuid = (UUID)ConcurrentUtil.get(future);
            this.coordinator.waitForResponse(uuid);
            return contentId;
        }
        return this.sqlStore.contentIdFromHash(contentHash);
    }

    public ArtifactMetaDataDto createArtifact(String groupId, String artifactId, String version, String artifactType, ContentHandle content, List<ArtifactReferenceDto> references) throws ArtifactAlreadyExistsException, RegistryStorageException {
        return this.createArtifactWithMetadata(groupId, artifactId, version, artifactType, content, null, references);
    }

    public ArtifactMetaDataDto createArtifactWithMetadata(String groupId, String artifactId, String version, String artifactType, ContentHandle content, EditableArtifactMetaDataDto metaData, List<ArtifactReferenceDto> references) throws ArtifactAlreadyExistsException, RegistryStorageException {
        if (this.sqlStore.isArtifactExists(groupId, artifactId)) {
            throw new ArtifactAlreadyExistsException(groupId, artifactId);
        }
        String contentHash = this.ensureContent(content, groupId, artifactId, artifactType, references);
        String createdBy = this.securityIdentity.getPrincipal().getName();
        Date createdOn = new Date();
        if (metaData == null) {
            metaData = this.extractMetaData(artifactType, content);
        }
        if (groupId != null && !this.isGroupExists(groupId)) {
            this.createGroup(GroupMetaDataDto.builder().groupId(groupId).createdOn(0L).modifiedOn(0L).createdBy(createdBy).modifiedBy(createdBy).build());
        }
        long globalId = this.nextClusterGlobalId();
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitArtifact(this.tenantContext.tenantId(), groupId, artifactId, version, ActionType.CREATE, globalId, artifactType, contentHash, createdBy, createdOn, metaData));
        return (ArtifactMetaDataDto)this.coordinator.waitForResponse(uuid);
    }

    public List<String> deleteArtifact(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        RuleType[] ruleTypes;
        if (!this.sqlStore.isArtifactExists(groupId, artifactId)) {
            throw new ArtifactNotFoundException(groupId, artifactId);
        }
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitArtifact(this.tenantContext.tenantId(), groupId, artifactId, ActionType.DELETE));
        List versionIds = (List)this.coordinator.waitForResponse(reqId);
        versionIds.forEach(vid -> this.submitter.submitArtifactVersionTombstone(this.tenantContext.tenantId(), groupId, artifactId, (String)vid));
        for (RuleType ruleType : ruleTypes = RuleType.values()) {
            this.submitter.submitArtifactRuleTombstone(this.tenantContext.tenantId(), groupId, artifactId, ruleType);
        }
        return versionIds;
    }

    public void deleteArtifacts(String groupId) throws RegistryStorageException {
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitGroup(this.tenantContext.tenantId(), groupId, ActionType.DELETE, true));
        this.coordinator.waitForResponse(reqId);
    }

    public StoredArtifactDto getArtifact(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        return this.sqlStore.getArtifact(groupId, artifactId);
    }

    public StoredArtifactDto getArtifact(String groupId, String artifactId, RegistryStorage.ArtifactRetrievalBehavior behavior) throws ArtifactNotFoundException, RegistryStorageException {
        return this.sqlStore.getArtifact(groupId, artifactId, behavior);
    }

    public ContentWrapperDto getArtifactByContentId(long contentId) throws ContentNotFoundException, RegistryStorageException {
        return this.sqlStore.getArtifactByContentId(contentId);
    }

    public ContentWrapperDto getArtifactByContentHash(String contentHash) throws ContentNotFoundException, RegistryStorageException {
        return this.sqlStore.getArtifactByContentHash(contentHash);
    }

    public ArtifactMetaDataDto updateArtifact(String groupId, String artifactId, String version, String artifactType, ContentHandle content, List<ArtifactReferenceDto> references) throws ArtifactNotFoundException, RegistryStorageException {
        return this.updateArtifactWithMetadata(groupId, artifactId, version, artifactType, content, null, references);
    }

    public ArtifactMetaDataDto updateArtifactWithMetadata(String groupId, String artifactId, String version, String artifactType, ContentHandle content, EditableArtifactMetaDataDto metaData, List<ArtifactReferenceDto> references) throws ArtifactNotFoundException, RegistryStorageException {
        if (!this.sqlStore.isArtifactExists(groupId, artifactId)) {
            throw new ArtifactNotFoundException(groupId, artifactId);
        }
        if (version != null && this.sqlStore.isArtifactVersionExists(groupId, artifactId, version)) {
            throw new VersionAlreadyExistsException(groupId, artifactId, version);
        }
        String contentHash = this.ensureContent(content, groupId, artifactId, artifactType, references);
        String createdBy = this.securityIdentity.getPrincipal().getName();
        Date createdOn = new Date();
        if (metaData == null) {
            metaData = this.extractMetaData(artifactType, content);
        }
        long globalId = this.nextClusterGlobalId();
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitArtifact(this.tenantContext.tenantId(), groupId, artifactId, version, ActionType.UPDATE, globalId, artifactType, contentHash, createdBy, createdOn, metaData));
        return (ArtifactMetaDataDto)this.coordinator.waitForResponse(reqId);
    }

    public Set<String> getArtifactIds(Integer limit) {
        return this.sqlStore.getArtifactIds(limit);
    }

    public ArtifactSearchResultsDto searchArtifacts(Set<SearchFilter> filters, OrderBy orderBy, OrderDirection orderDirection, int offset, int limit) {
        return this.sqlStore.searchArtifacts(filters, orderBy, orderDirection, offset, limit);
    }

    public ArtifactMetaDataDto getArtifactMetaData(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        return this.sqlStore.getArtifactMetaData(groupId, artifactId);
    }

    public ArtifactMetaDataDto getArtifactMetaData(String groupId, String artifactId, RegistryStorage.ArtifactRetrievalBehavior behavior) throws ArtifactNotFoundException, RegistryStorageException {
        return this.sqlStore.getArtifactMetaData(groupId, artifactId, behavior);
    }

    public ArtifactVersionMetaDataDto getArtifactVersionMetaData(String groupId, String artifactId, boolean canonical, ContentHandle content, List<ArtifactReferenceDto> artifactReferences) throws ArtifactNotFoundException, RegistryStorageException {
        return this.sqlStore.getArtifactVersionMetaData(groupId, artifactId, canonical, content, artifactReferences);
    }

    public ArtifactMetaDataDto getArtifactMetaData(long id) throws ArtifactNotFoundException, RegistryStorageException {
        return this.sqlStore.getArtifactMetaData(id);
    }

    public void updateArtifactMetaData(String groupId, String artifactId, EditableArtifactMetaDataDto metaData) throws ArtifactNotFoundException, RegistryStorageException {
        ArtifactMetaDataDto metaDataDto = this.sqlStore.getArtifactMetaData(groupId, artifactId);
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitArtifactVersion(this.tenantContext.tenantId(), groupId, artifactId, metaDataDto.getVersion(), ActionType.UPDATE, metaDataDto.getState(), metaData));
        this.coordinator.waitForResponse(reqId);
    }

    public void updateArtifactOwner(String groupId, String artifactId, ArtifactOwnerDto owner) throws ArtifactNotFoundException, RegistryStorageException {
        this.sqlStore.getArtifactMetaData(groupId, artifactId, RegistryStorage.ArtifactRetrievalBehavior.DEFAULT);
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitArtifactOwner(this.tenantContext.tenantId(), groupId, artifactId, ActionType.UPDATE, owner.getOwner()));
        this.coordinator.waitForResponse(reqId);
    }

    public List<RuleType> getArtifactRules(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        return this.sqlStore.getArtifactRules(groupId, artifactId);
    }

    public void createArtifactRule(String groupId, String artifactId, RuleType rule, RuleConfigurationDto config) throws ArtifactNotFoundException, RuleAlreadyExistsException, RegistryStorageException {
        if (this.sqlStore.isArtifactRuleExists(groupId, artifactId, rule)) {
            throw new RuleAlreadyExistsException(rule);
        }
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitArtifactRule(this.tenantContext.tenantId(), groupId, artifactId, rule, ActionType.CREATE, config));
        this.coordinator.waitForResponse(reqId);
    }

    public void deleteArtifactRules(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        if (!this.sqlStore.isArtifactExists(groupId, artifactId)) {
            throw new ArtifactNotFoundException(groupId, artifactId);
        }
        this.submitter.submitArtifactRule(this.tenantContext.tenantId(), groupId, artifactId, RuleType.COMPATIBILITY, ActionType.DELETE);
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitArtifactRule(this.tenantContext.tenantId(), groupId, artifactId, RuleType.VALIDITY, ActionType.DELETE));
        try {
            this.coordinator.waitForResponse(reqId);
        }
        catch (RuleNotFoundException ruleNotFoundException) {
            // empty catch block
        }
    }

    public RuleConfigurationDto getArtifactRule(String groupId, String artifactId, RuleType rule) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException {
        return this.sqlStore.getArtifactRule(groupId, artifactId, rule);
    }

    public void updateArtifactRule(String groupId, String artifactId, RuleType rule, RuleConfigurationDto config) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException {
        if (!this.sqlStore.isArtifactRuleExists(groupId, artifactId, rule)) {
            throw new RuleNotFoundException(rule);
        }
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitArtifactRule(this.tenantContext.tenantId(), groupId, artifactId, rule, ActionType.UPDATE, config));
        this.coordinator.waitForResponse(reqId);
    }

    public void deleteArtifactRule(String groupId, String artifactId, RuleType rule) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException {
        if (!this.sqlStore.isArtifactRuleExists(groupId, artifactId, rule)) {
            throw new RuleNotFoundException(rule);
        }
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitArtifactRule(this.tenantContext.tenantId(), groupId, artifactId, rule, ActionType.DELETE));
        this.coordinator.waitForResponse(reqId);
    }

    public List<String> getArtifactVersions(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        return this.sqlStore.getArtifactVersions(groupId, artifactId);
    }

    public VersionSearchResultsDto searchVersions(String groupId, String artifactId, int offset, int limit) throws ArtifactNotFoundException, RegistryStorageException {
        return this.sqlStore.searchVersions(groupId, artifactId, offset, limit);
    }

    public StoredArtifactDto getArtifactVersion(long id) throws ArtifactNotFoundException, RegistryStorageException {
        return this.sqlStore.getArtifactVersion(id);
    }

    public StoredArtifactDto getArtifactVersion(String groupId, String artifactId, String version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        return this.sqlStore.getArtifactVersion(groupId, artifactId, version);
    }

    public ArtifactVersionMetaDataDto getArtifactVersionMetaData(String groupId, String artifactId, String version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        return this.sqlStore.getArtifactVersionMetaData(groupId, artifactId, version);
    }

    public void deleteArtifactVersion(String groupId, String artifactId, String version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        this.handleVersion(groupId, artifactId, version, null, value -> {
            UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitVersion(this.tenantContext.tenantId(), groupId, artifactId, version, ActionType.DELETE));
            this.coordinator.waitForResponse(reqId);
            this.submitter.submitArtifactVersionTombstone(this.tenantContext.tenantId(), groupId, artifactId, version);
            return null;
        });
    }

    public void updateArtifactVersionMetaData(String groupId, String artifactId, String version, EditableArtifactMetaDataDto metaData) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        this.handleVersion(groupId, artifactId, version, ArtifactStateExt.ACTIVE_STATES, value -> {
            UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitArtifactVersion(this.tenantContext.tenantId(), groupId, artifactId, version, ActionType.UPDATE, value.getState(), metaData));
            return this.coordinator.waitForResponse(reqId);
        });
    }

    public void deleteArtifactVersionMetaData(String groupId, String artifactId, String version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        this.handleVersion(groupId, artifactId, version, null, value -> {
            UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitVersion(this.tenantContext.tenantId(), groupId, artifactId, version, ActionType.CLEAR));
            return this.coordinator.waitForResponse(reqId);
        });
    }

    private <T> T handleVersion(String groupId, String artifactId, String version, EnumSet<ArtifactState> states, Function<ArtifactVersionMetaDataDto, T> handler) throws ArtifactNotFoundException, RegistryStorageException {
        ArtifactVersionMetaDataDto metadata = this.sqlStore.getArtifactVersionMetaData(groupId, artifactId, version);
        ArtifactState state = metadata.getState();
        this.artifactStateEx.validateState(states, state, groupId, artifactId, version);
        return handler.apply(metadata);
    }

    public List<RuleType> getGlobalRules() throws RegistryStorageException {
        return this.sqlStore.getGlobalRules();
    }

    public void createGlobalRule(RuleType rule, RuleConfigurationDto config) throws RuleAlreadyExistsException, RegistryStorageException {
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitGlobalRule(this.tenantContext.tenantId(), rule, ActionType.CREATE, config));
        this.coordinator.waitForResponse(reqId);
    }

    public void deleteGlobalRules() throws RegistryStorageException {
        this.submitter.submitGlobalRule(this.tenantContext.tenantId(), RuleType.COMPATIBILITY, ActionType.DELETE);
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitGlobalRule(this.tenantContext.tenantId(), RuleType.VALIDITY, ActionType.DELETE));
        try {
            this.coordinator.waitForResponse(reqId);
        }
        catch (RuleNotFoundException ruleNotFoundException) {
            // empty catch block
        }
    }

    public RuleConfigurationDto getGlobalRule(RuleType rule) throws RuleNotFoundException, RegistryStorageException {
        return this.sqlStore.getGlobalRule(rule);
    }

    public void updateGlobalRule(RuleType rule, RuleConfigurationDto config) throws RuleNotFoundException, RegistryStorageException {
        if (!this.sqlStore.isGlobalRuleExists(rule)) {
            throw new RuleNotFoundException(rule);
        }
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitGlobalRule(this.tenantContext.tenantId(), rule, ActionType.UPDATE, config));
        this.coordinator.waitForResponse(reqId);
    }

    public void deleteGlobalRule(RuleType rule) throws RuleNotFoundException, RegistryStorageException {
        if (!this.sqlStore.isGlobalRuleExists(rule)) {
            throw new RuleNotFoundException(rule);
        }
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitGlobalRule(this.tenantContext.tenantId(), rule, ActionType.DELETE));
        this.coordinator.waitForResponse(reqId);
    }

    private void updateArtifactState(ArtifactState currentState, String groupId, String artifactId, String version, ArtifactState newState, EditableArtifactMetaDataDto metaData) {
        this.artifactStateEx.applyState(s -> {
            UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitArtifactVersion(this.tenantContext.tenantId(), groupId, artifactId, version, ActionType.UPDATE, newState, metaData));
            this.coordinator.waitForResponse(reqId);
        }, currentState, newState);
    }

    public void updateArtifactState(String groupId, String artifactId, ArtifactState state) throws ArtifactNotFoundException, RegistryStorageException {
        ArtifactMetaDataDto metadata = this.sqlStore.getArtifactMetaData(groupId, artifactId, RegistryStorage.ArtifactRetrievalBehavior.DEFAULT);
        EditableArtifactMetaDataDto metaDataDto = new EditableArtifactMetaDataDto();
        metaDataDto.setName(metadata.getName());
        metaDataDto.setDescription(metadata.getDescription());
        metaDataDto.setLabels(metadata.getLabels());
        metaDataDto.setProperties(metadata.getProperties());
        this.updateArtifactState(metadata.getState(), groupId, artifactId, metadata.getVersion(), state, metaDataDto);
    }

    public void updateArtifactState(String groupId, String artifactId, String version, ArtifactState state) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        ArtifactVersionMetaDataDto metadata = this.sqlStore.getArtifactVersionMetaData(groupId, artifactId, version);
        EditableArtifactMetaDataDto metaDataDto = new EditableArtifactMetaDataDto();
        metaDataDto.setName(metadata.getName());
        metaDataDto.setDescription(metadata.getDescription());
        metaDataDto.setLabels(metadata.getLabels());
        metaDataDto.setProperties(metadata.getProperties());
        this.updateArtifactState(metadata.getState(), groupId, artifactId, version, state, metaDataDto);
    }

    public LogConfigurationDto getLogConfiguration(String logger) throws RegistryStorageException, LogConfigurationNotFoundException {
        return this.sqlStore.getLogConfiguration(logger);
    }

    public List<LogConfigurationDto> listLogConfigurations() throws RegistryStorageException {
        return this.sqlStore.listLogConfigurations();
    }

    public void removeLogConfiguration(String logger) throws RegistryStorageException, LogConfigurationNotFoundException {
        LogConfigurationDto dto = new LogConfigurationDto();
        dto.setLogger(logger);
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitLogConfig(this.tenantContext.tenantId(), ActionType.DELETE, dto));
        this.coordinator.waitForResponse(reqId);
    }

    public void setLogConfiguration(LogConfigurationDto logConfiguration) throws RegistryStorageException {
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitLogConfig(this.tenantContext.tenantId(), ActionType.UPDATE, logConfiguration));
        this.coordinator.waitForResponse(reqId);
    }

    protected EditableArtifactMetaDataDto extractMetaData(String artifactType, ContentHandle content) {
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(artifactType);
        ContentExtractor extractor = provider.getContentExtractor();
        ExtractedMetaData emd = extractor.extract(content);
        EditableArtifactMetaDataDto metaData = emd != null ? new EditableArtifactMetaDataDto(emd.getName(), emd.getDescription(), emd.getLabels(), emd.getProperties()) : new EditableArtifactMetaDataDto();
        return metaData;
    }

    public void createGroup(GroupMetaDataDto group) throws GroupAlreadyExistsException, RegistryStorageException {
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitGroup(this.tenantContext.tenantId(), ActionType.CREATE, group));
        this.coordinator.waitForResponse(reqId);
    }

    public void updateGroupMetaData(GroupMetaDataDto group) throws GroupNotFoundException, RegistryStorageException {
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitGroup(this.tenantContext.tenantId(), ActionType.UPDATE, group));
        this.coordinator.waitForResponse(reqId);
    }

    public void deleteGroup(String groupId) throws GroupNotFoundException, RegistryStorageException {
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitGroup(this.tenantContext.tenantId(), groupId, ActionType.DELETE, false));
        this.coordinator.waitForResponse(reqId);
    }

    public List<String> getGroupIds(Integer limit) throws RegistryStorageException {
        return this.sqlStore.getGroupIds(limit);
    }

    public GroupMetaDataDto getGroupMetaData(String groupId) throws GroupNotFoundException, RegistryStorageException {
        return this.sqlStore.getGroupMetaData(groupId);
    }

    public List<ArtifactMetaDataDto> getArtifactVersionsByContentId(long contentId) {
        return this.sqlStore.getArtifactVersionsByContentId(contentId);
    }

    public List<Long> getArtifactContentIds(String groupId, String artifactId) {
        return this.sqlStore.getArtifactContentIds(groupId, artifactId);
    }

    public void exportData(Function<Entity, Void> handler) throws RegistryStorageException {
        this.sqlStore.exportData(handler);
    }

    public void importData(EntityInputStream entities, boolean preserveGlobalId, boolean preserveContentId) throws RegistryStorageException {
        try {
            KafkaSqlDataImporter dataImporter = preserveContentId ? new KafkaSqlDataImporter(this.log, this, preserveGlobalId) : new ContentIdNotPreserveKafkaSqlDataImporter(this.log, this, preserveGlobalId);
            Entity entity = null;
            while ((entity = entities.nextEntity()) != null) {
                dataImporter.importEntity(entity);
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.resetContentId();
            this.resetGlobalId();
        }
        catch (IOException e) {
            throw new RegistryStorageException("Failed to import data", (Throwable)e);
        }
    }

    public long countArtifacts() throws RegistryStorageException {
        return this.sqlStore.countArtifacts();
    }

    public long countArtifactVersions(String groupId, String artifactId) throws RegistryStorageException {
        return this.sqlStore.countArtifactVersions(groupId, artifactId);
    }

    public long countTotalArtifactVersions() throws RegistryStorageException {
        return this.sqlStore.countTotalArtifactVersions();
    }

    public void createRoleMapping(String principalId, String role, String principalName) throws RegistryStorageException {
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitRoleMapping(this.tenantContext.tenantId(), principalId, ActionType.CREATE, role, principalName));
        this.coordinator.waitForResponse(reqId);
    }

    public void deleteRoleMapping(String principalId) throws RegistryStorageException {
        if (!this.sqlStore.isRoleMappingExists(principalId)) {
            throw new RoleMappingNotFoundException();
        }
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitRoleMapping(this.tenantContext.tenantId(), principalId, ActionType.DELETE));
        this.coordinator.waitForResponse(reqId);
    }

    public List<RoleMappingDto> getRoleMappings() throws RegistryStorageException {
        return this.sqlStore.getRoleMappings();
    }

    public RoleMappingDto getRoleMapping(String principalId) throws RegistryStorageException {
        return this.sqlStore.getRoleMapping(principalId);
    }

    public String getRoleForPrincipal(String principalId) throws RegistryStorageException {
        return this.sqlStore.getRoleForPrincipal(principalId);
    }

    public void updateRoleMapping(String principalId, String role) throws RegistryStorageException {
        if (!this.sqlStore.isRoleMappingExists(principalId)) {
            throw new RoleMappingNotFoundException();
        }
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitRoleMapping(this.tenantContext.tenantId(), principalId, ActionType.UPDATE, role, null));
        this.coordinator.waitForResponse(reqId);
    }

    public void deleteAllUserData() throws RegistryStorageException {
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitGlobalAction(this.tenantContext.tenantId(), ActionType.DELETE_ALL_USER_DATA));
        this.coordinator.waitForResponse(reqId);
    }

    public String createDownload(DownloadContextDto context) throws RegistryStorageException {
        String downloadId = UUID.randomUUID().toString();
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitDownload(this.tenantContext.tenantId(), downloadId, ActionType.CREATE, context));
        return (String)this.coordinator.waitForResponse(reqId);
    }

    public DownloadContextDto consumeDownload(String downloadId) throws RegistryStorageException {
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitDownload(this.tenantContext.tenantId(), downloadId, ActionType.DELETE));
        return (DownloadContextDto)this.coordinator.waitForResponse(reqId);
    }

    public void deleteAllExpiredDownloads() throws RegistryStorageException {
        this.sqlStore.deleteAllExpiredDownloads();
    }

    public Map<String, ContentHandle> resolveReferences(List<ArtifactReferenceDto> references) {
        return this.sqlStore.resolveReferences(references);
    }

    public List<DynamicConfigPropertyDto> getConfigProperties() {
        return this.sqlStore.getConfigProperties();
    }

    public DynamicConfigPropertyDto getConfigProperty(String propertyName) {
        return this.sqlStore.getConfigProperty(propertyName);
    }

    public DynamicConfigPropertyDto getRawConfigProperty(String propertyName) {
        return this.sqlStore.getRawConfigProperty(propertyName);
    }

    public List<String> getTenantsWithStaleConfigProperties(Instant since) {
        return this.sqlStore.getTenantsWithStaleConfigProperties(since);
    }

    public void setConfigProperty(DynamicConfigPropertyDto propertyDto) {
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitConfigProperty(this.tenantContext.tenantId(), propertyDto.getName(), ActionType.UPDATE, propertyDto.getValue()));
        this.coordinator.waitForResponse(reqId);
    }

    public void deleteConfigProperty(String propertyName) {
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitConfigProperty(this.tenantContext.tenantId(), propertyName, ActionType.DELETE));
        this.coordinator.waitForResponse(reqId);
    }

    public boolean isArtifactExists(String groupId, String artifactId) throws RegistryStorageException {
        return this.sqlStore.isArtifactExists(groupId, artifactId);
    }

    public boolean isGroupExists(String groupId) throws RegistryStorageException {
        return this.sqlStore.isGroupExists(groupId);
    }

    public List<Long> getContentIdsReferencingArtifact(String groupId, String artifactId, String version) {
        return this.sqlStore.getContentIdsReferencingArtifact(groupId, artifactId, version);
    }

    public List<Long> getGlobalIdsReferencingArtifact(String groupId, String artifactId, String version) {
        return this.sqlStore.getGlobalIdsReferencingArtifact(groupId, artifactId, version);
    }

    public List<ArtifactReferenceDto> getInboundArtifactReferences(String groupId, String artifactId, String version) {
        return this.sqlStore.getInboundArtifactReferences(groupId, artifactId, version);
    }

    public List<CommentDto> getArtifactVersionComments(String groupId, String artifactId, String version) {
        return this.sqlStore.getArtifactVersionComments(groupId, artifactId, version);
    }

    public CommentDto createArtifactVersionComment(String groupId, String artifactId, String version, String value) {
        String theVersion = this.sqlStore.resolveVersion(groupId, artifactId, version);
        String createdBy = this.securityIdentity.getPrincipal().getName();
        Date createdOn = new Date();
        String commentId = String.valueOf(this.nextClusterCommentId());
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitComment(this.tenantContext.tenantId(), groupId, artifactId, theVersion, commentId, ActionType.CREATE, createdBy, createdOn, value));
        this.coordinator.waitForResponse(reqId);
        return CommentDto.builder().commentId(commentId).createdBy(createdBy).createdOn(createdOn.getTime()).value(value).build();
    }

    public void deleteArtifactVersionComment(String groupId, String artifactId, String version, String commentId) {
        String theVersion = this.sqlStore.resolveVersion(groupId, artifactId, version);
        if (!this.sqlStore.isArtifactVersionExists(groupId, artifactId, theVersion)) {
            throw new VersionNotFoundException(groupId, artifactId, theVersion);
        }
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitComment(this.tenantContext.tenantId(), groupId, artifactId, theVersion, commentId, ActionType.DELETE));
        this.coordinator.waitForResponse(reqId);
    }

    public void updateArtifactVersionComment(String groupId, String artifactId, String version, String commentId, String value) {
        String theVersion = this.sqlStore.resolveVersion(groupId, artifactId, version);
        if (!this.sqlStore.isArtifactVersionExists(groupId, artifactId, theVersion)) {
            throw new VersionNotFoundException(groupId, artifactId, theVersion);
        }
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitComment(this.tenantContext.tenantId(), groupId, artifactId, theVersion, commentId, ActionType.UPDATE, null, null, value));
        this.coordinator.waitForResponse(reqId);
    }

    public boolean isArtifactVersionExists(String groupId, String artifactId, String version) throws RegistryStorageException {
        return this.sqlStore.isArtifactVersionExists(groupId, artifactId, version);
    }

    public GroupSearchResultsDto searchGroups(Set<SearchFilter> filters, OrderBy orderBy, OrderDirection orderDirection, Integer offset, Integer limit) {
        return this.sqlStore.searchGroups(filters, orderBy, orderDirection, offset, limit);
    }

    protected void importArtifactRule(ArtifactRuleEntity entity) {
        RuleConfigurationDto config = new RuleConfigurationDto(entity.configuration);
        this.submitter.submitArtifactRule(this.tenantContext.tenantId(), entity.groupId, entity.artifactId, entity.type, ActionType.IMPORT, config);
    }

    public void importComment(CommentEntity entity) {
        this.submitter.submitComment(this.tenantContext.tenantId(), entity.commentId, ActionType.IMPORT, entity.globalId, entity.createdBy, new Date(entity.createdOn), entity.value);
    }

    protected void importArtifactVersion(ArtifactVersionEntity entity) {
        EditableArtifactMetaDataDto metaData = EditableArtifactMetaDataDto.builder().name(entity.name).description(entity.description).labels(entity.labels).properties(entity.properties).build();
        this.submitter.submitArtifact(this.tenantContext.tenantId(), entity.groupId, entity.artifactId, entity.version, ActionType.IMPORT, entity.globalId, entity.artifactType, null, entity.createdBy, new Date(entity.createdOn), metaData, entity.versionId, entity.state, entity.contentId, entity.isLatest);
    }

    protected void importContent(ContentEntity entity) {
        this.submitter.submitContent(this.tenantContext.tenantId(), entity.contentId, entity.contentHash, ActionType.IMPORT, entity.canonicalHash, ContentHandle.create((byte[])entity.contentBytes), entity.serializedReferences);
    }

    protected void importGlobalRule(GlobalRuleEntity entity) {
        RuleConfigurationDto config = new RuleConfigurationDto(entity.configuration);
        this.submitter.submitGlobalRule(this.tenantContext.tenantId(), entity.ruleType, ActionType.IMPORT, config);
    }

    protected void importGroup(GroupEntity entity) {
        GroupEntity e = entity;
        GroupMetaDataDto group = new GroupMetaDataDto();
        group.setArtifactsType(e.artifactsType);
        group.setCreatedBy(e.createdBy);
        group.setCreatedOn(e.createdOn);
        group.setDescription(e.description);
        group.setGroupId(e.groupId);
        group.setModifiedBy(e.modifiedBy);
        group.setModifiedOn(e.modifiedOn);
        group.setProperties(e.properties);
        this.submitter.submitGroup(this.tenantContext.tenantId(), ActionType.IMPORT, group);
    }

    private void resetContentId() {
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitGlobalId(this.tenantContext.tenantId(), ActionType.RESET));
        this.coordinator.waitForResponse(reqId);
    }

    private void resetGlobalId() {
        UUID reqId = (UUID)ConcurrentUtil.get(this.submitter.submitContentId(this.tenantContext.tenantId(), ActionType.RESET));
        this.coordinator.waitForResponse(reqId);
    }

    protected ContentHandle canonicalizeContent(String artifactType, ContentHandle content) {
        return this.canonicalizeContent(artifactType, content, Collections.emptyList());
    }

    protected ContentHandle canonicalizeContent(String artifactType, ContentHandle content, List<ArtifactReferenceDto> references) {
        try {
            ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(artifactType);
            ContentCanonicalizer canonicalizer = provider.getContentCanonicalizer();
            ContentHandle canonicalContent = canonicalizer.canonicalize(content, this.resolveReferences(references));
            return canonicalContent;
        }
        catch (Exception e) {
            this.log.debug("Failed to canonicalize content of type: {}", (Object)artifactType);
            return content;
        }
    }

    private byte[] concatContentAndReferences(byte[] contentBytes, String references) throws IOException {
        if (references != null) {
            byte[] referencesBytes = references.getBytes(StandardCharsets.UTF_8);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(contentBytes.length + referencesBytes.length);
            outputStream.write(contentBytes);
            outputStream.write(referencesBytes);
            return outputStream.toByteArray();
        }
        return contentBytes;
    }
}

