/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.dto.DownloadContextDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.dto.LogConfigurationDto;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlConfiguration;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlCoordinator;
import io.apicurio.registry.storage.impl.kafkasql.keys.ArtifactKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ArtifactOwnerKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ArtifactRuleKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ArtifactVersionKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.BootstrapKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.CommentIdKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.CommentKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ConfigPropertyKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ContentIdKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ContentKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.DownloadKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.GlobalActionKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.GlobalIdKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.GlobalRuleKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.GroupKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.LogConfigKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.MessageKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.RoleMappingKey;
import io.apicurio.registry.storage.impl.kafkasql.values.ActionType;
import io.apicurio.registry.storage.impl.kafkasql.values.ArtifactOwnerValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ArtifactRuleValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ArtifactValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ArtifactVersionValue;
import io.apicurio.registry.storage.impl.kafkasql.values.CommentIdValue;
import io.apicurio.registry.storage.impl.kafkasql.values.CommentValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ConfigPropertyValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ContentIdValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ContentValue;
import io.apicurio.registry.storage.impl.kafkasql.values.DownloadValue;
import io.apicurio.registry.storage.impl.kafkasql.values.GlobalActionValue;
import io.apicurio.registry.storage.impl.kafkasql.values.GlobalIdValue;
import io.apicurio.registry.storage.impl.kafkasql.values.GlobalRuleValue;
import io.apicurio.registry.storage.impl.kafkasql.values.GroupValue;
import io.apicurio.registry.storage.impl.kafkasql.values.LogConfigValue;
import io.apicurio.registry.storage.impl.kafkasql.values.MessageValue;
import io.apicurio.registry.storage.impl.kafkasql.values.RoleMappingValue;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.kafka.ProducerActions;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.internals.RecordHeader;

@ApplicationScoped
@Logged
public class KafkaSqlSubmitter {
    @Inject
    KafkaSqlConfiguration configuration;
    @Inject
    KafkaSqlCoordinator coordinator;
    @Inject
    ProducerActions<MessageKey, MessageValue> producer;

    public CompletableFuture<UUID> send(MessageKey key, MessageValue value) {
        UUID requestId = this.coordinator.createUUID();
        RecordHeader header = new RecordHeader("req", requestId.toString().getBytes());
        ProducerRecord record = new ProducerRecord(this.configuration.topic(), Integer.valueOf(0), (Object)key, (Object)value, Collections.singletonList(header));
        return ((CompletableFuture)this.producer.apply((Object)record)).thenApply(rm -> requestId);
    }

    public CompletableFuture<UUID> submitContent(String tenantId, long contentId, String contentHash, ActionType action, String canonicalHash, ContentHandle content, String serializedReferences) {
        ContentKey key = ContentKey.create(tenantId, contentId, contentHash);
        ContentValue value = ContentValue.create(action, canonicalHash, content, serializedReferences);
        return this.send(key, value);
    }

    public CompletableFuture<UUID> submitGroup(String tenantId, ActionType action, GroupMetaDataDto meta) {
        GroupKey key = GroupKey.create(tenantId, meta.getGroupId());
        GroupValue value = GroupValue.create(action, meta);
        return this.send(key, value);
    }

    public CompletableFuture<UUID> submitGroup(String tenantId, String groupId, ActionType action, boolean onlyArtifacts) {
        GroupKey key = GroupKey.create(tenantId, groupId);
        GroupValue value = GroupValue.create(action, onlyArtifacts);
        return this.send(key, value);
    }

    public CompletableFuture<UUID> submitArtifact(String tenantId, String groupId, String artifactId, String version, ActionType action, Long globalId, String artifactType, String contentHash, String createdBy, Date createdOn, EditableArtifactMetaDataDto metaData, Integer versionId, ArtifactState state, Long contentId, Boolean latest) {
        ArtifactKey key = ArtifactKey.create(tenantId, groupId, artifactId);
        ArtifactValue value = ArtifactValue.create(action, globalId, version, artifactType, contentHash, createdBy, createdOn, metaData, versionId, state, contentId, latest);
        return this.send(key, value);
    }

    public CompletableFuture<UUID> submitArtifact(String tenantId, String groupId, String artifactId, String version, ActionType action, Long globalId, String artifactType, String contentHash, String createdBy, Date createdOn, EditableArtifactMetaDataDto metaData) {
        return this.submitArtifact(tenantId, groupId, artifactId, version, action, globalId, artifactType, contentHash, createdBy, createdOn, metaData, null, null, null, null);
    }

    public CompletableFuture<UUID> submitArtifact(String tenantId, String groupId, String artifactId, ActionType action) {
        return this.submitArtifact(tenantId, groupId, artifactId, null, action, null, null, null, null, null, null);
    }

    public CompletableFuture<UUID> submitArtifactVersion(String tenantId, String groupId, String artifactId, String version, ActionType action, ArtifactState state, EditableArtifactMetaDataDto metaData) {
        ArtifactVersionKey key = ArtifactVersionKey.create(tenantId, groupId, artifactId, version);
        ArtifactVersionValue value = ArtifactVersionValue.create(action, state, metaData);
        return this.send(key, value);
    }

    public CompletableFuture<UUID> submitVersion(String tenantId, String groupId, String artifactId, String version, ActionType action) {
        return this.submitArtifactVersion(tenantId, groupId, artifactId, version, action, null, null);
    }

    public CompletableFuture<UUID> submitArtifactOwner(String tenantId, String groupId, String artifactId, ActionType action, String owner) {
        ArtifactOwnerKey key = ArtifactOwnerKey.create(tenantId, groupId, artifactId);
        ArtifactOwnerValue value = ArtifactOwnerValue.create(action, owner);
        return this.send(key, value);
    }

    public CompletableFuture<UUID> submitArtifactRule(String tenantId, String groupId, String artifactId, RuleType rule, ActionType action, RuleConfigurationDto config) {
        ArtifactRuleKey key = ArtifactRuleKey.create(tenantId, groupId, artifactId, rule);
        ArtifactRuleValue value = ArtifactRuleValue.create(action, config);
        return this.send(key, value);
    }

    public CompletableFuture<UUID> submitArtifactRule(String tenantId, String groupId, String artifactId, RuleType rule, ActionType action) {
        return this.submitArtifactRule(tenantId, groupId, artifactId, rule, action, null);
    }

    public CompletableFuture<UUID> submitComment(String tenantId, String groupId, String artifactId, String version, String commentId, ActionType action, long globalId, String createdBy, Date createdOn, String value) {
        CommentKey key = CommentKey.create(tenantId, groupId, artifactId, version, commentId);
        CommentValue cv = CommentValue.create(action, globalId, createdBy, createdOn, value);
        return this.send(key, cv);
    }

    public CompletableFuture<UUID> submitComment(String tenantId, String groupId, String artifactId, String version, String commentId, ActionType action, String createdBy, Date createdOn, String value) {
        return this.submitComment(tenantId, groupId, artifactId, version, commentId, action, -1L, createdBy, createdOn, value);
    }

    public CompletableFuture<UUID> submitComment(String tenantId, String groupId, String artifactId, String version, String commentId, ActionType action) {
        return this.submitComment(tenantId, groupId, artifactId, version, commentId, action, null, null, null);
    }

    public CompletableFuture<UUID> submitComment(String tenantId, String commentId, ActionType action, long globalId, String createdBy, Date createdOn, String value) {
        return this.submitComment(tenantId, "<import-comments>", "_", "_", commentId, action, globalId, createdBy, createdOn, value);
    }

    public CompletableFuture<UUID> submitGlobalRule(String tenantId, RuleType rule, ActionType action, RuleConfigurationDto config) {
        GlobalRuleKey key = GlobalRuleKey.create(tenantId, rule);
        GlobalRuleValue value = GlobalRuleValue.create(action, config);
        return this.send(key, value);
    }

    public CompletableFuture<UUID> submitGlobalRule(String tenantId, RuleType rule, ActionType action) {
        return this.submitGlobalRule(tenantId, rule, action, null);
    }

    public CompletableFuture<UUID> submitRoleMapping(String tenantId, String principalId, ActionType action, String role, String principalName) {
        RoleMappingKey key = RoleMappingKey.create(tenantId, principalId);
        RoleMappingValue value = RoleMappingValue.create(action, role, principalName);
        return this.send(key, value);
    }

    public CompletableFuture<UUID> submitRoleMapping(String tenantId, String principalId, ActionType action) {
        return this.submitRoleMapping(tenantId, principalId, action, null, null);
    }

    public CompletableFuture<UUID> submitLogConfig(String tenantId, ActionType action, LogConfigurationDto config) {
        LogConfigKey key = LogConfigKey.create(tenantId);
        LogConfigValue value = LogConfigValue.create(action, config);
        return this.send(key, value);
    }

    public CompletableFuture<UUID> submitLogConfig(String tenantId, ActionType action) {
        return this.submitLogConfig(tenantId, action, null);
    }

    public CompletableFuture<UUID> submitGlobalId(String tenantId, ActionType action) {
        GlobalIdKey key = GlobalIdKey.create(tenantId);
        GlobalIdValue value = GlobalIdValue.create(action);
        return this.send(key, value);
    }

    public CompletableFuture<UUID> submitContentId(String tenantId, ActionType action) {
        ContentIdKey key = ContentIdKey.create(tenantId);
        ContentIdValue value = ContentIdValue.create(action);
        return this.send(key, value);
    }

    public CompletableFuture<UUID> submitCommentId(String tenantId, ActionType action) {
        CommentIdKey key = CommentIdKey.create(tenantId);
        CommentIdValue value = CommentIdValue.create(action);
        return this.send(key, value);
    }

    public CompletableFuture<UUID> submitDownload(String tenantId, String downloadId, ActionType action, DownloadContextDto context) {
        DownloadKey key = DownloadKey.create(tenantId, downloadId);
        DownloadValue value = DownloadValue.create(action, context);
        return this.send(key, value);
    }

    public CompletableFuture<UUID> submitDownload(String tenantId, String downloadId, ActionType action) {
        return this.submitDownload(tenantId, downloadId, action, null);
    }

    public CompletableFuture<UUID> submitConfigProperty(String tenantId, String propertyName, ActionType action, String propertyValue) {
        ConfigPropertyKey key = ConfigPropertyKey.create(tenantId, propertyName);
        ConfigPropertyValue value = ConfigPropertyValue.create(action, propertyValue);
        return this.send(key, value);
    }

    public CompletableFuture<UUID> submitConfigProperty(String tenantId, String propertyName, ActionType action) {
        return this.submitConfigProperty(tenantId, propertyName, action, null);
    }

    public CompletableFuture<UUID> submitGlobalAction(String tenantId, ActionType action) {
        GlobalActionKey key = GlobalActionKey.create(tenantId);
        GlobalActionValue value = GlobalActionValue.create(action);
        return this.send(key, value);
    }

    public void submitArtifactVersionTombstone(String tenantId, String groupId, String artifactId, String version) {
        ArtifactVersionKey key = ArtifactVersionKey.create(tenantId, groupId, artifactId, version);
        this.send(key, null);
    }

    public void submitArtifactRuleTombstone(String tenantId, String groupId, String artifactId, RuleType rule) {
        ArtifactRuleKey key = ArtifactRuleKey.create(tenantId, groupId, artifactId, rule);
        this.send(key, null);
    }

    public void submitBootstrap(String bootstrapId) {
        BootstrapKey key = BootstrapKey.create(bootstrapId);
        this.send(key, null);
    }
}

