/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.keys;

import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.AbstractMessageKey;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.UUID;

@RegisterForReflection
public class ArtifactKey
extends AbstractMessageKey {
    private String groupId;
    private String artifactId;
    private final String uuid = UUID.randomUUID().toString();

    public static final ArtifactKey create(String tenantId, String groupId, String artifactId) {
        ArtifactKey key = new ArtifactKey();
        key.setTenantId(tenantId);
        key.setGroupId(groupId);
        key.setArtifactId(artifactId);
        return key;
    }

    @Override
    public MessageType getType() {
        return MessageType.Artifact;
    }

    @Override
    public String getPartitionKey() {
        return this.getTenantId() + "/" + this.groupId + "/" + this.artifactId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Override
    public String toString() {
        return "ArtifactKey [groupId=" + this.groupId + ", artifactId=" + this.artifactId + "]";
    }
}

