/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.keys;

import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.AbstractMessageKey;
import io.quarkus.runtime.annotations.RegisterForReflection;

@RegisterForReflection
public class ArtifactOwnerKey
extends AbstractMessageKey {
    private String groupId;
    private String artifactId;

    public static final ArtifactOwnerKey create(String tenantId, String groupId, String artifactId) {
        ArtifactOwnerKey key = new ArtifactOwnerKey();
        key.setTenantId(tenantId);
        key.setGroupId(groupId);
        key.setArtifactId(artifactId);
        return key;
    }

    @Override
    public MessageType getType() {
        return MessageType.ArtifactOwner;
    }

    @Override
    public String getPartitionKey() {
        return this.getTenantId() + "/" + this.groupId + "/" + this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Override
    public String toString() {
        return "ArtifactRuleKey [groupId=" + this.groupId + ", artifactId=" + this.artifactId + "]";
    }
}

