/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.keys;

import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.AbstractMessageKey;
import io.apicurio.registry.types.RuleType;
import io.quarkus.runtime.annotations.RegisterForReflection;

@RegisterForReflection
public class ArtifactRuleKey
extends AbstractMessageKey {
    private String groupId;
    private String artifactId;
    private RuleType ruleType;

    public static final ArtifactRuleKey create(String tenantId, String groupId, String artifactId, RuleType ruleType) {
        ArtifactRuleKey key = new ArtifactRuleKey();
        key.setTenantId(tenantId);
        key.setGroupId(groupId);
        key.setArtifactId(artifactId);
        key.setRuleType(ruleType);
        return key;
    }

    @Override
    public MessageType getType() {
        return MessageType.ArtifactRule;
    }

    @Override
    public String getPartitionKey() {
        return this.getTenantId() + "/" + this.groupId + "/" + this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(RuleType ruleType) {
        this.ruleType = ruleType;
    }

    @Override
    public String toString() {
        return "ArtifactRuleKey [groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", ruleType=" + this.ruleType + "]";
    }
}

