/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.keys;

import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.AbstractMessageKey;
import io.quarkus.runtime.annotations.RegisterForReflection;

@RegisterForReflection
public class ArtifactVersionKey
extends AbstractMessageKey {
    private String groupId;
    private String artifactId;
    private String version;

    public static final ArtifactVersionKey create(String tenantId, String groupId, String artifactId, String version) {
        ArtifactVersionKey key = new ArtifactVersionKey();
        key.setTenantId(tenantId);
        key.setGroupId(groupId);
        key.setArtifactId(artifactId);
        key.setVersion(version);
        return key;
    }

    @Override
    public MessageType getType() {
        return MessageType.ArtifactVersion;
    }

    @Override
    public String getPartitionKey() {
        return this.getTenantId() + "/" + this.groupId + "/" + this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return "ArtifactVersionKey [groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + "]";
    }
}

