/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.keys;

import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.AbstractMessageKey;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.UUID;

@RegisterForReflection
public class CommentIdKey
extends AbstractMessageKey {
    private static final String COMMENT_ID_PARTITION_KEY = "__apicurio_registry_comment_id__";
    private final String uuid = UUID.randomUUID().toString();

    public static final CommentIdKey create(String tenantId) {
        CommentIdKey key = new CommentIdKey();
        key.setTenantId(tenantId);
        return key;
    }

    @Override
    public MessageType getType() {
        return MessageType.CommentId;
    }

    @Override
    public String getPartitionKey() {
        return this.getTenantId() + COMMENT_ID_PARTITION_KEY;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Override
    public String toString() {
        return String.format("CommentIdKey(super = %s)", super.toString());
    }
}

