/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.keys;

import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.AbstractMessageKey;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.UUID;

@RegisterForReflection
public class CommentKey
extends AbstractMessageKey {
    private String groupId;
    private String artifactId;
    private String version;
    private String commentId;
    private final String uuid = UUID.randomUUID().toString();

    public static final CommentKey create(String tenantId, String groupId, String artifactId, String version, String commentId) {
        CommentKey key = new CommentKey();
        key.setTenantId(tenantId);
        key.setGroupId(groupId);
        key.setArtifactId(artifactId);
        key.setVersion(version);
        key.setCommentId(commentId);
        return key;
    }

    @Override
    public MessageType getType() {
        return MessageType.Comment;
    }

    @Override
    public String getPartitionKey() {
        return this.getTenantId() + "/" + this.groupId + "/" + this.artifactId + "/" + this.version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCommentId() {
        return this.commentId;
    }

    public void setCommentId(String commentId) {
        this.commentId = commentId;
    }

    @Override
    public String toString() {
        return "CommentKey [groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.getVersion() + ", commentId=" + this.getCommentId() + "]";
    }

    public String getUuid() {
        return this.uuid;
    }
}

