/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.keys;

import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.AbstractMessageKey;
import io.quarkus.runtime.annotations.RegisterForReflection;

@RegisterForReflection
public class ConfigPropertyKey
extends AbstractMessageKey {
    private String propertyName;

    public static final ConfigPropertyKey create(String tenantId, String propertyName) {
        ConfigPropertyKey key = new ConfigPropertyKey();
        key.setTenantId(tenantId);
        key.setPropertyName(propertyName);
        return key;
    }

    @Override
    public MessageType getType() {
        return MessageType.ConfigProperty;
    }

    @Override
    public String getPartitionKey() {
        return this.getTenantId() + "/" + this.getPropertyName();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public String toString() {
        return "ConfigPropertyKey [propertyName=" + this.propertyName + "]";
    }
}

