/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.keys;

import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.AbstractMessageKey;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.UUID;

@RegisterForReflection
public class ContentIdKey
extends AbstractMessageKey {
    private static final String CONTENT_ID_PARTITION_KEY = "__apicurio_registry_content_id__";
    private final String uuid = UUID.randomUUID().toString();

    public static final ContentIdKey create(String tenantId) {
        ContentIdKey key = new ContentIdKey();
        key.setTenantId(tenantId);
        return key;
    }

    @Override
    public MessageType getType() {
        return MessageType.ContentId;
    }

    @Override
    public String getPartitionKey() {
        return this.getTenantId() + CONTENT_ID_PARTITION_KEY;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Override
    public String toString() {
        return String.format("ContentIdKey(super = %s)", super.toString());
    }
}

