/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.keys;

import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.AbstractMessageKey;
import io.quarkus.runtime.annotations.RegisterForReflection;

@RegisterForReflection
public class ContentKey
extends AbstractMessageKey {
    private String contentHash;
    private long contentId;

    public static final ContentKey create(String tenantId, long contentId, String contentHash) {
        ContentKey key = new ContentKey();
        key.setTenantId(tenantId);
        key.setContentId(contentId);
        key.setContentHash(contentHash);
        return key;
    }

    @Override
    public MessageType getType() {
        return MessageType.Content;
    }

    @Override
    public String getPartitionKey() {
        return this.getTenantId() + this.contentHash;
    }

    public String getContentHash() {
        return this.contentHash;
    }

    public void setContentHash(String contentHash) {
        this.contentHash = contentHash;
    }

    public long getContentId() {
        return this.contentId;
    }

    public void setContentId(long contentId) {
        this.contentId = contentId;
    }

    @Override
    public String toString() {
        return "ContentKey [contentHash=" + this.contentHash + ", contentId=" + this.contentId + "]";
    }
}

