/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.keys;

import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.AbstractMessageKey;
import io.quarkus.runtime.annotations.RegisterForReflection;

@RegisterForReflection
public class DownloadKey
extends AbstractMessageKey {
    private static final String DOWNLOAD_PARTITION_KEY = "__apicurio_registry_download__";
    private String downloadId;

    public static final DownloadKey create(String tenantId, String downloadId) {
        DownloadKey key = new DownloadKey();
        key.setTenantId(tenantId);
        key.setDownloadId(downloadId);
        return key;
    }

    @Override
    public MessageType getType() {
        return MessageType.Download;
    }

    @Override
    public String getPartitionKey() {
        return this.getTenantId() + DOWNLOAD_PARTITION_KEY;
    }

    public String getDownloadId() {
        return this.downloadId;
    }

    public void setDownloadId(String downloadId) {
        this.downloadId = downloadId;
    }

    @Override
    public String toString() {
        return "DownloadKey [downloadId=" + this.downloadId + "]";
    }
}

